/************************************
 Miscellaneous functions
 (c) 1999 Jeremy Wise
 GnomeICU
*************************************/

#include "common.h"
#include "applet.h"
#include "changenick.h"
#include "changeaway.h"
#include "detach.h"
#include "dirbrowser.h"
#include "gnomecfg.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "history.h"
#include "icons.h"
#include "kanji_conv.h"
#include "msg.h"
#include "personal_info.h"
#include "response.h"
#include "sendcontact.h"
#include "sendmsg.h"
#include "showlist.h"
#include "tcp.h"
#include "user_popup.h"
#include "util.h"
#include "v7login.h"
#include "v7send.h"

GtkWidget *found_list;

int start_new_info = TRUE;

/*** Local function declarations ***/
static void icq_auth_request_clicked( GnomeDialog *dialog, gint button, gpointer data );
static void icq_accept_chat( GtkWidget *widget, GSList *contact );
static void icq_refuse_chat( GtkWidget *widget, GSList *contact );
static void icq_accept_file( GtkWidget *widget, gpointer xfer );
static void icq_refuse_file( GtkWidget *widget, gpointer xfer );
static void cb_menu_position (GtkMenu *menu, gint *x, gint *y, gpointer user_data);

static void open_file( GtkWidget *widget, gpointer data );
static void del_file( GtkWidget *widget, gpointer data );
/* static void open_dir( GtkWidget *widget, gpointer data ); */

gint animate_ref = 0;

/*** Global functions ***/
void animate_on( void )
{
	++animate_ref;

	/* If the eyes are already spinning, no need to start them again */
	if( animate_ref != 1 )
		return;

	gtk_widget_hide( eyes_still );
	gtk_widget_show( eyes_animated );
	gnome_animator_set_loop_type( GNOME_ANIMATOR( eyes_animated ),
	                              GNOME_ANIMATOR_LOOP_RESTART );
	gnome_animator_start( GNOME_ANIMATOR( eyes_animated ) );
}

void animate_off( void )
{
	--animate_ref;

	if( animate_ref < 0 )
		animate_ref = 0;

	/* If we're not back down to zero yet, don't stop the eyes */
	if( animate_ref )
		return;

	gnome_animator_stop( GNOME_ANIMATOR( eyes_animated ) );
	gtk_widget_hide( eyes_animated );
	gtk_widget_show( eyes_still );
}

/* TODO: split this into functions for different message types.
 * maybe it would be better to load gui from glade file */
void icq_msgbox( STORED_MESSAGE_PTR message_text, UIN_T uin )
{
	GtkWidget *window = NULL;
	GtkWidget *table;
	GtkWidget *menuitem;
	GtkWidget *entry1;
	GtkWidget *entry2;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *hbox1;
	GtkWidget *label1;
	GtkWidget *label2;
	GtkWidget *label3;
	GtkWidget *label4;
	GtkWidget *label5;
	GtkWidget *label6;
	GtkWidget *timefield;
	GtkWidget *scrolledwindow1;
	GtkWidget *text;
	GtkWidget *button1;
	GtkWidget *button3;
   	/* Mass-send - NH */
	GtkWidget *hbox6 = NULL;
	GtkWidget *label7;
	GtkWidget *optionmenu2;
	GtkWidget *optionmenu2_menu = NULL;

   	/* End mass-send */
	guchar tmp, *tmpstr;

	struct tm *my_tm;
	char msgtime[40];

	int cx;

	gchar *sender = NULL;

	GSList *contact;

	GtkWidget *url, *desc;

	GString *sessionname;

#ifdef TRACE_FUNCTION
	g_print( "icq_msgbox\n" );
#endif

	contact = Find_User( uin );
	if( contact == NULL )
		return;

	if( g_slist_length( kontakt->stored_messages ) == 1 )
	{
		kontakt->icon_p = get_pixmap_for_status( kontakt->status );
		kontakt->icon_b = get_bitmap_for_status( kontakt->status );
		kontakt->need_update = 1;
	}

/*** User has received a TEXT message ***/
	if( message_text->type == MESSAGE_TEXT )
	{
		if (uin == 10) { /* We've received a web message */
			if (toggles->russian)
				tmp = 192;
			else
				tmp = 0xFE;
			for (cx = 0; cx < strlen (message_text->message); cx++)
				if (message_text->message[cx] == tmp)
					message_text->message[cx] = '\n';
		}

		open_message_dlg_with_message (uin, message_text);

		return;
	}

/*** User has received a CONTACT LIST ***/
	if( message_text->type == MESSAGE_CONT_LIST )
	{
		received_contact_list_window( kontakt, message_text->data );
		return;
	}

/*** User has added you to his/her list ***/
	if( message_text->type == MESSAGE_USER_ADD )
	{
		if (kontakt->info->sex == FEMALE)
		  sender = g_strdup_printf( _("%s has added you to her list"), kontakt->nick );
		else if (kontakt->info->sex == MALE)
		  sender = g_strdup_printf( _("%s has added you to his list"), kontakt->nick );
		else /* No sex specified */
		  sender = g_strdup_printf( _("%s has added you to his/her list"), kontakt->nick );


		gtk_widget_show( gnome_message_box_new( sender,
		                                        GNOME_MESSAGE_BOX_INFO,
		                                        GNOME_STOCK_BUTTON_OK,
							NULL ) );
		g_free( sender );
		return;
	}

/*** Sender has authorized you to add him to your list ***/
	if( message_text->type == MESSAGE_USER_AUTHD )
	{
		sender = g_strdup_printf( _("You are authorized to add %s to your list"), kontakt->nick );

		gtk_widget_show( gnome_message_box_new( sender,
		                                        GNOME_MESSAGE_BOX_INFO,
		                                        GNOME_STOCK_BUTTON_OK,
							NULL ) );
		g_free( sender );
		return;
	}

/*** Sender has sent you a chat request ***/
	if( message_text->type == MESSAGE_CHAT_REQ )
	{

    	        kontakt->read_next = NULL;
		window = gnome_dialog_new (_("GnomeICU: Chat Request"), NULL);
		gtk_window_set_wmclass (GTK_WINDOW (window), "Chat_Request", "GnomeICU");
		gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, TRUE);

                set_window_icon( window, "gnomeicu-chat.png" );

		dialog_vbox1 = GNOME_DIALOG (window)->vbox;

		vbox1 = gtk_vbox_new (FALSE, 0);
		gtk_widget_show (vbox1);
		gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

		sender = g_strdup_printf( _("Accept Chat Request from %s?\n"), kontakt->nick );

		label1 = gtk_label_new ( sender );
		g_free( sender );
		gtk_widget_show (label1);
		gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);

		if (message_text->chatsessionname != NULL)
		{

		     sender = g_strdup_printf( _("Multi-party session:  %s?\n"),  message_text->chatsessionname);
		     label1 = gtk_label_new ( sender );
		     g_free( sender );
		     gtk_widget_show (label1);
		     gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
		}

		label2 = gtk_label_new (_("Reason:"));
		gtk_widget_show (label2);
		gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
		gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

		scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
		gtk_widget_show (scrolledwindow1);
		gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

		text = gtk_text_new (NULL, NULL);
		gtk_widget_show (text);
		gtk_text_set_word_wrap( GTK_TEXT( text ), TRUE );
		gtk_text_set_editable( GTK_TEXT( text ), FALSE );
/*		if( kontakt->chat_reason != NULL )
		{
				kanji_conv_to_locale_s( &kontakt->chat_reason );
				gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
				                 kontakt->chat_reason, -1 );
				g_free( kontakt->chat_reason );
				kontakt->chat_reason = NULL;
		}
*/
		if (message_text->message)
		     gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
				      message_text->message, -1 );
		else
		     gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
				                 _("No reason given"), -1 );

		gtk_container_add (GTK_CONTAINER (scrolledwindow1), text);

		if (Sessions != NULL && message_text->chatsessionname == NULL)
		{
		     GSList *gslcsession;
		     GSList *member_cc;

		     hbox6 = gtk_hbox_new(FALSE, 0);
		     gtk_box_pack_start (GTK_BOX (vbox1), hbox6,  TRUE, TRUE, 0);
		     label7 = gtk_label_new(_("Invite to session: "));
		     gtk_box_pack_start (GTK_BOX (hbox6), label7,  TRUE, TRUE, 0);
		     optionmenu2 = gtk_option_menu_new();
		     gtk_box_pack_start (GTK_BOX (hbox6), optionmenu2,  TRUE, TRUE, 0);
		     optionmenu2_menu = gtk_menu_new();
		     gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu2), optionmenu2_menu);

		     for (gslcsession = Sessions;
			  gslcsession != NULL;
			  gslcsession = gslcsession->next)
		     {
			  sessionname = g_string_new(our_info->nick);
			  for (member_cc = ((ChatSession *)gslcsession->data)->members;
			       member_cc != NULL;
			       member_cc = member_cc->next)
			  {
			       g_string_sprintfa(sessionname, ", %s", ((ChatContact *)member_cc->data)->contact->nick);
			  }
			  menuitem = gtk_menu_item_new_with_label(sessionname->str);
			  g_string_free (sessionname, TRUE);
			  gtk_menu_append(GTK_MENU (optionmenu2_menu), menuitem);
			  gtk_object_set_data (GTK_OBJECT (menuitem), "ChatSession", gslcsession->data);
		     }

		     menuitem = gtk_menu_item_new_with_label("None");
		     gtk_object_set_data (GTK_OBJECT (menuitem), "ChatSession", NULL);
		     gtk_menu_prepend(GTK_MENU(optionmenu2_menu), menuitem);
		     gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu2),0);
		     gtk_widget_show_all (hbox6);

		}

		/* TODO: buttons can be simplified. connect to dialog's
		 * "clicked" and "close" instead of buttons */

		gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_YES );
		button1 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
		if (GTK_IS_HBOX(hbox6))
		     gtk_object_set_data (GTK_OBJECT (button1), "OptionMenu", optionmenu2_menu);
		else {
		     gtk_object_set_data (GTK_OBJECT (button1), "OptionMenu", NULL);
		}
		gtk_object_set_data (GTK_OBJECT (button1), "ChatContact",message_text->data);

		gtk_signal_connect( GTK_OBJECT( button1 ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_accept_chat ),
		                    contact );

		gtk_signal_connect_object( GTK_OBJECT( button1 ), "clicked",
		                           (GtkSignalFunc) gtk_widget_destroy,
		                           GTK_OBJECT( window ) );

		gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_NO);
		button3 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
		gtk_object_set_data (GTK_OBJECT (button3), "ChatContact",message_text->data);

		gtk_signal_connect( GTK_OBJECT( button3 ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_refuse_chat ),
		                    contact );

		gtk_signal_connect_object( GTK_OBJECT( button3 ), "clicked",
		                           (GtkSignalFunc) gtk_widget_destroy,
		                           GTK_OBJECT( window ) );

		gtk_widget_show_all( window );
		return;
	}

/*** Sender has offered you a file ***/
	if( message_text->type == MESSAGE_FILE_REQ )
	{
		GSList *xfer;

		/* Make sure the file transfer is still there */
		for (xfer = pending_xfers;xfer;xfer=xfer->next)
			if (xfer->data == message_text->data)
				break;

		/* Nope, it's gone */
		if (!xfer) {
			gnome_ok_dialog( _("File transfer timed out.") );
			return;
		}

		window = gnome_dialog_new (_("GnomeICU: File Offer"), NULL);
		gtk_window_set_wmclass (GTK_WINDOW (window), "File_Offer", "GnomeICU");
		gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, TRUE);

                set_window_icon( window, "gnomeicu-file.png" );

		dialog_vbox1 = GNOME_DIALOG (window)->vbox;

		vbox1 = gtk_vbox_new (FALSE, 4);
		gtk_widget_show (vbox1);
		gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

		sender = g_strdup_printf( _("Accept file from %s?\n"), kontakt->nick );

		label1 = gtk_label_new ( sender );
		g_free( sender );
		gtk_widget_show (label1);
		gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);

		table = gtk_table_new (4, 3, FALSE);
		gtk_widget_show (table);
		gtk_box_pack_start (GTK_BOX (vbox1), table, TRUE, TRUE, 0);

		label3 = gtk_label_new (_("Size:"));
		gtk_widget_show (label3);
		gtk_table_attach (GTK_TABLE (table), label3, 0, 1, 1, 2,
		                  (GtkAttachOptions) (GTK_FILL),
		                  (GtkAttachOptions) (0), 0, 0);
		gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_RIGHT);
		gtk_misc_set_alignment (GTK_MISC (label3), 1, 0.5);

		label2 = gtk_label_new (_("Name:"));
		gtk_widget_show (label2);
		gtk_table_attach (GTK_TABLE (table), label2, 0, 1, 0, 1,
		                  (GtkAttachOptions) (GTK_FILL),
		                  (GtkAttachOptions) (0), 0, 0);
		gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_RIGHT);
		gtk_misc_set_alignment (GTK_MISC (label2), 1, 0.5);

		label5 = gtk_label_new ("");
		gtk_widget_show (label5);
		gtk_table_attach (GTK_TABLE (table), label5, 1, 2, 2, 3,
		                  (GtkAttachOptions) (0),
		                  (GtkAttachOptions) (0), 0, 0);

		label4 = gtk_label_new (_("\nReason:"));
		gtk_widget_show (label4);
		gtk_table_attach (GTK_TABLE (table), label4, 0, 2, 2, 3,
		                  (GtkAttachOptions) (GTK_FILL),
		                  (GtkAttachOptions) (0), 0, 0);
		gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);
		gtk_misc_set_alignment (GTK_MISC (label4), 0, 0.5);

		label6 = gtk_label_new ("");
		gtk_widget_show (label6);
		gtk_table_attach (GTK_TABLE (table), label6, 2, 3, 2, 3,
		                  (GtkAttachOptions) (0),
		                  (GtkAttachOptions) (0), 0, 0);

		scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
		gtk_widget_show (scrolledwindow1);
		gtk_table_attach (GTK_TABLE (table), scrolledwindow1, 0, 3, 3, 4,
		                  (GtkAttachOptions) (GTK_FILL),
		                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

		text = gtk_text_new (NULL, NULL);
		gtk_widget_show (text);
		gtk_text_set_word_wrap( GTK_TEXT( text ), TRUE );
		gtk_text_set_editable( GTK_TEXT( text ), FALSE );
		gtk_container_add (GTK_CONTAINER (scrolledwindow1), text);

		kanji_conv_to_locale_s( &message_text->message );
		gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
		                 message_text->message, -1 );

		entry1 = gtk_entry_new ();
		gtk_widget_show (entry1);
		gtk_entry_set_editable( GTK_ENTRY( entry1 ), FALSE );
		sender = g_strdup_printf( "%d", ((XferInfo *)message_text->data)->total_bytes );
		gtk_entry_set_text( GTK_ENTRY( entry1 ), sender );

		g_free( sender );
		gtk_table_attach (GTK_TABLE (table), entry1, 1, 3, 1, 2,
		                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		                  (GtkAttachOptions) (0), 0, 0);

		entry2 = gtk_entry_new ();
		gtk_widget_show (entry2);
		gtk_entry_set_editable( GTK_ENTRY( entry2 ), FALSE );
		gtk_entry_set_text( GTK_ENTRY( entry2 ), ((XferInfo *)message_text->data)->filename );

		gtk_table_attach (GTK_TABLE (table), entry2, 1, 3, 0, 1,
		                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		                  (GtkAttachOptions) (0), 0, 0);

		gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_YES);
		button1 = g_list_last (GNOME_DIALOG (window)->buttons)->data;

		gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_NO);
		button3 = g_list_last (GNOME_DIALOG (window)->buttons)->data;

		gtk_signal_connect (GTK_OBJECT (button1), "clicked",
		                    GTK_SIGNAL_FUNC (icq_accept_file),
		                    message_text->data);
		gtk_signal_connect (GTK_OBJECT (button3), "clicked",
		                    GTK_SIGNAL_FUNC (icq_refuse_file),
		                    message_text->data);
		gnome_dialog_set_close (GNOME_DIALOG (window), TRUE);

		gtk_widget_show_all( window );
		return;
	}


/* Sender wishes to add you to his/her list */
	if( message_text->type == MESSAGE_AUTH_REQ )
	{
		window = gnome_dialog_new (_("GnomeICU: Authorization Request"),
					   _("Allow"), _("Refuse"), NULL);

		gtk_window_set_wmclass (GTK_WINDOW (window), "Auth_Request", "GnomeICU");
		gtk_window_set_policy (GTK_WINDOW (window), FALSE, TRUE, FALSE);

		dialog_vbox1 = GNOME_DIALOG (window)->vbox;

		sender = g_strdup_printf( _("Auth Request from %s:\n"), kontakt->nick );

		label1 = gtk_label_new ( sender );
		g_free( sender );
		gtk_widget_show (label1);
		gtk_box_pack_start (GTK_BOX (dialog_vbox1), label1, FALSE, FALSE, 0);

		hbox1 = gtk_hbox_new (FALSE, 0);
		gtk_widget_show (hbox1);
		gtk_box_pack_start (GTK_BOX (dialog_vbox1), hbox1, TRUE, TRUE, 0);

		label3 = gtk_label_new (_("Time/Date:"));
		gtk_widget_show (label3);
		gtk_box_pack_start (GTK_BOX (hbox1), label3, TRUE, TRUE, 0);
		gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);
		gtk_misc_set_alignment (GTK_MISC (label3), 1, 0.5);

		timefield = gtk_entry_new ();
		gtk_widget_show (timefield);
		gtk_entry_set_editable( GTK_ENTRY( timefield ), FALSE );
		gtk_box_pack_start (GTK_BOX (hbox1), timefield, FALSE, TRUE, 0);

		my_tm = localtime (&message_text->time);
		strftime (msgtime, sizeof (msgtime), _("%c"), my_tm);
		gtk_entry_set_text( GTK_ENTRY( timefield ), msgtime );

		label2 = gtk_label_new (_("Reason:"));
		gtk_widget_show (label2);
		gtk_box_pack_start (GTK_BOX (dialog_vbox1), label2, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
		gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

		scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
		gtk_widget_show (scrolledwindow1);
		gtk_box_pack_start (GTK_BOX (dialog_vbox1), scrolledwindow1, TRUE, TRUE, 0);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

		text = gtk_text_new (NULL, NULL);
		gtk_widget_show (text);
		gtk_text_set_word_wrap( GTK_TEXT( text ), TRUE );
		gtk_text_set_editable( GTK_TEXT( text ), FALSE );

		kanji_conv_to_locale_s( &message_text->message );
		gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
		                 message_text->message, -1 );

		gtk_container_add (GTK_CONTAINER (scrolledwindow1), text);

		gtk_signal_connect( GTK_OBJECT( window ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_auth_request_clicked ),
				    GUINT_TO_POINTER(kontakt->uin) );

		gtk_widget_show (window);
		return;
	}

/* Sender has sent you a URL */
	if( message_text->type == MESSAGE_URL )
	{
		sender = g_strdup_printf( _("Received URL from %s:"), kontakt->nick );
		
		window = gnome_dialog_new (_("GnomeICU: URL"),
					   GNOME_STOCK_BUTTON_CLOSE, NULL);
		gtk_window_set_wmclass (GTK_WINDOW (window), "URL", "GnomeICU");
		gtk_widget_set_usize (window, 400, -2);
		gtk_window_set_default_size( GTK_WINDOW( window ), 500, 150 );
		gtk_window_set_policy (GTK_WINDOW (window), FALSE, TRUE, FALSE);
		gnome_dialog_set_close (GNOME_DIALOG (window), TRUE);

                set_window_icon( window, "gnomeicu-url.png" );

		dialog_vbox1 = GNOME_DIALOG (window)->vbox;

		label1 = gtk_label_new ( sender );
                g_free( sender);
		gtk_widget_show (label1);
		gtk_box_pack_start (GTK_BOX (dialog_vbox1), label1, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
		gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

		table = gtk_table_new (2, 2, FALSE);
		gtk_widget_show (table);
		gtk_box_pack_start (GTK_BOX (dialog_vbox1), table, TRUE, TRUE, 0);
		gtk_table_set_row_spacings (GTK_TABLE (table), 4);
		gtk_table_set_col_spacings (GTK_TABLE (table), 4);

		hbox1 = gtk_hbox_new (FALSE, 4);
		gtk_widget_show (hbox1);
		gtk_table_attach (GTK_TABLE (table), hbox1, 1, 2, 0, 1,
		                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

		url = gtk_entry_new ();
		gtk_widget_show (url);
		gtk_box_pack_start (GTK_BOX (hbox1), url, TRUE, TRUE, 0);

		gtk_entry_set_text( GTK_ENTRY( url ), message_text->data );

		button1 = gtk_button_new_with_label (_("Go To"));
		gtk_widget_show (button1);
		gtk_box_pack_start (GTK_BOX (hbox1), button1, FALSE, FALSE, 0);

		gtk_signal_connect( GTK_OBJECT( button1 ), "clicked",
		                    GTK_SIGNAL_FUNC( display_url ),
		                    tmpstr = g_strdup( message_text->data ) );
                g_free(tmpstr);

		desc = gtk_entry_new ();
		gtk_widget_show (desc);
		gtk_table_attach (GTK_TABLE (table), desc, 1, 2, 1, 2,
		                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		                  (GtkAttachOptions) (0), 0, 0);

		kanji_conv_to_locale_s( &message_text->message );

		gtk_entry_set_text( GTK_ENTRY( desc ), message_text->message );

		label2 = gtk_label_new (_("URL:"));
		gtk_widget_show (label2);
		gtk_table_attach (GTK_TABLE (table), label2, 0, 1, 0, 1,
		                 (GtkAttachOptions) (GTK_FILL),
		                 (GtkAttachOptions) (GTK_FILL), 0, 0);
		gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_RIGHT);
		gtk_misc_set_alignment (GTK_MISC (label2), 1, 0.5);

		label3 = gtk_label_new (_("Description:"));
		gtk_widget_show (label3);
		gtk_table_attach (GTK_TABLE (table), label3, 0, 1, 1, 2,
		                  (GtkAttachOptions) (GTK_FILL),
		                  (GtkAttachOptions) (GTK_FILL), 0, 0);
		gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_RIGHT);
		gtk_misc_set_alignment (GTK_MISC (label3), 1, 0.5);

		gtk_widget_show (window);

	}
}

GtkWidget *create_menu ( void )
{
	GtkWidget *item;
	GtkWidget *menu;

#ifdef TRACE_FUNCTION
	g_print( "create_menu\n" );
#endif

	menu = gtk_menu_new();

	item = gtk_menu_item_new_with_label ( _("Online") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_online), NULL );

	item = gtk_menu_item_new_with_label ( _("Offline") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_offline), NULL );

	item = gtk_menu_item_new_with_label ( _("Away") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_away), NULL );

	item = gtk_menu_item_new_with_label ( _("Not Available") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_na), NULL );

	item = gtk_menu_item_new_with_label ( _("Free for Chat") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_ffc), NULL );

	item = gtk_menu_item_new_with_label ( _("Occupied") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_occ), NULL );

	item = gtk_menu_item_new_with_label ( _("Do Not Disturb") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_dnd), NULL );

	item = gtk_menu_item_new_with_label ( _("Invisible") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_invisible), NULL );

	return menu;
}

void read_next( GtkWidget *widget, gpointer data )
{
     GtkWidget *text;
     GtkWidget *timefield;
     GtkWidget *fromfield = NULL;
     GtkWidget *subjectfield = NULL;
     GtkWidget *emailfield = NULL;
     GtkWidget *ipfield = NULL;
     GtkWidget *iplabel = NULL;

     struct tm *my_tm;
     char msgtime[40];
     gchar *new_str;
     gchar *tmp, *tmp2 = NULL;

     GSList *contact;

     STORED_MESSAGE_PTR msg;

#ifdef TRACE_FUNCTION
     g_print( "read_next\n" );
#endif

     if (!GTK_WIDGET_SENSITIVE (widget))
     	return;

	contact = gtk_object_get_data( GTK_OBJECT (widget), "contact" );

     if( contact == NULL )
	  return;
/* BEGIN COPY #1 */
     msg = (STORED_MESSAGE_PTR)kontakt->stored_messages->data;
/*     text = gtk_object_get_data( GTK_OBJECT( widget ), "text" );
     timefield = gtk_object_get_data( GTK_OBJECT( widget ), "time" );
*/
     if ( kontakt->uin == 10 )
     {
	  fromfield = gtk_object_get_data( GTK_OBJECT( widget ), "fromfield" );
	  subjectfield = gtk_object_get_data( GTK_OBJECT( widget ), "subjectfield" );
	  emailfield = gtk_object_get_data( GTK_OBJECT( widget ), "emailfield" );
	  ipfield = gtk_object_get_data( GTK_OBJECT( widget ), "ipfield" );
	  iplabel = gtk_object_get_data( GTK_OBJECT( ipfield ), "label" );
     }

     if( g_slist_length( kontakt->stored_messages ) )
     {
/*	  snprintf( buf, 100, _("Message from %s:"), kontakt->nick );  What is this line for?? */
/*	  gtk_editable_delete_text(GTK_EDITABLE(text), 0, -1);*/
	  open_message_dlg_with_message (kontakt->uin, msg);
	  g_free( msg->message );
	  g_free( msg );
	  kontakt->stored_messages = g_slist_remove( kontakt->stored_messages, msg );

	  if( g_slist_length( kontakt->stored_messages ) == 0 )
	  {
		kontakt->icon_p = get_pixmap_for_status( kontakt->status );
		kontakt->icon_b = get_bitmap_for_status( kontakt->status );
		kontakt->need_update = 1;
		gtk_widget_set_sensitive (kontakt->read_next, FALSE);
	  }
	  else
	  {
		/* msg points to some strange location already */
		if( ((STORED_MESSAGE_PTR)kontakt->stored_messages->data)->type != MESSAGE_TEXT )
			gtk_widget_set_sensitive( kontakt->read_next, FALSE );
		else
			gtk_widget_set_sensitive( kontakt->read_next, TRUE );
	  }

	  Update_Contact_Style( Which_List( kontakt ), kontakt );
	  applet_update( Current_Status, FALSE );
	  Shortcut_Update( kontakt );
	  return;

	  /* Strip \r's out of text - \r's are for Windows people */
	  new_str = stripr( msg->message );
	  g_free( msg->message );
	  msg->message = new_str;

	  my_tm = localtime (&msg->time);
	  strftime (msgtime, sizeof (msgtime), _("%c"), my_tm);
	  gtk_entry_set_text( GTK_ENTRY( timefield ), msgtime );
	
	  kanji_conv_to_locale_s( &msg->message );

	  if ( kontakt->uin == 10 )
	  {
		     /* I know this is ugly, fix your translation --Tester */
		     if (toggles->russian)
			  tmp = g_strdup_printf("%c", 192);
		     else
			  tmp = g_strdup_printf("%c", 0xFE);

		     tmp2 = strtok( msg->message, tmp);
		     g_assert(tmp2 != NULL);
		     gtk_entry_set_text( GTK_ENTRY( fromfield ), tmp2 );

		     tmp2 = strtok( NULL, tmp);
		     g_assert(tmp2 != NULL);
		     gtk_entry_set_text( GTK_ENTRY( emailfield ), tmp2 );

		     tmp2 = strtok( tmp2, "\n");
		     g_assert(tmp2 != NULL);

		     if (!strncmp(tmp2,"Sender IP:", 10))
		     {
			  gtk_widget_show (iplabel);
			  gtk_widget_show (ipfield);

			  tmp2 = strchr(tmp2, ':') + 2;

			  gtk_entry_set_text( GTK_ENTRY( ipfield ), tmp2 );

			  tmp2 = strtok( NULL, "\n");
			  g_assert(tmp2 != NULL);
		     }
		     else
		     {
			  gtk_widget_hide(ipfield);
			  gtk_widget_hide(iplabel);
		     }

		     tmp2 = strchr(tmp2, ':' ) + 2;
		     g_assert(tmp2 != (gchar *)2);

                     gtk_entry_set_text( GTK_ENTRY( subjectfield ), (gchar *)tmp2 );

		     tmp2 = strtok( NULL, tmp);
		     g_free(tmp);

		     gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
				      tmp2, -1);
		}
		else
		     gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
		                      msg->message, -1 );
/* END COPY #1 */

/* BEGIN COPY #2 */
          g_free( msg->chatsessionname );
	  if ( msg->type == MESSAGE_URL || 
               (msg->type == MESSAGE_CHAT_REQ && 
                ((ChatContact *)msg->data)->contact == NULL) )
            g_free( msg->data );
     }
/* END COPY #2 */
}

void send_chat_request( GtkWidget *widget, GtkWidget *text )
{
     GSList *contact;
     ChatSession *csession = NULL;
     GtkWidget *menu;

#ifdef TRACE_FUNCTION
     g_print( "send_chat_request\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
	     return;

	menu = gtk_object_get_data( GTK_OBJECT(widget), "OptionMenu");
	if (GTK_IS_MENU (menu))
	     csession = gtk_object_get_data( GTK_OBJECT(gtk_menu_get_active(GTK_MENU(menu))), "ChatSession");


	TCPSendChatRequest( kontakt->uin,
	                    gtk_editable_get_chars( GTK_EDITABLE( text ), 0, -1 ), csession);
}

void send_file_request( GtkWidget *widget, gpointer data )
{
	GSList *filenames = 0;
	gchar *filename = 0;
	gchar *msg;
	GtkText *text;
	GtkWidget *entry;
	UIN_T uin;
	gint currow;

	uin = GPOINTER_TO_INT( gtk_object_get_data( GTK_OBJECT( widget ), "uin" ) );
	text = gtk_object_get_data( GTK_OBJECT( widget ), "reason" );
	entry = gtk_object_get_data( GTK_OBJECT( widget ), "filelist" );

	for (currow = 0;gtk_clist_get_text( GTK_CLIST(entry), currow, 0, &filename);currow++)
		filenames = g_slist_append(filenames, filename);

	msg = g_strdup( gtk_editable_get_chars( GTK_EDITABLE( text ), 0, -1 ) );

	TCPSendFileRequest( uin, msg, filenames );

	g_slist_free(filenames);

	g_free( msg );
}

void send_url_window( GtkWidget *widget, char *defaulturl )
{
	GtkWidget *window;
	GtkWidget *dialog_vbox2;
	GtkWidget *vbox12;
	GtkWidget *label20;
	GtkWidget *table4;
	GtkWidget *label21;
	GtkWidget *label22;
	GtkWidget *entry2;
	GtkWidget *combo_entry2;
	GtkWidget *entry3;
	GtkWidget *combo_entry3;
	GtkWidget *button4;

	gchar *wtitle;

	struct URLInfo *urlinfo;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "send_url_window\n" );
#endif

	if (gtk_object_get_data (GTK_OBJECT (widget), "contact") == NULL)
		contact = get_contact_from_clist();
	else {
		contact = Contacts;
		while (contact != NULL && contact->data != gtk_object_get_data (GTK_OBJECT (widget), "contact"))
			contact = contact->next;
	}

	if( contact == NULL )
		return;

	urlinfo = g_new0( struct URLInfo, 1 );
	urlinfo->contact = contact;

	wtitle = g_strdup_printf( _("Send URL to: %s"), kontakt->nick );

	window = gnome_dialog_new (_("GnomeICU: Send URL"), NULL);
	gtk_window_set_default_size( GTK_WINDOW( window ), 500, 150 );
	gtk_window_set_policy (GTK_WINDOW (window), FALSE, TRUE, FALSE);
	gtk_window_set_wmclass (GTK_WINDOW (window), "SendURL", "GnomeICU");

	set_window_icon( window, "gnomeicu-url.png" );

	dialog_vbox2 = GNOME_DIALOG (window)->vbox;

	vbox12 = gtk_vbox_new (FALSE, 4);
	gtk_widget_show (vbox12);
	gtk_box_pack_start (GTK_BOX (dialog_vbox2), vbox12, TRUE, TRUE, 0);

	label20 = gtk_label_new ( wtitle );
	g_free( wtitle );
	gtk_widget_show (label20);
	gtk_box_pack_start (GTK_BOX (vbox12), label20, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label20), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label20), 0, 0.5);

	table4 = gtk_table_new (2, 2, FALSE);
	gtk_widget_show (table4);
	gtk_box_pack_start (GTK_BOX (vbox12), table4, TRUE, TRUE, 0);
	gtk_table_set_row_spacings (GTK_TABLE (table4), 4);
	gtk_table_set_col_spacings (GTK_TABLE (table4), 4);

	label21 = gtk_label_new (_("URL:"));
	gtk_widget_show (label21);
	gtk_table_attach (GTK_TABLE (table4), label21, 0, 1, 0, 1,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label21), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label21), 1, 0.5);

	label22 = gtk_label_new (_("Description:"));
	gtk_widget_show (label22);
	gtk_table_attach (GTK_TABLE (table4), label22, 0, 1, 1, 2,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label22), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label22), 1, 0.5);

	entry2 = gnome_entry_new ("gnomeicu_url");
	gtk_widget_show (entry2);
	gtk_table_attach (GTK_TABLE (table4), entry2, 1, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	combo_entry2 = gnome_entry_gtk_entry (GNOME_ENTRY (entry2));
	gtk_entry_set_text(GTK_ENTRY(combo_entry2), defaulturl);

	urlinfo->url = combo_entry2;

	entry3 = gnome_entry_new ("gnomeicu_history_desc");
	gtk_widget_show (entry3);
	gtk_table_attach (GTK_TABLE (table4), entry3, 1, 2, 1, 2,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	combo_entry3 = gnome_entry_gtk_entry (GNOME_ENTRY (entry3));
	urlinfo->desc = combo_entry3;

	gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (window),
						_("Send"),
						GNOME_STOCK_PIXMAP_JUMP_TO);
	button4 = g_list_last (GNOME_DIALOG (window)->buttons)->data;

	gtk_signal_connect (GTK_OBJECT (button4), "clicked",
			    GTK_SIGNAL_FUNC (icq_sendurl), urlinfo);

	gnome_dialog_append_button (GNOME_DIALOG (window),
				    GNOME_STOCK_BUTTON_CLOSE);
	gnome_dialog_set_default (GNOME_DIALOG (window), 0);

	gnome_dialog_set_close (GNOME_DIALOG (window), TRUE);

	gtk_window_set_focus (GTK_WINDOW (window), combo_entry2);
	gnome_dialog_editable_enters (GNOME_DIALOG (window),
				      GTK_EDITABLE (combo_entry2));
	gnome_dialog_editable_enters (GNOME_DIALOG (window),
				      GTK_EDITABLE (combo_entry3));

	/* This hopefully destroys urlinfo on window close */
        /* Tester: This does not seem to work */
	gtk_signal_connect_object (GTK_OBJECT (window), "delete_event",
				   GTK_SIGNAL_FUNC (g_free),
				   (gpointer) urlinfo);

	gtk_widget_show (window);
}

void remove_contact(UIN_T uin, gboolean rem_history)
{
	GSList *contact;
	gint method;

#ifdef TRACE_FUNCTION
	g_print( "remove_contact\n" );
#endif

	contact = Find_User (uin);

	if( contact == NULL )
		return;

	if( kontakt->inlist == FALSE )
		method = UPDATE_NOTLIST;
	else if( kontakt->status == STATUS_OFFLINE )
		method = UPDATE_OFFLINE;
	else
		method = UPDATE_ONLINE;

	if (rem_history)
	{
		gchar *path;

#ifdef HAVE_ICUDB
		path = g_strdup_printf( "%s/.icq/history/%d.db", g_get_home_dir(),
		                        kontakt->uin );
#else
		path = g_strdup_printf( "%s/.icq/history/%d", g_get_home_dir(),
		                        kontakt->uin );
#endif
		unlink( path );
		g_free( path );
	}

	if( kontakt->sok )
	{
		close( kontakt->sok );
		g_io_channel_close( kontakt->gioc );
		g_source_remove( kontakt->giocw );
	}

	if( kontakt->detached_window )
		gtk_widget_destroy( kontakt->detached_window );

	if (kontakt->msg_dlg_xml)
		gtk_widget_destroy (glade_xml_get_widget (kontakt->msg_dlg_xml, "message_dialog"));

	if (kontakt->info_dlg_xml)
		gtk_widget_destroy (glade_xml_get_widget (kontakt->info_dlg_xml, "userinfo_dialog"));

	Show_Quick_Status_lower( method, contact );
	applet_update( Current_Status, FALSE );
}

void icq_set_status( GtkWidget *widget, gpointer data )
{
	int status = GPOINTER_TO_INT( data );

	if ( status == STATUS_OFFLINE )
		icq_set_status_offline( NULL, NULL ); return;
	switch( status & 0xffff )
	{
		case STATUS_ONLINE:
			icq_set_status_online( NULL, NULL ); break;
		case STATUS_AWAY:
			icq_set_status_away( NULL, NULL ); break;
		case STATUS_NA:
			icq_set_status_na( NULL, NULL ); break;
		case STATUS_FREE_CHAT:
			icq_set_status_ffc( NULL, NULL ); break;
		case STATUS_OCCUPIED:
			icq_set_status_occ( NULL, NULL ); break;
		case STATUS_DND:
			icq_set_status_dnd( NULL, NULL ); break;
		case STATUS_INVISIBLE:
			icq_set_status_invisible( NULL, NULL ); break;
	}
}

void icq_set_status_online( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_online\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
/*       	create_tcp_line(); */

  		preset_status = STATUS_ONLINE; 
  		Done_Login = FALSE; 
                v7_new_login_session();
                
	}
	else
	{
		v7_setstatus( STATUS_ONLINE );
	}
}

void icq_set_status_offline( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_offline\n" );
#endif

	contact = Contacts;
        
        v7_quit();

	if( Current_Status == STATUS_OFFLINE )
          return;

	Current_Status = STATUS_OFFLINE;

	while( contact != NULL )
	{
		kontakt->last_status = kontakt->status;
		kontakt->status = STATUS_OFFLINE;
		kontakt->have_tcp_connection = NO;
		if( kontakt->sok )
		{
			g_io_channel_close( kontakt->gioc );
			close( kontakt->sok );
			g_source_remove( kontakt->giocw );
			kontakt->gioc = 0;
			kontakt->sok = 0;
		}
		contact = contact->next;
	}

	Show_Quick_Status_lower( UPDATE_ONLINE | UPDATE_OFFLINE | UPDATE_NOTLIST, NULL );

        enable_online_events = FALSE;

	ready_set();
}

int icq_set_status_away( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_away\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
/*  		create_tcp_line(); */
                preset_status = STATUS_AWAY;
  		Done_Login = FALSE; 
                v7_new_login_session();  
	}
	else
	{
		v7_setstatus( STATUS_AWAY );
		change_away_window( NULL, NULL );
	}

	return FALSE;
}

void icq_set_status_na( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_na\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
/*  		create_tcp_line(); */
		preset_status = STATUS_NA;
                Done_Login = FALSE; 
                v7_new_login_session();  
	}
	else
	{
		v7_setstatus( STATUS_NA );
		change_away_window( NULL, NULL );
	}
}

void icq_set_status_invisible( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_invisible\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
/*  		create_tcp_line(); */
		preset_status = STATUS_INVISIBLE;
                Done_Login = FALSE; 
                v7_new_login_session();   
	}
	else
	{
		v7_setstatus( STATUS_INVISIBLE );
	}
}

void icq_set_status_ffc( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_ffc\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
/*  		create_tcp_line(); */
		preset_status = STATUS_FREE_CHAT;
                Done_Login = FALSE; 
                v7_new_login_session();  
	}
	else
	{
		v7_setstatus( STATUS_FREE_CHAT );
	}
}

void icq_set_status_occ( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_occ\n" );
#endif

	if( Current_Status == STATUS_OCCUPIED )
		return;

	if( Current_Status == STATUS_OFFLINE )
	{
/*  		create_tcp_line(); */
		preset_status = STATUS_OCCUPIED;
                Done_Login = FALSE;
                v7_new_login_session();  
	}
	else
	{
		v7_setstatus( STATUS_OCCUPIED );
		change_away_window( NULL, NULL );
	}
}

void icq_set_status_dnd( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_dnd\n" );
#endif

	if( Current_Status == STATUS_DND )
		return;

	if( Current_Status == STATUS_OFFLINE )
	{
		/*  create_tcp_line(); */
  		preset_status = STATUS_DND; 
  		Done_Login = FALSE; 
                v7_new_login_session();  
	}
	else
	{
		v7_setstatus( STATUS_DND );
		change_away_window( NULL, NULL );
	}
}

void display_url( GtkWidget *widget, char *url )
{
	gnome_url_show( url );
}

void display_url_from_entry( GtkWidget *widget, GtkEntry *entry )
{
	display_url( NULL, gtk_entry_get_text( entry ) );
}

gint app_save_state_cb( GnomeClient *client, gint phase, GnomeRestartStyle save_style, gint shutdown, GnomeInteractStyle interact_style, gint fast, gpointer client_data )
{
	gchar *prefix= gnome_client_get_config_prefix (client);
	gchar *argv[]= { "rm", "-r", NULL, NULL };
	gchar *config_param = NULL;
	int i = 1;

#ifdef TRACE_FUNCTION
	g_print ("app_save_state_cb\n");
#endif

	/* Here is the real SM code. We set the argv to the parameters needed
	   to restart/discard the session that we've just saved and call
	   the gnome_session_set_*_command to tell the session manager it. */

	argv[2] = gnome_config_get_real_path (prefix);
	gnome_client_set_discard_command (client, 3, argv);

	/* Set commands to clone and restart this application.  Note that we
	   use the same values for both -- the session management code will
	   automatically add whatever magic option is required to set the
	   session id on startup.  */

	argv[0]= (gchar*) client_data;
	if ( toggles->applet == FALSE )
		argv[i++] = "-a";
	if ( strlen( configfilename ) )
	{
		config_param = g_strdup_printf ("--config=%s", configfilename);
		argv[i++] = config_param;
	}

	gnome_client_set_restart_command (client, i, argv);
	gnome_client_set_clone_command (client, 0, NULL);

	g_free(config_param);

	return TRUE;
}

int hide_ch_window( GtkWidget *widget, GdkEvent *event, GtkWidget *window )
{
#ifdef TRACE_FUNCTION
	g_print( "hide_ch_window\n" );
#endif
	gtk_widget_hide( window );
	return TRUE;
}

/* Callback for status menu positioning */
static void cb_menu_position (GtkMenu *menu, gint *x, gint *y, gpointer user_data)
{
	GtkWidget *widget, *button;
	gint screen_width, screen_height;

	GtkRequisition requisition;

	widget = GTK_WIDGET (menu);
	button = GTK_WIDGET (user_data);

	gtk_widget_size_request (widget, &requisition);

	gdk_window_get_origin (button->window, x, y);
	*y -= requisition.height;

	screen_width = gdk_screen_width ();
	screen_height = gdk_screen_height ();

	if (*x + requisition.width > screen_width) {
	  *x -= *x + requisition.width - screen_width;
	}
}

int popup_status_menu( GtkWidget *widget, gpointer data )
{
	GtkWidget *status_menu;
	GtkWidget *pm, *item_box, *item_label;
	GtkWidget *item;

#ifdef TRACE_FUNCTION
	g_print( "popup_status_menu\n" );
#endif

	status_menu = gtk_menu_new();

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_online_pixmap, icon_online_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Online") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_online ),
	                    NULL );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_away_pixmap, icon_away_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Away") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_away ),
	                    NULL );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_na_pixmap, icon_na_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Not Available") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_na ),
	                    NULL );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_ffc_pixmap, icon_ffc_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Free for Chat") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_ffc ),
	                    NULL );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_occ_pixmap, icon_occ_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Occupied") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_occ ),
	                    NULL );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_dnd_pixmap, icon_dnd_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Do Not Disturb") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_dnd ),
	                    NULL );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_inv_pixmap, icon_inv_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Invisible") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_invisible ),
	                    NULL );
	gtk_widget_show( item );

	item = gtk_menu_item_new();
	gtk_widget_set_sensitive( item, FALSE );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_offline_pixmap, icon_offline_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Offline") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_offline ),
	                    NULL );
	gtk_widget_show( item );

	gtk_widget_show( status_menu );

	gtk_menu_popup( GTK_MENU( status_menu ), NULL, NULL,
	                cb_menu_position, widget,
	                0, 0 );

	return TRUE;
}

/*** Local functions ***/
void icq_auth_request_clicked( GnomeDialog *dialog, gint button, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_auth_request_clicked\n" );
#endif

	if( button == 0 )
		/* Allow */
          v7_grant_auth( GPOINTER_TO_INT( data ));
        else if ( button == 1 )
          v7_deny_auth(GPOINTER_TO_INT( data ), "Authorisation denied");
          

	gnome_dialog_close (dialog);
}

void icq_accept_chat( GtkWidget *widget, GSList *contact )
{
     int sock = kontakt->sok;
     GtkWidget *menu;
     ChatSession *csession = NULL;
     ChatContact *ccontact;

#ifdef TRACE_FUNCTION
     g_print( "icq_accept_chat\n" );
#endif

     menu = gtk_object_get_data( GTK_OBJECT(widget), "OptionMenu");
     ccontact = gtk_object_get_data( GTK_OBJECT(widget), "Chatcontact");
     if (GTK_IS_MENU (menu))
	  csession = gtk_object_get_data( GTK_OBJECT(gtk_menu_get_active(GTK_MENU(menu))), "ChatSession");

     if (csession)
	  ccontact->chatsession = csession;

     TCPAcceptChat( sock, ccontact);
}

void icq_refuse_chat( GtkWidget *widget, GSList *contact )
{

     ChatContact *ccontact = gtk_object_get_data( GTK_OBJECT(widget), "ChatContact");
     int sock = kontakt->sok;

#ifdef TRACE_FUNCTION
     g_print( "icq_refuse_chat\n" );
#endif

     TCPRefuseChat( sock, ccontact);
}

void icq_accept_file( GtkWidget *widget, gpointer xfer )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_accept_file\n" );
#endif

	TCPAcceptFile( xfer );
}

void icq_refuse_file( GtkWidget *widget, gpointer xfer )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_refuse_file\n" );
#endif

	TCPRefuseFile( xfer );
}

/* FIXME: Come on.. clean this up, jwise.. this is a pathetic hack. */
void grab_history( GtkWidget *widget, gpointer data )
{
	GSList *contact;
/*	GSList *contact = gtk_object_get_data( GTK_OBJECT( gtk_menu_get_active( gtk_object_get_data( GTK_OBJECT( widget ), "menu" ) ) ), "contact" );*/
	contact = gtk_object_get_data (GTK_OBJECT (widget), "contact");
	history_display( NULL, contact->data );
}

void request_file_action ( GSList *completed_files )
{
    GtkWidget *dialog, *dialog_vbox, *main_vbox, *label;
    GtkWidget *label_name, *hseparator, *button_file, *button_del; /* , *button_dir; */
    GtkWidget *hbox;
    gchar *full_filename = NULL;

    GSList *file;

    dialog = gnome_dialog_new( _("Files recieved successfully"), NULL );
    gtk_window_set_policy( GTK_WINDOW( dialog ), FALSE, FALSE, TRUE );
    gnome_dialog_set_close( GNOME_DIALOG( dialog), TRUE );

    dialog_vbox = GNOME_DIALOG( dialog )->vbox;

    main_vbox = gtk_vbox_new( FALSE, 0 );
    gtk_box_pack_start ( GTK_BOX( dialog_vbox ), main_vbox, TRUE, TRUE, 0 );

    label = gtk_label_new( _("The following files have been successfully retrieved.") );
    gtk_box_pack_start( GTK_BOX( main_vbox ), label, FALSE, TRUE, 0 );
    gtk_label_set_line_wrap( GTK_LABEL( label ), TRUE );

    hseparator = gtk_hseparator_new();
    gtk_box_pack_start( GTK_BOX( main_vbox ), hseparator, FALSE, TRUE, 0 );

    for ( file = completed_files; file; file = file->next )
    {
        hbox = gtk_hbox_new( FALSE, 3 );
        gtk_box_pack_start( GTK_BOX( main_vbox ), hbox, TRUE, TRUE, 0 );
        gtk_container_set_border_width( GTK_CONTAINER( hbox ), 3 );

        label_name = gtk_label_new( ((struct file_struct*)file->data)->short_filename );

        gtk_box_pack_start( GTK_BOX( hbox ), label_name, TRUE, TRUE, 0 );
        gtk_misc_set_alignment( GTK_MISC( label_name ), 0, 0.5 );

        full_filename = g_strdup( ((struct file_struct*)file->data)->full_filename );
        button_file = gtk_button_new_with_label( _("Open File") );
        gtk_box_pack_start( GTK_BOX( hbox ), button_file, FALSE, FALSE, 0 );
        gtk_object_set_data( GTK_OBJECT( button_file ), "filename", full_filename );

	button_del = gtk_button_new_with_label( _("Delete") );
	gtk_box_pack_start( GTK_BOX( hbox ), button_del, FALSE, FALSE, 0 );
	gtk_object_set_data( GTK_OBJECT( button_del ), "filename", full_filename );
	gtk_object_set_data( GTK_OBJECT( button_del ), "hbox", hbox );
	gtk_object_set_data( GTK_OBJECT( button_del ), "button_file", button_file );



        /*        button_dir = gtk_button_new_with_label( _("Open Dir") );
        gtk_box_pack_start( GTK_BOX( hbox ), button_dir, FALSE, FALSE, 0 );
        gtk_object_set_data( GTK_OBJECT( button_file ), "filename", full_filename ); */

        gtk_signal_connect( GTK_OBJECT( button_file ), "clicked",
                            GTK_SIGNAL_FUNC( open_file ),
                            NULL );

        gtk_signal_connect( GTK_OBJECT( button_del ), "clicked",
                            GTK_SIGNAL_FUNC( del_file ),
                            NULL );

        /*        gtk_signal_connect( GTK_OBJECT( button_dir ), "clicked",
                            GTK_SIGNAL_FUNC( open_dir ),
                            NULL ); */

    }

    gnome_dialog_append_button( GNOME_DIALOG( dialog ), GNOME_STOCK_BUTTON_CLOSE );

    gtk_widget_show_all( dialog );
}

static void open_file( GtkWidget *widget, gpointer data )
{
    const gchar *filename = NULL, *mime_tpe = NULL;
    gchar *prgm, *prgm_orig, *cmd = NULL, *argv[4];
    int loc;

    filename = gtk_object_get_data( GTK_OBJECT( widget ), "filename" );
    mime_tpe = gnome_mime_type_of_file( filename );
    prgm = g_strdup( gnome_mime_program( mime_tpe ) );
    prgm_orig = prgm;

    if (prgm)
    {
        loc = (int)strstr(prgm, "%f") - (int)prgm;
        cmd = g_strdup_printf("%s\"%s\"", g_strndup(prgm, loc), filename);
        prgm += loc + 2;
        cmd = g_strdup_printf("%s%s", cmd, prgm);

        argv[0] = "/bin/sh";
        argv[1] = "-c";
        argv[2] = cmd;
        argv[3] = NULL;

        gnome_execute_async( NULL, 4, argv );
        g_free( prgm_orig );
        g_free( cmd );
    }
}

static void del_file( GtkWidget *widget, gpointer data )
{
     const gchar *filename = NULL;
     GtkWidget *hbox, *button_file, *label;

     filename = gtk_object_get_data( GTK_OBJECT( widget ), "filename" );
     hbox = gtk_object_get_data( GTK_OBJECT( widget ), "hbox" );
     button_file = gtk_object_get_data( GTK_OBJECT( widget ), "button_file" );

     if (unlink(filename) == 0) {

	  gtk_widget_hide(hbox);

	  gtk_widget_destroy(widget);
	  gtk_widget_destroy(button_file);

	  label = gtk_label_new(_("DELETED"));

	  gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );

	  gtk_widget_show_all(hbox);

     }

}

/* static void open_dir( GtkWidget *widget, gpointer data )
{
    g_print("Should open the dir...\n");
} */

gboolean icq_sendmessage_window( GtkWidget *clist, GdkEventButton *event, gpointer data )
{
	int row, column;

	UIN_T uin;

	GSList *contact;

	if( event == NULL )
		return FALSE;

#ifdef TRACE_FUNCTION
	g_print( "icq_sendmessage_window\n" );
#endif

	if( event->type == GDK_KEY_PRESS )
	{
 		if( ((GdkEventKey*)event)->keyval != GDK_Return && ((GdkEventKey*)event)->keyval != ' ' )
			return FALSE;
	}
	else if( ( event->type == GDK_2BUTTON_PRESS && event->button != 1 ) ||
	         ( event->type == GDK_BUTTON_PRESS && event->button != 3 ) )
			return FALSE;

        MainData->lb_userwin = clist;
	gtk_clist_get_selection_info( GTK_CLIST( clist ), event->x, event->y,
	                              &row, &column );

	if( event->type == GDK_KEY_PRESS )
		row = GTK_CLIST(clist)->focus_row;

	if( !GTK_IS_SCROLLBAR( clist ) &&
	    event->type == GDK_BUTTON_PRESS && event->button == 3 )
		 gtk_clist_select_row( GTK_CLIST( clist ), row, column );

	if( data != NULL )
		contact = (GSList*)data;
	else 
	{
		uin = GPOINTER_TO_INT( gtk_clist_get_row_data( GTK_CLIST( clist ), row ) );

		if( uin == 0 )
			return FALSE;

		contact = Find_User( uin );
		if( contact == NULL )
			return FALSE;
	}

	if( ( event->type == GDK_BUTTON_PRESS && event->button == 3 ) ||
	    ( event->type == GDK_KEY_PRESS && ((GdkEventKey*)event)->keyval == ' ' ) )
	{
		GtkWidget *personal_menu;
		GdkEventButton *bevent = (GdkEventButton *) event;

		personal_menu = user_popup (kontakt);
		gtk_menu_popup( GTK_MENU( personal_menu ), NULL, NULL, NULL,
				NULL, bevent->button, bevent->time );
		return TRUE;
	}

	if( g_slist_length( kontakt->stored_messages ) )
		show_contact_message( contact );
	else
		open_message_dlg_with_message (kontakt->uin, NULL);

	return TRUE;
}
