#include "common.h"
#include "gnomeicu.h"
#include "ignore.h"
#include "listwindow.h"
#include "showlist.h"
#include "v7send.h"
#include "v7snac13.h"

static void modify_ignore_list( GtkWidget *widget, gpointer data );

static gboolean is_ignore (CONTACT_PTR contact);
static void remove_func (CONTACT_PTR contact);

gboolean is_ignore (CONTACT_PTR contact)
{
	return contact->ignore_list == TRUE;
}

void remove_func (CONTACT_PTR contact)
{
  if (contact->ignore_list)
    v7_ignore (contact->uin, contact->ignorelist_uid, FALSE);
  contact->ignore_list = FALSE;
  contact->ignorelist_uid = 0;
  Show_Quick_Status_lower (UPDATE_ONLINE|UPDATE_OFFLINE, NULL);
}

void ignore_list_dialog( void )
{
	static GtkWidget *dlg = NULL;
	
	if( dlg == NULL )
	{
		dlg = list_window_new(
			_("GnomeICU: Ignore List"), "Ignore_List",
                        /*
			_("Drag the users you wish to add to your\n"
			  "ignore list into this window, and then click\n"
			  "the \"Apply\" button below.")*/NULL,
			GNOME_STOCK_BUTTON_OK, NULL,
			GTK_SIGNAL_FUNC (modify_ignore_list),
			is_ignore,
                        remove_func
		);
		gtk_widget_show_all( dlg );
		gtk_signal_connect( GTK_OBJECT(dlg), "destroy",
				    GTK_SIGNAL_FUNC(gtk_widget_destroyed),
				    &dlg );
	} else {
		gdk_window_show(dlg->window);
		gdk_window_raise(dlg->window);
	}
}

void modify_ignore_list( GtkWidget *widget, gpointer data )
{
	GtkCList *clist = GTK_CLIST( data );
	gchar *uin;
	int cx;

	gint method = 0;

	GSList *contact;
	gboolean inlist;

#ifdef TRACE_FUNCTION
	g_print( "modify_ignore_list\n" );
#endif

	contact = Contacts;
	
	while( contact != NULL )
	{
		inlist = FALSE;
		if (kontakt->ignore_list) {
			for (cx = 0; cx < clist->rows; cx++) {
				gtk_clist_get_text (clist, cx, 0, &uin);
				if (atoi (uin) == kontakt->uin) {
					inlist = TRUE;
					break;
				}
			}
			if (!inlist) {
				if (kontakt->inlist == FALSE)
					method |= UPDATE_NOTLIST;
				else if (kontakt->status == STATUS_OFFLINE)
					method |= UPDATE_OFFLINE;
				else
					method |= UPDATE_ONLINE;
			}
			kontakt->ignore_list = FALSE;
		}
		contact = contact->next;
	}

	for( cx = 0; cx < clist->rows; cx ++ )
	{
		gtk_clist_get_text( clist, cx, 0, &uin );
		contact = Contacts;
		while( contact != NULL )
		{
			if( atoi( uin ) == kontakt->uin )
			{
				kontakt->ignore_list = TRUE;
                                if (kontakt->invis_list == FALSE) {
                                  kontakt->invis_list = TRUE;
                                  /* v7_addinvisible(kontakt->uin); OLD */
                                }
                                if ( kontakt->vis_list == TRUE ) {
                                  kontakt->vis_list = FALSE;
                                  /* v7_remvisible(kontakt->uin); OLD */
                                }

				if( kontakt->inlist == FALSE )
					method |= UPDATE_NOTLIST;
				else if( kontakt->status == STATUS_OFFLINE )
					method |= UPDATE_OFFLINE;
				else
					method |= UPDATE_ONLINE;
			}

			contact = contact->next;
		}
	}

	Show_Quick_Status_lower( method, NULL );

	gtk_widget_set_sensitive( widget, FALSE );
}
