#include "common.h"
#include "gnomeicu.h"
#include "invisible.h"
#include "listwindow.h"
#include "v7send.h"
#include "v7snac13.h"

static void modify_invisible_list( GtkWidget *widget, gpointer data );

static gboolean is_invisible (CONTACT_PTR contact);
static void remove_func (CONTACT_PTR contact);

gboolean is_invisible (CONTACT_PTR contact)
{
	return contact->invis_list == TRUE;
}

void remove_func (CONTACT_PTR contact)
{
  if (contact->invis_list)
    v7_invisible (contact->uin, contact->invlist_uid, FALSE);
  contact->invis_list = FALSE;
  contact->invlist_uid = 0;
}

void invisible_list_dialog( void )
{
	static GtkWidget *dlg = NULL;
	
	if( dlg == NULL )
	{
		dlg = list_window_new(
			_("GnomeICU: Invisible List"), "Invisible_List",
                        /*
			_("Drag the users you wish to add to your\n"
			  "invisible list into this window, and then click\n"
			  "the \"Apply\" button below.")*/NULL,
			GNOME_STOCK_BUTTON_OK, NULL,
			GTK_SIGNAL_FUNC (modify_invisible_list),
			is_invisible,
                        remove_func
		);
		gtk_widget_show_all( dlg );
		gtk_signal_connect( GTK_OBJECT(dlg), "destroy",
				    GTK_SIGNAL_FUNC(gtk_widget_destroyed),
				    &dlg );
	} else {
		gdk_window_show(dlg->window);
		gdk_window_raise(dlg->window);
	}
}

void modify_invisible_list( GtkWidget *widget, gpointer data )
{
	GtkCList *clist = GTK_CLIST( data );
	gchar *uin;
	int cx;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "modify_invisible_list\n" );
#endif

	contact = Contacts;
	
	while( contact != NULL )
	{
		kontakt->invis_list = FALSE;
		contact = contact->next;
	}

	for( cx = 0; cx < clist->rows; cx ++ )
	{
		gtk_clist_get_text( clist, cx, 0, &uin );
		contact = Contacts;
		while( contact != NULL )
		{
                  if( atoi( uin ) == kontakt->uin )
                    {
                      if (kontakt->invis_list == FALSE) {
                        kontakt->invis_list = TRUE;
                        /* v7_addinvisible(kontakt->uin); OLD */
                        if (kontakt->vis_list == TRUE) {
                          kontakt->vis_list = FALSE;
                          /* v7_remvisible(kontakt->uin); OLD */
                          
                        }                                
                      } 
                    } 
                  
                  contact = contact->next;
		}
	}
        
        
        gtk_widget_set_sensitive( widget, FALSE );
}
