#include "common.h"
#include "dragdrop.h"
#include "gnomeicu.h"
#include "listwindow.h"
#include "personal_info.h"
#include "util.h"
#include "v7send.h"

static void remove_contact_list_candidate( GtkWidget *widget, gpointer data );
static void info_list_candidate( GtkWidget *widget, gpointer data );
static void label_drag_data_received( GtkWidget *widget,
				      GdkDragContext *context,
				      gint x, gint y, GtkSelectionData *data,
				      guint info, guint time);

GtkWidget* list_window_new( const gchar *title, const gchar *wmclass,
			    const gchar *label,
			    const gchar *button_name,
			    const gchar *button_pixmap,
			    GtkSignalFunc button_clicked,
			    IsInListFunc is_in_list,
                            RemoveFunc remove_func)
{
	GtkWidget *dialog;
	GtkWidget *dialog_vbox;
	GtkWidget *label2;
	GtkWidget *scrolledwindow1;
	GtkWidget *clist1;
	GtkWidget *hbuttonbox3;
	GtkWidget *remove_button;
	GtkWidget *info_button;
	GtkWidget *custom_button;

	char *buf[2];
	char *luin, *lnick;

	char *titles[2];

	GSList *contact;

	dialog = gnome_dialog_new (title, NULL);
	gtk_window_set_default_size( GTK_WINDOW( dialog ), -2, 374);
	gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);

	gtk_window_set_wmclass( GTK_WINDOW( dialog ), wmclass, "GnomeICU" );

	dialog_vbox = GNOME_DIALOG (dialog)->vbox;

	label2 = gtk_label_new (label);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), label2, FALSE, FALSE, 0);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	titles[0] = _("UIN");
	titles[1] = _("Nickname");

	clist1 = gtk_clist_new_with_titles (2, titles);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 65);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 80);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), clist1);
	gtk_widget_show (clist1);

	/* Some dialogs do not need initialization */
	/* TODO: move this into separate function */
	if( is_in_list != NULL )
	{
		contact = Contacts;

		while( contact != NULL )
		{
			if( is_in_list( kontakt ) )
			{
				luin = g_strdup_printf( "%d", kontakt->uin );
				lnick = kontakt->nick;
				buf[0] = luin;
				buf[1] = lnick;
				gtk_clist_append( GTK_CLIST( clist1 ), buf );
				g_free( luin );
			}
			contact = contact->next;
		}
	}
        /* disable drag and drop for now
	gtk_drag_dest_set( clist1, GTK_DEST_DEFAULT_ALL, target_table, 1,
	                   GDK_ACTION_COPY | GDK_ACTION_MOVE );
	gtk_signal_connect( GTK_OBJECT( clist1 ), "drag_data_received",
	                    GTK_SIGNAL_FUNC( label_drag_data_received ), clist1 );
        */
	hbuttonbox3 = gtk_hbutton_box_new ();
	gtk_widget_show (hbuttonbox3);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), hbuttonbox3, FALSE, FALSE, 0);

	info_button = gtk_button_new_with_label (_("User's Info"));

	gtk_signal_connect( GTK_OBJECT( info_button ), "clicked",
	                    GTK_SIGNAL_FUNC( info_list_candidate ),
	                    clist1 );

	gtk_widget_show (info_button);
	gtk_container_add (GTK_CONTAINER (hbuttonbox3), info_button);

	remove_button = gtk_button_new_with_label (_("Remove User"));
        gtk_object_set_data (GTK_OBJECT (remove_button),
                             "remove_user", remove_func);

	gtk_signal_connect( GTK_OBJECT( remove_button ), "clicked",
	                    GTK_SIGNAL_FUNC( remove_contact_list_candidate ),
	                    clist1 );

	gtk_widget_show (remove_button);
	gtk_container_add (GTK_CONTAINER (hbuttonbox3), remove_button);

	gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (dialog),
	                                        button_name, button_pixmap );
	custom_button = g_list_last (GNOME_DIALOG (dialog)->buttons)->data;

        /* disable event for the OK/apply button 
	gtk_signal_connect( GTK_OBJECT( custom_button ), "clicked",
			    button_clicked, clist1 );
        */
	gtk_object_set_data (GTK_OBJECT (custom_button), "clist", clist1);

	if( !strcmp( button_name, GNOME_STOCK_BUTTON_OK ) ) {
		gtk_widget_set_sensitive( custom_button, FALSE );

		gtk_object_set_data( GTK_OBJECT( remove_button ), "apply", custom_button );
		gtk_object_set_data( GTK_OBJECT( clist1 ), "apply", custom_button );
	}

	gnome_dialog_append_button (GNOME_DIALOG (dialog), GNOME_STOCK_BUTTON_CLOSE);
	gnome_dialog_set_close (GNOME_DIALOG (dialog), TRUE);

	return dialog;
}

GtkWidget* list_window_new_with_drag_drop( const gchar *title,
                                           const gchar *wmclass,
                                           const gchar *label,
                                           const gchar *button_name,
                                           const gchar *button_pixmap,
                                           GtkSignalFunc button_clicked,
                                           IsInListFunc is_in_list )
{
	GtkWidget *dialog;
	GtkWidget *dialog_vbox;
	GtkWidget *label2;
	GtkWidget *scrolledwindow1;
	GtkWidget *clist1;
	GtkWidget *hbuttonbox3;
	GtkWidget *remove_button;
	GtkWidget *info_button;
	GtkWidget *custom_button;

	char *buf[2];
	char *luin, *lnick;

	char *titles[2];

	GSList *contact;

	dialog = gnome_dialog_new (title, NULL);
	gtk_window_set_default_size( GTK_WINDOW( dialog ), -2, 374);
	gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);

	gtk_window_set_wmclass( GTK_WINDOW( dialog ), wmclass, "GnomeICU" );

	dialog_vbox = GNOME_DIALOG (dialog)->vbox;

	label2 = gtk_label_new (label);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), label2, FALSE, FALSE, 0);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	titles[0] = _("UIN");
	titles[1] = _("Nickname");

	clist1 = gtk_clist_new_with_titles (2, titles);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 65);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 80);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), clist1);
	gtk_widget_show (clist1);

	/* Some dialogs do not need initialization */
	/* TODO: move this into separate function */
	if( is_in_list != NULL )
	{
		contact = Contacts;

		while( contact != NULL )
		{
			if( is_in_list( kontakt ) )
			{
				luin = g_strdup_printf( "%d", kontakt->uin );
				lnick = kontakt->nick;
				buf[0] = luin;
				buf[1] = lnick;
				gtk_clist_append( GTK_CLIST( clist1 ), buf );
				g_free( luin );
			}
			contact = contact->next;
		}
	}

	gtk_drag_dest_set( clist1, GTK_DEST_DEFAULT_ALL, target_table, 1,
	                   GDK_ACTION_COPY | GDK_ACTION_MOVE );
	gtk_signal_connect( GTK_OBJECT( clist1 ), "drag_data_received",
	                    GTK_SIGNAL_FUNC( label_drag_data_received ), clist1 );

	hbuttonbox3 = gtk_hbutton_box_new ();
	gtk_widget_show (hbuttonbox3);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), hbuttonbox3, FALSE, FALSE, 0);

	info_button = gtk_button_new_with_label (_("User's Info"));

	gtk_signal_connect( GTK_OBJECT( info_button ), "clicked",
	                    GTK_SIGNAL_FUNC( info_list_candidate ),
	                    clist1 );

	gtk_widget_show (info_button);
	gtk_container_add (GTK_CONTAINER (hbuttonbox3), info_button);

	remove_button = gtk_button_new_with_label (_("Remove User"));

	gtk_signal_connect( GTK_OBJECT( remove_button ), "clicked",
	                    GTK_SIGNAL_FUNC( remove_contact_list_candidate ),
	                    clist1 );

	gtk_widget_show (remove_button);
	gtk_container_add (GTK_CONTAINER (hbuttonbox3), remove_button);

	gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (dialog),
	                                        button_name, button_pixmap );
	custom_button = g_list_last (GNOME_DIALOG (dialog)->buttons)->data;

	gtk_signal_connect( GTK_OBJECT( custom_button ), "clicked",
			    button_clicked, clist1 );
	gtk_object_set_data (GTK_OBJECT (custom_button), "clist", clist1);

	if( !strcmp( button_name, GNOME_STOCK_BUTTON_OK ) ) {
		gtk_widget_set_sensitive( custom_button, FALSE );

		gtk_object_set_data( GTK_OBJECT( remove_button ), "apply", custom_button );
		gtk_object_set_data( GTK_OBJECT( clist1 ), "apply", custom_button );
	}

	gnome_dialog_append_button (GNOME_DIALOG (dialog), GNOME_STOCK_BUTTON_CLOSE);
	gnome_dialog_set_close (GNOME_DIALOG (dialog), TRUE);

	return dialog;
}

void remove_contact_list_candidate( GtkWidget *widget, gpointer data )
{
  GtkWidget *clist;
  gchar *buf;
  GSList *contact;
  UIN_T uin;
  RemoveFunc removefunc = NULL;

  clist = GTK_WIDGET( data );
  if( clist == NULL )
    return;

  gtk_clist_get_text (GTK_CLIST (clist), GTK_CLIST (clist)->focus_row, 0, &buf);

  if (buf == NULL)
    return;

  uin = atoi (buf);

  removefunc = gtk_object_get_data (GTK_OBJECT (widget), "remove_user");

  if (removefunc == NULL) {
    g_warning ("removefunc is NULL.");
    return;
  }

  contact = Contacts;
  while (contact) {
    if (kontakt->uin == uin) {
      removefunc (contact->data);
      break;
    }
    contact = contact->next;
  }

  gtk_clist_remove( GTK_CLIST( clist ), GTK_CLIST( clist )->focus_row );
}

void info_list_candidate( GtkWidget *widget, gpointer data )
{
	GtkWidget *clist;
	UIN_T uin;
	gchar *text;
	GSList *contact;
	int res;

	clist = GTK_WIDGET( data );
	if( clist == NULL )
		return;

	res = gtk_clist_get_text( GTK_CLIST( clist ), GTK_CLIST( clist )->focus_row, 0, &text );

	if( res == 0 || text == NULL || text[0] == '\0' )
		return;

	uin = atoi( text );

	contact = Find_User( uin );
	if( contact == NULL )
		return;

        v7_request_info(uin);
        dump_personal_info( uin ); 
}

void label_drag_data_received (GtkWidget *widget, GdkDragContext *context,
                               gint x, gint y, GtkSelectionData *data,
                               guint info, guint time)
{
	gchar *str;
	gchar *uin, *nick;
	gchar *ptr_uin;
	gchar *buf[2];
	GtkWidget *button;

	if( data == NULL || data->data == NULL )
		return;

	str = g_strdup( (gchar*)data->data );

	nick = strchr( str, '\n' );
	nick[0] = 0;
	uin = str;
	nick++;
	if ((data->length >= 0) && (data->format == 8))
	{
		/* check if the uin is already in list, yes to ignore, no to append. */
		int cx;
		UIN_T cuin = atoi(uin);
		for ( cx = 0; cx < GTK_CLIST( widget )->rows; cx ++ )
		{
			gtk_clist_get_text( GTK_CLIST( widget ), cx, 0, &ptr_uin);
			if ( atoi(ptr_uin) == cuin) break;
		}
		/* If the uin is already in list, the cx will be small than */
		/* GTK_CLIST( widget )->rows. If you want notify the user */
		/* that the user is already in list, try else :) */
		if (cx == GTK_CLIST( widget )->rows) {
			buf[0] = uin;
			buf[1] = nick;
			gtk_clist_append( GTK_CLIST( widget ), buf );
		}
		gtk_drag_finish (context, TRUE, FALSE, time);
	}
	/* the g_free should be the same level as g_strdup. */
	/* Otherwise, It may cause the memory leak. */
	g_free( str );

	button = gtk_object_get_data( GTK_OBJECT( widget ), "apply" );
	if( button != NULL )
		gtk_widget_set_sensitive( button, TRUE );

	gtk_drag_finish (context, FALSE, FALSE, time);
}

#if 0

later share this too between visible/invisible/notify at least

void modify_list_window( GtkWidget *widget, gpointer data )
{
	GtkCList *clist = GTK_CLIST( data );
	gchar *uin;
	int cx;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "modify_visible_list\n" );
#endif

	contact = Contacts;
	
	while( contact != NULL )
	{
		/* <LI> unset */
		kontakt->vis_list = FALSE;
		/* </LI> */
		contact = contact->next;
	}

	for( cx = 0; cx < clist->rows; cx ++ )
	{
		gtk_clist_get_text( clist, cx, 0, &uin );
		contact = Contacts;
		while( contact != NULL )
		{
			if( atoi( uin ) == kontakt->uin )
			{
				/* <LI> toggle */
				kontakt->invis_list = FALSE;
				kontakt->vis_list = TRUE;
				/* </LI> */
				break;
			}

			contact = contact->next;
		}
	}

	/* <LI> send */
	snd_vis_list();
	snd_invis_list();
	/* </LI> */

	gtk_widget_set_sensitive( widget, FALSE );
}
#endif
