/************************************
 Message dialog routines
 (c) 1999 Jeremy Wise
 GnomeICU
*************************************/

#include "common.h"
#include "applet.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "gtkspell.h"
#include "icons.h"
#include "kanji_conv.h"
#include "msg.h"
#include "response.h"
#include "showlist.h"
#include "user_popup.h"
#include "util.h"
#include "v7send.h"

static char *ispell_cmd[] = { "ispell", "-a", NULL };

void open_message_dlg_with_message (UIN_T uin, STORED_MESSAGE_PTR message_text)
{
	GSList *contact;
	GladeXML *xml;
	GtkWidget *msg_dlg;
	GtkWidget *chat_toggle;
	GtkWidget *conversation;
	GtkWidget *input;
	GtkWidget *message_nick;
	GtkWidget *readnext_button;
	GtkWidget *history_button;
	GtkWidget *send_button;
	GtkWidget *usermenu_button;

	struct tm *my_tm;
	gchar short_msgtime[40];
	gchar *new_str;

	gchar *header;
	GdkColor header_color;

	gchar *title;

	/* gint cursor_position; */

	contact = Find_User (uin);
	if (!contact)
		return;

	if (kontakt->msg_dlg_xml != NULL)
		xml = kontakt->msg_dlg_xml;
	else {
		xml = glade_xml_new (GNOMEICU_GLADEDIR "message.glade", "message_dialog");
		if (!xml) {
			gnome_dialog_run (GNOME_DIALOG (gnome_message_box_new (
							  _("Unable to load Message Dialog interface!"),
							  GNOME_MESSAGE_BOX_ERROR,
							  GNOME_STOCK_BUTTON_OK,
							  NULL)));
			return;
		}
		kontakt->msg_dlg_xml = xml;
		gtk_object_set_data (GTK_OBJECT (glade_xml_get_widget (xml, "close_button")), "dlg",
		                                 glade_xml_get_widget (xml, "message_dialog"));
		gtk_object_set_data (GTK_OBJECT (glade_xml_get_widget (xml, "message_dialog")), "dlg",
		                                 glade_xml_get_widget (xml, "message_dialog"));

		chat_toggle = glade_xml_get_widget (xml, "chat_toggle");
		if (toggles->default_to_chat)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chat_toggle), TRUE);
		glade_xml_signal_autoconnect (xml);
	}

        set_window_icon( glade_xml_get_widget (xml, "message_dialog"),
                         "gnomeicu-message.png");
	msg_dlg = glade_xml_get_widget (xml, "message_dialog");
	title = g_strdup_printf ("%s - GnomeICU", kontakt->nick);
	gtk_window_set_title (GTK_WINDOW (msg_dlg), title);
	g_free (title);
	chat_toggle = glade_xml_get_widget (xml, "chat_toggle");
	conversation = glade_xml_get_widget (xml, "conversation");
	if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (chat_toggle)))
		gtk_editable_delete_text (GTK_EDITABLE (conversation), 0, -1);
	gtk_text_set_word_wrap (GTK_TEXT (conversation), TRUE);
	input = glade_xml_get_widget (xml, "input");
	gtk_text_set_word_wrap (GTK_TEXT (input), TRUE);
	if (!GTK_WIDGET_VISIBLE (input))
		gtk_editable_delete_text (GTK_EDITABLE (input), 0, -1);
	message_nick = glade_xml_get_widget (xml, "message_nick");
	gtk_entry_set_text (GTK_ENTRY (message_nick), kontakt->nick);
	kontakt->read_next = readnext_button = glade_xml_get_widget (xml, "readnext_button");
	history_button = glade_xml_get_widget (xml, "history_button");
	send_button = glade_xml_get_widget (xml, "send_button");
	usermenu_button = glade_xml_get_widget (xml, "usermenu_button");

	gtk_object_set_data (GTK_OBJECT (history_button), "contact", contact);
	gtk_object_set_data (GTK_OBJECT (readnext_button), "contact", contact);
	gtk_object_set_data (GTK_OBJECT (send_button), "contact", contact);
	gtk_object_set_data (GTK_OBJECT (input), "send", send_button);
	gtk_object_set_data (GTK_OBJECT (input), "readnext", readnext_button);
	gtk_object_set_data (GTK_OBJECT (input), "contact", contact);
	gtk_object_set_data (GTK_OBJECT (usermenu_button), "contact", contact);

	/* Turn on spell checking if so desired */
	if (toggles->check_spell)
	{
		if (!gtkspell_running())
			gtkspell_start(NULL, ispell_cmd);
		gtkspell_attach(GTK_TEXT(input));
	}

	if (message_text != NULL) {
		/* Show the time of this message in the time widget */
		my_tm = localtime (&message_text->time);
		strftime (short_msgtime, sizeof (short_msgtime), _("%X"), my_tm);
		
		/* Strip the \r's out of the message... */
		if (message_text->message) {
			new_str = stripr (message_text->message);
			g_free (message_text->message);
			message_text->message = new_str;
		}
	
		/* Convert to the correct locale */
		kanji_conv_to_locale_s (&message_text->message);

		/* Find out where to place the cursor */
		/* cursor_position = strlen (gtk_editable_get_chars (GTK_EDITABLE (conversation), 0, -1)); */
	
		/* Display the message */
		header_color.pixel = 0;
		header_color.red = 0;
		header_color.green = 0;
		header_color.blue = 65535;
		
		header = g_strdup_printf ("%s (%s): ", kontakt->nick, short_msgtime);
		gtk_text_insert (GTK_TEXT (conversation), NULL, &header_color, NULL, header, -1);
		g_free (header);
	
		header = g_strdup (message_text->message);
		while (*(header + strlen (header) - 1) == '\n' )
			*(header+strlen(header)-1) = 0x00;
		gtk_text_insert (GTK_TEXT (conversation), NULL, NULL, NULL, header, -1);
		gtk_text_insert (GTK_TEXT (conversation), NULL, NULL, NULL, "\n", 1);
		g_free (header);
                /* Why are we doing that ? */
                /* gtk_editable_set_position (GTK_EDITABLE (conversation), cursor_position); */
	} else
		gtk_widget_set_sensitive (readnext_button, FALSE);

	gtk_widget_grab_focus (input);
	gtk_widget_show_all (msg_dlg);
}

gboolean message_close_clicked_callback (GtkWidget *widget, gpointer data)
{
	GtkWidget *window;

	window = gtk_object_get_data (GTK_OBJECT (widget), "dlg");
	gtk_widget_hide_all (window);
        gtk_widget_unrealize(window);

	return TRUE;
}

void message_send_clicked_callback (GtkWidget *widget, gpointer data)
{
	GtkWidget *entry;
	GtkWidget *conversation;
	GSList *contact;
	gchar *buf;
	GtkWidget *toggle;
	GtkWidget *dlg;

	gchar *header;
	GdkColor header_color;

	struct tm *my_tm;
	time_t now;
	gchar msgtime[40];

	contact = gtk_object_get_data (GTK_OBJECT (widget), "contact");
	if (contact == NULL)
		return;

	entry = glade_xml_get_widget (kontakt->msg_dlg_xml, "input");
	toggle = glade_xml_get_widget (kontakt->msg_dlg_xml, "chat_toggle");
	dlg = glade_xml_get_widget (kontakt->msg_dlg_xml, "message_dialog");
	conversation = glade_xml_get_widget (kontakt->msg_dlg_xml, "conversation");

	if (toggle == NULL || entry == NULL || dlg == NULL || conversation == NULL)
		return;

	buf = gtk_editable_get_chars( GTK_EDITABLE( entry ), 0, -1 );
	gtk_editable_delete_text (GTK_EDITABLE (entry), 0, -1);

	if (!strlen (buf)) {
		g_free (buf);
		return;
	}

	if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggle))) {
		gtk_widget_hide_all (dlg);
                gtk_widget_unrealize(dlg);
        }
	else
		gtk_widget_grab_focus (glade_xml_get_widget (kontakt->msg_dlg_xml, "input"));

	/* Display the message */
	header_color.pixel = 0;
	header_color.red = 65535;
	header_color.green = 0;
	header_color.blue = 0;

	/* Show the time of this message in the time widget */
	now = time (NULL);
	my_tm = localtime (&now);
	strftime (msgtime, sizeof (msgtime), _("%X"), my_tm);

	header = g_strdup_printf ("%s (%s): ", our_info->nick, msgtime);
	gtk_text_insert (GTK_TEXT (conversation), NULL, &header_color, NULL, header, -1);
	g_free (header);

	header = g_strdup (buf);
	while (*(header + strlen (header) - 1) == '\n' )
		*(header+strlen(header)-1) = 0x00;
	gtk_text_insert (GTK_TEXT (conversation), NULL, NULL, NULL, header, -1);
	gtk_text_insert (GTK_TEXT (conversation), NULL, NULL, NULL, "\n", 1);
	g_free (header);

	kanji_conv_auto_s (&buf, KANJI_SJIS);
	v7_sendmsg(kontakt->uin, buf);
}

void show_contact_message( GSList *contact )
{
	STORED_MESSAGE_PTR msg = (STORED_MESSAGE_PTR)kontakt->stored_messages->data;

	if( g_slist_length( kontakt->stored_messages ) )
	{
		kontakt->stored_messages = g_slist_remove( kontakt->stored_messages, msg );		
		icq_msgbox( msg, kontakt->uin );

		g_free(msg->chatsessionname);
		if (msg->type == MESSAGE_URL || 
                    (msg->type == MESSAGE_CHAT_REQ && 
                     ((ChatContact *)msg->data)->contact == NULL))
                  g_free(msg->data);
		g_free( msg->message );
		g_free( msg );


		if( g_slist_length( kontakt->stored_messages ) == 0 )
		{
			kontakt->icon_p = get_pixmap_for_status( kontakt->status );
			kontakt->icon_b = get_bitmap_for_status( kontakt->status );
			kontakt->need_update = 1;
			if (kontakt->read_next)
			     gtk_widget_set_sensitive( kontakt->read_next, FALSE );
		}
		else
		{
		     if( ((STORED_MESSAGE_PTR)kontakt->stored_messages->data)->type != MESSAGE_TEXT )
			  gtk_widget_set_sensitive( kontakt->read_next, FALSE);
		     else
			  gtk_widget_set_sensitive( kontakt->read_next, TRUE );
		}

	  	Update_Contact_Style( Which_List( kontakt ), kontakt );
		applet_update( Current_Status, FALSE );
		Shortcut_Update( kontakt );
	}
}

void message_input_key_callback (GtkWidget *widget, GdkEventKey *event, gpointer data)
{
	if ((event->state & GDK_CONTROL_MASK) && (event->keyval == GDK_Return))
		message_send_clicked_callback (gtk_object_get_data (GTK_OBJECT (widget), "send"), NULL);
	if ((event->state & GDK_CONTROL_MASK) && (event->keyval == 'n'))
		read_next (gtk_object_get_data (GTK_OBJECT (widget), "readnext"),
		           gtk_object_get_data (GTK_OBJECT (widget), "contact"));
}

void message_usermenu_clicked_callback (GtkWidget *widget, gpointer data)
{
	GSList *contact;
	GtkWidget *personal_menu;

	contact = (GSList*)gtk_object_get_data (GTK_OBJECT (widget), "contact");
	if (contact == NULL)
		return;
	personal_menu = user_popup (kontakt);
	gtk_menu_popup( GTK_MENU( personal_menu ), NULL, NULL, NULL,
			NULL, 0, 0 );
}
