// $Id: mainwin.h,v 1.10 2000/01/12 19:45:06 cactus Exp $ -*- c++ -*-
/*
  Gnomoku Copyright (C) 1998-1999 NAGY Andrs <nagya@telnet.hu>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2
  (included in the RadioActive distribution in doc/GPL) as published by
  the Free Software Foundation.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef MAINWIN_H
#define MAINWIN_H

#include <gnome--.h>
#include "point.h"
#include "ai.h"
#include "user.h"
#include "options.h"

// GNOMOKU
class Gnomoku : public Gnome::App {
    Gnome::AppBar status;
    Point ***tbl;
    int rows, cols;

    Opponent *opponent;
    bool my_turn;

    op_t optype;
    string server, port;
    bool beep;
public:
    Gnomoku(int rows_ = 15, int cols_ = 15);
    ~Gnomoku();
private:
    void reset();
    void message(const char *fmt, ...);
    void cleanup();
    void start_game();
    gint tmout();
    gint status_timeout();
    void get_msg();
    void point_pressed(Point *p);
    bool won(int y, int x);
    void quit();
    void options();
    void about();
    SigC::Connection status_conn;
};

#endif
