#ifndef _GSTREAMERMM_H_
#define _GSTREAMERMM_H_

#include <gstreamermm/init.h>
#include <gstreamermm/version.h>
#include <gstreamermm/wrap_init.h>

// Core includes
#include <gstreamermm/bin.h>
#include <gstreamermm/buffer.h>
#include <gstreamermm/bus.h>
#include <gstreamermm/caps.h>
#include <gstreamermm/childproxy.h>
#include <gstreamermm/clock.h>
#include <gstreamermm/element.h>
#include <gstreamermm/elementfactory.h>
#include <gstreamermm/enums.h>
#include <gstreamermm/error.h>
#include <gstreamermm/event.h>
#include <gstreamermm/filter.h>
#include <gstreamermm/format.h>
#include <gstreamermm/ghostpad.h>
#include <gstreamermm/index.h>
#include <gstreamermm/indexfactory.h>
#include <gstreamermm/interface.h>
#include <gstreamermm/iterator.h>
#include <gstreamermm/message.h>
#include <gstreamermm/object.h>
#include <gstreamermm/pad.h>
#include <gstreamermm/padtemplate.h>
#include <gstreamermm/parse.h>
#include <gstreamermm/pipeline.h>
#include <gstreamermm/plugin.h>
#include <gstreamermm/pluginfeature.h>
#include <gstreamermm/preset.h>
#include <gstreamermm/query.h>
#include <gstreamermm/segment.h>
#include <gstreamermm/structure.h>
#include <gstreamermm/systemclock.h>
#include <gstreamermm/taglist.h>
#include <gstreamermm/tagsetter.h>
#include <gstreamermm/task.h>
#include <gstreamermm/urihandler.h>
#include <gstreamermm/value.h>
#include <gstreamermm/xml.h>

// Core library base includes
#include <gstreamermm/basesrc.h>
#include <gstreamermm/basesink.h>
#include <gstreamermm/basetransform.h>
#include <gstreamermm/pushsrc.h>

// Base library includes
#include <gstreamermm/audioclock.h>
#include <gstreamermm/audiofilter.h>
#include <gstreamermm/audiosink.h>
#include <gstreamermm/audiosrc.h>
#include <gstreamermm/baseaudiosink.h>
#include <gstreamermm/baseaudiosrc.h>
#include <gstreamermm/cddabasesrc.h>

// Base inteface includes
#include <gstreamermm/colorbalance.h>
#include <gstreamermm/colorbalancechannel.h>
#include <gstreamermm/mixer.h>
#include <gstreamermm/mixeroptions.h>
#include <gstreamermm/mixertrack.h>
#include <gstreamermm/propertyprobe.h>
#include <gstreamermm/tuner.h>
#include <gstreamermm/tunerchannel.h>
#include <gstreamermm/tunernorm.h>
#include <gstreamermm/videoorientation.h>
#include <gstreamermm/xoverlay.h>

#endif // _GSTREAMERMM_H
