// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_XML_H
#define _GSTREAMERMM_XML_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstxml.h>
#include <gstreamermm/object.h>
#include <libxml++/document.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstXML GstXML;
typedef struct _GstXMLClass GstXMLClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class XML_Class; } // namespace Gst
namespace Gst
{

class Element;

/** Gst::XML - XML save/restore operations of pipelines.
 * GStreamer pipelines can be saved to xml files using write_to_stream(). They
 * can be loaded back using parse_doc() / parse_file() / parse_memory().
 * Additionally one can load saved pipelines into the gst-editor to inspect
 * the graph.
 *
 * Gst::Element implementations need to override Gst::Object::save_vfunc()
 * and Gst::Object::restore_vfunc().
 */

class XML : public Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef XML CppObjectType;
  typedef XML_Class CppClassType;
  typedef GstXML BaseObjectType;
  typedef GstXMLClass BaseClassType;

private:  friend class XML_Class;
  static CppClassType xml_class_;

private:
  // noncopyable
  XML(const XML&);
  XML& operator=(const XML&);

protected:
  explicit XML(const Glib::ConstructParams& construct_params);
  explicit XML(GstXML* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~XML();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstXML*       gobj()       { return reinterpret_cast<GstXML*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstXML* gobj() const { return reinterpret_cast<GstXML*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstXML* gobj_copy();

private:


protected:
  XML();

public:
  /** Create a new Gst::XML parser object.
   * @return A Glib::RefPtr<> to a new Gst::XML object.
   */
  
  static Glib::RefPtr<XML> create();


  /** Converts the given element into an XML presentation.
   * @param element The element to write out.
   * @return A pointer to an XML document.
   */
  static xmlDocPtr write(const Glib::RefPtr<const Gst::Element>& element);

  /** Converts the given element into XML and writes the formatted XML to an
   * open output stream.
   *
   * @param element The element to write out.
   * @param out An open std::ostream, like std::cout.
   */
  static void write_to_stream(const Glib::RefPtr<const Gst::Element>& element, std::ostream& out);

  
  /** Fills the GstXML object with the elements from the
   * xmlDocPtr.
   * @param doc A pointer to an xml document to parse.
   * @param root The name of the root object to build.
   * @return <tt>true</tt> on success, <tt>false</tt> otherwise.
   */
  bool parse_doc(xmlpp::Document* doc, Glib::ustring& root);
  
  /** Fills the GstXML object with the corresponding elements from
   * the XML file fname. Optionally it will only build the element from
   * the element node root (if it is not <tt>0</tt>). This feature is useful
   * if you only want to build a specific element from an XML file
   * but not the pipeline it is embedded in.
   * 
   * Pass "-" as fname to read from stdin. You can also pass a URI
   * of any format that libxml supports, including http.
   * @param fname The filename with the xml description.
   * @param root The name of the root object to build.
   * @return <tt>true</tt> on success, <tt>false</tt> otherwise.
   */
  bool parse_file(const std::string& filename, const Glib::ustring& root);

  /** Fills the Gst::XML object with the corresponding elements from an in
   * memory XML buffer.
   *
   * @param buffer The in memory XML buffer.
   * @param root The name of the root objects to build.
   * @return true on success.
   */
  bool parse_memory(const std::string& buffer, const Glib::ustring& root);
  

  /** This function is used to get a pointer to the GstElement corresponding
   * to name in the pipeline description. You would use this if you have
   * to do anything to the element after loading.
   * @param name The name of element to retrieve.
   * @return A pointer to a new GstElement, caller owns returned reference.
   */
  Glib::RefPtr<Gst::Element> get_element(const Glib::ustring& name);
  
  /** This function is used to get a pointer to the GstElement corresponding
   * to name in the pipeline description. You would use this if you have
   * to do anything to the element after loading.
   * @param name The name of element to retrieve.
   * @return A pointer to a new GstElement, caller owns returned reference.
   */
  Glib::RefPtr<const Gst::Element> get_element(const Glib::ustring& name) const;

 
  /** Retrieve a list of toplevel elements.
   * @return A GList of top-level elements. The caller does not own a copy
   * of the list and must not free or modify the list. The caller also does not
   * own a reference to any of the elements in the list and should obtain its own
   * reference using Gst::Object::ref() if necessary.
   */
  Glib::ListHandle< Glib::RefPtr<Gst::Element> > get_topelements();

 
  /** Retrieve a list of toplevel elements.
   * @return A GList of top-level elements. The caller does not own a copy
   * of the list and must not free or modify the list. The caller also does not
   * own a reference to any of the elements in the list and should obtain its own
   * reference using Gst::Object::ref() if necessary.
   */
  Glib::ListHandle< Glib::RefPtr<const Gst::Element> > get_topelements() const;

  
  /** Load the element from the XML description
   * @param cur The xml node.
   * @param parent The parent of this object when it's loaded.
   * @return The new element.
   */
  static Glib::RefPtr<Gst::Element> make_element(xmlpp::Node* curr, const Glib::RefPtr<Gst::Object>& parent);

 
  /** Signals that a new object has been deserialized.
   */
  //TODO: use xmlpp::Node* for signal:
  
  /**
   * @par Prototype:
   * <tt>void on_my_%object_loaded(const Glib::RefPtr<Gst::Object>& object, xmlNode* xml_node)</tt>
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<Gst::Object>&,xmlNode* > signal_object_loaded();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_object_loaded(const Glib::RefPtr<Gst::Object>& object, xmlNode* xml_node);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} //namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::XML
   */
  Glib::RefPtr<Gst::XML> wrap(GstXML* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_XML_H */

