// Generated by gtkmmproc -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/ringbuffer.h>
#include <gstreamermm/private/ringbuffer_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2009 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/audio/audio-enumtypes.h>
#include <gstreamermm/handle_error.h>


namespace
{

extern "C"
{

static void RingBuffer_Fill_gstreamermm_callback(GstRingBuffer*, guint8* data, guint len,
                                                 gpointer user_data)
{
  Gst::RingBuffer::SlotFill& slot_fill = *static_cast<Gst::RingBuffer::SlotFill*>(user_data);

  try
  {
    Glib::ArrayHandle<guint8> cpp_data(data, len, Glib::OWNERSHIP_NONE);
    slot_fill(cpp_data, len);
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }
}

} // extern "C"

} // anonymous namespace

namespace Gst
{

RingBufferSpec::RingBufferSpec()
: m_spec(g_try_new(GstRingBufferSpec, 1)),
  take_ownership(true)
{
  // Handle possible memory allocation failure.
  if(!m_spec)
  {
    gstreamermm_handle_error("Failed to allocate a new Gst::RingBufferSpec.");
    return;
  }
}

RingBufferSpec::RingBufferSpec(const Glib::RefPtr<Gst::Caps>& caps,
  Gst::BufferFormatType type, Gst::BufferFormat format, bool sign,
  bool bigend, int width, int depth, int rate, int channels,
  guint64 latency_time, guint64 buffer_time, int segsize, int segtotal,
  int seglatency)
: m_spec(g_try_new(GstRingBufferSpec, 1)),
  take_ownership(true)
  
{
  // Handle possible memory allocation failure.
  if(!m_spec)
  {
    gstreamermm_handle_error("Failed to allocate a new Gst::RingBufferSpec.");
    return;
  }

  GstRingBufferSpec* spec = gobj();

  spec->caps = Glib::unwrap(caps);

  // Keep a copy of the caps (it will be unreferenced in the destructor).
  if (caps)
    caps->reference();

  spec->type = static_cast<GstBufferFormatType>(type);
  spec->format = static_cast<GstBufferFormat>(format);
  spec->sign = static_cast<int>(sign);
  spec->bigend = static_cast<int>(bigend);
  spec->width = width;
  spec->depth = depth;
  spec->rate = rate;
  spec->channels = channels;
  spec->latency_time = latency_time;
  spec->buffer_time = buffer_time;
  spec->segsize = segsize;
  spec->segtotal = segtotal;
  spec->seglatency = seglatency;
}


RingBufferSpec::RingBufferSpec(GstRingBufferSpec& castitem, bool take_ownership)
: m_spec(&castitem),
  take_ownership(take_ownership)
{
  // Keep a copy of the caps (it will be unreferenced in the destructor).
  if(castitem.caps)
      gst_caps_ref(castitem.caps);
}

RingBufferSpec::RingBufferSpec(const RingBufferSpec& other)
: m_spec(g_try_new(GstRingBufferSpec, 1)),
  take_ownership(true)
{
  // Handle possible memory allocation failure.
  if(!m_spec)
  {
    gstreamermm_handle_error("Failed to allocate a new Gst::RingBufferSpec.");
    return;
  }

  m_spec->caps = other.m_spec->caps;

  // Keep a copy of the caps (it will be unreferenced in the destructor).
  if(m_spec->caps)
    gst_caps_ref(m_spec->caps);

  m_spec->type = other.m_spec->type;
  m_spec->format = other.m_spec->format;
  m_spec->sign = other.m_spec->sign;
  m_spec->bigend = other.m_spec->bigend;
  m_spec->width = other.m_spec->width;
  m_spec->depth = other.m_spec->depth;
  m_spec->rate = other.m_spec->rate;
  m_spec->channels = other.m_spec->channels;
  m_spec->latency_time = other.m_spec->latency_time;
  m_spec->buffer_time = other.m_spec->buffer_time;
  m_spec->segsize = other.m_spec->segsize;
  m_spec->segtotal = other.m_spec->segtotal;
  m_spec->bytes_per_sample = other.m_spec->bytes_per_sample;
  m_spec->seglatency = other.m_spec->seglatency;

  std::copy(other.m_spec->silence_sample, other.m_spec->silence_sample + GSTREAMERMM_RING_BUFFER_SPEC_SILENCE_SAMPLE, m_spec->silence_sample);
}

RingBufferSpec& RingBufferSpec::operator=(const RingBufferSpec& other)
{
  RingBufferSpec temp(other);
  swap(temp);
  return *this;
}

RingBufferSpec::~RingBufferSpec()
{
  // Unref existing reference to caps.
  if(m_spec->caps)
    gst_caps_unref(m_spec->caps);

  // Release the underlying m_spec if it is owned.
  if(take_ownership)
    g_free(m_spec);
}

void RingBufferSpec::swap(RingBufferSpec& other)
{
  GstRingBufferSpec* spec_temp = m_spec;
  m_spec = other.m_spec;
  other.m_spec = spec_temp;

  const bool take_temp = take_ownership;
  take_ownership = other.take_ownership;
  other.take_ownership = take_temp;
}

void RingBufferSpec::set_silence_sample(const Glib::ArrayHandle<guint8>& silence_sample)
{
  std::copy(silence_sample.data(),
    silence_sample.data() + GSTREAMERMM_RING_BUFFER_SPEC_SILENCE_SAMPLE,
    m_spec->silence_sample);
}

void RingBuffer::set_fill_slot(const SlotFill& slot)
{
  // The slot is dynamically allocated because according to the
  // gst_ring_buffer_set_callback() docs, the slot may be called several times.
  // A copy is hence created to avoid losing the slot.  The copy is kept in an
  // auto_ptr<> so that is released upon the ring buffer's destruction.
  m_slot.reset(new SlotFill(slot));

  gst_ring_buffer_set_callback(gobj(), &RingBuffer_Fill_gstreamermm_callback,
    m_slot.get());
}

bool RingBuffer::prepare_read(int& segment, std::vector<guint8>& readptr,
  int& len)
{
  guint8* c_readptr = 0;

  const bool result = static_cast<bool>(gst_ring_buffer_prepare_read(gobj(), &segment, &c_readptr, &len));
  readptr.assign(c_readptr, c_readptr + len);

  if (c_readptr)
    g_free(c_readptr);

  return result;
}

gboolean RingBuffer_Class::acquire_vfunc_callback(GstRingBuffer* self, GstRingBufferSpec* spec)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        Gst::RingBufferSpec cpp_spec(*spec);

        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->acquire_vfunc(cpp_spec));

      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->acquire)
    return (*base->acquire)(self, spec);


  typedef gboolean RType;
  return RType();
}
bool Gst::RingBuffer::acquire_vfunc(Gst::RingBufferSpec& spec) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->acquire)
    return static_cast<bool>((*base->acquire)(gobj(), spec.gobj()));

  typedef bool RType;
  return RType();
}
guint RingBuffer_Class::commit_vfunc_callback(GstRingBuffer* self, guint64* sample, guchar* data, gint in_samples, gint out_samples, gint* accum)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // This formula is obtained from the definition of the data_end
        // variable in the default_commit() function of the C API
        // gstringbuffer.c file.
        size_t data_length = (self->spec.bytes_per_sample * in_samples);

        // Declare the ArrayHandle for the C++ vfunc.
        Glib::ArrayHandle<guchar> cpp_data(data, data_length, Glib::OWNERSHIP_NONE);
        // Call the virtual member method, which derived classes might override.
        return obj->commit_vfunc(*(sample), cpp_data, in_samples, out_samples,
          *(accum));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->commit)
    return (*base->commit)(self, sample, data, in_samples, out_samples, accum);


  typedef guint RType;
  return RType();
}
guint Gst::RingBuffer::commit_vfunc(guint64& sample, const Glib::ArrayHandle<guchar>& data, int in_samples, int out_samples, int& accum) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->commit)
    return (*base->commit)(gobj(),&sample,const_cast<guchar*>(data.data()),in_samples,out_samples,&accum);

  typedef guint RType;
  return RType();
}

} // namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::RingBufferSegState>::value_type()
{
  return gst_ring_buffer_seg_state_get_type();
}

// static
GType Glib::Value<Gst::RingBufferState>::value_type()
{
  return gst_ring_buffer_state_get_type();
}

// static
GType Glib::Value<Gst::BufferFormat>::value_type()
{
  return gst_buffer_format_get_type();
}

// static
GType Glib::Value<Gst::BufferFormatType>::value_type()
{
  return gst_buffer_format_type_get_type();
}


namespace Gst
{


 Glib::RefPtr<Gst::Caps> RingBufferSpec::get_caps()
{
  Glib::RefPtr<Gst::Caps> ref_ptr(Glib::wrap(gobj()->caps));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gst::Caps> RingBufferSpec::get_caps() const
{
  Glib::RefPtr<const Gst::Caps> ref_ptr(Glib::wrap(gobj()->caps));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}
 
 void RingBufferSpec::set_caps(const Glib::RefPtr<Gst::Caps>& value)
{
  Glib::RefPtr<Gst::Caps> valueOld(Glib::wrap(gobj()->caps)); //Take possession of the old one, unref-ing it in the destructor.

  if(value)
    value->reference(); //Ref once for the recipient.

  gobj()->caps = Glib::unwrap(value);
}
 
 Gst::BufferFormatType RingBufferSpec::get_type() const
{
  return ((Gst::BufferFormatType)(gobj()->type));
}
 
 void RingBufferSpec::set_type(const Gst::BufferFormatType& value)
{
  gobj()->type = ((GstBufferFormatType)(value));
}
 
 Gst::BufferFormat RingBufferSpec::get_format() const
{
  return ((Gst::BufferFormat)(gobj()->format));
}
 
 void RingBufferSpec::set_format(const Gst::BufferFormat& value)
{
  gobj()->format = ((GstBufferFormat)(value));
}
 
 bool RingBufferSpec::get_sign() const
{
  return gobj()->sign;
}
 
 void RingBufferSpec::set_sign(const bool& value)
{
  gobj()->sign = static_cast<int>(value);
}
 
 bool RingBufferSpec::get_bigend() const
{
  return gobj()->bigend;
}
 
 void RingBufferSpec::set_bigend(const bool& value)
{
  gobj()->bigend = static_cast<int>(value);
}
 
 int RingBufferSpec::get_width() const
{
  return gobj()->width;
}
 
 void RingBufferSpec::set_width(const int& value)
{
  gobj()->width = value;
}
 
 int RingBufferSpec::get_depth() const
{
  return gobj()->depth;
}
 
 void RingBufferSpec::set_depth(const int& value)
{
  gobj()->depth = value;
}
 
 int RingBufferSpec::get_rate() const
{
  return gobj()->rate;
}
 
 void RingBufferSpec::set_rate(const int& value)
{
  gobj()->rate = value;
}
 
 int RingBufferSpec::get_channels() const
{
  return gobj()->channels;
}
 
 void RingBufferSpec::set_channels(const int& value)
{
  gobj()->channels = value;
}
 
 guint64 RingBufferSpec::get_latency_time() const
{
  return gobj()->latency_time;
}
 
 void RingBufferSpec::set_latency_time(const guint64& value)
{
  gobj()->latency_time = value;
}
 
 guint64 RingBufferSpec::get_buffer_time() const
{
  return gobj()->buffer_time;
}
 
 void RingBufferSpec::set_buffer_time(const guint64& value)
{
  gobj()->buffer_time = value;
}
 
 int RingBufferSpec::get_segsize() const
{
  return gobj()->segsize;
}
 
 void RingBufferSpec::set_segsize(const int& value)
{
  gobj()->segsize = value;
}
 
 int RingBufferSpec::get_segtotal() const
{
  return gobj()->segtotal;
}
 
 void RingBufferSpec::set_segtotal(const int& value)
{
  gobj()->segtotal = value;
}
 
 int RingBufferSpec::get_seglatency() const
{
  return gobj()->seglatency;
}
 
 void RingBufferSpec::set_seglatency(const int& value)
{
  gobj()->seglatency = value;
}
 
 int RingBufferSpec::get_bytes_per_sample() const
{
  return gobj()->bytes_per_sample;
}
 
 void RingBufferSpec::set_bytes_per_sample(const int& value)
{
  gobj()->bytes_per_sample = value;
}
 
 Glib::ArrayHandle<guint8> RingBufferSpec::get_silence_sample() const
{
  return Glib::ArrayHandle<guint8>(gobj()->silence_sample, GSTREAMERMM_RING_BUFFER_SPEC_SILENCE_SAMPLE, Glib::OWNERSHIP_NONE);
}
 

} // namespace Gst


namespace Glib
{

Glib::RefPtr<Gst::RingBuffer> wrap(GstRingBuffer* object, bool take_copy)
{
  return Glib::RefPtr<Gst::RingBuffer>( dynamic_cast<Gst::RingBuffer*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& RingBuffer_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &RingBuffer_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_ring_buffer_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void RingBuffer_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->open_device = &open_device_vfunc_callback;
  klass->release = &release_vfunc_callback;
  klass->close_device = &close_device_vfunc_callback;
  klass->start = &start_vfunc_callback;
  klass->pause = &pause_vfunc_callback;
  klass->resume = &resume_vfunc_callback;
  klass->stop = &stop_vfunc_callback;
  klass->delay = &delay_vfunc_callback;
  klass->activate = &activate_vfunc_callback;
  klass->clear_all = &clear_all_vfunc_callback;
  klass->acquire = &acquire_vfunc_callback;
  klass->commit = &commit_vfunc_callback;
  
}

gboolean RingBuffer_Class::open_device_vfunc_callback(GstRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->open_device_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->open_device)
    return (*base->open_device)(self);


  typedef gboolean RType;
  return RType();
}
gboolean RingBuffer_Class::release_vfunc_callback(GstRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->release_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->release)
    return (*base->release)(self);


  typedef gboolean RType;
  return RType();
}
gboolean RingBuffer_Class::close_device_vfunc_callback(GstRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->close_device_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->close_device)
    return (*base->close_device)(self);


  typedef gboolean RType;
  return RType();
}
gboolean RingBuffer_Class::start_vfunc_callback(GstRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->start_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->start)
    return (*base->start)(self);


  typedef gboolean RType;
  return RType();
}
gboolean RingBuffer_Class::pause_vfunc_callback(GstRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->pause_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->pause)
    return (*base->pause)(self);


  typedef gboolean RType;
  return RType();
}
gboolean RingBuffer_Class::resume_vfunc_callback(GstRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->resume_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->resume)
    return (*base->resume)(self);


  typedef gboolean RType;
  return RType();
}
gboolean RingBuffer_Class::stop_vfunc_callback(GstRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->stop_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->stop)
    return (*base->stop)(self);


  typedef gboolean RType;
  return RType();
}
guint RingBuffer_Class::delay_vfunc_callback(GstRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->delay_vfunc();
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->delay)
    return (*base->delay)(self);


  typedef guint RType;
  return RType();
}
gboolean RingBuffer_Class::activate_vfunc_callback(GstRingBuffer* self, gboolean active)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->activate_vfunc(active
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->activate)
    return (*base->activate)(self, active);


  typedef gboolean RType;
  return RType();
}
void RingBuffer_Class::clear_all_vfunc_callback(GstRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->clear_all_vfunc();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->clear_all)
    (*base->clear_all)(self);

}


Glib::ObjectBase* RingBuffer_Class::wrap_new(GObject* object)
{
  return new RingBuffer((GstRingBuffer*)object);
}


/* The implementation: */

GstRingBuffer* RingBuffer::gobj_copy()
{
  reference();
  return gobj();
}

RingBuffer::RingBuffer(const Glib::ConstructParams& construct_params)
:
  Gst::Object(construct_params)
{

}

RingBuffer::RingBuffer(GstRingBuffer* castitem)
:
  Gst::Object((GstObject*)(castitem))
{}


RingBuffer::~RingBuffer()
{}


RingBuffer::CppClassType RingBuffer::ringbuffer_class_; // initialize static member

GType RingBuffer::get_type()
{
  return ringbuffer_class_.init().get_type();
}


GType RingBuffer::get_base_type()
{
  return gst_ring_buffer_get_type();
}

bool RingBuffer::acquire(Gst::RingBufferSpec& spec)
{
  return gst_ring_buffer_acquire(gobj(), spec.gobj());
}

bool RingBuffer::release()
{
  return gst_ring_buffer_release(gobj());
}

bool RingBuffer::is_acquired() const
{
  return gst_ring_buffer_is_acquired(const_cast<GstRingBuffer*>(gobj()));
}

bool RingBuffer::activate(bool active)
{
  return gst_ring_buffer_activate(gobj(), static_cast<int>(active));
}

bool RingBuffer::is_active() const
{
  return gst_ring_buffer_is_active(const_cast<GstRingBuffer*>(gobj()));
}

bool RingBuffer::start()
{
  return gst_ring_buffer_start(gobj());
}

bool RingBuffer::pause()
{
  return gst_ring_buffer_pause(gobj());
}

bool RingBuffer::stop()
{
  return gst_ring_buffer_stop(gobj());
}

guint RingBuffer::get_delay() const
{
  return gst_ring_buffer_delay(const_cast<GstRingBuffer*>(gobj()));
}

guint64 RingBuffer::get_samples_done() const
{
  return gst_ring_buffer_samples_done(const_cast<GstRingBuffer*>(gobj()));
}

void RingBuffer::set_sample(guint64 sample)
{
  gst_ring_buffer_set_sample(gobj(), sample); 
}

guint RingBuffer::commit(guint64 sample, const Glib::ArrayHandle<guchar>& data, guint len)
{
  return gst_ring_buffer_commit(gobj(), sample, const_cast<guchar*>(data.data()), len);
}

guint RingBuffer::commit(guint64& sample, const Glib::ArrayHandle<guchar>& data, int in_samples, int out_samples, int& accum)
{
  return gst_ring_buffer_commit_full(gobj(), &sample, const_cast<guchar*>(data.data()), in_samples, out_samples, &(accum));
}

bool RingBuffer::convert(Gst::Format src_fmt, gint64 src_val, Gst::Format dest_fmt, gint64& dest_val) const
{
  return gst_ring_buffer_convert(const_cast<GstRingBuffer*>(gobj()), ((GstFormat)(src_fmt)), src_val, ((GstFormat)(dest_fmt)), &dest_val);
}

guint RingBuffer::read(guint64 sample, const Glib::ArrayHandle<guchar>& data, guint len)
{
  return gst_ring_buffer_read(gobj(), sample, const_cast<guchar*>(data.data()), len);
}

void RingBuffer::clear(int segment)
{
  gst_ring_buffer_clear(gobj(), segment); 
}

void RingBuffer::clear_all()
{
  gst_ring_buffer_clear_all(gobj()); 
}

void RingBuffer::advance(guint advance)
{
  gst_ring_buffer_advance(gobj(), advance); 
}

bool RingBuffer::close_device()
{
  return gst_ring_buffer_close_device(gobj());
}

bool RingBuffer::open_device()
{
  return gst_ring_buffer_open_device(gobj());
}

bool RingBuffer::device_is_open() const
{
  return gst_ring_buffer_device_is_open(const_cast<GstRingBuffer*>(gobj()));
}

void RingBuffer::set_may_start(bool allowed)
{
  gst_ring_buffer_may_start(gobj(), static_cast<int>(allowed)); 
}

bool RingBuffer::parse_caps(Gst::RingBufferSpec& p1, const Glib::RefPtr<Gst::Caps>& caps)
{
  return gst_ring_buffer_parse_caps(p1.gobj(), Glib::unwrap(caps));
}


void RingBuffer::set_flushing(bool flushing)
{
  gst_ring_buffer_set_flushing(gobj(), static_cast<int>(flushing)); 
}


bool Gst::RingBuffer::open_device_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->open_device)
    return (*base->open_device)(gobj());

  typedef bool RType;
  return RType();
}
bool Gst::RingBuffer::release_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->release)
    return (*base->release)(gobj());

  typedef bool RType;
  return RType();
}
bool Gst::RingBuffer::close_device_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->close_device)
    return (*base->close_device)(gobj());

  typedef bool RType;
  return RType();
}
bool Gst::RingBuffer::start_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->start)
    return (*base->start)(gobj());

  typedef bool RType;
  return RType();
}
bool Gst::RingBuffer::pause_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->pause)
    return (*base->pause)(gobj());

  typedef bool RType;
  return RType();
}
bool Gst::RingBuffer::resume_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->resume)
    return (*base->resume)(gobj());

  typedef bool RType;
  return RType();
}
bool Gst::RingBuffer::stop_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->stop)
    return (*base->stop)(gobj());

  typedef bool RType;
  return RType();
}
guint Gst::RingBuffer::delay_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->delay)
    return (*base->delay)(gobj());

  typedef guint RType;
  return RType();
}
bool Gst::RingBuffer::activate_vfunc(bool active) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->activate)
    return (*base->activate)(gobj(),static_cast<int>(active));

  typedef bool RType;
  return RType();
}
void Gst::RingBuffer::clear_all_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->clear_all)
    (*base->clear_all)(gobj());
}


} // namespace Gst


