// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_TYPEFIND_H
#define _GSTREAMERMM_TYPEFIND_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2009 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gsttypefind.h>
#include <glibmm/arrayhandle.h>


namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 */
enum TypeFindProbability
{
  TYPE_FIND_MINIMUM = 1,
  TYPE_FIND_POSSIBLE = 50,
  TYPE_FIND_LIKELY = 80,
  TYPE_FIND_NEARLY_CERTAIN = 99,
  TYPE_FIND_MAXIMUM = 100
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::TypeFindProbability> : public Glib::Value_Enum<Gst::TypeFindProbability>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


class Caps;
class Plugin;

/** A class used for stream type detection.
 * Gst::TypeFind methods allow you to detect the media type of an unknown
 * stream.
 *
 * Last reviewed on 2005-11-09 (0.9.4).
 */
class TypeFind
{
  //TODO: Maybe file a GStreamer bug about GstTypeFind not being a GObject
  //making it difficult for C++ developers to write their own TypeFind classes
  //(see the Gst::TypeFindFactory class docs for more info).
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TypeFind CppObjectType;
  typedef GstTypeFind BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  TypeFind();

  explicit TypeFind(const GstTypeFind* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  GstTypeFind*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const GstTypeFind* gobj() const { return &gobject_; }

protected:
  GstTypeFind gobject_;

private:
  

public:
  /** For example,
   * void on_find();.
   */
  typedef sigc::slot<void> SlotFind;

public:
 

  /** Returns the @a size bytes of the stream to identify beginning at offset. If
   * offset is a positive number, the offset is relative to the beginning of the
   * stream, if offset is a negative number the offset is relative to the end of
   * the stream. The returned memory is valid until the typefinding function
   * returns and must not be freed.
   * 
   * Returns: the requested data, or <tt>0</tt> if that data is not available.
   * @param offset The offset.
   * @param size The number of bytes to return.
   * @return The requested data, or <tt>0</tt> if that data is not available.
   */
  Glib::ArrayHandle<guint8> peek(gint64 offset, guint size) const;

  
  /** If a Gst::TypeFind::SlotFind calls this method it suggests the caps with the
   * given probability. A Gst::TypeFind::SlotFind may supply different suggestions
   * in one call.
   * It is up to the caller of the Gst::TypeFind::SlotFind to interpret these
   * values.
   * @param probability The probability in percent that the suggestion is right.
   * @param caps The fixed Gst::Caps to suggest.
   */
  void suggest(guint probability, const Glib::RefPtr<const Gst::Caps>& caps) const;
  

  /** Get the length of the data stream.
   * @return The length of the data stream, or 0 if it is not available.
   */
  guint64 get_length() const;

  /** Registers a new typefind slot to be used for typefinding. After
   * registering the slot will be available for typefinding. This method
   * is typically called during an element's plugin initialization.
   *
   * @param plugin A Gst::Plugin (for a static typefind function, i.e. one not
   * related to any  Gst::Plugin, use register_slot() without the Gst::Plugin
   * argument).
   * @param name The name for registering.
   * @param rank The rank (or importance) of this typefind function.
   * @param find_slot The Gst::TypeFind::SlotFind to use.
   * @param extensions Extensions belonging to this type (for no extensions use
   * register_slot() with no extensions parameter).
   * @param caps The caps to be returned when typefinding succeeds (for no
   * caps, use register_slot() with no caps argument).
   * @return true on success, false otherwise.
   */
  static bool register_slot(const Glib::RefPtr<Gst::Plugin>& plugin, const Glib::ustring& name, guint rank, const SlotFind& find_slot, const Glib::StringArrayHandle& extensions, const Glib::RefPtr<const Gst::Caps>& caps);

  /** Registers a new typefind slot to be used for typefinding. After
   * registering the slot will be available for typefinding. This method
   * is typically called during an element's plugin initialization.
   *
   * @param plugin A Gst::Plugin (for a static typefind function, i.e. one not
   * related to any  Gst::Plugin, use register_slot() without the Gst::Plugin
   * argument).
   * @param name The name for registering.
   * @param rank The rank (or importance) of this typefind function.
   * @param find_slot The Gst::TypeFind::SlotFind to use.
   * @param caps The caps to be returned when typefinding succeeds (for no
   * caps, use register_slot() with no caps argument).
   * @return true on success, false otherwise.
   */
  static bool register_slot(const Glib::RefPtr<Gst::Plugin>& plugin, const Glib::ustring& name, guint rank, const SlotFind& find_slot, const Glib::RefPtr<const Gst::Caps>& caps);

  /** Registers a new typefind slot to be used for typefinding. After
   * registering the slot will be available for typefinding. This method
   * is typically called during an element's plugin initialization.
   *
   * @param plugin A Gst::Plugin (for a static typefind function, i.e. one not
   * related to any  Gst::Plugin, use register_slot() without the Gst::Plugin
   * argument).
   * @param name The name for registering.
   * @param rank The rank (or importance) of this typefind function.
   * @param find_slot The Gst::TypeFind::SlotFind to use.
   * @param extensions Extensions belonging to this type (for no extensions use
   * register_slot() with no extensions parameter).
   * @return true on success, false otherwise.
   */
  static bool register_slot(const Glib::RefPtr<Gst::Plugin>& plugin, const Glib::ustring& name, guint rank, const SlotFind& find_slot, const Glib::StringArrayHandle& extensions);

  /** Registers a new typefind slot to be used for typefinding. After
   * registering the slot will be available for typefinding. This method
   * is typically called during an element's plugin initialization.
   *
   * @param plugin A Gst::Plugin (for a static typefind function, i.e. one not
   * related to any  Gst::Plugin, use register_slot() without the Gst::Plugin
   * argument).
   * @param name The name for registering.
   * @param rank The rank (or importance) of this typefind function.
   * @param find_slot The Gst::TypeFind::SlotFind to use.
   * @return true on success, false otherwise.
   */
  static bool register_slot(const Glib::RefPtr<Gst::Plugin>& plugin, const Glib::ustring& name, guint rank, const SlotFind& find_slot);

  /** Registers a new static (not requiring a Gst::Plugin) typefind slot to be
   * used for typefinding. After registering the slot will be available for
   * typefinding.
   *
   * @param name The name for registering.
   * @param rank The rank (or importance) of this typefind function.
   * @param find_slot The Gst::TypeFind::SlotFind to use.
   * @param extensions Extensions belonging to this type (for no extensions use
   * register_slot() with no extensions parameter).
   * @param caps The caps to be returned when typefinding succeeds (for no
   * caps, use register_slot() with no caps argument).
   * @return true on success, false otherwise.
   */
  static bool register_slot(const Glib::ustring& name, guint rank, const SlotFind& find_slot, const Glib::StringArrayHandle& extensions, const Glib::RefPtr<const Gst::Caps>& caps);

  /** Registers a new static (not requiring a Gst::Plugin) typefind slot to be
   * used for typefinding. After registering the slot will be available for
   * typefinding.
   *
   * @param name The name for registering.
   * @param rank The rank (or importance) of this typefind function.
   * @param find_slot The Gst::TypeFind::SlotFind to use.
   * @param caps The caps to be returned when typefinding succeeds (for no
   * caps, use register_slot() with no caps argument).
   * @return true on success, false otherwise.
   */
  static bool register_slot(const Glib::ustring& name, guint rank, const SlotFind& find_slot, const Glib::RefPtr<const Gst::Caps>& caps);

  /** Registers a new static (not requiring a Gst::Plugin) typefind slot to be
   * used for typefinding. After registering the slot will be available for
   * typefinding.
   *
   * @param name The name for registering.
   * @param rank The rank (or importance) of this typefind function.
   * @param find_slot The Gst::TypeFind::SlotFind to use.
   * @param extensions Extensions belonging to this type (for no extensions use
   * register_slot() with no extensions parameter).
   * @return true on success, false otherwise.
   */
  static bool register_slot(const Glib::ustring& name, guint rank, const SlotFind& find_slot, const Glib::StringArrayHandle& extensions);

  /** Registers a new static (not requiring a Gst::Plugin) typefind slot to be
   * used for typefinding. After registering the slot will be available for
   * typefinding.
   *
   * @param name The name for registering.
   * @param rank The rank (or importance) of this typefind function.
   * @param find_slot The Gst::TypeFind::SlotFind to use.
   * @return true on success, false otherwise.
   */
  static bool register_slot(const Glib::ustring& name, guint rank, const SlotFind& find_slot);


};

} // namespace Gst


namespace Glib
{

/** @relates Gst::TypeFind
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Gst::TypeFind& wrap(GstTypeFind* object);

/** @relates Gst::TypeFind
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Gst::TypeFind& wrap(const GstTypeFind* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gst::TypeFind> : public Glib::Value_Boxed<Gst::TypeFind>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GSTREAMERMM_TYPEFIND_H */

