// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/query.h>
#include <gstreamermm/private/query_p.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstenumtypes.h>
#include <gstreamermm/iterator.h>


namespace Gst
{

QueryTypeDefinition::QueryTypeDefinition()
: value(Gst::QUERY_NONE),
  quark(static_cast<GQuark>(0))
{}

QueryTypeDefinition::QueryTypeDefinition(const GstQueryTypeDefinition* castitem)
: value(Gst::QUERY_NONE),
  quark((castitem) ? castitem->quark : 0)
{
  if(castitem)
  {
    value = static_cast<QueryType>(castitem->value);
    nick = castitem->nick;
    description = castitem->description;
  }
}

namespace Enums
{

Glib::ustring get_name(QueryType t)
{
  return gst_query_type_get_name(static_cast<GstQueryType>(t));
}

Glib::QueryQuark get_quark(QueryType t)
{
  return Glib::QueryQuark(gst_query_type_to_quark(static_cast<GstQueryType>(t)));
}

} //namespace Enums

Glib::RefPtr<Gst::Query> Query::create_writable()
{
  return Gst::wrap(gst_query_make_writable(gobj()));
}

bool get_details(QueryType type, QueryTypeDefinition &def)
{
  const GstQueryTypeDefinition* gstdef = gst_query_type_get_details(GstQueryType(type));

  if(!gstdef)
    return false;

  def.value = static_cast<QueryType>(gstdef->value);
  def.nick = gstdef->nick;
  def.description = gstdef->description;
  def.quark = gstdef->quark;

  return true;
}

QueryApplication::QueryApplication(GstQuery* castitem) :
Query(castitem)
{}

Glib::RefPtr<Gst::Query> QueryApplication::create(QueryType type, Gst::Structure& structure)
{
  // Create copy because query takes ownership of structure:
  GstStructure* copy_struct = gst_structure_copy(structure.gobj());
  GstQuery* query = gst_query_new_application(GstQueryType(type),
    copy_struct); 
  return Gst::Query::wrap(query);
}

QueryConvert::QueryConvert(GstQuery* castitem) :
Query(castitem)
{}

Glib::RefPtr<Gst::Query> QueryConvert::create(Format src_format, gint64 value, Format dest_format)
{
  GstQuery* query = gst_query_new_convert(GstFormat(src_format), value,
    GstFormat(dest_format));
  return Gst::Query::wrap(query);
}

void QueryConvert::set(Format src_format, gint64 src_value, Format dest_format, gint64 dest_value)
{
  gst_query_set_convert(gobj(), GstFormat(src_format), src_value, GstFormat(dest_format), dest_value);
}

void QueryConvert::parse(Format& src_format, gint64& src_value, Format& dest_format, gint64& dest_value) const
{
  gst_query_parse_convert(const_cast<GstQuery*>(gobj()),
    reinterpret_cast<GstFormat*>(&src_format), &src_value,
    reinterpret_cast<GstFormat*>(&dest_format), &dest_value);
}

void QueryConvert::parse(Format& dest_format, gint64& dest_value) const
{
  gst_query_parse_convert(const_cast<GstQuery*>(gobj()), 0, 0,
    reinterpret_cast<GstFormat*>(&dest_format), &dest_value);
}

Format QueryConvert::parse_src_format() const
{
  Format src_format = Gst::FORMAT_UNDEFINED;
  gst_query_parse_convert(const_cast<GstQuery*>(gobj()),
    reinterpret_cast<GstFormat*>(&src_format), 0, 0, 0);
  return src_format;
}

gint64 QueryConvert::parse_src_value() const
{
  gint64 src_value = 0;
  gst_query_parse_convert(const_cast<GstQuery*>(gobj()), 0, &src_value,
    0, 0);
  return src_value;
}

Format QueryConvert::parse_dest_format() const
{
  Format dest_format = Gst::FORMAT_UNDEFINED;
  gst_query_parse_convert(const_cast<GstQuery*>(gobj()), 0, 0,
    reinterpret_cast<GstFormat*>(&dest_format), 0);
  return dest_format;
}

gint64 QueryConvert::parse_dest_value() const
{
  gint64 dest_value = 0;
  gst_query_parse_convert(const_cast<GstQuery*>(gobj()), 0, 0, 0,
    &dest_value);
  return dest_value;
}

QueryPosition::QueryPosition(GstQuery* castitem) :
Query(castitem)
{}

Glib::RefPtr<Gst::Query> QueryPosition::create(Format format)
{
  GstQuery* query = gst_query_new_position(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QueryPosition::set(Format format, gint64 position)
{
  gst_query_set_position(gobj(), GstFormat(format), position);
}

void QueryPosition::parse(Format& format, gint64& position) const
{
  gst_query_parse_position(const_cast<GstQuery*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), &position);
}

gint64 QueryPosition::parse() const
{
  gint64 position = 0;
  gst_query_parse_position(const_cast<GstQuery*>(gobj()), 0, &position);
  return position;
}

Format QueryPosition::parse_format() const
{
  Format format = Gst::FORMAT_UNDEFINED;
  gst_query_parse_position(const_cast<GstQuery*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), 0);
  return format;
}

QueryDuration::QueryDuration(GstQuery* castitem) :
Query(castitem)
{}

Glib::RefPtr<Gst::Query> QueryDuration::create(Format format)
{
  GstQuery* query = gst_query_new_duration(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QueryDuration::set(Format format, gint64 duration)
{
  gst_query_set_duration(gobj(), GstFormat(format), duration);
}

void QueryDuration::parse(Format& format, gint64& duration) const
{
  gst_query_parse_duration(const_cast<GstQuery*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), &duration);
}

gint64 QueryDuration::parse() const
{
  gint64 duration = 0;
  gst_query_parse_duration(const_cast<GstQuery*>(gobj()), 0, &duration);
  return duration;
}

Format QueryDuration::parse_format() const
{
  Format format = Gst::FORMAT_UNDEFINED;
  gst_query_parse_duration(const_cast<GstQuery*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), 0);
  return format;
}

QueryLatency::QueryLatency(GstQuery* castitem) :
Query(castitem)
{}

Glib::RefPtr<Gst::Query> QueryLatency::create()
{
  GstQuery* query = gst_query_new_latency();
  return Gst::Query::wrap(query);
}

void QueryLatency::set(bool live, ClockTime min_latency, ClockTime max_latency)
{
  gst_query_set_latency(gobj(), live, GstClockTime(min_latency), GstClockTime(max_latency));
}

void QueryLatency::parse(bool& live, ClockTime& min_latency, ClockTime& max_latency) const
{
  gboolean glive = FALSE;
  gst_query_parse_latency(const_cast<GstQuery*>(gobj()), &glive,
    reinterpret_cast<ClockTime*>(&min_latency),
    reinterpret_cast<ClockTime*>(&max_latency));
  live = glive;
}

bool QueryLatency::parse_live() const
{
  gboolean glive = FALSE;
  gst_query_parse_latency(const_cast<GstQuery*>(gobj()), &glive, 0, 0);
  return glive;
}

ClockTime QueryLatency::parse_min() const
{
  ClockTime min = 0;
  gst_query_parse_latency(const_cast<GstQuery*>(gobj()), 0,
    reinterpret_cast<ClockTime*>(&min), 0);
  return min;
}

ClockTime QueryLatency::parse_max() const
{
  ClockTime max = 0;
  gst_query_parse_latency(const_cast<GstQuery*>(gobj()), 0, 0,
    reinterpret_cast<ClockTime*>(&max));
  return max;
}

QuerySeeking::QuerySeeking(GstQuery* castitem) :
Query(castitem)
{}

Glib::RefPtr<Gst::Query> QuerySeeking::create(Format format)
{
  GstQuery* query = gst_query_new_seeking(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QuerySeeking::set(Format format, bool seekable, gint64 segment_start, gint64 segment_end)
{
  gst_query_set_seeking(gobj(), GstFormat(format), seekable, segment_start, segment_end);
}

void QuerySeeking::parse(Format& format, bool& seekable, gint64& segment_start, gint64& segment_end) const
{
  gboolean gseekable = FALSE;
  gst_query_parse_seeking(const_cast<GstQuery*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), &gseekable, &segment_start,
    &segment_end);
  seekable = gseekable;
}

Format QuerySeeking::parse_format() const
{
  Format format = Gst::FORMAT_UNDEFINED;
  gst_query_parse_seeking(const_cast<GstQuery*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), 0, 0, 0);
  return format;
}

bool QuerySeeking::parse_seekable() const
{
  gboolean gseekable = FALSE;
  gst_query_parse_seeking(const_cast<GstQuery*>(gobj()), 0,
    &gseekable, 0, 0);
  return gseekable;
}

gint64 QuerySeeking::parse_start() const
{
  gint64 start = 0;
  gst_query_parse_seeking(const_cast<GstQuery*>(gobj()), 0, 0,
    &start, 0);
  return start;
}

gint64 QuerySeeking::parse_end() const
{
  gint64 end = 0;
  gst_query_parse_seeking(const_cast<GstQuery*>(gobj()), 0, 0, 0,
    &end);
  return end;
}

QueryFormats::QueryFormats(GstQuery* castitem) :
Query(castitem)
{}

Glib::RefPtr<Gst::Query> QueryFormats::create()
{
  GstQuery* query = gst_query_new_formats();
  return Gst::Query::wrap(query);
}

void QueryFormats::set(const Glib::ArrayHandle<Format>& formats)
{
  gst_query_set_formatsv(gobj(), formats.size(),
    reinterpret_cast<GstFormat*>(const_cast<Gst::Format*>(formats.data())));
}

void QueryFormats::set(int n_formats, const Glib::ArrayHandle<Format>& formats)
{
  gst_query_set_formatsv(gobj(), n_formats,
    reinterpret_cast<GstFormat*>(const_cast<Gst::Format*>(formats.data())));
}

guint QueryFormats::parse_length() const
{
  guint n_formats = 0;
  gst_query_parse_formats_length(const_cast<GstQuery*>(gobj()), &n_formats);
  return n_formats;
}

Format QueryFormats::parse(guint nth) const
{
  Format format = Gst::FORMAT_UNDEFINED;
  gst_query_parse_formats_nth(const_cast<GstQuery*>(gobj()), nth,
    reinterpret_cast<GstFormat*>(&format));
  return format;
}

QuerySegment::QuerySegment(GstQuery* castitem) :
Query(castitem)
{}

Glib::RefPtr<Gst::Query> QuerySegment::create(Format format)
{
  GstQuery* query = gst_query_new_segment(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QuerySegment::set(double rate, Format format, gint64 start_value, gint64 stop_value)
{
  gst_query_set_segment(gobj(), rate, static_cast<GstFormat>(format),
    start_value, stop_value);
}

void QuerySegment::parse(double& rate, Format& format, gint64& start_value, gint64& stop_value) const
{
  gst_query_parse_segment(const_cast<GstQuery*>(gobj()), &rate,
    reinterpret_cast<GstFormat*>(&format), &start_value, &stop_value);
}

double QuerySegment::parse_rate() const
{
  double rate = 0;
  gst_query_parse_segment(const_cast<GstQuery*>(gobj()), &rate, 0,
    0, 0);
  return rate;
}

Format QuerySegment::parse_format() const
{
  Format format = Gst::FORMAT_UNDEFINED;
  gst_query_parse_segment(const_cast<GstQuery*>(gobj()), 0,
    reinterpret_cast<GstFormat*>(&format), 0, 0);
  return format;
}

gint64 QuerySegment::parse_start() const
{
  gint64 start = 0;
  gst_query_parse_segment(const_cast<GstQuery*>(gobj()), 0, 0,
    &start, 0);
  return start;
}

gint64 QuerySegment::parse_stop() const
{
  gint64 stop = 0;
  gst_query_parse_segment(const_cast<GstQuery*>(gobj()), 0, 0,
    0, &stop);
  return stop;
}

QueryBuffering::QueryBuffering(GstQuery* castitem) :
Query(castitem)
{}

Glib::RefPtr<Gst::Query> QueryBuffering::create(Format format)
{
  GstQuery* query = gst_query_new_buffering(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QueryBuffering::set(bool busy, int percent)
{
  gst_query_set_buffering_percent(gobj(), busy, percent);
}

void QueryBuffering::parse(bool& busy, int& percent) const
{
  gboolean gbusy = FALSE;
  gst_query_parse_buffering_percent(const_cast<GstQuery*>(gobj()), &gbusy,
    &percent);
  busy = gbusy;
}

bool QueryBuffering::parse_busy() const
{
  gboolean gbusy = FALSE;
  gst_query_parse_buffering_percent(const_cast<GstQuery*>(gobj()), &gbusy,
    0);
  return gbusy;
}

int QueryBuffering::parse_percent() const
{
  int percent = 0;
  gst_query_parse_buffering_percent(const_cast<GstQuery*>(gobj()), 0,
    &percent);
  return percent;
}

void QueryBuffering::set(BufferingMode mode, int avg_in, int avg_out, gint64 buffering_left)
{
  gst_query_set_buffering_stats(gobj(), static_cast<GstBufferingMode>(mode),
    avg_in, avg_out, buffering_left);
}

void QueryBuffering::parse(BufferingMode& mode, int& avg_in, int& avg_out, gint64 buffering_left) const
{
  gst_query_parse_buffering_stats(const_cast<GstQuery*>(gobj()),
    reinterpret_cast<GstBufferingMode*>(&mode), &avg_in, &avg_out,
    &buffering_left);
}

BufferingMode QueryBuffering::parse_mode() const
{
  BufferingMode mode = Gst::BUFFERING_STREAM;
  gst_query_parse_buffering_stats(const_cast<GstQuery*>(gobj()),
    reinterpret_cast<GstBufferingMode*>(&mode), 0, 0, 0);
  return mode;
}

int QueryBuffering::parse_input_rate() const
{
  int avg_in = 0;
  gst_query_parse_buffering_stats(const_cast<GstQuery*>(gobj()), 0,
    &avg_in, 0, 0);
  return avg_in;
}

int QueryBuffering::parse_output_rate() const
{
  int avg_out = 0;
  gst_query_parse_buffering_stats(const_cast<GstQuery*>(gobj()), 0, 0,
    &avg_out, 0);
  return avg_out;
}

gint64 QueryBuffering::parse_time_left() const
{
  gint64 buffering_left = Gst::BUFFERING_STREAM;
  gst_query_parse_buffering_stats(const_cast<GstQuery*>(gobj()), 0,
    0, 0, &buffering_left);
  return buffering_left;
}

void QueryBuffering::set(Format format, gint64 start, gint64 stop, gint64 estimated_total)
{
  gst_query_set_buffering_range(gobj(), static_cast<GstFormat>(format),
    start, stop, estimated_total);
}

void QueryBuffering::parse(Format& format, gint64& start, gint64& stop, gint64& estimated_total) const
{
  gst_query_parse_buffering_range(const_cast<GstQuery*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), &start, &stop, &estimated_total);
}

Format QueryBuffering::parse_format() const
{
  Format format = Gst::FORMAT_UNDEFINED;
  gst_query_parse_buffering_range(const_cast<GstQuery*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), 0, 0, 0);
  return format;
}

gint64 QueryBuffering::parse_start() const
{
  gint64 start = 0;
  gst_query_parse_buffering_range(const_cast<GstQuery*>(gobj()), 0,
    &start, 0, 0);
  return start;
}

gint64 QueryBuffering::parse_stop() const
{
  gint64 stop = 0;
  gst_query_parse_buffering_range(const_cast<GstQuery*>(gobj()), 0,
    0, &stop, 0);
  return stop;
}

gint64 QueryBuffering::parse_total_time() const
{
  gint64 estimated_total = 0;
  gst_query_parse_buffering_range(const_cast<GstQuery*>(gobj()), 0,
    0, 0, &estimated_total);
  return estimated_total;
}

Glib::RefPtr<Gst::Query> Query::wrap(GstQuery* query, bool take_copy)
{
  Gst::Query* wrapper = 0;
  Glib::RefPtr<Gst::Query> result;

  if(!query)
    return result;

  switch(GST_QUERY_TYPE(query))
  {
    case GST_QUERY_POSITION:
      wrapper = new Gst::QueryPosition(query);
      break;
    case GST_QUERY_DURATION:
      wrapper = new Gst::QueryDuration(query);
      break;
    case GST_QUERY_LATENCY:
      wrapper = new Gst::QueryLatency(query);
      break;
    case GST_QUERY_SEEKING:
      wrapper = new Gst::QuerySeeking(query);
      break;
    case GST_QUERY_SEGMENT:
      wrapper = new Gst::QuerySegment(query);
      break;
    case GST_QUERY_CONVERT:
      wrapper = new Gst::QueryConvert(query);
      break;
    case GST_QUERY_FORMATS:
      wrapper = new Gst::QueryFormats(query);
      break;
    case GST_QUERY_BUFFERING:
      wrapper = new Gst::QueryBuffering(query);
      break;
    case GST_QUERY_NONE:
    case GST_QUERY_JITTER:
      wrapper = new Gst::Query(query);
      break;
        /* The rest of the query types are custom ones */
    default:
      wrapper = new Gst::QueryApplication(query);
  }

  result = Glib::RefPtr<Gst::Query>(wrapper);

  if(take_copy)
    result->reference();

  return result;
}

Gst::MiniObject* Query_Class::wrap_new(GstMiniObject* object)
{
  // Use the Gst::Query wrap() method to get the right type of Query class
  // and return the underlying object in the refptr.  The extra reference is
  // needed so that the object does not loose a reference when the local refptr
  // is destroyed.
  return Gst::Query::wrap((GstQuery*)object, true).operator->();
}

GstMiniObject* Query_Class::copy_vfunc_callback(const GstMiniObject* self)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(GST_MINI_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && GST_MINI_OBJECT_CLASS(base)->copy)
    return (*GST_MINI_OBJECT_CLASS(base)->copy)(self);

  return 0;
}
Glib::RefPtr<Gst::MiniObject> Query::copy_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobj())) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && GST_MINI_OBJECT_CLASS(base)->copy)
  {
    return Gst::Query::wrap(GST_QUERY((*GST_MINI_OBJECT_CLASS(base)->copy)(
        GST_MINI_OBJECT(gobj()))));
  }

  return Glib::RefPtr<Gst::MiniObject>(0);
}
void Query_Class::finalize_vfunc_callback(GstMiniObject* self)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(GST_MINI_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && GST_MINI_OBJECT_CLASS(base)->finalize)
    (*GST_MINI_OBJECT_CLASS(base)->finalize)(self);
}
void Query::finalize_vfunc()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobj())) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && GST_MINI_OBJECT_CLASS(base)->finalize)
    (*GST_MINI_OBJECT_CLASS(base)->finalize)(GST_MINI_OBJECT(gobj()));
}

} //namesapce Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::QueryType>::value_type()
{
  return gst_query_type_get_type();
}

// static
GType Glib::Value<Gst::BufferingMode>::value_type()
{
  return gst_buffering_mode_get_type();
}


namespace Gst
{


} // namespace Gst


namespace Gst
{

Glib::RefPtr<Gst::Query> wrap(GstQuery* object, bool take_copy)
{
  //Note that we use Gst::wrap() instead of Glib::wrap() 
  //because we are dealing with a GstMiniObject, not a GObject:
  return Glib::RefPtr<Gst::Query>( dynamic_cast<Gst::Query*> (Gst::wrap_auto ((GstMiniObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Gst */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Query_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Query_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_query_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Query_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  GST_MINI_OBJECT_CLASS(klass)->copy = &copy_vfunc_callback;
  GST_MINI_OBJECT_CLASS(klass)->finalize = &finalize_vfunc_callback;
  
}


/* The implementation: */

GstQuery* Query::gobj_copy()
{
  // Use the mini object copying function to get a copy of the underlying
  // gobject instead of referencing and returning the underlying gobject as
  // would be done normally:
  return reinterpret_cast<GstQuery*>(gst_mini_object_copy(reinterpret_cast<GstMiniObject*>(gobj())));
}


Query::Query(GstQuery* castitem)
:
  Gst::MiniObject((GstMiniObject*)(castitem))
{}

Query::~Query()
{}


Query::CppClassType Query::query_class_; // initialize static member

GType Query::get_type()
{
  return query_class_.init().get_type();
}


GType Query::get_base_type()
{
  return gst_query_get_type();
}

const Gst::Structure Query::get_structure() const
{
  return Glib::wrap(const_cast<GstStructure*>(gst_query_get_structure(const_cast<GstQuery*>(gobj()))), true);
}

 QueryType Query::get_query_type() const
{
  return ((QueryType)(gobj()->type));
}
 
QueryType Query::register_query_type(const Glib::ustring& nick, const Glib::ustring& description)
{
  return ((QueryType)(gst_query_type_register(nick.c_str(), description.c_str())));
}


QueryType Query::get_query_type(const Glib::ustring& nick)
{
  return ((QueryType)(gst_query_type_get_by_nick(nick.c_str())));
}


bool Query::query_types_contain(const Glib::ArrayHandle<const QueryType>& types, QueryType type)
{
  return gst_query_types_contains((GstQueryType*)((types).data()), ((GstQueryType)(type)));
}


Gst::IteratorBasic<const Gst::QueryTypeDefinition> Query::iterate_definitions()
{
  return Gst::IteratorBasic<const Gst::QueryTypeDefinition>(gst_query_type_iterate_definitions());
}


} // namespace Gst


