// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/query.h>
#include <gstreamermm/private/query_p.h>

#include <gst/gstquery.h>

namespace Gst
{

const Structure& Query::get_structure()
{
  structure_ = Structure(const_cast<GstStructure*>(gst_query_get_structure(gobj())), false);
  return structure_;
}

bool get_details(QueryType type, QueryTypeDefinition &def)
{
  const GstQueryTypeDefinition* gstdef = gst_query_type_get_details(GstQueryType(type));

  g_return_val_if_fail(gstdef != NULL, false);

  def.value = QueryType(gstdef->value);
  def.nick = gstdef->nick;
  def.description = gstdef->description;
  def.quark = gstdef->quark;

  return true;
}

QueryConvert::QueryConvert(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QueryConvert::create(Format src_format, gint64 value, Format dest_format)
{
  GstQuery* query = gst_query_new_convert(GstFormat(src_format), value,
    GstFormat(dest_format));
  return Gst::Query::wrap(query);
}

void QueryConvert::set(Format src_format, gint64 src_value, Format dest_format, gint64 dest_value)
{
  gst_query_set_convert(gobj(), GstFormat(src_format), src_value, GstFormat(dest_format), dest_value);
}

void QueryConvert::parse(Format& dest_format, gint64& dest_value)
{
  gst_query_parse_convert(gobj(), NULL, NULL, (GstFormat*)(&dest_format), &dest_value);
}

void QueryConvert::parse(Format& src_format, gint64& src_value, Format& dest_format, gint64& dest_value)
{
  gst_query_parse_convert(gobj(), (GstFormat*)(&src_format), &src_value, (GstFormat*)(&dest_format), &dest_value);
}

QueryPosition::QueryPosition(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QueryPosition::create(Format format)
{
  GstQuery* query = gst_query_new_position(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QueryPosition::set(Format format, gint64 position)
{
  gst_query_set_position(gobj(), GstFormat(format), position);
}

void QueryPosition::parse(Format& format, gint64& position)
{
  gst_query_parse_position(gobj(), (GstFormat*)(&format), &position);
}

QueryDuration::QueryDuration(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QueryDuration::create(Format format)
{
  GstQuery* query = gst_query_new_duration(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QueryDuration::set(Format format, gint64 duration)
{
  gst_query_set_duration(gobj(), GstFormat(format), duration);
}

void QueryDuration::parse(Format& format, gint64& duration)
{
  gst_query_parse_duration(gobj(), (GstFormat*)(&format), &duration);
}

QueryLatency::QueryLatency(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QueryLatency::create()
{
  GstQuery* query = gst_query_new_latency();
  return Gst::Query::wrap(query);
}

void QueryLatency::set(bool live, ClockTime min_latency, ClockTime max_latency)
{
  gst_query_set_latency(gobj(), live, GstClockTime(min_latency), GstClockTime(max_latency));
}

void QueryLatency::parse(bool& live, ClockTime& min_latency, ClockTime& max_latency)
{
  gboolean glive;
  gst_query_parse_latency(gobj(), &glive, (ClockTime*)(&min_latency), (ClockTime*)(&max_latency));
  live = glive;
}

QuerySeeking::QuerySeeking(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QuerySeeking::create(Format format)
{
  GstQuery* query = gst_query_new_seeking(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QuerySeeking::set(Format format, bool seekable, gint64 segment_start, gint64 segment_end)
{
  gst_query_set_seeking(gobj(), GstFormat(format), seekable, segment_start, segment_end);
}

void QuerySeeking::parse(Format& format, bool& seekable, gint64& segment_start, gint64& segment_end)
{
  gboolean gseekable;
  gst_query_parse_seeking(gobj(), (GstFormat*)(&format), &gseekable, &segment_start, &segment_end);
  seekable = gseekable;
}

QueryFormats::QueryFormats(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QueryFormats::create()
{
  GstQuery* query = gst_query_new_formats();
  return Gst::Query::wrap(query);
}

void QueryFormats::set(int n_formats, const va_list& varargs)
{
  gst_query_set_formats(gobj(), n_formats, const_cast<va_list&>(varargs));
}

void QueryFormats::parse(guint& n_formats)
{
  gst_query_parse_formats_length(gobj(), &n_formats);
}

void QueryFormats::parse(guint nth, Format& format)
{
  gst_query_parse_formats_nth(gobj(), nth, (GstFormat*)(&format));
}

QuerySegment::QuerySegment(GstQuery* castitem) :
Query(castitem)
{
}

Glib::RefPtr<Query> QuerySegment::create(Format format)
{
  GstQuery* query = gst_query_new_segment(GstFormat(format));
  return Gst::Query::wrap(query);
}

void QuerySegment::set(double rate, Format format, gint64 start_value, gint64 stop_value)
{
  gst_query_set_segment(gobj(), rate, GstFormat(format), start_value, stop_value);
}

void QuerySegment::parse(double& rate, Format& format, gint64& start_value, gint64& stop_value)
{
  gst_query_parse_segment(gobj(), &rate, (GstFormat*)(&format), &start_value, &stop_value);
}

Glib::RefPtr<Query> Query::wrap(GstQuery* query, bool take_copy) {

  Glib::RefPtr<Query> result;

  if(!query)
    return result;

  switch (GST_QUERY_TYPE(query)) {
    case GST_QUERY_POSITION:
      result = Glib::RefPtr<Query>( new Gst::QueryPosition(query) );
      break;
    case GST_QUERY_DURATION:
      result = Glib::RefPtr<Query>( new Gst::QueryDuration(query) );
      break;
    case GST_QUERY_LATENCY:
      result = Glib::RefPtr<Query>( new Gst::QueryLatency(query) );
      break;
    case GST_QUERY_SEEKING:
      result = Glib::RefPtr<Query>( new Gst::QuerySeeking(query) );
      break;
    case GST_QUERY_SEGMENT:
      result = Glib::RefPtr<Query>( new Gst::QuerySegment(query) );
      break;
    case GST_QUERY_CONVERT:
      result = Glib::RefPtr<Query>( new Gst::QueryConvert(query) );
      break;
    case GST_QUERY_FORMATS:
      result = Glib::RefPtr<Query>( new Gst::QueryFormats(query) );
      break;
    default:
      result = Gst::wrap(query, false);
  }

  if(result && take_copy)
    result->reference();

  return result;
}

} //namesapce Gst

namespace
{
} // anonymous namespace


namespace Gst
{

Glib::RefPtr<Gst::Query> wrap(GstQuery* object, bool take_copy)
{
  //Note that we use Gst::wrap() instead of Glib::wrap() 
  //because we are dealing with a GstMiniObject, not a GObject:
  return Glib::RefPtr<Gst::Query>( dynamic_cast<Gst::Query*> (Gst::wrap_auto ((GstMiniObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Gst */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Query_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Query_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_query_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Query_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Query_Class::wrap_new(GstMiniObject* object)
{
  return new Query((GstQuery*)object);
}


/* The implementation: */

GstQuery* Query::gobj_copy()
{
  reference();
  return gobj();
}


Query::Query(GstQuery* castitem)
:
  Gst::MiniObject((GstMiniObject*)(castitem))
{}

Query::~Query()
{}


Query::CppClassType Query::query_class_; // initialize static member

GType Query::get_type()
{
  return query_class_.init().get_type();
}

GType Query::get_base_type()
{
  return gst_query_get_type();
}


 QueryType Query::get_query_type() const
{
  return QueryType(gobj()->type);
}
 
QueryType Query::register_query_type(const Glib::ustring& nick, const Glib::ustring& description)
{
  return QueryType(gst_query_type_register(nick.c_str(), description.c_str()));
}


QueryType Query::get_query_type(const Glib::ustring& nick)
{
  return QueryType(gst_query_type_get_by_nick(nick.c_str()));
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gst


