// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/caps.h>
#include <gstreamermm/private/caps_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/structure.h>
#include <gst/gstcaps.h>

namespace Gst
{

Glib::RefPtr<Caps>
Caps::create()
{
  return Glib::wrap(gst_caps_new_empty());
}

Glib::RefPtr<Caps>
Caps::create_any()
{
  return Glib::wrap(gst_caps_new_any());
}

/*
  This method is implemented because gst_caps_new_simple is a variable argument
  function and cannot be wrapped.  In addition, because gst_caps_new_simple
  creates a GstStructure for the GstCaps and will not be called, we must create
  our own GstStructure here and append it to the GstCaps.
*/
Glib::RefPtr<Caps>
Caps::create_simple(const Glib::ustring& media_type)
{
  Glib::RefPtr<Caps> result = Glib::wrap(gst_caps_new_empty());
  GstStructure* gst_struct = gst_structure_empty_new(media_type.c_str());
  gst_caps_append_structure(result->gobj(), gst_struct);
  return result;
}

Glib::RefPtr<Caps>
Caps::create_full(Structure& structure)
{
  return Glib::wrap(gst_caps_new_full(structure.gobj()));
}

/*
  This method is implemented because gst_caps_set_simple is a variable argument
  function and cannot be wrapped.  In addition, in order for
  gst_caps_set_simple to work, this Caps must be "simple", ie, it must only
  have one GstStructure (gst_caps_set_simple checks for this).  Here we must
  set the field in the Structure ourselves so we must check for only one
  Structure ourselves also (because we wont be calling gst_caps_set_simple)
*/
//Glib::RefPtr<Caps>
void
Caps::set_simple(const Glib::ustring& name, const Glib::ValueBase& value)
{
  //g_return_val_if_fail((gobj()->structs->len == 1), Glib::RefPtr<Caps>());
  g_return_if_fail((gobj()->structs->len == 1));
  gst_structure_set_value(gst_caps_get_structure(gobj(), 0), name.c_str(), value.gobj());

  //return Glib::wrap(gobj(), true);
}

} //namespace Gst

namespace
{
} // anonymous namespace


/* Why reinterpret_cast<Caps*>(gobject) is needed:
 *
 * A Caps instance is in fact always a GstCaps instance.
 * Unfortunately, GstCaps cannot be a member of Caps,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because Caps does not have any member data, and
 * it is impossible to derive from it.  This is ensured by not implementing
 * the (protected) default constructor.  The ctor is protected rather than
 * private just to avoid a compile warning.
 */

namespace Glib
{

Glib::RefPtr<Gst::Caps> wrap(GstCaps* object, bool take_copy)
{
  if(take_copy && object)
    gst_caps_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gst::Caps>(reinterpret_cast<Gst::Caps*>(object));
}

} // namespace Glib


namespace Gst
{


void Caps::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_caps_ref(reinterpret_cast<GstCaps*>(const_cast<Caps*>(this)));
}

void Caps::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_caps_unref(reinterpret_cast<GstCaps*>(const_cast<Caps*>(this)));
}

GstCaps* Caps::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GstCaps*>(this);
}

const GstCaps* Caps::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GstCaps*>(this);
}

GstCaps* Caps::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  GstCaps *const gobject = reinterpret_cast<GstCaps*>(const_cast<Caps*>(this));
  gst_caps_ref(gobject);
  return gobject;
}


Glib::RefPtr<Caps> Caps::copy() const
{
  return Glib::wrap(gst_caps_copy(const_cast<GstCaps*>(gobj())));
}

Glib::RefPtr<Caps> Caps::copy_nth(guint nth)
{
  return Glib::wrap(gst_caps_copy_nth(gobj(), nth));
}

void Caps::append(const Glib::RefPtr<Caps>& caps)
{
gst_caps_append(gobj(), Glib::unwrap(caps)); 
}

void Caps::merge(const Glib::RefPtr<Caps>& caps)
{
gst_caps_merge(gobj(), Glib::unwrap(caps)); 
}

void Caps::append_structure(Structure& structure)
{
gst_caps_append_structure(gobj(), ((GstStructure*)(&(structure)))); 
}

void Caps::merge_structure(Structure& structure)
{
gst_caps_merge_structure(gobj(), ((GstStructure*)(&(structure)))); 
}

Structure* Caps::get_structure(guint idx)
{
  return ((Structure*) (gst_caps_get_structure(gobj(), idx)));
}

void Caps::remove_structure(guint idx)
{
gst_caps_remove_structure(gobj(), idx); 
}

guint Caps::size() const
{
  return gst_caps_get_size(const_cast<GstCaps*>(gobj()));
}

void Caps::set_simple_valist(char* field, const va_list& varargs)
{
gst_caps_set_simple_valist(gobj(), field, const_cast<va_list&>(varargs)); 
}

bool Caps::is_any() const
{
  return gst_caps_is_any(const_cast<GstCaps*>(gobj()));
}

bool Caps::empty() const
{
  return gst_caps_is_empty(const_cast<GstCaps*>(gobj()));
}

bool Caps::fixed() const
{
  return gst_caps_is_fixed(const_cast<GstCaps*>(gobj()));
}

bool Caps::equals(const Glib::RefPtr<Caps>& other_caps) const
{
  return gst_caps_is_equal(const_cast<GstCaps*>(gobj()), Glib::unwrap(other_caps));
}

bool Caps::equals_fixed(const Glib::RefPtr<Caps>& other_caps) const
{
  return gst_caps_is_equal_fixed(const_cast<GstCaps*>(gobj()), Glib::unwrap(other_caps));
}

bool Caps::always_compatible(const Glib::RefPtr<Caps>& other_caps) const
{
  return gst_caps_is_always_compatible(const_cast<GstCaps*>(gobj()), Glib::unwrap(other_caps));
}

bool Caps::subset(const Glib::RefPtr<Caps>& superset_caps) const
{
  return gst_caps_is_subset(const_cast<GstCaps*>(gobj()), Glib::unwrap(superset_caps));
}

Glib::RefPtr<Caps> Caps::the_intersect(const Glib::RefPtr<Caps>& other_caps) const
{
  return Glib::wrap(gst_caps_intersect(const_cast<GstCaps*>(gobj()), Glib::unwrap(other_caps)));
}

Glib::RefPtr<Caps> Caps::the_union(const Glib::RefPtr<Caps>& other_caps) const
{
  return Glib::wrap(gst_caps_union(const_cast<GstCaps*>(gobj()), Glib::unwrap(other_caps)));
}

Glib::RefPtr<Caps> Caps::normalize()
{
  return Glib::wrap(gst_caps_normalize(gobj()));
}

bool Caps::simplify()
{
  return gst_caps_do_simplify(gobj());
}

xmlNodePtr Caps::save(const xmlNodePtr& parent)
{
  return gst_caps_save_thyself(gobj(), parent);
}

Glib::RefPtr<Caps> Caps::load(xmlNodePtr parent)
{
  return Glib::wrap(gst_caps_load_thyself(parent));
}


Glib::ustring Caps::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gst_caps_to_string(const_cast<GstCaps*>(gobj())));
}

Glib::RefPtr<Caps> Caps::from_string(const Glib::ustring& string)
{
  return Glib::wrap(gst_caps_from_string(string.c_str()));
}


Glib::RefPtr<Caps> Caps::subtract(const Glib::RefPtr<Caps>& subtrahend_caps)
{
  return Glib::wrap(gst_caps_subtract(gobj(), Glib::unwrap(subtrahend_caps)));
}

Glib::RefPtr<Caps> Caps::make_writable()
{
  return Glib::wrap(gst_caps_make_writable(gobj()));
}

void Caps::truncate()
{
gst_caps_truncate(gobj()); 
}


} // namespace Gst


