// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_ELEMENT_H
#define _GSTREAMERMM_ELEMENT_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/object.h>
#include <gstreamermm/clock.h>
#include <gstreamermm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstElement GstElement;
typedef struct _GstElementClass GstElementClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Element_Class; } // namespace Gst
namespace Gst
{

class Bus;
class Caps;
class Clock;
class ElementFactory;
class Event;
class Index;
class Message;
class Pad;
class PadTemplate;
class Query;


class Element : public Object 
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Element CppObjectType;
  typedef Element_Class CppClassType;
  typedef GstElement BaseObjectType;
  typedef GstElementClass BaseClassType;

private:  friend class Element_Class;
  static CppClassType element_class_;

private:
  // noncopyable
  Element(const Element&);
  Element& operator=(const Element&);

protected:
  explicit Element(const Glib::ConstructParams& construct_params);
  explicit Element(GstElement* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Element();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstElement*       gobj()       { return reinterpret_cast<GstElement*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstElement* gobj() const { return reinterpret_cast<GstElement*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstElement* gobj_copy();

private:


protected:
  //TODO: What C function does this correspond to?
  Element();

public:
  static Glib::RefPtr<Element> create(const Glib::ustring& factoryname, const Glib::ustring& name);
  Glib::RefPtr<Element> link(const Glib::RefPtr<Element>& other_element);
  
  /** Adds a pad (link point) to @a element. @a pad's parent will be set to @a element;
   * see Gst::Object::set_parent() for refcounting information.
   * 
   * Pads are not automatically activated so elements should perform the needed
   * steps to activate the pad in case this pad is added in the PAUSED or PLAYING
   * state. See Gst::Pad::set_active() for more information about activating pads.
   * 
   * The pad and the element should be unlocked when calling this function.
   * 
   * This function will emit the Gst::Element::pad-added signal on the element.
   * @param pad The Gst::Pad to add to the element.
   * @return <tt>true</tt> if the pad could be added. This function can fail when
   * a pad with the same name already existed or the pad already had another
   * parent.
   * 
   * MT safe.
   */
  bool add_pad(const Glib::RefPtr<Pad>& pad);
  
  /** Retrieves a pad from @a element by name. Tries get_static_pad()
   * first, then get_request_pad().
   * 
   * &lt;note&gt;Usage of this function is not recommended as it is unclear if the reference
   * to the result pad should be released with Gst::Object::unref() in case of a static pad
   * or release_request_pad() in case of a request pad.&lt;/note&gt;
   * @param name The name of the pad to retrieve.
   * @return The Gst::Pad if found, otherwise <tt>0</tt>. Unref or Release after usage,
   * depending on the type of the pad.
   */
  Glib::RefPtr<Pad> get_pad(const Glib::ustring& name);
  
  /** Creates a pad for each pad template that is always available.
   * This function is only useful during object intialization of
   * subclasses of Gst::Element.
   */
  void create_all_pads();

  //TODO: Why does this throw an exception? murrayc
  Glib::RefPtr<Pad> get_compatible_pad(const Glib::RefPtr<Pad>& pad, const Glib::RefPtr<Caps>& caps);
  Glib::RefPtr<PadTemplate> get_compatible_pad_template(const Glib::RefPtr<PadTemplate>& padtemplate);

  
  /** Retrieves a pad from the element by name. This version only retrieves
   * request pads. The pad should be released with
   * release_request_pad().
   * @param name The name of the request Gst::Pad to retrieve.
   * @return Requested Gst::Pad if found, otherwise <tt>0</tt>. Release after usage.
   */
  Glib::RefPtr<Pad> get_request_pad(const Glib::ustring& name);
  
  /** Retrieves a pad from @a element by name. This version only retrieves
   * already-existing (i.e. 'static') pads.
   * @param name The name of the static Gst::Pad to retrieve.
   * @return The requested Gst::Pad if found, otherwise <tt>0</tt>. unref after
   * usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Pad> get_static_pad(const Glib::ustring& name);
  
  /** Use this function to signal that the element does not expect any more pads
   * to show up in the current pipeline. This function should be called whenever
   * pads have been added by the element itself. Elements with Gst::PAD_SOMETIMES
   * pad templates use this in combination with autopluggers to figure out that
   * the element is done initializing its pads.
   * 
   * This function emits the Gst::Element::no-more-pads signal.
   * 
   * MT safe.
   */
  void no_more_pads();
  
  /** Makes the element free the previously requested pad as obtained
   * with get_request_pad().
   * 
   * MT safe.
   * @param pad The Gst::Pad to release.
   */
  void release_request_pad(const Glib::RefPtr<Pad>& pad);
  
  /** Removes @a pad from @a element. @a pad will be destroyed if it has not been
   * referenced elsewhere using Gst::Object::unparent().
   * 
   * This function is used by plugin developers and should not be used
   * by applications. Pads that were dynamically requested from elements
   * with get_request_pad() should be released with the
   * release_request_pad() function instead.
   * 
   * Pads are not automatically deactivated so elements should perform the needed
   * steps to deactivate the pad in case this pad is removed in the PAUSED or
   * PLAYING state. See Gst::Pad::set_active() for more information about
   * deactivating pads.
   * 
   * The pad and the element should be unlocked when calling this function.
   * 
   * This function will emit the Gst::Element::pad-removed signal on the element.
   * @param pad The Gst::Pad to remove from the element.
   * @return <tt>true</tt> if the pad could be removed. Can return <tt>false</tt> if the
   * pad does not belong to the provided element.
   * 
   * MT safe.
   */
  bool remove_pad(const Glib::RefPtr<Pad>& pad);
 
  
  /** Unlinks all source pads of the source element with all sink pads
   * of the sink element to which they are linked.
   * 
   * If the link has been made using link(), it could have created an
   * requestpad, which has to be released using release_request_pad().
   * @param dest The sink Gst::Element to unlink.
   */
  void unlink(const Glib::RefPtr<Element>& other_element);

  
  /** Links the two named pads of the source and destination elements.
   * Side effect is that if one of the pads has no parent, it becomes a
   * child of the parent of the other element.  If they have different
   * parents, the link fails.
   * @param srcpadname The name of the Gst::Pad in source element or <tt>0</tt> for any pad.
   * @param dest The Gst::Element containing the destination pad.
   * @param destpadname The name of the Gst::Pad in destination element,
   * or <tt>0</tt> for any pad.
   * @return <tt>true</tt> if the pads could be linked, <tt>false</tt> otherwise.
   */
  bool link_pads(const Glib::ustring& padname, const Glib::RefPtr<Element>& other_element, const Glib::ustring& others_padname);

  
  /** Unlinks the two named pads of the source and destination elements.
   * @param srcpadname The name of the Gst::Pad in source element.
   * @param dest A Gst::Element containing the destination pad.
   * @param destpadname The name of the Gst::Pad in destination element.
   */
  void unlink_pads(const Glib::ustring& padname, const Glib::RefPtr<Element>& other_element, const Glib::ustring& other_padname);

  //TODO: Use ustring?:
  
  /** Links the two named pads of the source and destination elements. Side effect
   * is that if one of the pads has no parent, it becomes a child of the parent of
   * the other element. If they have different parents, the link fails. If @a caps
   * is not #<tt>0</tt>, makes sure that the caps of the link is a subset of @a caps.
   * @param srcpadname The name of the Gst::Pad in source element or <tt>0</tt> for any pad.
   * @param dest The Gst::Element containing the destination pad.
   * @param destpadname The name of the Gst::Pad in destination element or <tt>0</tt> for any pad.
   * @param filter The Gst::Caps to filter the link, or #<tt>0</tt> for no filter.
   * @return <tt>true</tt> if the pads could be linked, <tt>false</tt> otherwise.
   */
  bool link_pads_filtered(const char* padname, const Glib::RefPtr<Element>& other_element, const char* others_padname, const Glib::RefPtr<Caps>& filter);

  
  /** Links @a src to @a dest using the given caps as filtercaps.
   * The link must be from source to
   * destination; the other direction will not be tried. The function looks for
   * existing pads that aren't linked yet. It will request new pads if necessary.
   * If multiple links are possible, only one is established.
   * 
   * Make sure you have added your elements to a bin or pipeline with
   * Gst::Bin::add() before trying to link them.
   * @param dest The Gst::Element containing the destination pad.
   * @param filter The Gst::Caps to filter the link, or #<tt>0</tt> for no filter.
   * @return <tt>true</tt> if the pads could be linked, <tt>false</tt> otherwise.
   */
  bool link_filtered(const Glib::RefPtr<Element>& other_element, const Glib::RefPtr<Caps>& filter);
  
  /** Set the base time of an element. See get_base_time().
   * 
   * MT safe.
   * @param time The base time to set.
   */
  void set_base_time(ClockTime time);
  
  /** Returns: the base time of the element.
   * @return The base time of the element.
   * 
   * MT safe.
   */
  ClockTime get_base_time() const;
  
  /** Sets the bus of the element. Increases the refcount on the bus.
   * For internal use only, unless you're testing elements.
   * 
   * MT safe.
   * @param bus The Gst::Bus to set.
   */
  void set_bus(const Glib::RefPtr<Bus>& bus);
  
  /** Returns: the element's Gst::Bus. unref after usage.
   * @return The element's Gst::Bus. unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Bus> get_bus();
  
  /** Returns: the element's Gst::Bus. unref after usage.
   * @return The element's Gst::Bus. unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Bus> get_bus() const;
  
  /** Set @a index on the element. The refcount of the index
   * will be increased, any previously set index is unreffed.
   * 
   * MT safe.
   * @param index A Gst::Index.
   */
  void set_index(const Glib::RefPtr<Index>& index);

  //Note: gst_element_get_index provides a reference.
  
  /** Gets the index from the element.
   * @return A Gst::Index or <tt>0</tt> when no index was set on the
   * element. unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Index> get_index();
  
  /** Gets the index from the element.
   * @return A Gst::Index or <tt>0</tt> when no index was set on the
   * element. unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Index const> get_index() const;


  /** Retrieves the factory that was used to create this element.
   * @return The Gst::ElementFactory used for creating this element.
   * no refcounting is needed.
   */
  Glib::RefPtr<ElementFactory> get_factory();
  
  /** Queries if the element can be indexed.
   * @return <tt>true</tt> if the element can be indexed.
   * 
   * MT safe.
   */
  bool is_indexable() const;
  
  /** Query if the element requires a clock.
   * @return <tt>true</tt> if the element requires a clock
   * 
   * MT safe.
   */
  bool requires_clock() const;
  
  /** Sets the clock for the element. This function increases the
   * refcount on the clock. Any previously set clock on the object
   * is unreffed.
   * @param clock The Gst::Clock to set for the element.
   * @return <tt>true</tt> if the element accepted the clock. An element can refuse a
   * clock when it, for example, is not able to slave its internal clock to the
   *  @a clock or when it requires a specific clock to operate.
   * 
   * MT safe.
   */
  bool set_clock(const Glib::RefPtr<Clock>& clock);
  
  /** Gets the currently configured clock of the element. This is the clock as was
   * last set with set_clock().
   * @return The Gst::Clock of the element. unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Clock> get_clock();
  
  /** Gets the currently configured clock of the element. This is the clock as was
   * last set with set_clock().
   * @return The Gst::Clock of the element. unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Clock> get_clock() const;
  
  /** Query if the element provides a clock. A Gst::Clock provided by an
   * element can be used as the global Gst::Clock for the pipeline.
   * An element that can provide a clock is only required to do so in the PAUSED
   * state, this means when it is fully negotiated and has allocated the resources
   * to operate the clock.
   * @return <tt>true</tt> if the element provides a clock
   * 
   * MT safe.
   */
  bool provides_clock() const;
  
  /** Get the clock provided by the given element.
   * &lt;note&gt;An element is only required to provide a clock in the PAUSED
   * state. Some elements can provide a clock in other states.&lt;/note&gt;
   * @return The GstClock provided by the element or <tt>0</tt>
   * if no clock could be provided.  Unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Clock> provide_clock();
  
  /** Get the clock provided by the given element.
   * &lt;note&gt;An element is only required to provide a clock in the PAUSED
   * state. Some elements can provide a clock in other states.&lt;/note&gt;
   * @return The GstClock provided by the element or <tt>0</tt>
   * if no clock could be provided.  Unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Clock> provide_clock() const;
  
  /** Sets the state of the element. This function will try to set the
   * requested state by going through all the intermediary states and calling
   * the class's state change function for each.
   * 
   * This function can return Gst::STATE_CHANGE_ASYNC, in which case the
   * element will perform the remainder of the state change asynchronously in
   * another thread.
   * An application can use get_state() to wait for the completion
   * of the state change or it can wait for a state change message on the bus.
   * @param state The element's new Gst::State.
   * @return Result of the state change using Gst::StateChangeReturn.
   * 
   * MT safe.
   */
  StateChangeReturn set_state(State state);
  
  /** Gets the state of the element.
   * 
   * For elements that performed an ASYNC state change, as reported by
   * set_state(), this function will block up to the
   * specified timeout value for the state change to complete.
   * If the element completes the state change or goes into
   * an error, this function returns immediately with a return value of
   * Gst::STATE_CHANGE_SUCCESS or Gst::STATE_CHANGE_FAILURE respectively.
   * 
   * For elements that did not return Gst::STATE_CHANGE_ASYNC, this function
   * Returns: Gst::STATE_CHANGE_SUCCESS if the element has no more pending state
   * @param state A pointer to Gst::State to hold the state. Can be <tt>0</tt>.
   * @param pending A pointer to Gst::State to hold the pending state.
   * Can be <tt>0</tt>.
   * @param timeout A Gst::ClockTime to specify the timeout for an async
   * state change or Gst::CLOCK_TIME_NONE for infinite timeout.
   * @return Gst::STATE_CHANGE_SUCCESS if the element has no more pending state
   * and the last state change succeeded, Gst::STATE_CHANGE_ASYNC if the
   * element is still performing a state change or
   * Gst::STATE_CHANGE_FAILURE if the last state change failed.
   * 
   * MT safe.
   */
  StateChangeReturn get_state(State& state, State& pending, ClockTime timeout) const;
  
  /** Locks the state of an element, so state changes of the parent don't affect
   * this element anymore.
   * 
   * MT safe.
   * @param locked_state <tt>true</tt> to lock the element's state.
   * @return <tt>true</tt> if the state was changed, <tt>false</tt> if bad parameters were given
   * or the elements state-locking needed no change.
   */
  bool set_locked_state(gboolean locked_state);
  
  /** Checks if the state of an element is locked.
   * If the state of an element is locked, state changes of the parent don't
   * affect the element.
   * This way you can leave currently unused elements inside bins. Just lock their
   * state before changing the state from Gst::STATE_<tt>0</tt>.
   * 
   * MT safe.
   * @return <tt>true</tt>, if the element's state is locked.
   */
  bool is_locked_state() const;
  
  /** Abort the state change of the element. This function is used
   * by elements that do asynchronous state changes and find out
   * something is wrong.
   * 
   * This function should be called with the STATE_LOCK held.
   * 
   * MT safe.
   */
  void abort_state();
  
  /** Commit the state change of the element and proceed to the next
   * pending state if any. This function is used
   * by elements that do asynchronous state changes.
   * The core will normally call this method automatically when an
   * element returned Gst::STATE_CHANGE_SUCCESS from the state change function.
   * 
   * If after calling this method the element still has not reached
   * the pending state, the next state change is performed.
   * 
   * This method is used internally and should normally not be called by plugins
   * or applications.
   * @param ret The previous state return value.
   * @return The result of the commit state change.
   * 
   * MT safe.
   */
  StateChangeReturn continue_state(StateChangeReturn prestate_value);
  
  /** Brings the element to the lost state. The current state of the
   * element is copied to the pending state so that any call to
   * get_state() will return Gst::STATE_CHANGE_ASYNC.
   * 
   * An ASYNC_START message is posted with an indication to distribute a new
   * base_time to the element.
   * If the element was PLAYING, it will go to PAUSED. The element
   * will be restored to its PLAYING state by the parent pipeline when it
   * prerolls again.
   * 
   * This is mostly used for elements that lost their preroll buffer
   * in the Gst::STATE_PAUSED or Gst::STATE_PLAYING state after a flush,
   * they will go to their pending state again when a new preroll buffer is
   * queued. This function can only be called when the element is currently
   * not in error or an async state change.
   * 
   * This function is used internally and should normally not be called from
   * plugins or applications.
   * 
   * MT safe.
   */
  void lost_state();
  
  /** Tries to change the state of the element to the same as its parent.
   * If this function returns <tt>false</tt>, the state of element is undefined.
   * @return <tt>true</tt>, if the element's state could be synced to the parent's state.
   * 
   * MT safe.
   */
  bool sync_state_with_parent();
  
  /** Perform @a transition on @a element.
   * 
   * This function must be called with STATE_LOCK held and is mainly used
   * internally.
   * @param transition The requested transition.
   * @return The Gst::StateChangeReturn of the state transition.
   */
  StateChangeReturn change_state(StateChange transition);

  //TODO: Change the parameter order?
  
  /** Post an error, warning or info message on the bus from inside an element.
   * 
   *  @a type must be of Gst::MESSAGE_ERROR, Gst::MESSAGE_WARNING or
   * Gst::MESSAGE_INFO.
   * 
   * MT safe.
   * @param type The Gst::MessageType.
   * @param domain The GStreamer GError domain this message belongs to.
   * @param code The GError code belonging to the domain.
   * @param text An allocated text string to be used as a replacement for the
   * default message connected to code, or <tt>0</tt>.
   * @param debug An allocated debug message to be used as a replacement for the
   * default debugging information, or <tt>0</tt>.
   * @param file The source code file where the error was generated.
   * @param function The source code function where the error was generated.
   * @param line The source code line where the error was generated.
   */
  void post_message(MessageType message_type, GQuark domain, int code, const Glib::ustring& message, const Glib::ustring& debug, const Glib::ustring& filename, const Glib::ustring& function_name, int line_number);
  
  /** Post a message on the element's Gst::Bus. This function takes ownership of the
   * message; if you want to access the message after this call, you should add an
   * additional reference before calling.
   * @param message A Gst::Message to post.
   * @return <tt>true</tt> if the message was successfully posted. The function returns
   * <tt>false</tt> if the element did not have a bus.
   * 
   * MT safe.
   */
  bool post_message(const Glib::RefPtr<Message>& message);

  //TODO: Use ArrayHandle?
  
  /** Get an array of query types from the element.
   * If the element doesn't implement a query types function,
   * the query will be forwarded to the peer of a random linked sink pad.
   * @return An array of Gst::QueryType elements that should not
   * be freed or modified.
   * 
   * MT safe.
   */
  const QueryType* get_query_types() const;

  
  /** Performs a query on the given element.
   * 
   * For elements that don't implement a query handler, this function
   * forwards the query to a random srcpad or to the peer of a
   * random linked sinkpad of this element.
   * @param query The Gst::Query.
   * @return <tt>true</tt> if the query could be performed.
   * 
   * MT safe.
   */
  bool query(const Glib::RefPtr<Query>& query);
  
  /** Queries an element to convert @a src_val in @a src_format to @a dest_format.
   * @param src_format A Gst::Format to convert from.
   * @param src_val A value to convert.
   * @param dest_format A pointer to the Gst::Format to convert to.
   * @param dest_val A pointer to the result.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_convert(Format src_format, gint64 src_value, Format& dst_format, gint64& dst_value) const;
  
  /** Queries an element for the stream position.
   * @param format A pointer to the Gst::Format asked for.
   * On return contains the Gst::Format used.
   * @param cur A location in which to store the current position, or <tt>0</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_position(Format& format, gint64& position) const;
  
  /** Queries an element for the total stream duration.
   * @param format A pointer to the Gst::Format asked for.
   * On return contains the Gst::Format used.
   * @param duration A location in which to store the total duration, or <tt>0</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_duration(Format& format, gint64& duration) const;

  bool query_position(Format& format) const;
  bool query_duration(Format& format) const;

  
  /** Simple API to perform a seek on the given element, meaning it just seeks
   * to the given position relative to the start of the stream. For more complex
   * operations like segment seeks (e.g. for looping) or changing the playback
   * rate or seeking relative to the last configured playback segment you should
   * use seek().
   * 
   * In a completely prerolled PAUSED or PLAYING pipeline, seeking is always
   * guaranteed to return <tt>true</tt> on a seekable media type or <tt>false</tt> when the media
   * type is certainly not seekable (such as a live stream).
   * 
   * Some elements allow for seeking in the READY state, in this
   * case they will store the seek event and execute it when they are put to
   * PAUSED. If the element supports seek in READY, it will always return <tt>true</tt> when
   * it receives the event in the READY state.
   * @param format A Gst::Format to execute the seek in, such as Gst::FORMAT_TIME.
   * @param seek_flags Seek options; playback applications will usually want to use
   * GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_KEY_UNIT here.
   * @param seek_pos Position to seek to (relative to the start); if you are doing
   * a seek in Gst::FORMAT_TIME this value is in nanoseconds -
   * multiply with Gst::SECOND to convert seconds to nanoseconds or
   * with Gst::MSECOND to convert milliseconds to nanoseconds.
   * @return <tt>true</tt> if the seek operation succeeded (the seek might not always be
   * executed instantly though)
   * 
   * Since: 0.10.7.
   */
  bool seek(Format format, SeekFlags flags, gint64 position);
  
  /** Sends a seek event to an element. See Gst::Event::new_seek() for the details of
   * the parameters. The seek event is sent to the element using
   * send_event().
   * @param rate The new playback rate.
   * @param format The format of the seek values.
   * @param flags The optional seek flags.
   * @param cur_type The type and flags for the new current position.
   * @param cur The value of the new current position.
   * @param stop_type The type and flags for the new stop position.
   * @param stop The value of the new stop position.
   * @return <tt>true</tt> if the event was handled.
   * 
   * MT safe.
   */
  bool seek(double rate, Format format, SeekFlags flags, SeekType current_type, gint64 current_position, SeekType stop_type, gint64 stop_position);

  bool send_event(const Glib::RefPtr<Event>& event);

  
  /** Test whether the given element implements a certain interface of type
   * iface_type, and test whether it is supported for this specific instance.
   * @param iface_type (final) type of the interface which we want to be implemented.
   * @return Whether or not the element implements the interface.
   */
  bool implements_interface(GType iface_type);

  
  /**
   * @par Prototype:
   * <tt>void on_my_%no_more_pads()</tt>
   */

  Glib::SignalProxy0< void > signal_no_more_pads();


  /**
   * @par Prototype:
   * <tt>void on_my_%pad_added(const Glib::RefPtr<Pad>& new_pad)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Pad>& > signal_pad_added();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%pad_removed(const Glib::RefPtr<Pad>& old_pad)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Pad>& > signal_pad_removed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_no_more_pads();
  virtual void on_pad_added(const Glib::RefPtr<Pad>& new_pad);
  virtual void on_pad_removed(const Glib::RefPtr<Pad>& old_pad);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Element
   */
  Glib::RefPtr<Gst::Element> wrap(GstElement* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_ELEMENT_H */

