// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/message.h>
#include <gstreamermm/private/message_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstenumtypes.h>
#include <gstreamermm/structure.h>
#include <gstreamermm/taglist.h>


namespace Gst
{

namespace Enums
{

Glib::ustring get_name(MessageType t)
{
  return gst_message_type_get_name(GstMessageType(t));
}

Glib::QueryQuark get_quark(MessageType t)
{
  return Glib::QueryQuark(gst_message_type_to_quark(GstMessageType(t)));
}

} //namespace Enums

Structure Message::get_structure() const
{
  static Structure structure;

  GstStructure* gst_structure = const_cast<GstStructure*>(gst_message_get_structure(const_cast<GstMessage*>(gobj())));
  return Structure(gst_structure, true /* take_copy */);
}

MessageApplication::MessageApplication(GstMessage* castitem)
: Message(castitem)
{
}

// MessageApplication
Glib::RefPtr<Message> MessageApplication::create(const Glib::RefPtr<Object>& src, Structure& structure)
{
  GstMessage* message = gst_message_new_application(src->gobj(), structure.gobj());
  return Gst::Message::wrap(message, false);
}


MessageClockProvide::MessageClockProvide(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageClockProvide::create(const Glib::RefPtr<Object>& src, const Glib::RefPtr<Clock>& clock, bool ready)
{
  GstMessage* message = gst_message_new_clock_provide(src->gobj(), clock->gobj(), ready);
  return Gst::Message::wrap(message, false);
}


void MessageClockProvide::parse(Glib::RefPtr<Clock>& clock, bool& ready)
{
  GstClock* cclock = 0;
  gboolean ready_ = false;
  gst_message_parse_clock_provide(gobj(), &cclock, &ready_);
  clock = Glib::wrap(cclock);
  ready = ready_;
}


MessageClockLost::MessageClockLost(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageClockLost::create(const Glib::RefPtr<Object>& src, const Glib::RefPtr<Clock>& clock)
{
  GstMessage* message = gst_message_new_clock_lost(src->gobj(), clock->gobj());
  return Gst::Message::wrap(message, false);
}

void MessageClockLost::parse(Glib::RefPtr<Clock>& clock)
{
  GstClock* cclock = 0;
  gst_message_parse_clock_lost(gobj(), &cclock);
  clock = Glib::wrap(cclock, false);
}


MessageCustom::MessageCustom(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageCustom::create(MessageType type, const Glib::RefPtr<Object>& src, Structure& structure)
{
  GstMessage* message = gst_message_new_custom(GstMessageType(type), src->gobj(), structure.gobj());
  return Gst::Message::wrap(message, false);
}


MessageElement::MessageElement(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageElement::create(const Glib::RefPtr<Object>& src, Structure& structure)
{
  GstMessage* message = gst_message_new_element(src->gobj(), structure.gobj());
  return Gst::Message::wrap(message, false);
}


MessageEos::MessageEos(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageEos::create(const Glib::RefPtr<Object>& src)
{
  GstMessage* message = gst_message_new_eos(src->gobj());
  return Gst::Message::wrap(message, false);
}


MessageError::MessageError(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageError::create(const Glib::RefPtr<Object>& src, Glib::Error& error, const std::string& debug)
{
  GstMessage* message = gst_message_new_error(src->gobj(), error.gobj(),(gchar*)(debug.c_str()));
  return Gst::Message::wrap(message, false);
}

void MessageError::parse(Glib::Error& error, std::string& debug)
{
  GError* c_error = 0;
  gchar* c_debug = 0;
  gst_message_parse_error(gobj(), &c_error, &c_debug);

  if(c_debug)
  {
    debug = c_debug;
    g_free(c_debug);
  }

  if(c_error)
  {
    error = Glib::Error(c_error); 
    g_error_free(c_error);
  }
}

void MessageError::parse(Glib::Error& error)
{
  GError* c_error = 0;
  gst_message_parse_error(gobj(), &c_error, NULL);

  if(c_error)
  {
    error = Glib::Error(c_error); 
    g_error_free(c_error);
  }
}


MessageInfo::MessageInfo(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageInfo::create(const Glib::RefPtr<Object>& src, Glib::Error& error, const std::string& debug)
{
  GstMessage* message = gst_message_new_info(src->gobj(), error.gobj(),(gchar*)(debug.c_str()));
  return Gst::Message::wrap(message, false);
}


void MessageInfo::parse(Glib::Error& error, std::string& debug)
{
  GError* c_error = 0;
  gchar* c_debug = 0;
  gst_message_parse_info(gobj(), &c_error, &c_debug);

  if(c_debug)
  {
    debug = c_debug;
    g_free(c_debug);
  }

  if(c_error)
  {
    error = Glib::Error(c_error); 
    g_error_free(c_error);
  }
}

void MessageInfo::parse(Glib::Error& error)
{
  GError* c_error = 0;
  gst_message_parse_info(gobj(), &c_error, NULL);

  if(c_error)
  {
    error = Glib::Error(c_error); 
    g_error_free(c_error);
  }
}


MessageNewClock::MessageNewClock(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageNewClock::create(const Glib::RefPtr<Object>& src, const Glib::RefPtr<Clock>& clock)
{
  GstMessage* message = gst_message_new_new_clock(src->gobj(), clock->gobj());
  return Gst::Message::wrap(message, false);
}


MessageSegmentDone::MessageSegmentDone(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageSegmentDone::create(const Glib::RefPtr<Object>& src, Format format, gint64 position)
{
  GstMessage* message = gst_message_new_segment_done(src->gobj(), GstFormat(format), position);
  return Gst::Message::wrap(message, false);
}


MessageSegmentStart::MessageSegmentStart(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageSegmentStart::create(const Glib::RefPtr<Object>& src, Format format, gint64 position)
{
  GstMessage* message = gst_message_new_segment_start(src->gobj(), GstFormat(format), position);
  return Gst::Message::wrap(message, false);
}


MessageStateChanged::MessageStateChanged(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageStateChanged::create(const Glib::RefPtr<Object>& src, State oldstate, State newstate, State pending)
{
  GstMessage* message = gst_message_new_state_changed(src->gobj(), GstState(oldstate), GstState(newstate), GstState(pending));
  return Gst::Message::wrap(message, false);
}


MessageBuffering::MessageBuffering(GstMessage* castitem)
: Message(castitem)
{
}

MessageTag::MessageTag(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageTag::create(const Glib::RefPtr<Object>& src, const TagList& taglist)
{
  //We create a copy because gst_message_new_tag() takes ownership:
  GstTagList* c_taglist = gst_tag_list_copy(taglist.gobj());
  GstMessage* message = gst_message_new_tag(src->gobj(), c_taglist);
  return Gst::Message::wrap(message, false);
}

void MessageTag::parse(TagList& taglist)
{
  GstTagList* gst_tag_list = gst_tag_list_new();
  gst_message_parse_tag(gobj(), &gst_tag_list);
  TagList result(gst_tag_list);
  taglist.swap(result);
}

Glib::RefPtr<Message> MessageBuffering::create(const Glib::RefPtr<Object>& src, int percent)
{
  GstMessage* message = gst_message_new_buffering(src->gobj(), percent);
  return Gst::Message::wrap(message, false);
}


MessageWarning::MessageWarning(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageWarning::create(const Glib::RefPtr<Object>& src, Glib::Error& error, const std::string& debug)
{
  GstMessage* message = gst_message_new_warning(src->gobj(), error.gobj(),(gchar*)(debug.c_str()));
  return Gst::Message::wrap(message, false);
}


MessageDuration::MessageDuration(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageDuration::create(const Glib::RefPtr<Object>& src, Format format, gint64 position)
{
  GstMessage* message = gst_message_new_duration(src->gobj(), GstFormat(format), position);
  return Gst::Message::wrap(message, false);
}


MessageStateDirty::MessageStateDirty(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageStateDirty::create(const Glib::RefPtr<Object>& src)
{
  GstMessage* message = gst_message_new_state_dirty(src->gobj());
  return Gst::Message::wrap(message, false);
}


MessageAsyncStart::MessageAsyncStart(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageAsyncStart::create(const Glib::RefPtr<Object>& src, bool new_base_time)
{
  GstMessage* message = gst_message_new_async_start(src->gobj(), new_base_time);
  return Gst::Message::wrap(message, false);
}

void MessageAsyncStart::parse(bool& base_time)
{
  gboolean result;
  gst_message_parse_async_start(gobj(), &result);
  base_time = result;
}


MessageAsyncDone::MessageAsyncDone(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageAsyncDone::create(const Glib::RefPtr<Object>& src)
{
  GstMessage* message = gst_message_new_async_done(src->gobj());
  return Gst::Message::wrap(message, false);
}


MessageLatency::MessageLatency(GstMessage* castitem)
: Message(castitem)
{
}

Glib::RefPtr<Message> MessageLatency::create(const Glib::RefPtr<Object>& src)
{
  GstMessage* message = gst_message_new_latency(src->gobj());
  return Gst::Message::wrap(message, false);
}

Glib::RefPtr<Message> Message::wrap(GstMessage* message, bool take_copy) {

  Glib::RefPtr<Message> result;

  if(!message)
    return result;

  switch (GST_MESSAGE_TYPE(message)) {
    case GST_MESSAGE_EOS:
      result = Glib::RefPtr<Message>( new Gst::MessageEos(message) );
      break;
    case GST_MESSAGE_ERROR:
      result = Glib::RefPtr<Message>( new Gst::MessageError(message) );
      break;
    case GST_MESSAGE_WARNING:
      result = Glib::RefPtr<Message>( new Gst::MessageWarning(message) );
      break;
    case GST_MESSAGE_INFO:
      result = Glib::RefPtr<Message>( new Gst::MessageInfo(message) );
      break;
    case GST_MESSAGE_TAG:
      result = Glib::RefPtr<Message>( new Gst::MessageTag(message) );
      break;
    case GST_MESSAGE_BUFFERING:
      result = Glib::RefPtr<MessageBuffering>( new Gst::MessageBuffering(message) );
      break;
    case GST_MESSAGE_STATE_CHANGED:
      result = Glib::RefPtr<Message>( new Gst::MessageStateChanged(message) );
      break;
    case GST_MESSAGE_STATE_DIRTY:
      result = Glib::RefPtr<Message>( new Gst::MessageStateDirty(message) );
      break;
    case GST_MESSAGE_CLOCK_PROVIDE:
      result = Glib::RefPtr<Message>( new Gst::MessageClockProvide(message) );
      break;
    case GST_MESSAGE_CLOCK_LOST:
      result = Glib::RefPtr<Message>( new Gst::MessageClockLost(message) );
      break;
    case GST_MESSAGE_NEW_CLOCK:
      result = Glib::RefPtr<Message>( new Gst::MessageNewClock(message) );
      break;
    case GST_MESSAGE_APPLICATION:
      result = Glib::RefPtr<Message>( new Gst::MessageApplication(message) );
      break;
    case GST_MESSAGE_ELEMENT:
      result = Glib::RefPtr<Message>( new Gst::MessageElement(message) );
      break;
    case GST_MESSAGE_SEGMENT_START:
      result = Glib::RefPtr<Message>( new Gst::MessageSegmentStart(message) );
      break;
    case GST_MESSAGE_SEGMENT_DONE:
      result = Glib::RefPtr<Message>( new Gst::MessageSegmentDone(message) );
      break;
    case GST_MESSAGE_DURATION:
      result = Glib::RefPtr<MessageDuration>( new Gst::MessageDuration(message) );
      break;
    case GST_MESSAGE_LATENCY:
      result = Glib::RefPtr<Message>( new Gst::MessageLatency(message) );
      break;
    case GST_MESSAGE_ASYNC_START:
      result = Glib::RefPtr<Message>( new Gst::MessageAsyncStart(message) );
      break;
    case GST_MESSAGE_ASYNC_DONE:
      result = Glib::RefPtr<Message>( new Gst::MessageAsyncDone(message) );
      break;
    //TODO?: case GST_MESSAGE_STEP_DONE:
    //TODO?: case GST_MESSAGE_STRUCTURE_CHANGE:
    //TODO?: case GST_MESSAGE_STREAM_STATUS:
    default:
      result = Gst::wrap(message, false);
  }

  if(result && take_copy)
    result->reference();

  return result;
}

} //namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::MessageType>::value_type()
{
  return gst_message_type_get_type();
}


namespace Gst
{

Glib::RefPtr<Gst::Message> wrap(GstMessage* object, bool take_copy)
{
  //Note that we use Gst::wrap() instead of Glib::wrap() 
  //because we are dealing with a GstMiniObject, not a GObject:
  return Glib::RefPtr<Gst::Message>( dynamic_cast<Gst::Message*> (Gst::wrap_auto ((GstMiniObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Gst */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Message_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Message_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_message_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Message_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Message_Class::wrap_new(GstMiniObject* object)
{
  return new Message((GstMessage*)object);
}


/* The implementation: */

GstMessage* Message::gobj_copy()
{
  reference();
  return gobj();
}


Message::Message(GstMessage* castitem)
:
  Gst::MiniObject((GstMiniObject*)(castitem))
{}

Message::~Message()
{}


Message::CppClassType Message::message_class_; // initialize static member

GType Message::get_type()
{
  return message_class_.init().get_type();
}

GType Message::get_base_type()
{
  return gst_message_get_type();
}


 MessageType Message::get_message_type() const
{
  return ((MessageType)(gobj()->type));
}
 
 ClockTime Message::get_timestamp() const
{
  return (ClockTime (gobj()->timestamp));
}
 
 Glib::RefPtr<Gst::Object> Message::get_source()
{
  Glib::RefPtr<Gst::Object> ref_ptr(Glib::wrap(gobj()->src));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gst::Object> Message::get_source() const
{
  Glib::RefPtr<const Gst::Object> ref_ptr(Glib::wrap(gobj()->src));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}
 

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gst


