// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/mixer.h>
#include <gstreamermm/private/mixer_p.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

 #include <gst/interfaces/mixer.h>
 #include <gstreamermm/mixeroptions.h>

namespace Gst
{

Glib::ArrayHandle<int> Mixer::get_volume(const Glib::RefPtr<const Gst::MixerTrack>& track) const
{
  const guint32 num_channels = track->get_num_channels();
  int* volumes = new int[num_channels];

  gst_mixer_get_volume(const_cast<GstMixer*>(gobj()),
    const_cast<GstMixerTrack*>(track->gobj()), volumes);

  return Glib::ArrayHandle<int>::ArrayHandle(volumes, num_channels,
    Glib::OWNERSHIP_DEEP);
}

#ifdef GLIBMM_VFUNCS_ENABLED
// This vfunc wrapper is manually written, because we want the C++ vfunc to
// return the result instead of passing in a pointer in which to store it.

void Mixer_Class::get_volume_vfunc_callback(GstMixer* self, GstMixerTrack* track, gint* volumes)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      // Call the virtual member method, which derived classes might override.
      Glib::ArrayHandle<int> result = obj->get_volume_vfunc(Glib::wrap(track, true));
      const int* result_data = result.data();
      for (int i = 0; i < result.size(); i++)
      {
        volumes[i] = result_data[i];
      }
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

    // Call the original underlying C function:
    if(base && base->get_volume)
      return (*base->get_volume)(self, track, volumes);
  }
}

Glib::ArrayHandle<int> Gst::Mixer::get_volume_vfunc(const Glib::RefPtr<const Gst::MixerTrack>& track) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_volume)
  {
    const guint32 num_channels = track->get_num_channels();
    int* volumes = new int[num_channels];
    (*base->get_volume)(const_cast<GstMixer*>(gobj()),
      const_cast<GstMixerTrack*>((track)->gobj()), volumes);
    return Glib::ArrayHandle<int>(volumes, num_channels, Glib::OWNERSHIP_DEEP);
  }

  typedef Glib::ArrayHandle<int> RType;
  return RType(0, 0, Glib::OWNERSHIP_DEEP);
}
#endif //GLIBMM_VFUNCS_ENABLED

} // namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::MixerType>::value_type()
{
  return gst_mixer_type_get_type();
}

// static
GType Glib::Value<Gst::MixerFlags>::value_type()
{
  return gst_mixer_flags_get_type();
}

// static
GType Glib::Value<Gst::MixerMessageType>::value_type()
{
  return gst_mixer_message_type_get_type();
}


namespace Glib
{

Glib::RefPtr<Gst::Mixer> wrap(GstMixer* object, bool take_copy)
{
  return Glib::RefPtr<Gst::Mixer>( dynamic_cast<Gst::Mixer*> (Glib::wrap_auto_interface<Gst::Mixer> ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} // namespace Glib


namespace Gst
{


/* The *_Class implementation: */

const Glib::Interface_Class& Mixer_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Interface_Class has to know the interface init function
    // in order to add interfaces to implementing types.
    class_init_func_ = &Mixer_Class::iface_init_function;

    // We can not derive from another interface, and it is not necessary anyway.
    gtype_ = gst_mixer_get_type();
  }

  return *this;
}

void Mixer_Class::iface_init_function(void* g_iface, void*)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_iface);

  //This is just to avoid an "unused variable" warning when there are no vfuncs or signal handlers to connect.
  //This is a temporary fix until I find out why I can not seem to derive a GtkFileChooser interface. murrayc
  g_assert(klass != 0); 

#ifdef GLIBMM_VFUNCS_ENABLED
  klass->set_mute = &set_mute_vfunc_callback;
  klass->set_record = &set_record_vfunc_callback;
  klass->set_option = &set_option_vfunc_callback;
    klass->get_volume = &get_volume_vfunc_callback;
  #endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
void Mixer_Class::set_mute_vfunc_callback(GstMixer* self, GstMixerTrack* track, gboolean mute)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->set_mute_vfunc(Glib::wrap((track), true)
, mute
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_mute)
    (*base->set_mute)(self, track, mute);

}
void Mixer_Class::set_record_vfunc_callback(GstMixer* self, GstMixerTrack* track, gboolean record)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->set_record_vfunc(Glib::wrap((track), true)
, record
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_record)
    (*base->set_record)(self, track, record);

}
void Mixer_Class::set_option_vfunc_callback(GstMixer* self, GstMixerOptions* opts, gchar* value)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->set_option_vfunc(Glib::wrap((opts), true)
, Glib::convert_const_gchar_ptr_to_ustring(value)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_option)
    (*base->set_option)(self, opts, value);

}
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Mixer_Class::wrap_new(GObject* object)
{
  return new Mixer((GstMixer*)(object));
}


/* The implementation: */

Mixer::Mixer()
:
  Glib::Interface(mixer_class_.init())
{}

Mixer::Mixer(GstMixer* castitem)
:
  Glib::Interface((GObject*)(castitem))
{}

Mixer::Mixer(const Glib::Interface_Class& interface_class)
: Glib::Interface(interface_class)
{
}

Mixer::~Mixer()
{}

// static
void Mixer::add_interface(GType gtype_implementer)
{
  mixer_class_.init().add_interface(gtype_implementer);
}

Mixer::CppClassType Mixer::mixer_class_; // initialize static member

GType Mixer::get_type()
{
  return mixer_class_.init().get_type();
}

GType Mixer::get_base_type()
{
  return gst_mixer_get_type();
}


Glib::ListHandle< Glib::RefPtr<Gst::MixerTrack> > Mixer::list_tracks()
{
  return Glib::ListHandle< Glib::RefPtr<Gst::MixerTrack> >(const_cast<GList*>(gst_mixer_list_tracks(gobj())), Glib::OWNERSHIP_NONE);
}

Glib::ListHandle< Glib::RefPtr<const Gst::MixerTrack> > Mixer::list_tracks() const
{
  return Glib::ListHandle< Glib::RefPtr<const Gst::MixerTrack> >(const_cast<GList*>(gst_mixer_list_tracks(const_cast<GstMixer*>(gobj()))), Glib::OWNERSHIP_NONE);
}

void Mixer::set_volume(const Glib::RefPtr<Gst::MixerTrack>& track, const Glib::ArrayHandle<int>& volumes)
{
gst_mixer_set_volume(gobj(), Glib::unwrap(track), const_cast<int*>((volumes).data())); 
}

void Mixer::set_mute(const Glib::RefPtr<Gst::MixerTrack>& track, bool mute)
{
gst_mixer_set_mute(gobj(), Glib::unwrap(track), static_cast<int>(mute)); 
}

void Mixer::set_record(const Glib::RefPtr<Gst::MixerTrack>& track, bool record)
{
gst_mixer_set_record(gobj(), Glib::unwrap(track), static_cast<int>(record)); 
}

void Mixer::set_option(const Glib::RefPtr<Gst::MixerOptions>& opts, const Glib::ustring& value)
{
gst_mixer_set_option(gobj(), Glib::unwrap(opts), const_cast<gchar*>(value.c_str())); 
}

void Mixer::mute_toggled(const Glib::RefPtr<Gst::MixerTrack>& track, bool mute)
{
gst_mixer_mute_toggled(gobj(), Glib::unwrap(track), static_cast<int>(mute)); 
}

void Mixer::record_toggled(const Glib::RefPtr<Gst::MixerTrack>& track, bool record)
{
gst_mixer_record_toggled(gobj(), Glib::unwrap(track), static_cast<int>(record)); 
}

void Mixer::volume_changed(const Glib::RefPtr<Gst::MixerTrack>& track, const Glib::ArrayHandle<int>& volumes)
{
gst_mixer_volume_changed(gobj(), Glib::unwrap(track), const_cast<int*>((volumes).data())); 
}

void Mixer::option_changed(const Glib::RefPtr<Gst::MixerOptions>& opts, const Glib::ustring& value)
{
gst_mixer_option_changed(gobj(), Glib::unwrap(opts), const_cast<gchar*>(value.c_str())); 
}

void Mixer::options_list_changed(const Glib::RefPtr<Gst::MixerOptions>& opts)
{
gst_mixer_options_list_changed(gobj(), Glib::unwrap(opts)); 
}

Glib::ustring Mixer::get_option(const Glib::RefPtr<const Gst::MixerOptions>& opts) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gst_mixer_get_option(const_cast<GstMixer*>(gobj()), const_cast<GstMixerOptions*>((opts)->gobj())));
}

void Mixer::mixer_changed()
{
gst_mixer_mixer_changed(gobj()); 
}

Gst::MixerFlags Mixer::get_mixer_flags() const
{
  return ((Gst::MixerFlags)(gst_mixer_get_mixer_flags(const_cast<GstMixer*>(gobj()))));
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
void Gst::Mixer::set_mute_vfunc(const Glib::RefPtr<Gst::MixerTrack>& track, bool mute) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_mute)
    (*base->set_mute)(gobj(),Glib::unwrap(track),static_cast<int>(mute));
}
void Gst::Mixer::set_record_vfunc(const Glib::RefPtr<Gst::MixerTrack>& track, bool record) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_record)
    (*base->set_record)(gobj(),Glib::unwrap(track),static_cast<int>(record));
}
void Gst::Mixer::set_option_vfunc(const Glib::RefPtr<Gst::MixerOptions>& opts, const Glib::ustring& value) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_option)
    (*base->set_option)(gobj(),Glib::unwrap(opts),const_cast<gchar*>(value.c_str()));
}
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gst


