// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/miniobject.h>
#include <gstreamermm/private/miniobject_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/miniobject.h>
#include <gstreamermm/private/miniobject_p.h>

namespace Gst
{

MiniObject::~MiniObject()
{
    GstMiniObject *const gobject_ = reinterpret_cast<GstMiniObject*>(const_cast<MiniObject*>(this));
  // The value of the reference count is checked so that if this mini object is
  // being destroyed as a result of weak reference notification no
  // unreferencing is done and thus no error is issued on unreferencing a mini
  // object with a reference of 0.
  if(gobject_ && GST_MINI_OBJECT_REFCOUNT_VALUE(gobject_) > 0)
    gst_mini_object_unref(gobject_);
}

} //namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::MiniObjectFlags>::value_type()
{
  return gst_mini_object_flags_get_type();
}

// static
GType Glib::Value<Gst::LockFlags>::value_type()
{
  return gst_lock_flags_get_type();
}


/* Why reinterpret_cast<MiniObject*>(gobject) is needed:
 *
 * A MiniObject instance is in fact always a GstMiniObject instance.
 * Unfortunately, GstMiniObject cannot be a member of MiniObject,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because MiniObject does not have any member data, and
 * it is impossible to derive from it.  This is ensured by not implementing
 * the (protected) default constructor.  The ctor is protected rather than
 * private just to avoid a compile warning.
 */

namespace Glib
{

Glib::RefPtr<Gst::MiniObject> wrap(GstMiniObject* object, bool take_copy)
{
  if(take_copy && object)
    gst_mini_object_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gst::MiniObject>(reinterpret_cast<Gst::MiniObject*>(object));
}

} // namespace Glib


namespace Gst
{


void MiniObject::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_mini_object_ref(reinterpret_cast<GstMiniObject*>(const_cast<MiniObject*>(this)));
}

void MiniObject::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_mini_object_unref(reinterpret_cast<GstMiniObject*>(const_cast<MiniObject*>(this)));
}

GstMiniObject* MiniObject::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GstMiniObject*>(this);
}

const GstMiniObject* MiniObject::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GstMiniObject*>(this);
}

GstMiniObject* MiniObject::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  GstMiniObject *const gobject = reinterpret_cast<GstMiniObject*>(const_cast<MiniObject*>(this));
  gst_mini_object_ref(gobject);
  return gobject;
}


 guint MiniObject::get_flags() const
{
  return gobj()->flags;
}
 
 void MiniObject::set_flags(const guint& value)
{
  gobj()->flags = value;
}
 
bool MiniObject::lock(LockFlags flags)
{
  return gst_mini_object_lock(gobj(), ((GstLockFlags)(flags)));
}

void MiniObject::unlock(LockFlags flags)
{
  gst_mini_object_unlock(gobj(), ((GstLockFlags)(flags)));
}

bool MiniObject::is_writable() const
{
  return gst_mini_object_is_writable(const_cast<GstMiniObject*>(gobj()));
}

Glib::RefPtr<MiniObject> MiniObject::create_writable()
{
  return Glib::wrap(gst_mini_object_make_writable(gobj()));
}


} // namespace Gst


