/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef CCD_COLOR_H
#define CCD_COLOR_H

#include <stdbool.h>
#include <glib.h>
#include <libcroco/libcroco.h>
#include <ccd/ccd-features.h>
#include <ccd/ccd-property.h>

G_BEGIN_DECLS

#define CCD_COLOR_ASSIGN(lhs_, rhs_) {		\
	(lhs_).red = (rhs_).red;		\
	(lhs_).green = (rhs_).green;		\
	(lhs_).blue = (rhs_).blue;		\
}

typedef struct {
	double red;
	double green;
	double blue;
} ccd_color_t;

ccd_property_spec_t ccd_color_parse (ccd_color_t *self, CRTerm const **value);

void ccd_color_dump (ccd_color_t const *self);

G_END_DECLS

#endif /* CCD_COLOR_H */

