/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include "ccd-gtk-style.h"

/**
 * ccd_style_draw_gap:
 * @self:	a ccd_style_t.
 * @cr:		the target to draw onto.
 * @x:		the starting x coordinate.
 * @y:		the starting y coordinate.
 * @width:	width of the outline to draw.
 * @height:	height of the outline to draw.
 * @gap_side:	side in which to leave the gap.
 * @gap_start:	starting position of the gap.
 * @gap_width:	width of the gap.
 *
 * Draw a rectangle with gap using this style instance.
 **/
void
ccd_style_draw_gap (ccd_style_t	const	*self, 
		    cairo_t		*cr, 
		    int32_t		 x,
		    int32_t		 y,
		    int32_t		 width,
		    int32_t		 height, 
		    GtkPositionType	 gap_side,
		    int32_t		 gap_start,
		    int32_t		 gap_width)
{
	ccd_background_draw (self->bg_color, self->bg_image,
			     cr, x, y, width, height);

	switch (gap_side) {
	case GTK_POS_LEFT:
		if (gap_start > y || gap_width < height) {
			/* Draw gap only if it's not over the whole border. */
			ccd_border_draw (&self->left, NULL, NULL, NULL,
					 cr, x, y, 0, gap_start);
			ccd_border_draw (&self->left, NULL, NULL, NULL,
					 cr, x, y + gap_start + gap_width, 
					 0, height - gap_start - gap_width);
		}
		ccd_border_draw (NULL, &self->top, &self->right, &self->bottom,
				 cr, x, y, width, height);
		break;
	case GTK_POS_TOP:
		if (gap_start > x || gap_width < width) {
			/* Draw gap only if it's not over the whole border. */
			ccd_border_draw (NULL, &self->top, NULL, NULL,
					 cr, x, y, gap_start, 0);
			ccd_border_draw (NULL, &self->top, NULL, NULL,
					 cr, x + gap_start + gap_width, y, 
					 width - gap_start - gap_width, 0);
		}
		ccd_border_draw (&self->left, NULL, &self->right, &self->bottom,
				 cr, x, y, width, height);
		break;
	case GTK_POS_RIGHT:
		if (gap_start > y || gap_width < height) {
			/* Draw gap only if it's not over the whole border. */
			ccd_border_draw (&self->left, NULL, NULL, NULL, cr, 
					 x + width, y, 0, gap_start);
			ccd_border_draw (&self->left, NULL, NULL, NULL, cr, 
					 x + width, y + gap_start + gap_width, 
					 0, height - gap_start - gap_width);
		}
		ccd_border_draw (&self->left, &self->top, NULL, &self->bottom,
				 cr, x, y, width, height);
		break;
	case GTK_POS_BOTTOM:
		if (gap_start > x || gap_width < width) {
			/* Draw gap only if it's not over the whole border. */
			ccd_border_draw (NULL, NULL, NULL, &self->bottom,
					 cr, x, y + height, gap_start, 0);
			ccd_border_draw (NULL, NULL, NULL, &self->bottom,
					 cr, x + gap_start + gap_width, y + height,
					 width - gap_start - gap_width, 0);
		}
		ccd_border_draw (&self->left, &self->top, &self->right, NULL,
				 cr, x, y, width, height);
		break;
	default:
		g_assert_not_reached ();
		return;	/* prevent error building without assertions */
	}
}

/**
 * ccd_style_draw_polygon:
 * @self:	a ccd_style_t.
 * @cr:		the target to draw onto.
 * @points:	an array of #GdkPoint<!-- -->s.
 * @n_points:	length of @points.
 * @fill:	%true if the polygon should be filled.
 *
 * Draw a rectangle with gap using this style instance.
 **/
void
ccd_style_draw_polygon (ccd_style_t const	*self, 
			cairo_t			*cr, 
			GdkPoint		*points,
			int32_t			 n_points,
			bool		 fill)
{

}

