/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef CCD_STYLESHEET_H
#define CCD_STYLESHEET_H

#include <stdbool.h>
#include <glib.h>
#include <ccd/ccd-features.h>
#include <ccd/ccd-selector-group.h>
#include <ccd/ccd-style.h>

G_BEGIN_DECLS

typedef struct ccd_stylesheet_ ccd_stylesheet_t;

ccd_stylesheet_t *	ccd_stylesheet_new_from_buffer	(char const *buffer,
							 size_t size);
ccd_stylesheet_t *	ccd_stylesheet_new_from_file	(char const *css_file);
void			ccd_stylesheet_free		(ccd_stylesheet_t *self);

ccd_selector_group_t const * ccd_stylesheet_query_type (ccd_stylesheet_t const *self,
							char const *type_name);

bool ccd_stylesheet_query_collect (ccd_stylesheet_t const *self, ccd_node_t const *node, 
				   ccd_selector_group_t *result_group, bool as_base);

bool ccd_stylesheet_query_apply (ccd_stylesheet_t const *self, ccd_node_t const *node, 
				 ccd_style_t *style);

void ccd_stylesheet_dump (ccd_stylesheet_t const *self);

G_END_DECLS

#endif /* CCD_STYLESHEET_H */

