
#include <atkmm/object.h>
#include <atkmm/private/object_p.h>

#include <atk/atk-enum-types.h>
// -*- c++ -*-
/* $Id: object.ccg,v 1.3 2002/02/24 21:13:59 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <atkmm/relationset.h>
#include <atkmm/stateset.h>

namespace
{


void Object_signal_children_changed_callback(AtkObject*, guint p0,gpointer p1,void* data)
{
  using namespace Atk;
  typedef SigC::Slot2<void,guint,gpointer> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0,p1, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Object_signal_children_changed_info =
{
  "children_changed",
  (GCallback) &Object_signal_children_changed_callback,
  (GCallback) &Object_signal_children_changed_callback
};


void Object_signal_focus_event_callback(AtkObject*, gboolean p0,void* data)
{
  using namespace Atk;
  typedef SigC::Slot1<void,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Object_signal_focus_event_info =
{
  "focus_event",
  (GCallback) &Object_signal_focus_event_callback,
  (GCallback) &Object_signal_focus_event_callback
};


void Object_signal_property_change_callback(AtkObject*, AtkPropertyValues* p0,void* data)
{
  using namespace Atk;
  typedef SigC::Slot1<void,AtkPropertyValues*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Object_signal_property_change_info =
{
  "property_change",
  (GCallback) &Object_signal_property_change_callback,
  (GCallback) &Object_signal_property_change_callback
};


void Object_signal_state_change_callback(AtkObject*, const gchar* p0,gboolean p1,void* data)
{
  using namespace Atk;
  typedef SigC::Slot2<void,const Glib::ustring&,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::convert_const_gchar_ptr_to_ustring(p0)
,p1
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Object_signal_state_change_info =
{
  "state_change",
  (GCallback) &Object_signal_state_change_callback,
  (GCallback) &Object_signal_state_change_callback
};


const Glib::SignalProxyInfo Object_signal_visible_data_changed_info =
{
  "visible_data_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace

// static
GType Glib::Value<Atk::Role>::value_type()
{
  return atk_role_get_type();
}

// static
GType Glib::Value<Atk::Layer>::value_type()
{
  return atk_layer_get_type();
}


namespace Glib
{

Glib::RefPtr<Atk::Object> wrap(AtkObject* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Atk::Object>( dynamic_cast<Atk::Object*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Atk
{


/* The *_Class implementation: */

GType Object_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(atk_object_get_type(), "atkmm__Object", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Object_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->children_changed = &children_changed_callback;
  klass->focus_event = &focus_event_callback;
  klass->property_change = &property_change_callback;
  klass->state_change = &state_change_callback;
  klass->visible_data_changed = &visible_data_changed_callback;
}


void Object_Class::children_changed_callback(AtkObject* self, guint p0, gpointer p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_children_changed(p0, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->children_changed)
      (*base->children_changed)(self, p0, p1);
  }
}

void Object_Class::focus_event_callback(AtkObject* self, gboolean p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_focus_event(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->focus_event)
      (*base->focus_event)(self, p0);
  }
}

void Object_Class::property_change_callback(AtkObject* self, AtkPropertyValues* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_property_change(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->property_change)
      (*base->property_change)(self, p0);
  }
}

void Object_Class::state_change_callback(AtkObject* self, const gchar* p0, gboolean p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_state_change(Glib::convert_const_gchar_ptr_to_ustring(p0)
, p1
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->state_change)
      (*base->state_change)(self, p0, p1);
  }
}

void Object_Class::visible_data_changed_callback(AtkObject* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_visible_data_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->visible_data_changed)
      (*base->visible_data_changed)(self);
  }
}


Glib::ObjectBase* Object_Class::wrap_new(GObject* o)
{
  return new Object((AtkObject*)(o));
}


/* The implementation: */

AtkObject* Object::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<Object> Object::wrap_specific_type(AtkObject* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<Object> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    Object* pCppObject = dynamic_cast<Object*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<Object>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<Object>( new Object(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

Object::Object(AtkObject* castitem)
: Glib::Object((GObject*)(castitem))
{}

Object::~Object()
{
}

Object::CppClassType Object::object_class_; //Initialize static member.

GType Object::get_type()
{
  return object_class_.get_type();
}

GType Object::get_base_type()
{
  return atk_object_get_type();
}

Glib::ustring Object::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(atk_object_get_name(const_cast<AtkObject*>(gobj())));
}

Glib::ustring Object::get_description() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(atk_object_get_description(const_cast<AtkObject*>(gobj())));
}

Glib::RefPtr<Object> Object::get_parent()
{
  return Glib::wrap(atk_object_get_parent(gobj()));
}

int Object::get_n_accessible_children() const
{
  return atk_object_get_n_accessible_children(const_cast<AtkObject*>(gobj()));
}

Glib::RefPtr<Object> Object::ref_accessible_child(int i)
{
  return Glib::wrap(atk_object_ref_accessible_child(gobj(), i));
}

Glib::RefPtr<RelationSet> Object::ref_relation_set()
{
  return Glib::wrap(atk_object_ref_relation_set(gobj()));
}

Role Object::get_role() const
{
  return ((Role)(atk_object_get_role(const_cast<AtkObject*>(gobj()))));
}

Layer Object::get_layer() const
{
  return ((Layer)(atk_object_get_layer(const_cast<AtkObject*>(gobj()))));
}

int Object::get_mdi_zorder() const
{
  return atk_object_get_mdi_zorder(const_cast<AtkObject*>(gobj()));
}

Glib::RefPtr<StateSet> Object::ref_state_set()
{
  return Glib::wrap(atk_object_ref_state_set(gobj()));
}

int Object::get_index_in_parent()
{
  return atk_object_get_index_in_parent(gobj());
}

void Object::set_name(const Glib::ustring& name)
{
  atk_object_set_name(gobj(), name.c_str());
}

void Object::set_description(const Glib::ustring& description)
{
  atk_object_set_description(gobj(), description.c_str());
}

void Object::set_parent(const Glib::RefPtr<Object>& parent)
{
  atk_object_set_parent(gobj(), (parent)->gobj());
}

void Object::set_role(Role role)
{
  atk_object_set_role(gobj(), ((AtkRole)(role)));
}

void Object::notify_state_change(AtkState state, bool value)
{
  atk_object_notify_state_change(gobj(), state, static_cast<int>(value));
}


Glib::SignalProxy2<void,guint,gpointer> Object::signal_children_changed()
{
  return Glib::SignalProxy2<void,guint,gpointer>(this, &Object_signal_children_changed_info);
}

Glib::SignalProxy1<void,bool> Object::signal_focus_event()
{
  return Glib::SignalProxy1<void,bool>(this, &Object_signal_focus_event_info);
}

Glib::SignalProxy1<void,AtkPropertyValues*> Object::signal_property_change()
{
  return Glib::SignalProxy1<void,AtkPropertyValues*>(this, &Object_signal_property_change_info);
}

Glib::SignalProxy2<void,const Glib::ustring&,bool> Object::signal_state_change()
{
  return Glib::SignalProxy2<void,const Glib::ustring&,bool>(this, &Object_signal_state_change_info);
}

Glib::SignalProxy0<void> Object::signal_visible_data_changed()
{
  return Glib::SignalProxy0<void>(this, &Object_signal_visible_data_changed_info);
}


Glib::PropertyProxy<Glib::ustring> Object::property_accessible_name()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "accessible_name");
}

Glib::PropertyProxy<Glib::ustring> Object::property_accessible_description()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "accessible_description");
}

Glib::PropertyProxy< Glib::RefPtr<Atk::Object> > Object::property_accessible_parent()
{
  return Glib::PropertyProxy< Glib::RefPtr<Atk::Object> >(this, "accessible_parent");
}

Glib::PropertyProxy<double> Object::property_accessible_value()
{
  return Glib::PropertyProxy<double>(this, "accessible_value");
}

Glib::PropertyProxy<int> Object::property_accessible_role()
{
  return Glib::PropertyProxy<int>(this, "accessible_role");
}

Glib::PropertyProxy_ReadOnly<int> Object::property_accessible_component_layer()
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "accessible_component_layer");
}

Glib::PropertyProxy_ReadOnly<int> Object::property_accessible_component_mdi_zorder()
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "accessible_component_mdi_zorder");
}

Glib::PropertyProxy<Glib::ustring> Object::property_accessible_table_caption()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "accessible_table_caption");
}

Glib::PropertyProxy<Glib::ustring> Object::property_accessible_table_column_description()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "accessible_table_column_description");
}

Glib::PropertyProxy< Glib::RefPtr<Atk::Object> > Object::property_accessible_table_column_header()
{
  return Glib::PropertyProxy< Glib::RefPtr<Atk::Object> >(this, "accessible_table_column_header");
}

Glib::PropertyProxy<Glib::ustring> Object::property_accessible_table_row_description()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "accessible_table_row_description");
}

Glib::PropertyProxy< Glib::RefPtr<Atk::Object> > Object::property_accessible_table_row_header()
{
  return Glib::PropertyProxy< Glib::RefPtr<Atk::Object> >(this, "accessible_table_row_header");
}

Glib::PropertyProxy< Glib::RefPtr<Atk::Object> > Object::property_accessible_table_summary()
{
  return Glib::PropertyProxy< Glib::RefPtr<Atk::Object> >(this, "accessible_table_summary");
}


void Atk::Object::on_children_changed(guint change_index, gpointer changed_child)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->children_changed)
    (*base->children_changed)(gobj(),change_index,changed_child);
}

void Atk::Object::on_focus_event(bool focus_in)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->focus_event)
    (*base->focus_event)(gobj(),static_cast<int>(focus_in));
}

void Atk::Object::on_property_change(AtkPropertyValues* values)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->property_change)
    (*base->property_change)(gobj(),values);
}

void Atk::Object::on_state_change(const Glib::ustring& name, bool state_set)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->state_change)
    (*base->state_change)(gobj(),name.c_str(),static_cast<int>(state_set));
}

void Atk::Object::on_visible_data_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->visible_data_changed)
    (*base->visible_data_changed)(gobj());
}


} // namespace Atk

