
extern "C"
{
#include <glib-object.h>
#include <gdk/gdkenumtypes.h>
}

#include <gdkmm/pixbufloader.h>
#include <gdkmm/private/pixbufloader_p.h>

// -*- c++ -*-
/* $Id: pixbufloader.ccg,v 1.2 2001/12/19 07:31:16 kenelson Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdkcolor.h>

namespace Gdk
{

PixbufLoader::PixbufLoader(const Glib::ustring& image_type)
: Glib::Object( (GObject*)gdk_pixbuf_loader_new_with_type(image_type.c_str(), 0) )
  {}

PixbufLoader::PixbufLoader(const Glib::ustring& image_type, GError*& error)
: Glib::Object( (GObject*)gdk_pixbuf_loader_new_with_type(image_type.c_str(), &error) )
  {}

bool PixbufLoader::close()
{
  return (bool)gdk_pixbuf_loader_close(gobj(), 0);
}

} /* namespace Gdk */


namespace
{

const Glib::SignalProxyInfo PixbufLoader_signal_area_prepared_info =
{
  "area_prepared",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


void PixbufLoader_signal_area_updated_callback(GdkPixbufLoader*, gint p0,gint p1,gint p2,gint p3,void* data)
{
  using namespace Gdk;
  typedef SigC::Slot4<void,int,int,int,int> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
,p1
,p2
,p3
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo PixbufLoader_signal_area_updated_info =
{
  "area_updated",
  (GCallback) &PixbufLoader_signal_area_updated_callback,
  (GCallback) &PixbufLoader_signal_area_updated_callback
};


const Glib::SignalProxyInfo PixbufLoader_signal_closed_info =
{
  "closed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gdk::PixbufLoader> wrap(GdkPixbufLoader* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gdk::PixbufLoader>( dynamic_cast<Gdk::PixbufLoader*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

GType PixbufLoader_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gdk_pixbuf_loader_get_type(), "gdkmm__PixbufLoader", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void PixbufLoader_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->area_prepared = &area_prepared_callback;
  klass->area_updated = &area_updated_callback;
  klass->closed = &closed_callback;
}


void PixbufLoader_Class::area_prepared_callback(GdkPixbufLoader* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_area_prepared();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->area_prepared)
      (*base->area_prepared)(self);
  }
}

void PixbufLoader_Class::area_updated_callback(GdkPixbufLoader* self, gint p0, gint p1, gint p2, gint p3)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_area_updated(p0
, p1
, p2
, p3
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->area_updated)
      (*base->area_updated)(self, p0, p1, p2, p3);
  }
}

void PixbufLoader_Class::closed_callback(GdkPixbufLoader* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_closed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->closed)
      (*base->closed)(self);
  }
}


Glib::ObjectBase* PixbufLoader_Class::wrap_new(GObject* o)
{
  return new PixbufLoader((GdkPixbufLoader*)(o));
}


/* The implementation: */

GdkPixbufLoader* PixbufLoader::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<PixbufLoader> PixbufLoader::wrap_specific_type(GdkPixbufLoader* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<PixbufLoader> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    PixbufLoader* pCppObject = dynamic_cast<PixbufLoader*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<PixbufLoader>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<PixbufLoader>( new PixbufLoader(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

PixbufLoader::PixbufLoader(GdkPixbufLoader* castitem)
: Glib::Object((GObject*)(castitem))
{}

PixbufLoader::~PixbufLoader()
{
}

PixbufLoader::CppClassType PixbufLoader::pixbufloader_class_; //Initialize static member.

GType PixbufLoader::get_type()
{
  return pixbufloader_class_.get_type();
}

GType PixbufLoader::get_base_type()
{
  return gdk_pixbuf_loader_get_type();
}

PixbufLoader::PixbufLoader()
: Glib::Object((GObject*)(g_object_new(get_type(), (char*)0)))
{}

Glib::RefPtr<PixbufLoader> PixbufLoader::create()
{
  return Glib::RefPtr<PixbufLoader>( new PixbufLoader() );
}
Glib::RefPtr<PixbufLoader> PixbufLoader::create(const Glib::ustring& image_type)
{
  return Glib::RefPtr<PixbufLoader>( new PixbufLoader(image_type) );
}
Glib::RefPtr<PixbufLoader> PixbufLoader::create(const Glib::ustring& image_type, GError*& error)
{
  return Glib::RefPtr<PixbufLoader>( new PixbufLoader(image_type, error) );
}
bool PixbufLoader::write(const guchar* buf, gsize count, GError*& error)
{
  return gdk_pixbuf_loader_write(gobj(), buf, count, &(error));
}

Glib::RefPtr<Gdk::Pixbuf> PixbufLoader::get_pixbuf()
{
  return Glib::wrap(gdk_pixbuf_loader_get_pixbuf(gobj()));
}

Glib::RefPtr<Gdk::PixbufAnimation> PixbufLoader::get_animation()
{
  return Glib::wrap(gdk_pixbuf_loader_get_animation(gobj()));
}

bool PixbufLoader::close(GError*& error)
{
  return gdk_pixbuf_loader_close(gobj(), &(error));
}


Glib::SignalProxy0<void> PixbufLoader::signal_area_prepared()
{
  return Glib::SignalProxy0<void>(this, &PixbufLoader_signal_area_prepared_info);
}

Glib::SignalProxy4<void,int,int,int,int> PixbufLoader::signal_area_updated()
{
  return Glib::SignalProxy4<void,int,int,int,int>(this, &PixbufLoader_signal_area_updated_info);
}

Glib::SignalProxy0<void> PixbufLoader::signal_closed()
{
  return Glib::SignalProxy0<void>(this, &PixbufLoader_signal_closed_info);
}


void Gdk::PixbufLoader::on_area_prepared()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->area_prepared)
    (*base->area_prepared)(gobj());
}

void Gdk::PixbufLoader::on_area_updated(int x, int y, int width, int height)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->area_updated)
    (*base->area_updated)(gobj(),x,y,width,height);
}

void Gdk::PixbufLoader::on_closed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->closed)
    (*base->closed)(gobj());
}


} // namespace Gdk

