// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_COMBO_H
#define _GTKMM_COMBO_H

#include <glibmm.h>

/* $Id: combo.hg,v 1.23 2002/04/01 16:19:33 murrayc Exp $ */

/* combo.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/listhandle.h>
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/entry.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkCombo GtkCombo;
typedef struct _GtkComboClass GtkComboClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{ class Combo_Class; } // namespace Gtk
namespace Gtk
{

class Item;
class ScrolledWindow;
class Window;

/** Combo widget
 * A combo is a compound widget which crosses a text entry area and a pull
 * down list.  It may allow text entry or it may just allow list
 * values depending on the settings.
 *
 * Access members allow altering of the widget components.
 *
 * @ingroup Widgets
 */

class Combo : public HBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Combo CppObjectType;
  typedef Combo_Class CppClassType;
  typedef GtkCombo BaseObjectType;
  typedef GtkComboClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Combo();

private:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class CppClassType;
  static CppClassType combo_class_;

  Combo(const Combo&);
  Combo& operator=(const Combo&); // not implemented

protected:
  explicit Combo(GtkCombo* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkCombo* gobj()             { return (GtkCombo*)(gobject_); }
  const GtkCombo* gobj() const { return (GtkCombo*)(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:

  Combo();
  

  /** Allow direct text entry
   * Whether the text in the entry must be or not be in the list.
   *
   * {\param value} - Set to true if the value must be in list.
   *
   * {\param empty} - Set to true if the text area is allowed to be empty.
   */
  
  void set_value_in_list(bool value = true, bool empty = false);

  /** Set arrows keys to change value
   * Up and down will scroll through the list items.
   * Useful when there is a small list of value that the
   * list must have.
   *
   * {\parm arrows_on} - true indicates the arrow keys scroll.
   */
  
  void set_use_arrows(bool arrows_on = true);

  /** Set arrows keys to change if value not in list
   * Up and down will scroll through the list items but only
   * change the current value if the text does not match a list item..
   * Useful when there is a small list of value that the
   * list must have.
   *
   * {\parm arrows_always} - true indicates the value will change.
   */
  
  void set_use_arrows_always(bool arrows_always = true);

  /** Sets list case sensitive
   * Determines if the list items and text comparisons for
   * {set_use_arrows_always()} should be case sensitive.
   */
  
  void set_case_sensitive(bool val = true);

  /** Set the current entry Glib::ustring
   * Call this function on an item if it isn't a label or you
   * want it to have a different value to be displayed in the entry
   */
  //_WRAP_METHOD(void set_item_string(Gtk::Item& item, const Glib::ustring& item_value), gtk_combo_set_item_string)
  //void remove_item_string(Gtk::Item& item);

  /// Insert a list of items.
  
  void set_popdown_strings(const Glib::ListHandle<Glib::ustring>& strings);

  Glib::ListHandle<Glib::ustring> get_popdown_strings() const;

  
  void disable_activate();

  Entry* get_entry();
  const Entry* get_entry() const;
  //_MEMBER_GET_PTR(list,list,List*,GtkWidget*)

  Glib::PropertyProxy<bool> property_enable_arrow_keys();

  Glib::PropertyProxy<bool> property_enable_arrows_always();

  Glib::PropertyProxy<bool> property_case_sensitive();

  Glib::PropertyProxy<bool> property_allow_empty();

  Glib::PropertyProxy<bool> property_value_in_list();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Combo */
  Gtk::Combo* wrap(GtkCombo* object, bool take_copy = false);
}
#endif /* _GTKMM_COMBO_H */

