
#include <gtkmm/drawingarea.h>
#include <gtkmm/private/drawingarea_p.h>

// -*- c++ -*-
/* $Id: drawingarea.ccg,v 1.3 2001/10/25 11:17:19 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkdrawingarea.h>


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::DrawingArea* wrap(GtkDrawingArea* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::DrawingArea *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType DrawingArea_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_drawing_area_get_type(), "gtkmm__DrawingArea", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void DrawingArea_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* DrawingArea_Class::wrap_new(GObject* o)
{
  return manage(new DrawingArea((GtkDrawingArea*)(o)));
}


/* The implementation: */

DrawingArea::DrawingArea(GtkDrawingArea* castitem)
: Gtk::Widget((GtkWidget*)(castitem))
{}

DrawingArea::~DrawingArea()
{
  destroy_();
}

DrawingArea::CppClassType DrawingArea::drawingarea_class_; //Initialize static member.

GType DrawingArea::get_type()
{
  return drawingarea_class_.get_type();
}

GType DrawingArea::get_base_type()
{
  return gtk_drawing_area_get_type();
}

DrawingArea::DrawingArea()
: Gtk::Widget((GtkWidget*)(g_object_new(get_type(), (char*)0)))
{}


} // namespace Gtk

