// -*- c++ -*-
#ifndef _GTKMM_STOCK_H
#define _GTKMM_STOCK_H

/* $Id: stock.h,v 1.7 2002/04/02 13:24:46 daniel Exp $ */

/* stock.h
 *
 * Copyright (C) 2001 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/stockitem.h>
#include <glibmm/ustring.h>
#include <glibmm/slisthandle.h>

namespace Gtk
{

namespace Stock
{

struct BuiltinStockID
{
  const char* id;
  operator Glib::ustring() const { return id; }
};

extern const BuiltinStockID DIALOG_INFO;
extern const BuiltinStockID DIALOG_WARNING;
extern const BuiltinStockID DIALOG_ERROR;
extern const BuiltinStockID DIALOG_QUESTION;

// These aren't real stock items, because they provide only an icon.
extern const BuiltinStockID DND;
extern const BuiltinStockID DND_MULTIPLE;

extern const BuiltinStockID ADD;
extern const BuiltinStockID APPLY;
extern const BuiltinStockID BOLD;
extern const BuiltinStockID CANCEL;
extern const BuiltinStockID CDROM;
extern const BuiltinStockID CLEAR;
extern const BuiltinStockID CLOSE;
extern const BuiltinStockID CONVERT;
extern const BuiltinStockID COPY;
extern const BuiltinStockID CUT;
extern const BuiltinStockID DELETE;
extern const BuiltinStockID EXECUTE;
extern const BuiltinStockID FIND;
extern const BuiltinStockID FIND_AND_REPLACE;
extern const BuiltinStockID FLOPPY;
extern const BuiltinStockID GOTO_BOTTOM;
extern const BuiltinStockID GOTO_FIRST;
extern const BuiltinStockID GOTO_LAST;
extern const BuiltinStockID GOTO_TOP;
extern const BuiltinStockID GO_BACK;
extern const BuiltinStockID GO_DOWN;
extern const BuiltinStockID GO_FORWARD;
extern const BuiltinStockID GO_UP;
extern const BuiltinStockID HELP;
extern const BuiltinStockID HOME;
extern const BuiltinStockID INDEX;
extern const BuiltinStockID ITALIC;
extern const BuiltinStockID JUMP_TO;
extern const BuiltinStockID JUSTIFY_CENTER;
extern const BuiltinStockID JUSTIFY_FILL;
extern const BuiltinStockID JUSTIFY_LEFT;
extern const BuiltinStockID JUSTIFY_RIGHT;
extern const BuiltinStockID MISSING_IMAGE;
extern const BuiltinStockID NEW;
extern const BuiltinStockID NO;
extern const BuiltinStockID OK;
extern const BuiltinStockID OPEN;
extern const BuiltinStockID PASTE;
extern const BuiltinStockID PREFERENCES;
extern const BuiltinStockID PRINT;
extern const BuiltinStockID PRINT_PREVIEW;
extern const BuiltinStockID PROPERTIES;
extern const BuiltinStockID QUIT;
extern const BuiltinStockID REDO;
extern const BuiltinStockID REFRESH;
extern const BuiltinStockID REMOVE;
extern const BuiltinStockID REVERT_TO_SAVED;
extern const BuiltinStockID SAVE;
extern const BuiltinStockID SAVE_AS;
extern const BuiltinStockID SELECT_COLOR;
extern const BuiltinStockID SELECT_FONT;
extern const BuiltinStockID SORT_ASCENDING;
extern const BuiltinStockID SORT_DESCENDING;
extern const BuiltinStockID SPELL_CHECK;
extern const BuiltinStockID STOP;
extern const BuiltinStockID STRIKETHROUGH;
extern const BuiltinStockID UNDELETE;
extern const BuiltinStockID UNDERLINE;
extern const BuiltinStockID UNDO;
extern const BuiltinStockID YES;
extern const BuiltinStockID ZOOM_100;
extern const BuiltinStockID ZOOM_FIT;
extern const BuiltinStockID ZOOM_IN;
extern const BuiltinStockID ZOOM_OUT;


//TODO: void gtk_stock_add(const GtkStockItem  *items, guint n_items);
//TODO: void gtk_stock_add_static(const GtkStockItem  *items, guint n_items);

bool lookup(const Glib::ustring& stock_id, StockItem& item);

Glib::SListHandle<Glib::ustring> get_list_ids();

} // namespace Stock

} // namespace Gtk


#endif /* _GTKMM_STOCK_H */

