
#include <gtkmm/treeselection.h>
#include <gtkmm/private/treeselection_p.h>

// -*- c++ -*-
/* $Id: treeselection.ccg,v 1.13 2002/04/02 13:25:19 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/treeview.h>

namespace Gtk
{

//This Signal Proxy allows the C++ coder to specify a SigC::Slot instead of a static function.
class SignalProxy_Select
{
public:
  typedef TreeSelection::SlotSelect SlotType;

  SignalProxy_Select(const SlotType& slot);
  ~SignalProxy_Select();

  static gboolean gtk_callback(GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer data);
  static void gtk_callback_destroy(gpointer data);

protected:
  SlotType slot_;
};

SignalProxy_Select::SignalProxy_Select(const SlotType& slot)
{
  slot_ = slot;
}

SignalProxy_Select::~SignalProxy_Select()
{
}

gboolean SignalProxy_Select::gtk_callback(GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer data)
{
  SignalProxy_Select* pSignalProxy = static_cast<SignalProxy_Select*>(data);
  if(pSignalProxy)
  {
    //Use Slot::operator():
    Glib::RefPtr<TreeModel> refTreeModel = Glib::wrap(model, true); //true = copy
    TreePath cppTreePath = Glib::wrap(path, true); //true = copy
    return (pSignalProxy->slot_)(refTreeModel, cppTreePath, path_currently_selected);
  }
  return 0;
}

void SignalProxy_Select::gtk_callback_destroy(gpointer data)
{
  SignalProxy_Select* pSignalProxy = static_cast<SignalProxy_Select*>(data);
  if(pSignalProxy)
    delete pSignalProxy;
}


/*
//This Signal Proxy allows the C++ coder to specify a SigC::Slot instead of a static function.
class SignalProxy_ForEach
{
public:
  typedef TreeSelection::SlotForEach SlotType;

  SignalProxy_ForEach(const SlotType& slot);
  ~SignalProxy_ForEach();

  static void gtk_callback(GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer data);

protected:
  SlotType slot_;
};

SignalProxy_ForEach::SignalProxy_ForEach(const SlotType& slot)
{
  slot_ = slot;
}

SignalProxy_ForEach::~SignalProxy_ForEach()
{
}

void SignalProxy_ForEach::gtk_callback(GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer data)
{
  SignalProxy_ForEach* pSignalProxy = static_cast<SignalProxy_ForEach*>(data);
  if(pSignalProxy)
  {
    //Use Slot::operator():
    (pSignalProxy->slot_)(Glib::wrap(model), Glib::wrap(path), Glib::wrap(iter));
  }
}
*/

void TreeSelection::set_select_function(SlotSelect& slot)
{
  //Create a signal proxy. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when SignalProxy_Select::gtk_callback_destroy() is called.
  SignalProxy_Select* pSignalProxy = new SignalProxy_Select(slot);

  gtk_tree_selection_set_select_function(gobj(),
    &SignalProxy_Select::gtk_callback, (gpointer)pSignalProxy,
    &SignalProxy_Select::gtk_callback_destroy);
}


TreeIter TreeSelection::get_selected() const
{
  TreeIter iter;
  GtkTreeModel* model_gobject = 0;

  gtk_tree_selection_get_selected(
      const_cast<GtkTreeSelection*>(gobj()),
      &model_gobject, iter.gobj());

  iter.set_model_gobject(model_gobject);
  return iter;
}

TreeIter TreeSelection::get_selected(Glib::RefPtr<TreeModel>& model) const
{
  TreeIter iter;
  GtkTreeModel* model_gobject = 0;

  gtk_tree_selection_get_selected(
      const_cast<GtkTreeSelection*>(gobj()),
      &model_gobject, iter.gobj());

  model = Glib::wrap(model_gobject, true);

  iter.set_model_gobject(model_gobject);
  return iter;
}

/*
void TreeSelection::for_each(const SlotForEach& slot)
{
  SignalProxy_ForEach proxy(slot);
  gtk_tree_selection_foreach(gobj(), &SignalProxy_ForEach::gtk_callback, (gpointer)(&proxy));
}
*/

} // namespace Gtk


namespace
{

const Glib::SignalProxyInfo TreeSelection_signal_changed_info =
{
  "changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::TreeSelection> wrap(GtkTreeSelection* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::TreeSelection>( dynamic_cast<Gtk::TreeSelection*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType TreeSelection_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_tree_selection_get_type(), "gtkmm__TreeSelection", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void TreeSelection_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->changed = &changed_callback;
}


void TreeSelection_Class::changed_callback(GtkTreeSelection* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->changed)
      (*base->changed)(self);
  }
}


Glib::ObjectBase* TreeSelection_Class::wrap_new(GObject* o)
{
  return new TreeSelection((GtkTreeSelection*)(o));
}


/* The implementation: */

GtkTreeSelection* TreeSelection::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<TreeSelection> TreeSelection::wrap_specific_type(GtkTreeSelection* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<TreeSelection> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    TreeSelection* pCppObject = dynamic_cast<TreeSelection*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<TreeSelection>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<TreeSelection>( new TreeSelection(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

TreeSelection::TreeSelection(GtkTreeSelection* castitem)
: Glib::Object((GObject*)(castitem))
{}

TreeSelection::~TreeSelection()
{
}

TreeSelection::CppClassType TreeSelection::treeselection_class_; //Initialize static member.

GType TreeSelection::get_type()
{
  return treeselection_class_.get_type();
}

GType TreeSelection::get_base_type()
{
  return gtk_tree_selection_get_type();
}

void TreeSelection::set_mode(SelectionMode type)
{
  gtk_tree_selection_set_mode(gobj(), ((GtkSelectionMode)(type)));
}

SelectionMode TreeSelection::get_mode()
{
  return ((SelectionMode)(gtk_tree_selection_get_mode(gobj())));
}

gpointer TreeSelection::get_user_data()
{
  return gtk_tree_selection_get_user_data(gobj());
}

TreeView* TreeSelection::get_tree_view()
{
  return Glib::wrap(gtk_tree_selection_get_tree_view(gobj()));
}

void TreeSelection::select(const TreePath& path)
{
  gtk_tree_selection_select_path(gobj(), const_cast<GtkTreePath*>((path).gobj()));
}

void TreeSelection::select(const TreeIter& iter)
{
  gtk_tree_selection_select_iter(gobj(), const_cast<GtkTreeIter*>((iter).gobj()));
}

void TreeSelection::select(const TreePath& start_path, const TreePath& end_path)
{
  gtk_tree_selection_select_range(gobj(), const_cast<GtkTreePath*>((start_path).gobj()), const_cast<GtkTreePath*>((end_path).gobj()));
}

void TreeSelection::unselect(const TreePath& path)
{
  gtk_tree_selection_unselect_path(gobj(), const_cast<GtkTreePath*>((path).gobj()));
}

void TreeSelection::unselect(const TreeIter& iter)
{
  gtk_tree_selection_unselect_iter(gobj(), const_cast<GtkTreeIter*>((iter).gobj()));
}

bool TreeSelection::is_selected(const TreePath& path)
{
  return gtk_tree_selection_path_is_selected(gobj(), const_cast<GtkTreePath*>((path).gobj()));
}

bool TreeSelection::is_selected(const TreeIter& iter)
{
  return gtk_tree_selection_iter_is_selected(gobj(), const_cast<GtkTreeIter*>((iter).gobj()));
}

void TreeSelection::select_all()
{
  gtk_tree_selection_select_all(gobj());
}

void TreeSelection::unselect_all()
{
  gtk_tree_selection_unselect_all(gobj());
}


Glib::SignalProxy0<void> TreeSelection::signal_changed()
{
  return Glib::SignalProxy0<void>(this, &TreeSelection_signal_changed_info);
}


void Gtk::TreeSelection::on_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->changed)
    (*base->changed)(gobj());
}


} // namespace Gtk

