
#include <gtkmm/window.h>
#include <gtkmm/private/window_p.h>

// -*- c++ -*-
/* $Id: window.ccg,v 1.26 2002/03/24 15:50:14 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/window.h>
#include <gtkmm/accelgroup.h>
#include <gdkmm/cursor.h>
#include <gtk/gtkwindow.h>


namespace Gtk
{

Glib::RefPtr<AccelGroup> Window::get_accel_group()
{
  //There doesn't seem to be any gtk_window_get_accel_group().
  //I think that you're supposed to remember what you added yourself.
  //And that's what we do here.

  if(!accel_group_)
  {
    accel_group_ = AccelGroup::create();
    add_accel_group(accel_group_);
  }

  return accel_group_;
}

bool Window::is_toplevel() const
{
  return gobj()->type == GTK_WINDOW_TOPLEVEL;
}

bool Window::is_popup() const
{
  return gobj()->type == GTK_WINDOW_POPUP;
}

void Window::raise()
{
  get_window()->raise();
}

} /* namespace Gtk */


namespace
{


void Window_signal_set_focus_callback(GtkWindow*, GtkWidget* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,Widget*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Window_signal_set_focus_info =
{
  "set_focus",
  (GCallback) &Window_signal_set_focus_callback,
  (GCallback) &Window_signal_set_focus_callback
};


gboolean Window_signal_frame_event_callback(GtkWindow*, GdkEvent* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<bool,GdkEvent*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (p0, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean Window_signal_frame_event_notify_callback(GtkWindow*, GdkEvent* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,GdkEvent*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo Window_signal_frame_event_info =
{
  "frame_event",
  (GCallback) &Window_signal_frame_event_callback,
  (GCallback) &Window_signal_frame_event_notify_callback
};


const Glib::SignalProxyInfo Window_signal_activate_focus_info =
{
  "activate_focus",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo Window_signal_activate_default_info =
{
  "activate_default",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


void Window_signal_move_focus_callback(GtkWindow*, GtkDirectionType p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,DirectionType> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (((DirectionType)(p0))
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Window_signal_move_focus_info =
{
  "move_focus",
  (GCallback) &Window_signal_move_focus_callback,
  (GCallback) &Window_signal_move_focus_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::Window* wrap(GtkWindow* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Window *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Window_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_window_get_type(), "gtkmm__Window", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Window_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->set_focus = &set_focus_callback;
  klass->frame_event = &frame_event_callback;
  klass->activate_focus = &activate_focus_callback;
  klass->activate_default = &activate_default_callback;
  klass->move_focus = &move_focus_callback;
}


void Window_Class::set_focus_callback(GtkWindow* self, GtkWidget* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_set_focus(Glib::wrap(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->set_focus)
      (*base->set_focus)(self, p0);
  }
}

gboolean Window_Class::frame_event_callback(GtkWindow* self, GdkEvent* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_frame_event(p0));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->frame_event)
      (*base->frame_event)(self, p0);
  }

  typedef gboolean RType;
  return RType();
}

void Window_Class::activate_focus_callback(GtkWindow* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_activate_focus();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->activate_focus)
      (*base->activate_focus)(self);
  }
}

void Window_Class::activate_default_callback(GtkWindow* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_activate_default();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->activate_default)
      (*base->activate_default)(self);
  }
}

void Window_Class::move_focus_callback(GtkWindow* self, GtkDirectionType p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_move_focus(((DirectionType)(p0))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->move_focus)
      (*base->move_focus)(self, p0);
  }
}


Glib::ObjectBase* Window_Class::wrap_new(GObject* o)
{
  return manage(new Window((GtkWindow*)(o)));
}


/* The implementation: */

Window::Window(GtkWindow* castitem)
: Gtk::Bin((GtkBin*)(castitem))
{}

Window::~Window()
{
  destroy_();
}

Window::CppClassType Window::window_class_; //Initialize static member.

GType Window::get_type()
{
  return window_class_.get_type();
}

GType Window::get_base_type()
{
  return gtk_window_get_type();
}

Window::Window(WindowType type)
: Gtk::Bin((GtkBin*)( g_object_new(get_type(), "type", ((GtkWindowType)(type)), (char*)0) ))
{}

WindowType Window::get_window_type() const
{
  return static_cast<WindowType>(gobj()->type);
}

Glib::RefPtr<Gdk::Window> Window::get_frame()
{
  Glib::RefPtr<Gdk::Window> ref_ptr(Gdk::Window::wrap_specific_type(gobj()->frame));

  if(!ref_ptr.is_null())
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gdk::Window> Window::get_frame() const
{
  Glib::RefPtr<const Gdk::Window> ref_ptr(Gdk::Window::wrap_specific_type(gobj()->frame));

  if(!ref_ptr.is_null())
    ref_ptr->reference();

  return ref_ptr;
}

void Window::set_title(const Glib::ustring& title)
{
  gtk_window_set_title(gobj(), title.c_str());
}

Glib::ustring Window::get_title() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_window_get_title(const_cast<GtkWindow*>(gobj())));
}

void Window::set_wmclass(const Glib::ustring& wmclass_name, const Glib::ustring& wmclass_class)
{
  gtk_window_set_wmclass(gobj(), wmclass_name.c_str(), wmclass_class.c_str());
}

void Window::set_role(const Glib::ustring& role)
{
  gtk_window_set_role(gobj(), role.c_str());
}

Glib::ustring Window::get_role() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_window_get_role(const_cast<GtkWindow*>(gobj())));
}

void Window::add_accel_group(const Glib::RefPtr<AccelGroup>& accel_group)
{
  gtk_window_add_accel_group(gobj(), Glib::unwrap(accel_group));
}

void Window::remove_accel_group(const Glib::RefPtr<AccelGroup>& accel_group)
{
  gtk_window_remove_accel_group(gobj(), Glib::unwrap(accel_group));
}

void Window::set_position(WindowPosition position)
{
  gtk_window_set_position(gobj(), ((GtkWindowPosition)(position)));
}

bool Window::activate_focus()
{
  return gtk_window_activate_focus(gobj());
}

void Window::set_focus(Gtk::Widget& focus)
{
  gtk_window_set_focus(gobj(), (focus).gobj());
}

Widget* Window::get_focus()
{
  return Glib::wrap(gtk_window_get_focus(gobj()));
}

void Window::set_default(Gtk::Widget& defaultw)
{
  gtk_window_set_default(gobj(), (defaultw).gobj());
}

bool Window::activate_default()
{
  return gtk_window_activate_default(gobj());
}

void Window::set_transient_for(Window& parent)
{
  gtk_window_set_transient_for(gobj(), (parent).gobj());
}

Window* Window::get_transient_for()
{
  return Glib::wrap(gtk_window_get_transient_for(gobj()));
}

void Window::set_type_hint(Gdk::WindowTypeHint hint)
{
  gtk_window_set_type_hint(gobj(), ((GdkWindowTypeHint)(hint)));
}

Gdk::WindowTypeHint Window::get_type_hint() const
{
  return ((Gdk::WindowTypeHint)(gtk_window_get_type_hint(const_cast<GtkWindow*>(gobj()))));
}

bool Window::get_destroy_with_parent() const
{
  return gtk_window_get_destroy_with_parent(const_cast<GtkWindow*>(gobj()));
}

void Window::set_resizable(bool resizeable)
{
  gtk_window_set_resizable(gobj(), static_cast<int>(resizeable));
}

bool Window::get_resizable() const
{
  return gtk_window_get_resizable(const_cast<GtkWindow*>(gobj()));
}

void Window::set_gravity(Gdk::Gravity gravity)
{
  gtk_window_set_gravity(gobj(), ((GdkGravity)(gravity)));
}

Gdk::Gravity Window::get_gravity() const
{
  return ((Gdk::Gravity)(gtk_window_get_gravity(const_cast<GtkWindow*>(gobj()))));
}

void Window::set_geometry_hints(Widget& geometry_widget, const Gdk::Geometry& geometry, Gdk::WindowHints geom_mask)
{
  gtk_window_set_geometry_hints(gobj(), (geometry_widget).Gtk::Widget::gobj(), const_cast<GdkGeometry*>(geometry.gobj()), ((GdkWindowHints)(geom_mask)));
}

void Window::set_has_frame(bool setting)
{
  gtk_window_set_has_frame(gobj(), static_cast<int>(setting));
}

bool Window::get_has_frame() const
{
  return gtk_window_get_has_frame(const_cast<GtkWindow*>(gobj()));
}

void Window::set_frame_dimensions(int left, int top, int right, int bottom)
{
  gtk_window_set_frame_dimensions(gobj(), left, top, right, bottom);
}

void Window::get_frame_dimensions(int& left, int& top, int& right, int& bottom) const
{
  gtk_window_get_frame_dimensions(const_cast<GtkWindow*>(gobj()), &left, &top, &right, &bottom);
}

void Window::set_decorated(bool setting)
{
  gtk_window_set_decorated(gobj(), static_cast<int>(setting));
}

bool Window::get_decorated() const
{
  return gtk_window_get_decorated(const_cast<GtkWindow*>(gobj()));
}

Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> > Window::get_icon_list() const
{
  return Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >(gtk_window_get_icon_list(const_cast<GtkWindow*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

void Window::set_icon_list(const Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >& list)
{
  gtk_window_set_icon_list(gobj(), list.data());
}

void Window::set_icon(const Glib::RefPtr<Gdk::Pixbuf>& icon)
{
  gtk_window_set_icon(gobj(), Glib::unwrap(icon));
}

Glib::RefPtr<Gdk::Pixbuf> Window::get_icon() const
{
  Glib::RefPtr<Gdk::Pixbuf> retvalue = Glib::wrap(gtk_window_get_icon(const_cast<GtkWindow*>(gobj())));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void Window::set_default_icon_list(const Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >& list)
{
  gtk_window_set_default_icon_list(list.data());
}

Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> > Window::get_default_icon_list()
{
  return Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >(gtk_window_get_default_icon_list(), Glib::OWNERSHIP_SHALLOW);
}

void Window::set_modal(bool modal)
{
  gtk_window_set_modal(gobj(), static_cast<int>(modal));
}

bool Window::get_modal() const
{
  return gtk_window_get_modal(const_cast<GtkWindow*>(gobj()));
}

Glib::ListHandle<Window*> Window::list_toplevels()
{
  return Glib::ListHandle<Window*>(gtk_window_list_toplevels(), Glib::OWNERSHIP_SHALLOW);
}

void Window::add_mnemonic(guint keyval, Widget& target)
{
  gtk_window_add_mnemonic(gobj(), keyval, (target).Gtk::Widget::gobj());
}

void Window::remove_mnemonic(guint keyval, Widget& target)
{
  gtk_window_remove_mnemonic(gobj(), keyval, (target).Gtk::Widget::gobj());
}

bool Window::mnemonic_activate(guint keyval, Gdk::ModifierType modifier)
{
  return gtk_window_mnemonic_activate(gobj(), keyval, ((GdkModifierType)(modifier)));
}

void Window::set_mnemonic_modifier(Gdk::ModifierType modifier)
{
  gtk_window_set_mnemonic_modifier(gobj(), ((GdkModifierType)(modifier)));
}

Gdk::ModifierType Window::get_mnemonic_modifier()
{
  return ((Gdk::ModifierType)(gtk_window_get_mnemonic_modifier(gobj())));
}

void Window::present()
{
  gtk_window_present(gobj());
}

void Window::iconify()
{
  gtk_window_iconify(gobj());
}

void Window::deiconify()
{
  gtk_window_deiconify(gobj());
}

void Window::stick()
{
  gtk_window_stick(gobj());
}

void Window::unstick()
{
  gtk_window_unstick(gobj());
}

void Window::maximize()
{
  gtk_window_maximize(gobj());
}

void Window::unmaximize()
{
  gtk_window_unmaximize(gobj());
}

void Window::begin_resize_drag(Gdk::WindowEdge edge, int button, int root_x, int root_y, guint32 timestamp)
{
  gtk_window_begin_resize_drag(gobj(), ((GdkWindowEdge)(edge)), button, root_x, root_y, timestamp);
}

void Window::begin_move_drag(int button, int root_x, int root_y, guint32 timestamp)
{
  gtk_window_begin_move_drag(gobj(), button, root_x, root_y, timestamp);
}

void Window::set_default_size(int width, int height)
{
  gtk_window_set_default_size(gobj(), width, height);
}

void Window::get_default_size(int& width, int& height) const
{
  gtk_window_get_default_size(const_cast<GtkWindow*>(gobj()), &width, &height);
}

void Window::resize(int width, int height)
{
  gtk_window_resize(gobj(), width, height);
}

void Window::get_size(int& width, int& height) const
{
  gtk_window_get_size(const_cast<GtkWindow*>(gobj()), &width, &height);
}

void Window::move(int x, int y)
{
  gtk_window_move(gobj(), x, y);
}

void Window::get_position(int& root_x, int& root_y) const
{
  gtk_window_get_position(const_cast<GtkWindow*>(gobj()), &root_x, &root_y);
}

bool Window::parse_geometry(const Glib::ustring& geometry)
{
  return gtk_window_parse_geometry(gobj(), geometry.c_str());
}

void Window::reshow_with_initial_size()
{
  gtk_window_reshow_with_initial_size(gobj());
}


Glib::SignalProxy1<void,Widget*> Window::signal_set_focus()
{
  return Glib::SignalProxy1<void,Widget*>(this, &Window_signal_set_focus_info);
}

Glib::SignalProxy1<bool,GdkEvent*> Window::signal_frame_event()
{
  return Glib::SignalProxy1<bool,GdkEvent*>(this, &Window_signal_frame_event_info);
}

Glib::SignalProxy0<void> Window::signal_activate_focus()
{
  return Glib::SignalProxy0<void>(this, &Window_signal_activate_focus_info);
}

Glib::SignalProxy0<void> Window::signal_activate_default()
{
  return Glib::SignalProxy0<void>(this, &Window_signal_activate_default_info);
}

Glib::SignalProxy1<void,DirectionType> Window::signal_move_focus()
{
  return Glib::SignalProxy1<void,DirectionType>(this, &Window_signal_move_focus_info);
}


Glib::PropertyProxy<Glib::ustring> Window::property_title()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "title");
}

Glib::PropertyProxy<bool> Window::property_allow_shrink()
{
  return Glib::PropertyProxy<bool>(this, "allow_shrink");
}

Glib::PropertyProxy<bool> Window::property_allow_grow()
{
  return Glib::PropertyProxy<bool>(this, "allow_grow");
}

Glib::PropertyProxy<bool> Window::property_resizable()
{
  return Glib::PropertyProxy<bool>(this, "resizable");
}

Glib::PropertyProxy<bool> Window::property_modal()
{
  return Glib::PropertyProxy<bool>(this, "modal");
}

Glib::PropertyProxy<WindowPosition> Window::property_window_position()
{
  return Glib::PropertyProxy<WindowPosition>(this, "window_position");
}

Glib::PropertyProxy<int> Window::property_default_width()
{
  return Glib::PropertyProxy<int>(this, "default_width");
}

Glib::PropertyProxy<int> Window::property_default_height()
{
  return Glib::PropertyProxy<int>(this, "default_height");
}

Glib::PropertyProxy<bool> Window::property_destroy_with_parent()
{
  return Glib::PropertyProxy<bool>(this, "destroy_with_parent");
}

Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > Window::property_icon()
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> >(this, "icon");
}


void Gtk::Window::on_set_focus(Widget* focus)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->set_focus)
    (*base->set_focus)(gobj(),(GtkWidget*)Glib::unwrap(focus));
}

bool Gtk::Window::on_frame_event(GdkEvent* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->frame_event)
    return (*base->frame_event)(gobj(),event);

  typedef bool RType;
  return RType();
}

void Gtk::Window::on_activate_focus()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->activate_focus)
    (*base->activate_focus)(gobj());
}

void Gtk::Window::on_activate_default()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->activate_default)
    (*base->activate_default)(gobj());
}

void Gtk::Window::on_move_focus(DirectionType direction)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->move_focus)
    (*base->move_focus)(gobj(),((GtkDirectionType)(direction)));
}


} // namespace Gtk


namespace Glib
{

Glib::RefPtr<Gtk::WindowGroup> wrap(GtkWindowGroup* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::WindowGroup>( dynamic_cast<Gtk::WindowGroup*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType WindowGroup_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_window_group_get_type(), "gtkmm__WindowGroup", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void WindowGroup_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* WindowGroup_Class::wrap_new(GObject* o)
{
  return new WindowGroup((GtkWindowGroup*)(o));
}


/* The implementation: */

GtkWindowGroup* WindowGroup::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<WindowGroup> WindowGroup::wrap_specific_type(GtkWindowGroup* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<WindowGroup> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    WindowGroup* pCppObject = dynamic_cast<WindowGroup*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<WindowGroup>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<WindowGroup>( new WindowGroup(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

WindowGroup::WindowGroup(GtkWindowGroup* castitem)
: Glib::Object((GObject*)(castitem))
{}

WindowGroup::~WindowGroup()
{
}

WindowGroup::CppClassType WindowGroup::windowgroup_class_; //Initialize static member.

GType WindowGroup::get_type()
{
  return windowgroup_class_.get_type();
}

GType WindowGroup::get_base_type()
{
  return gtk_window_group_get_type();
}

WindowGroup::WindowGroup()
: Glib::Object((GObject*)(g_object_new(get_type(), (char*)0)))
{}

void WindowGroup::add_window(Window& window)
{
  gtk_window_group_add_window(gobj(), (window).gobj());
}

void WindowGroup::remove_window(Window& window)
{
  gtk_window_group_remove_window(gobj(), (window).gobj());
}


} // namespace Gtk

