
#include <atkmm/stateset.h>
#include <atkmm/private/stateset_p.h>

#include <atk/atk-enum-types.h>
// -*- c++ -*-
/* $Id: stateset.ccg,v 1.2 2002/04/15 18:48:40 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Atk
{

void StateSet::add_states(const Glib::ArrayHandle<StateType>& types)
{
  atk_state_set_add_states(gobj(), (AtkStateType*)types.data(), types.size());
}

bool StateSet::contains_states(const Glib::ArrayHandle<StateType>& types)
{
  return atk_state_set_contains_states(gobj(), (AtkStateType*)types.data(), types.size());
}

} /* namespace Atk */


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Atk::StateType>::value_type()
{
  return atk_state_type_get_type();
}


namespace Glib
{

Glib::RefPtr<Atk::StateSet> wrap(AtkStateSet* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Atk::StateSet>( dynamic_cast<Atk::StateSet*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Atk
{


/* The *_Class implementation: */

GType StateSet_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(atk_state_set_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void StateSet_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* StateSet_Class::wrap_new(GObject* o)
{
  return new StateSet((AtkStateSet*)(o));
}


/* The implementation: */

AtkStateSet* StateSet::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<StateSet> StateSet::wrap_specific_type(AtkStateSet* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<StateSet> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    StateSet* pCppObject = dynamic_cast<StateSet*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<StateSet>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<StateSet>( new StateSet(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

StateSet::StateSet(AtkStateSet* castitem)
: Glib::Object((GObject*)(castitem))
{}

StateSet::~StateSet()
{
}

StateSet::CppClassType StateSet::stateset_class_; //Initialize static member.

GType StateSet::get_type()
{
  return stateset_class_.get_type();
}

GType StateSet::get_base_type()
{
  return atk_state_set_get_type();
}

StateSet::StateSet()
: Glib::Object((GObject*)(g_object_new(get_type(), (char*)0)))
{}

Glib::RefPtr<StateSet> StateSet::create()
{
  return Glib::RefPtr<StateSet>( new StateSet() );
}
bool StateSet::is_empty()
{
  return atk_state_set_is_empty(gobj());
}

bool StateSet::add_state(StateType type)
{
  return atk_state_set_add_state(gobj(), ((AtkStateType)(type)));
}

void StateSet::clear_states()
{
  atk_state_set_clear_states(gobj());
}

bool StateSet::contains_state(StateType type)
{
  return atk_state_set_contains_state(gobj(), ((AtkStateType)(type)));
}

bool StateSet::remove_state(StateType type)
{
  return atk_state_set_remove_state(gobj(), ((AtkStateType)(type)));
}

Glib::RefPtr<StateSet> StateSet::and_sets(const Glib::RefPtr<StateSet>& compare_set)
{
  return Glib::wrap(atk_state_set_and_sets(gobj(), (compare_set)->gobj()));
}

Glib::RefPtr<StateSet> StateSet::or_sets(const Glib::RefPtr<StateSet>& compare_set)
{
  return Glib::wrap(atk_state_set_or_sets(gobj(), (compare_set)->gobj()));
}

Glib::RefPtr<StateSet> StateSet::xor_sets(const Glib::RefPtr<StateSet>& compare_set)
{
  return Glib::wrap(atk_state_set_xor_sets(gobj(), (compare_set)->gobj()));
}


} // namespace Atk

