/* example-start eventbox eventbox.c */

#include <gtkmm/window.h>
#include <gtkmm/main.h>
#include <gtkmm/eventbox.h>
#include <gtkmm/label.h>
#include <gtkmm/tooltips.h>

class AppWindow : public Gtk::Window
{
  Gtk::Tooltips tips;

  bool event_box_on_button_press(GdkEventButton*);

public:
  AppWindow();
  ~AppWindow();
};


AppWindow::AppWindow()
{
  Gtk::EventBox *event_box;
  Gtk::Label *label;

  set_title ("Event Box");
  set_border_width (10);

  /* Create an EventBox and add it to our toplevel window */
    
  event_box = manage( new Gtk::EventBox () );
  add (*event_box);

  /* Create a long label */
    
  label = manage( new Gtk::Label ("Click here to quit, quit, quit, quit, quit") );
  event_box-> add (*label);

  /* Clip it short. */
  label->set_size_request (110, 20);

  /* And bind an action to it */
  event_box->set_events(Gdk::BUTTON_PRESS_MASK);
  event_box->signal_button_press_event().connect(
      slot(*this, &AppWindow::event_box_on_button_press));

  tips.set_tip(*event_box, "Click me!");
 
  /* Yet one more thing you need an X window for ... */

//  event_box->realize();
//  event_box->get_window().set_cursor (gdk_cursor_new (GDK_HAND1));

  show_all ();    
}

AppWindow::~AppWindow() {}

bool AppWindow::event_box_on_button_press(GdkEventButton*)
{
  hide();
  return true;
}


int 
main (int argc, char *argv[])
{
    
    Gtk::Main main (argc, argv);
    AppWindow window;
    
    Gtk::Main::run(window);
    
    return 0;
}
/* example-end */
