
#include <gtkmm/editable.h>
#include <gtkmm/private/editable_p.h>

// -*- c++ -*-
/* $Id: editable.ccg,v 1.4 2001/11/07 15:18:49 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkeditable.h>


namespace
{


void Editable_signal_insert_text_callback(GtkEditable*, const gchar* text,gint length,gint* position,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const Glib::ustring&,int*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::ustring(text, text + length),position, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Editable_signal_insert_text_info =
{
  "insert_text",
  (GCallback) &Editable_signal_insert_text_callback,
  (GCallback) &Editable_signal_insert_text_callback
};


void Editable_signal_delete_text_callback(GtkEditable*, gint start_pos,gint end_pos,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,int,int> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (start_pos
,end_pos
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Editable_signal_delete_text_info =
{
  "delete_text",
  (GCallback) &Editable_signal_delete_text_callback,
  (GCallback) &Editable_signal_delete_text_callback
};


const Glib::SignalProxyInfo Editable_signal_changed_info =
{
  "changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::Editable> wrap(GtkEditable* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::Editable>( dynamic_cast<Gtk::Editable*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType Editable_Class::get_type()
{
  if (!gtype_) //Create the GType if necessary.
    {
      //Make sure that the parent type has been created:
      CppClassParent::CppObjectType::get_type();

      //Get the size of the base C class:
      GType gtype_base = gtk_editable_get_type();
      gtype_ = gtype_base; //We can not derive from another interface.
/*
      GTypeQuery typeQueryBase = {0 ,};
      g_type_query(gtype_base, &typeQueryBase);

      //Create a derived C type.
      //These init funcs will, in turn, call the init functions in the base C type.
      GTypeInfo info =
        {
          typeQueryBase.class_size, // class_size
          (GBaseInitFunc) 0, // base_init *
          (GBaseFinalizeFunc) 0, // base_finalize
          (GClassInitFunc) class_init_function, // class_init
          0, // class_finalize
          0, // class_data
          typeQueryBase.instance_size, // instance_size
          0, // n_preallocs
          (GInstanceInitFunc) object_init_function // instance_init
        };

      gtype_ = g_type_register_static(gtype_base, "gtkmm__Editable", &info, GTypeFlags(0));
*/
    }
  return gtype_;
}

void Editable_Class::iface_init_function(BaseClassType* iface)
{
  CppClassParent::iface_init_function((GTypeInterface*)iface);
  BaseClassType* klass = iface; //Allows us to reuse generated code from GObject wrappers.
   klass->do_insert_text = &do_insert_text_vfunc_callback;
  klass->do_delete_text = &do_delete_text_vfunc_callback;
  klass->get_chars = &get_chars_vfunc_callback;
  klass->set_selection_bounds = &set_selection_bounds_vfunc_callback;
  klass->get_selection_bounds = &get_selection_bounds_vfunc_callback;
  klass->set_position = &set_position_vfunc_callback;
  klass->get_position = &get_position_vfunc_callback;
   klass->insert_text = &insert_text_callback;
  klass->delete_text = &delete_text_callback;
  klass->changed = &changed_callback;
}

void Editable_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((GTypeInterface*)klass);
}

void Editable_Class::object_init_function(BaseObjectType* object)
{
}

void Editable_Class::do_insert_text_vfunc_callback(GtkEditable* self, const gchar* text, gint length, gint* position)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)      self));

  if(obj)
  {
    try
    {
      obj->insert_text_vfunc(      text, length, position);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->do_insert_text)
      (*base->do_insert_text)(      self, text, length, position);
  }
}

void Editable_Class::do_delete_text_vfunc_callback(GtkEditable* self, gint start_pos, gint end_pos)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->delete_text_vfunc(start_pos, end_pos);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->do_delete_text)
      (*base->do_delete_text)(self, start_pos, end_pos);
  }
}

gchar* Editable_Class::get_chars_vfunc_callback(GtkEditable* self, gint start_pos, gint end_pos)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->get_chars_vfunc(start_pos, end_pos);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->get_chars)
      (*base->get_chars)(self, start_pos, end_pos);
  }

  typedef gchar* RType;
  return RType();
}

void Editable_Class::set_selection_bounds_vfunc_callback(GtkEditable* self, gint start_pos, gint end_pos)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->select_region_vfunc(start_pos, end_pos);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->set_selection_bounds)
      (*base->set_selection_bounds)(self, start_pos, end_pos);
  }
}

gboolean Editable_Class::get_selection_bounds_vfunc_callback(GtkEditable* self, gint* start_pos, gint* end_pos)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->get_selection_bounds_vfunc(start_pos, end_pos);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->get_selection_bounds)
      (*base->get_selection_bounds)(self, start_pos, end_pos);
  }

  typedef gboolean RType;
  return RType();
}

void Editable_Class::set_position_vfunc_callback(GtkEditable* self, gint position)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->set_position_vfunc(position);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->set_position)
      (*base->set_position)(self, position);
  }
}

gint Editable_Class::get_position_vfunc_callback(GtkEditable* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->get_position_vfunc();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->get_position)
      (*base->get_position)(self);
  }

  typedef gint RType;
  return RType();
}


void Editable_Class::insert_text_callback(GtkEditable* self, const gchar* text, gint length, gint* position)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)      self));

  if(obj)
  {
    try
    {
      obj->on_insert_text(      Glib::ustring(text, text + length), position);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->insert_text)
      (*base->insert_text)(      self, text, length, position);
  }
}

void Editable_Class::delete_text_callback(GtkEditable* self, gint start_pos, gint end_pos)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_delete_text(start_pos
, end_pos
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->delete_text)
      (*base->delete_text)(self, start_pos, end_pos);
  }
}

void Editable_Class::changed_callback(GtkEditable* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->changed)
      (*base->changed)(self);
  }
}


Glib::ObjectBase* Editable_Class::wrap_new(GObject* o)
{
  return new Editable((GtkEditable*)(o));
}


/* The implementation: */

Editable::Editable(GtkEditable* castitem)
: Glib::Interface((GObject*)(castitem))
{}

Editable::~Editable()
{
}

/*
GtkEditable* Editable::gobj_copy()
{
  reference();
  return gobj();
}
*/

Glib::RefPtr<Editable> Editable::wrap_specific_type(GtkEditable* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<Editable> refPtr;
  //Check for an existing wrapper:
  Editable* pCppObject = dynamic_cast<Editable*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
  if(pCppObject)
  {
    //Return the existing wrapper:
    refPtr = Glib::RefPtr<Editable>(pCppObject);
  }
  else
  {
    //Create a new wrapper:
    refPtr = Glib::RefPtr<Editable>( new Editable(gobject) );
  }

  if(take_copy)
    refPtr->reference();

  return refPtr;
}

Editable::Editable()
{
}


void Editable::add_interface(GType gtype_implementer) //static
{
  static const GInterfaceInfo iface_info =
  {
	  (GInterfaceInitFunc)CppClassType::iface_init_function,
	  NULL,
	  NULL
  };

  g_type_add_interface_static(
    gtype_implementer,
    get_type(), //interface_type: whose direct parent type must be G_TYPE_INTERFACE
    &iface_info
  );
}

Editable::CppClassType Editable::editable_class_; //Initialize static member.

GType Editable::get_type()
{
  return editable_class_.get_type();
}

GType Editable::get_base_type()
{
  return gtk_editable_get_type();
}

void Editable::cut_clipboard()
{
  gtk_editable_cut_clipboard(gobj());
}

void Editable::copy_clipboard()
{
  gtk_editable_copy_clipboard(gobj());
}

void Editable::paste_clipboard()
{
  gtk_editable_paste_clipboard(gobj());
}

void Editable::delete_selection()
{
  gtk_editable_delete_selection(gobj());
}

void Editable::set_editable(bool is_editable)
{
  gtk_editable_set_editable(gobj(), static_cast<int>(is_editable));
}

bool Editable::get_editable() const
{
  return gtk_editable_get_editable(const_cast<GtkEditable*>(gobj()));
}


Glib::SignalProxy2<void,const Glib::ustring&,int*> Editable::signal_insert_text()
{
  return Glib::SignalProxy2<void,const Glib::ustring&,int*>(this, &Editable_signal_insert_text_info);
}

Glib::SignalProxy2<void,int,int> Editable::signal_delete_text()
{
  return Glib::SignalProxy2<void,int,int>(this, &Editable_signal_delete_text_info);
}

Glib::SignalProxy0<void> Editable::signal_changed()
{
  return Glib::SignalProxy0<void>(this, &Editable_signal_changed_info);
}


void Gtk::Editable::on_insert_text(const Glib::ustring& text, int* position)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->insert_text)
    (*base->insert_text)(gobj(),text.data(),text.bytes(),position);
}

void Gtk::Editable::on_delete_text(int start_pos, int end_pos)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->delete_text)
    (*base->delete_text)(gobj(),start_pos,end_pos);
}

void Gtk::Editable::on_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->changed)
    (*base->changed)(gobj());
}


void Gtk::Editable::insert_text_vfunc(      const gchar* text, gint length, gint* position)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->do_insert_text)
    (*base->do_insert_text)(gobj(),text,length,position);
}

void Gtk::Editable::delete_text_vfunc(gint start_pos, gint end_pos)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->do_delete_text)
    (*base->do_delete_text)(gobj(),start_pos,end_pos);
}

gchar* Gtk::Editable::get_chars_vfunc(gint start_pos, gint end_pos)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->get_chars)
    return (*base->get_chars)(gobj(),start_pos,end_pos);

  typedef gchar* RType;
  return RType();
}

void Gtk::Editable::select_region_vfunc(gint start_pos, gint end_pos)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->set_selection_bounds)
    (*base->set_selection_bounds)(gobj(),start_pos,end_pos);
}

gboolean Gtk::Editable::get_selection_bounds_vfunc(gint* start_pos, gint* end_pos)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->get_selection_bounds)
    return (*base->get_selection_bounds)(gobj(),start_pos,end_pos);

  typedef gboolean RType;
  return RType();
}

void Gtk::Editable::set_position_vfunc(gint position)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->set_position)
    (*base->set_position)(gobj(),position);
}

gint Gtk::Editable::get_position_vfunc()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->get_position)
    return (*base->get_position)(gobj());

  typedef gint RType;
  return RType();
}

void Gtk::Editable::insert_text(const Glib::ustring& text, int& position)
{
  insert_text_vfunc(      text.data(), text.bytes(), &position);
 }

void Gtk::Editable::delete_text(int start_pos, int end_pos)
{
  delete_text_vfunc(start_pos, end_pos);
 }

Glib::ustring Gtk::Editable::get_chars(int start_pos, int end_pos) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(const_cast<Editable*>(this)->get_chars_vfunc(start_pos, end_pos));
 }

void Gtk::Editable::select_region(int start_pos, int end_pos)
{
  select_region_vfunc(start_pos, end_pos);
 }

bool Gtk::Editable::get_selection_bounds(int& start_pos, int& end_pos) const
{
  return const_cast<Editable*>(this)->get_selection_bounds_vfunc(&start_pos, &end_pos);
 }

void Gtk::Editable::set_position(int position)
{
  set_position_vfunc(position);
 }

int Gtk::Editable::get_position() const
{
  return const_cast<Editable*>(this)->get_position_vfunc();
 }

;

} // namespace Gtk

