// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TEXTBUFFER_H
#define _GTKMM_TEXTBUFFER_H

#include <glibmm.h>

/* $Id: textbuffer.hg,v 1.23 2002/04/16 13:01:53 murrayc Exp $ */

/* textbuffer.h
 * 
 * Copyright(C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtkmm/object.h>
#include <gtkmm/texttagtable.h>
//#include <gtkmm/textmark.h>
#include <gtkmm/textiter.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTextBuffer GtkTextBuffer;
typedef struct _GtkTextBufferClass GtkTextBufferClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TextBuffer_Class; } // namespace Gtk
namespace Gtk
{

class TextMark;


class TextBuffer : public Glib::Object
{
   public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TextBuffer          CppObjectType;
  typedef TextBuffer_Class    CppClassType;
  typedef GtkTextBuffer           BaseObjectType;
  typedef GtkTextBufferClass      BaseClassType;

private:
  friend class TextBuffer_Class;
  static CppClassType textbuffer_class_;

  TextBuffer(const TextBuffer&);
  TextBuffer& operator=(const TextBuffer&); // not implemented

protected:
  explicit TextBuffer(GtkTextBuffer* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TextBuffer();

  static Glib::RefPtr<TextBuffer> wrap_specific_type(GtkTextBuffer* gobject, bool take_copy = false); //Re-uses the existing wrapper, if it exists.

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkTextBuffer* gobj()             { return (GtkTextBuffer*)(gobject_); }
  const GtkTextBuffer* gobj() const { return (GtkTextBuffer*)(gobject_); }

  GtkTextBuffer* gobj_copy();


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_insert_text(const TextIter& pos, const Glib::ustring& text, int bytes);
  virtual void on_insert_pixbuf(const TextIter& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  virtual void on_insert_child_anchor(const TextIter& pos, const Glib::RefPtr<TextChildAnchor>& anchor);
  virtual void on_delete_range(const TextIter& start, const TextIter& end);
  virtual void on_changed();
  virtual void on_modified_changed();
  virtual void on_mark_set(const TextIter& location, const Glib::RefPtr<TextMark>& mark);
  virtual void on_mark_deleted(const Glib::RefPtr<TextMark>& mark);
  virtual void on_apply_tag(const Glib::RefPtr<TextTag>& tag, const TextIter& start_char, const TextIter& end_char);
  virtual void on_remove_tag(const Glib::RefPtr<TextTag>& tag, const TextIter& start_char, const TextIter& end_char);
  virtual void on_begin_user_action();
  virtual void on_end_user_action();


private:

   
protected:
  TextBuffer();
  explicit TextBuffer(const Glib::RefPtr<TextTagTable>& tag_table);

public:

  
  static Glib::RefPtr<TextBuffer> create();

  
  static Glib::RefPtr<TextBuffer> create(const Glib::RefPtr<TextTagTable>& tag_table);


  int get_line_count() const;
  
  int get_char_count() const;

  
  Glib::RefPtr<TextTagTable> get_tag_table();

  void set_text(const Glib::ustring& text);
  void set_text(const char* text_begin, const char* text_end);

  void insert(TextIter& iter, const Glib::ustring& text);
  void insert(TextIter& iter, const char* text_begin, const char* text_end);

  void insert_at_cursor(const Glib::ustring& text);
  void insert_at_cursor(const char* text_begin, const char* text_end);

  bool insert_interactive(TextIter& iter, const Glib::ustring& text, bool default_editable);
  bool insert_interactive(TextIter& iter, const char* text_begin, const char* text_end, bool default_editable);

  bool insert_interactive_at_cursor(const Glib::ustring& text, bool default_editable);
  bool insert_interactive_at_cursor(const char* text_begin, const char* text_end, bool default_editable);

  
  void insert_range(TextIter& iter, const TextIter& start, const TextIter& end);
  
  bool insert_range_interactive(TextIter& iter, const TextIter& start, const TextIter& end,
                                             bool default_editable);

  void insert_with_tag(TextIter& iter, const Glib::ustring& text, const Glib::RefPtr<TextTag>& tag);
  void insert_with_tag(TextIter& iter, const char* text_begin, const char* text_end, const Glib::RefPtr<TextTag>& tag);

  void insert_with_tag(TextIter& iter, const Glib::ustring& text, const Glib::ustring& tag_name);
  void insert_with_tag(TextIter& iter, const char* text_begin, const char* text_end, const Glib::ustring& tag_name);

  void insert_with_tags(TextIter& iter, const Glib::ustring& text,
                        const Glib::ArrayHandle< Glib::RefPtr<TextTag> >& tags);
  void insert_with_tags(TextIter& iter, const char* text_begin, const char* text_end,
                        const Glib::ArrayHandle< Glib::RefPtr<TextTag> >& tags);

  void insert_with_tags_by_name(TextIter& iter, const Glib::ustring& text,
                                const Glib::StringArrayHandle& tag_names);
  void insert_with_tags_by_name(TextIter& iter, const char* text_begin, const char* text_end,
                                const Glib::StringArrayHandle& tag_names);

  
  void delete_(TextIter& start, TextIter& end);
  
  bool delete_interactive(TextIter& start_iter, TextIter& end_iter, bool default_editable);


  Glib::ustring get_text(const TextIter& start, const TextIter& end,
                                                     bool include_hidden_chars);

  
  Glib::ustring get_slice(const TextIter& start, const TextIter& end,
                                                     bool include_hidden_chars);


  void insert_pixbuf(TextIter& iter, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);

  
  void insert_child_anchor(TextIter& iter, const Glib::RefPtr<TextChildAnchor>& anchor);
  
  Glib::RefPtr<TextChildAnchor> create_child_anchor(TextIter& iter);

  
  Glib::RefPtr<TextMark> create_mark(const Glib::ustring& mark_name, const TextIter& where, bool left_gravity);
  
  void move_mark(const Glib::RefPtr<TextMark>& mark, const TextIter& where);
  
  void delete_mark(const Glib::RefPtr<TextMark>& mark);
  
  Glib::RefPtr<TextMark> get_mark(const Glib::ustring& name);

  
  void move_mark_by_name(const Glib::ustring& name, const TextIter& where);
  
  void delete_mark_by_name(const Glib::ustring& name);

  
  Glib::RefPtr<TextMark> get_insert();
  
  Glib::RefPtr<TextMark> get_selection_bound();

  
  void place_cursor(const TextIter& where);
  
  void apply_tag(const Glib::RefPtr<TextTag>& tag, const TextIter& start, const TextIter& end);
  
  void remove_tag(const Glib::RefPtr<TextTag>& tag, const TextIter& start, const TextIter& end);
  
  void apply_tag_by_name(const Glib::ustring& name, const TextIter& start, const TextIter& end);
  
  void remove_tag_by_name(const Glib::ustring& name, const TextIter& start, const TextIter& end);
  
  void remove_all_tags(const TextIter& start, const TextIter& end);

  Glib::RefPtr<TextTag> create_tag(const Glib::ustring& tag_name);

  TextIter get_iter_at_line_offset(int line_number, int char_offset);
  TextIter get_iter_at_line_index(int line_number, int byte_index);
  TextIter get_iter_at_offset(int char_offset);
  TextIter get_iter_at_line(int line_number);
  TextIter get_start_iter();
  TextIter get_end_iter();
  void get_bounds(TextIter& start, TextIter& end);
  TextIter get_iter_at_mark(const Glib::RefPtr<TextMark>& mark);

  TextIter get_iter_at_child_anchor(const Glib::RefPtr<TextChildAnchor>& anchor);

  
  bool get_modified();
  
  void set_modified(bool setting = true);

//TODO:
//  _WRAP_METHOD(void add_selection_clipboard(GtkClipboard* clipboard), gtk_text_buffer_add_selection_clipboard)
//  _WRAP_METHOD(void remove_selection_clipboard(GtkClipboard* clipboard), gtk_text_buffer_remove_selection_clipboard)
//
//  _WRAP_METHOD(void cut_clipboard(GtkClipboard  *clipboard, bool default_editable), gtk_text_buffer_cut_clipboard)
//  _WRAP_METHOD(void copy_clipboard(GtkClipboard  *clipboard), gtk_text_buffer_copy_clipboard)
  //_WRAP_METHOD(void paste_clipboard(GtkClipboard  *clipboard, TextIter& override_location, bool default_editable), gtk_text_buffer_paste_clipboard)

  //_WRAP_METHOD(bool gtk_text_buffer_get_selection_bounds(TextIter& start, TextIter& end), )
  void get_selection_bounds(TextIter& start, TextIter& end);
  
  bool delete_selection(bool interactive, bool default_editable);

/* Called to specify atomic user actions, used to implement undo */
  
  void begin_user_action();
  
  void end_user_action();


  /**
   * @par Prototype:
   * <tt>void %insert_text(const TextIter& pos, const Glib::ustring& text, int bytes)</tt>
   */
  Glib::SignalProxy3<void,const TextIter&,const Glib::ustring&,int> signal_insert_text();

  
  /**
   * @par Prototype:
   * <tt>void %insert_pixbuf(const TextIter& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)</tt>
   */
  Glib::SignalProxy2<void,const TextIter&,const Glib::RefPtr<Gdk::Pixbuf>&> signal_insert_pixbuf();

  
  /**
   * @par Prototype:
   * <tt>void %insert_child_anchor(const TextIter& pos, const Glib::RefPtr<TextChildAnchor>& anchor)</tt>
   */
  Glib::SignalProxy2<void,const TextIter&,const Glib::RefPtr<TextChildAnchor>&> signal_insert_child_anchor();

  
  /**
   * @par Prototype:
   * <tt>void %delete_range(const TextIter& start, const TextIter& end)</tt>
   */
  Glib::SignalProxy2<void,const TextIter&,const TextIter&> signal_delete_range();

  
  /**
   * @par Prototype:
   * <tt>void %changed()</tt>
   */
  Glib::SignalProxy0<void> signal_changed();

  
  /**
   * @par Prototype:
   * <tt>void %modified_changed()</tt>
   */
  Glib::SignalProxy0<void> signal_modified_changed();

  
  /**
   * @par Prototype:
   * <tt>void %mark_set(const TextIter& location, const Glib::RefPtr<TextMark>& mark)</tt>
   */
  Glib::SignalProxy2<void,const TextIter&,const Glib::RefPtr<TextMark>&> signal_mark_set();

  
  /**
   * @par Prototype:
   * <tt>void %mark_deleted(const Glib::RefPtr<TextMark>& mark)</tt>
   */
  Glib::SignalProxy1<void,const Glib::RefPtr<TextMark>&> signal_mark_deleted();

  
  /**
   * @par Prototype:
   * <tt>void %apply_tag(const Glib::RefPtr<TextTag>& tag, const TextIter& start_char, const TextIter& end_char)</tt>
   */
  Glib::SignalProxy3<void,const Glib::RefPtr<TextTag>&,const TextIter&,const TextIter&> signal_apply_tag();

  
  /**
   * @par Prototype:
   * <tt>void %remove_tag(const Glib::RefPtr<TextTag>& tag, const TextIter& start_char, const TextIter& end_char)</tt>
   */
  Glib::SignalProxy3<void,const Glib::RefPtr<TextTag>&,const TextIter&,const TextIter&> signal_remove_tag();

  
  /**
   * @par Prototype:
   * <tt>void %begin_user_action()</tt>
   */
  Glib::SignalProxy0<void> signal_begin_user_action();

  
  /**
   * @par Prototype:
   * <tt>void %end_user_action()</tt>
   */
  Glib::SignalProxy0<void> signal_end_user_action();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::TextBuffer */
  Glib::RefPtr<Gtk::TextBuffer> wrap(GtkTextBuffer* object, bool take_copy = false);
}


#endif /* _GTKMM_TEXTBUFFER_H */

