// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TOGGLEBUTTON_H
#define _GTKMM_TOGGLEBUTTON_H

#include <glibmm.h>

/* $Id: togglebutton.hg,v 1.19 2002/04/01 16:19:35 murrayc Exp $ */

/* togglebutton.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/button.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkToggleButton GtkToggleButton;
typedef struct _GtkToggleButtonClass GtkToggleButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ToggleButton_Class; } // namespace Gtk
namespace Gtk
{

/** A Gtk::ToggleButton will remain 'pressed-in' when clicked. Clicking again will cause the toggle button to return to it's normal state.
 * The state of a Gtk::ToggleButton can be set specifically using set_active(), and retrieved using get_active().
 * To simply switch the state of a toggle button, use toggled().
 *
 * @ingroup Widgets
 */

class ToggleButton : public Button
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ToggleButton CppObjectType;
  typedef ToggleButton_Class CppClassType;
  typedef GtkToggleButton BaseObjectType;
  typedef GtkToggleButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ToggleButton();

private:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class ToggleButton_Class;
  static CppClassType togglebutton_class_;

  ToggleButton(const ToggleButton&);
  ToggleButton& operator=(const ToggleButton&); // not implemented

protected:
  explicit ToggleButton(GtkToggleButton* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkToggleButton* gobj()             { return (GtkToggleButton*)(gobject_); }
  const GtkToggleButton* gobj() const { return (GtkToggleButton*)(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_toggled();


private:

public:

  /** Create an empty toggle button.
   * With an empty button, you can {Gtk::Button::add()} a widget
   * such as a {Gtk::Pixmap::} or {Gtk::Box::}.
   *
   * If you just wish to add a {Gtk::Label::},
   * you may want to
   * use the {\decl Gtk::ToggleButton(const Glib::ustring &label)} ctor
   * directly instead.
   */
  ToggleButton();

  /** Create a toggle button with a label.
   * You won't be able
   * to add a widget to this button since it already contains a Gtk::Label
   */
  explicit ToggleButton(const Glib::ustring& label, bool mnemonic = false);
  

  //: Whether the indicator will be drawn.
  //- See {draw_indicator}.
  
  void set_mode(bool draw_indicator = true);
  
  bool get_mode() const;

  //: The state of the indicator.
  
  void set_active(bool is_active = true);
  
  bool get_active() const;

  
  void set_inconsistent(bool setting = true);
  
  bool get_inconsistent() const;

  
  void toggled();

  //: Emitted on a change of button state.
  //- Triggered when the button changes state
  //- (Note : changing the button's state with {set_active()}
  //- will also trigger this signal).
  
  /**
   * @par Prototype:
   * <tt>void %toggled()</tt>
   */
  Glib::SignalProxy0<void> signal_toggled();


  Glib::PropertyProxy<bool> property_active();

  Glib::PropertyProxy<bool> property_inconsistent();

  Glib::PropertyProxy<bool> property_draw_indicator();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::ToggleButton */
  Gtk::ToggleButton* wrap(GtkToggleButton* object, bool take_copy = false);
}
#endif /* _GTKMM_TOGGLEBUTTON_H */

