
#include <gtkmm/arrow.h>
#include <gtkmm/private/arrow_p.h>

// -*- c++ -*-
/* $Id: arrow.ccg,v 1.9 2002/04/02 13:25:13 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <gtk/gtkarrow.h>

namespace Gtk
{

/*
#define MIN_ARROW_SIZE  11

Arrow::Arrow(ArrowType arrow_type, ShadowType shadow_type)
  : Misc((GtkMisc*)(g_object_new(get_type(),0)))
{

  GtkArrow *arrow=gobj();

  GTK_WIDGET (arrow)->requisition.width = MIN_ARROW_SIZE + GTK_MISC (arrow)->xpad * 2;
  GTK_WIDGET (arrow)->requisition.height = MIN_ARROW_SIZE + GTK_MISC (arrow)->ypad * 2;

  arrow->arrow_type = arrow_type;
  arrow->shadow_type = shadow_type;
}

*/

} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Arrow* wrap(GtkArrow* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Arrow *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Arrow_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_arrow_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Arrow_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Arrow_Class::wrap_new(GObject* o)
{
  return manage(new Arrow((GtkArrow*)(o)));
}


/* The implementation: */

Arrow::Arrow(GtkArrow* castitem)
: Gtk::Misc((GtkMisc*)(castitem))
{}

Arrow::~Arrow()
{
  destroy_();
}

Arrow::CppClassType Arrow::arrow_class_; //Initialize static member.

GType Arrow::get_type()
{
  return arrow_class_.get_type();
}

GType Arrow::get_base_type()
{
  return gtk_arrow_get_type();
}

Arrow::Arrow(ArrowType arrow_type, ShadowType shadow_type)
: Gtk::Misc((GtkMisc*)( g_object_new(get_type(), "arrow_type", ((GtkArrowType)(arrow_type)), "shadow_type", ((GtkShadowType)(shadow_type)), (char*)0) ))
{}

void Arrow::set(ArrowType arrow_type, ShadowType shadow_type)
{
  gtk_arrow_set(gobj(), ((GtkArrowType)(arrow_type)), ((GtkShadowType)(shadow_type)));
}


Glib::PropertyProxy<ArrowType> Arrow::property_arrow_type()
{
  return Glib::PropertyProxy<ArrowType>(this, "arrow_type");
}

Glib::PropertyProxy<ShadowType> Arrow::property_shadow_type()
{
  return Glib::PropertyProxy<ShadowType>(this, "shadow_type");
}


} // namespace Gtk

