/* $Id: menu_elems.h,v 1.5 2002/04/15 21:30:41 murrayc Exp $ */
#ifndef _GTKMM_MENU_ELEMS_H
#define _GTKMM_MENU_ELEMS_H
/* menu_elems.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// TODO Why does this one file have a different naming convention 
// than all the rest? -KEN

#include <gdk/gdkkeysyms.h>

#include <gtkmm/container.h>
#include <gtkmm/menuitem.h>
#include <gtkmm/imagemenuitem.h>
#include <gtkmm/radiomenuitem.h>
#include <gtkmm/checkmenuitem.h>
#include <gtkmm/tearoffmenuitem.h>
#include <gtkmm/accelgroup.h>
#include <gtkmm/accelkey.h>

namespace Gtk
{

class Menu;
class MenuShell;
class Window;

namespace Menu_Helpers
{

// input class (MenuItem-Factory)
class Element
{
public:
  typedef SigC::Slot0<void> CallSlot;

  Element();
  Element(MenuItem& child);
  Element(Widget& widget, const AccelKey& accel_key = AccelKey());
  ~Element();

  friend class MenuList;

  const Glib::RefPtr<MenuItem>& get_child() const;

protected:

  void set_child_key(const AccelKey& accel_key);

  // connects a slot to the activate signal
  void set_slot(const CallSlot& slot,
                    const Glib::ustring& accel_signal);

  // creates a label and sets up for navigation and accelerator
  void set_navigation(const Glib::ustring& str,
                      const AccelKey& accel_key = AccelKey());


  void init(const Glib::ustring& label,
                    const CallSlot& slot,
                    const Glib::ustring& accel_signal,
                    const AccelKey& key = AccelKey());

  void init(const Glib::ustring& label,
                    Gtk::Menu& submenu,
                    const AccelKey& key = AccelKey());

  //We use a RefPtr to avoid leaks when the manage()d widget never gets added to a container.
  Glib::RefPtr<MenuItem> child_;
};

class MenuElem : public Element
{
public:

  MenuElem(MenuItem& child);

  //: create a labeled, non-accelerated menuitem with a slot
  MenuElem(const Glib::ustring& label, const CallSlot& slot = CallSlot(),
           const Glib::ustring& accel_signal = "activate") ;

  //: create a labeled, accelerated menuitem with a slot
  MenuElem(const Glib::ustring& label, const AccelKey& key,
           const CallSlot& slot = CallSlot(),
           const Glib::ustring& accel_signal = "activate");

  //: create a labeled, non-accelerated menuitem with a submenu
  MenuElem(const Glib::ustring& label, Gtk::Menu& submenu);

  //: create a labeled, accelerated menuitem with a submenu
  MenuElem(const Glib::ustring& label,
           const AccelKey& key,
           Gtk::Menu& submenu);

};

class SeparatorElem : public Element
{
public:
  SeparatorElem();
};

class ImageMenuElem : public Element
{
public:
  ImageMenuElem(ImageMenuItem& child);

  //: create a labeled, non-accelerated menuitem with a slot
  ImageMenuElem(const Glib::ustring& label,
                const Gtk::Widget& image_widget,
                const CallSlot& slot = CallSlot(),
                const Glib::ustring& accel_signal = "activate");

  //: create a labeled, accelerated menuitem with a slot
  ImageMenuElem(const Glib::ustring& label, const AccelKey& key,
                const Gtk::Widget& image_widget,
                const CallSlot& slot = CallSlot(),
                const Glib::ustring& accel_signal = "activate");

  //: create a labeled, non-accelerated menuitem with a submenu
  ImageMenuElem(const Glib::ustring& label,
                const Gtk::Widget& image_widget,
                Gtk::Menu& submenu);

  //: create a labeled, accelerated menuitem with a submenu
  ImageMenuElem(const Glib::ustring& label, const AccelKey& key,
                const Gtk::Widget& image_widget,
                Gtk::Menu& submenu);
};

class StockMenuElem : public Element
{
public:
  //: create a non-accelerated menuitem from a stock-item
  StockMenuElem(const Gtk::StockID& stock_id,
                const CallSlot& slot = CallSlot(),
                const Glib::ustring& accel_signal = "activate");

  //: create an accelerated menuitem from a stock-item
  StockMenuElem(const Gtk::StockID& stock_id,
                const AccelKey& key,
                const CallSlot& slot = CallSlot(),
                const Glib::ustring& accel_signal = "activate");
};

class CheckMenuElem : public Element
{
public:
  CheckMenuElem(CheckMenuItem& child);

  //: create a labeled, non-accelerated menuitem with a slot
  CheckMenuElem(const Glib::ustring& label, const CallSlot& slot = CallSlot(),
                const Glib::ustring& accel_signal = "toggled");

  //: create a labeled, accelerated checkmenuitem with a slot
  CheckMenuElem(const Glib::ustring& label, const AccelKey& key,
                const CallSlot& slot = CallSlot(),
                const Glib::ustring& accel_signal = "toggled");

};


class RadioMenuElem : public Element
{
public:
  RadioMenuElem(RadioMenuItem& child);

  //: create a labeled, non-accelerated menuitem with a slot
  RadioMenuElem(RadioMenuItem::Group&, const Glib::ustring& label,
                const CallSlot& slot = CallSlot(),
                const Glib::ustring& accel_signal = "toggled");

  //: create a labeled, accelerated checkmenuitem with a slot
  RadioMenuElem(RadioMenuItem::Group&, const Glib::ustring& label,
                const AccelKey& key,
                const CallSlot& slot = CallSlot(),
                const Glib::ustring& accel_signal = "toggled");

protected:
  RadioMenuItem::Group *gr_;
};

class TearoffMenuElem : public Element
{
public:
  TearoffMenuElem(TearoffMenuItem& child);

  //: create a non-accelerated tearoffmenuitem with a slot
  TearoffMenuElem(const CallSlot& slot = CallSlot(),
                  const Glib::ustring& accel_signal = "activate");

  //: create accelerated tearoffmenuitem with a slot
  TearoffMenuElem(const AccelKey& key,
                  const CallSlot& slot = CallSlot(),
                  const Glib::ustring& accel_signal = "activate");

protected:
  void init(const CallSlot& slot,
                    const Glib::ustring& accel_signal,
                    const AccelKey& accel_key = AccelKey());
};

} /* namespace Menu_Helpers */

} /* namespace Gtk */

#endif //_GTKMM_MENU_ELEMS_H
