
#include <gtkmm/invisible.h>
#include <gtkmm/private/invisible_p.h>

// -*- c++ -*-
/* $Id: invisible.ccg,v 1.5 2001/11/16 19:03:40 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkinvisible.h>

namespace Gtk
{

  //TOOD: gtk_invisible_new() calls gtk_widget_realize(). Do we need to?
}


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Invisible* wrap(GtkInvisible* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Invisible *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Invisible_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_invisible_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Invisible_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Invisible_Class::wrap_new(GObject* o)
{
  return manage(new Invisible((GtkInvisible*)(o)));
}


/* The implementation: */

Invisible::Invisible(GtkInvisible* castitem)
: Gtk::Widget((GtkWidget*)(castitem))
{}

Invisible::~Invisible()
{
  destroy_();
}

Invisible::CppClassType Invisible::invisible_class_; //Initialize static member.

GType Invisible::get_type()
{
  return invisible_class_.get_type();
}

GType Invisible::get_base_type()
{
  return gtk_invisible_get_type();
}

Invisible::Invisible()
: Gtk::Widget((GtkWidget*)(g_object_new(get_type(), (char*)0)))
{}


} // namespace Gtk

