
#include <gtkmm/aspectframe.h>
#include <gtkmm/private/aspectframe_p.h>

// -*- c++ -*-
/* $Id: aspectframe.ccg,v 1.7 2001/10/25 11:17:19 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkaspectframe.h>


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::AspectFrame* wrap(GtkAspectFrame* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::AspectFrame *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType AspectFrame_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_aspect_frame_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void AspectFrame_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* AspectFrame_Class::wrap_new(GObject* o)
{
  return manage(new AspectFrame((GtkAspectFrame*)(o)));
}


/* The implementation: */

AspectFrame::AspectFrame(GtkAspectFrame* castitem)
: Gtk::Frame((GtkFrame*)(castitem))
{}

AspectFrame::~AspectFrame()
{
  destroy_();
}

AspectFrame::CppClassType AspectFrame::aspectframe_class_; //Initialize static member.

GType AspectFrame::get_type()
{
  return aspectframe_class_.get_type();
}

GType AspectFrame::get_base_type()
{
  return gtk_aspect_frame_get_type();
}

AspectFrame::AspectFrame(const Glib::ustring & label, float xalign, float yalign, float ratio, bool obey_child)
: Gtk::Frame((GtkFrame*)( g_object_new(get_type(), "label", label.c_str(), "xalign", xalign, "yalign", yalign, "ratio", ratio, "obey_child", static_cast<int>(obey_child), (char*)0) ))
{}

void AspectFrame::set(float xalign, float yalign, float ratio, int obey_child)
{
  gtk_aspect_frame_set(gobj(), xalign, yalign, ratio, obey_child);
}


Glib::PropertyProxy<float> AspectFrame::property_xalign()
{
  return Glib::PropertyProxy<float>(this, "xalign");
}

Glib::PropertyProxy<float> AspectFrame::property_yalign()
{
  return Glib::PropertyProxy<float>(this, "yalign");
}

Glib::PropertyProxy<float> AspectFrame::property_ratio()
{
  return Glib::PropertyProxy<float>(this, "ratio");
}

Glib::PropertyProxy<bool> AspectFrame::property_obey_child()
{
  return Glib::PropertyProxy<bool>(this, "obey_child");
}


} // namespace Gtk

