#include <gtkmm/scrolledwindow.h>
#include <gtkmm/main.h>
#include <gtkmm/scrollbar.h>
#include <gtkmm/window.h>
#include <gtkmm/textview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treeview.h>
#include <gtkmm/cellrenderertext.h>
#include <gtkmm/paned.h>

class AppMessages: public Gtk::ScrolledWindow 
{
public:
  AppMessages();
  virtual ~AppMessages();

  class ModelColumns : public Gtk::TreeModel::ColumnRecord
  {
  public:

    ModelColumns()
    { add(m_col_text); }

    Gtk::TreeModelColumn<Glib::ustring> m_col_text;
  };

  ModelColumns m_Columns;

protected:
  Glib::RefPtr<Gtk::ListStore> m_refListStore; //The Tree Model.
  Gtk::TreeView m_TreeView; //The Tree View.
};

/* Create the list of "messages" */
AppMessages::AppMessages()
{
  /* Create a new scrolled window, with scrollbars only if needed */
  set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

  add(m_TreeView);

  /* create list store */
  m_refListStore = Gtk::ListStore::create(m_Columns);

  m_TreeView.set_model(m_refListStore);

  /* Add some messages to the window */
  for(int i = 0; i < 10; ++i)
  {
    Gtk::TreeModel::Row row = *(m_refListStore->append());

    const Glib::ScopedPtr<char> text_buf (g_strdup_printf("message #%d", i));
    row[m_Columns.m_col_text] = text_buf.get();
  }

  //Add the Model's column to the View's columns:
  m_TreeView.append_column("Messages", m_Columns.m_col_text);

  show_all_children();
}

AppMessages::~AppMessages()
{
}


class AppText : public Gtk::ScrolledWindow
{
public:
  AppText();
  virtual ~AppText();

  virtual void insert_text();

protected:
  Gtk::TextView m_TextView;
};
   
/* Create a scrolled text area that displays a "message" */
AppText::AppText()
{
  set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

  add(m_TextView);
  insert_text();

  show_all_children();
}

AppText::~AppText()
{
}

void AppText::insert_text()
{
  Glib::RefPtr<Gtk::TextBuffer> refTextBuffer = m_TextView.get_buffer();

  Gtk::TextBuffer::iterator iter = refTextBuffer->get_iter_at_offset(0);
  refTextBuffer->insert(iter,
    "From: pathfinder@nasa.gov\n"
    "To: mom@nasa.gov\n"
    "Subject: Made it!\n"
    "\n"
    "We just got in this morning. The weather has been\n"
    "great - clear but cold, and there are lots of fun sights.\n"
    "Sojourner says hi. See you soon.\n"
    " -Path\n");
}

class AppWindow : public Gtk::Window
{
public:
  AppWindow();
  virtual ~AppWindow();

protected:
  Gtk::VPaned m_VPaned;
  AppMessages m_AppMessages;
  AppText m_AppText;
};

   
AppWindow::AppWindow()
{
  set_title ("Paned Windows");
  set_border_width (10);
  set_size_request (450, 400);

  /* Add a vpaned widget to our toplevel window */
  add(m_VPaned);

  /* Now add the contents of the two halves of the window */
  m_VPaned.add1(m_AppMessages);
  m_VPaned.add2(m_AppText);

  show_all_children();
}

AppWindow::~AppWindow()
{}


int main(int argc, char *argv[] )
{
  /* Initialise GTK */
  Gtk::Main kit(&argc, &argv);

  /* Create a new window */
  AppWindow app;

  /* Enter the event loop */
  Gtk::Main::run(app);

  return(0);
}

