#include <gtkmm/main.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/scale.h>
#include <gtkmm/box.h>
#include <gtkmm/label.h>
#include <gtkmm/window.h>
#include <gtkmm/separator.h>
#include <gtkmm/scrollbar.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/menu.h>
#include <gtkmm/optionmenu.h>

// Gtk-- version of the range widgets example from the gtk+ tutorial

class LabeledOptionMenu : public Gtk::HBox
{
  Gtk::Label m_label;

public:
    LabeledOptionMenu(const Glib::ustring &menutitle, Gtk::Menu *menu,
		      bool homogeneous=false,
		      int spacing = 10);
    Gtk::Menu *m_menu;
};

LabeledOptionMenu::LabeledOptionMenu(const Glib::ustring &menutitle,
				     Gtk::Menu *menu,
				     bool homogeneous,
				     int spacing) :
    Gtk::HBox(homogeneous, spacing),
    m_label(menutitle),
    m_menu(menu)
{
  pack_start(m_label, Gtk::SHRINK);
  Gtk::OptionMenu *om=manage(new Gtk::OptionMenu);
  om->set_menu(*m_menu);
  pack_start(*om);
}

class RangeControls : public Gtk::Window
{

  Gtk::VBox m_vbox1, m_vbox2, m_vbox3;
  Gtk::HBox m_hbox1, m_hbox2;

  Gtk::Adjustment m_adj1;

  Gtk::VScale m_vscale;
  Gtk::HScale m_hscale;

  Gtk::HSeparator m_separator;
  
  Gtk::Button m_buttonQuit;
  Gtk::CheckButton m_checkbutton;
  
  Gtk::HScrollbar m_scrollbar;

public:

    RangeControls();

    // callbacks
    void draw_value(Gtk::CheckButton *button);
    void menu_pos_select_cb(Gtk::PositionType type);
    void menu_update_select_cb(Gtk::UpdateType type);
    void digits_cb(Gtk::Adjustment *adj);
    void psize_cb(Gtk::Adjustment *adj);
};

RangeControls::RangeControls() :
  m_vbox1(false, 0),
  m_vbox2(false, 20),
  m_vbox3(false, 10),

  m_hbox1(false, 10),
  m_hbox2(false, 10),

  // value, lower, upper, step_increment, page_increment, page_size
  // note that the page_size value only makes a difference for
  // scrollbar widgets, and the highest value you'll get is actually
  // (upper - page_size).
  m_adj1(0.0, 0.0, 101.0, 0.1, 1.0, 1.0),

  m_vscale(m_adj1),

  m_hscale(m_adj1),

  m_buttonQuit("Quit"),
  // a checkbutton to control whether the value is displayed or not
  m_checkbutton("Display value on scale widgets",0),

  // reuse the same adjustment again
  m_scrollbar(m_adj1)
  // notice how this causes the scales to always be update
  // continuously when the scrollbar is moved
{
  set_title("range controls");

  m_vscale.set_update_policy(Gtk::UPDATE_CONTINUOUS);
  m_vscale.set_digits(1);
  m_vscale.set_value_pos(Gtk::POS_TOP);
  m_vscale.set_draw_value(true);
  m_hscale.set_update_policy(Gtk::UPDATE_CONTINUOUS);
  m_hscale.set_digits(1);
  m_hscale.set_value_pos(Gtk::POS_TOP);
  m_hscale.set_draw_value(true);

  add(m_vbox1);
  m_vbox1.pack_start(m_vbox2);
  m_vbox2.set_border_width(10);
  m_vbox2.pack_start(m_hbox1);
  m_hbox1.pack_start(m_vscale);  
  m_hbox1.pack_start(m_vbox3);
  
  m_hscale.set_size_request(200, 30);
  m_vbox3.pack_start(m_hscale);
  
  m_scrollbar.set_update_policy(Gtk::UPDATE_CONTINUOUS);
  m_vbox3.pack_start(m_scrollbar);
  
  m_checkbutton.set_active(true);
  m_checkbutton.signal_toggled().connect(
      bind(slot(*this, &RangeControls::draw_value), &m_checkbutton));
  m_vbox2.pack_start(m_checkbutton);

  {
      using namespace Gtk::Menu_Helpers;

      Gtk::Menu *menu_vpos=manage(new Gtk::Menu);
      MenuList& list_vpos=menu_vpos->items();
      list_vpos.push_back(
	  MenuElem("Top",bind(
	      slot(*this,&RangeControls::menu_pos_select_cb), Gtk::POS_TOP)));
      list_vpos.push_back(
	  MenuElem("Bottom",bind(
	      slot(*this,&RangeControls::menu_pos_select_cb), Gtk::POS_BOTTOM)));
      list_vpos.push_back(
	  MenuElem("Left",bind(
	      slot(*this,&RangeControls::menu_pos_select_cb), Gtk::POS_LEFT)));
      list_vpos.push_back(
	  MenuElem("Right",bind(
	      slot(*this,&RangeControls::menu_pos_select_cb), Gtk::POS_RIGHT)));

      Gtk::Menu *menu_upd=manage(new Gtk::Menu);
      MenuList& list_upd=menu_upd->items();
      list_upd.push_back(
	  MenuElem("Continuous",bind(
	      slot(*this,&RangeControls::menu_update_select_cb), Gtk::UPDATE_CONTINUOUS)));
      list_upd.push_back(
	  MenuElem("Discontinuous",bind(
	      slot(*this,&RangeControls::menu_update_select_cb), Gtk::UPDATE_DISCONTINUOUS)));
      list_upd.push_back(
	  MenuElem("Delayed",bind(
	      slot(*this,&RangeControls::menu_update_select_cb), Gtk::UPDATE_DELAYED)));

      m_vbox2.pack_start(
	  *manage(new LabeledOptionMenu("Scale Value Position:", menu_vpos)));
      m_vbox2.pack_start(
	  *manage(new LabeledOptionMenu("Scale Update Policy:", menu_upd)));
  }

  Gtk::HBox *lsbox1 = manage(new Gtk::HBox(false,10));
  lsbox1->pack_start(*manage(new Gtk::Label("Scale Digits:",0)),  Gtk::SHRINK);
  Gtk::Adjustment *adj1 = manage(new Gtk::Adjustment(1.0, 0.0, 5.0));
  Gtk::HScale *digits = manage(new Gtk::HScale(*adj1));
  digits->set_digits(0);
  adj1->signal_value_changed().connect(bind(slot(*this, &RangeControls::digits_cb), adj1));
  lsbox1->pack_start(*digits);

  Gtk::HBox *lsbox2 = manage(new Gtk::HBox(false,10));
  lsbox2->pack_start(*manage(new Gtk::Label("Scrollbar Page Size:",0)), Gtk::SHRINK);
  Gtk::Adjustment *adj2 = manage(new Gtk::Adjustment(1.0, 1.0, 101.0));
  Gtk::HScale *pgsize = manage(new Gtk::HScale(*adj2));
  pgsize->set_digits(0);
  adj2->signal_value_changed().connect(bind(slot(*this, &RangeControls::psize_cb), adj2));
  lsbox2->pack_start(*pgsize);
  
  m_vbox2.pack_start(*lsbox1);
  m_vbox2.pack_start(*lsbox2);
  m_vbox1.pack_start(m_separator, Gtk::FILL);
  m_vbox1.pack_start(m_buttonQuit, Gtk::SHRINK);
  m_buttonQuit.set_flags(Gtk::CAN_DEFAULT);
  m_buttonQuit.grab_default();
  m_buttonQuit.signal_clicked().connect(SigC::slot(&Gtk::Main::quit));
  m_buttonQuit.set_border_width(10);
  show_all();
}

void RangeControls::draw_value(Gtk::CheckButton *button)
{
    m_vscale.set_draw_value(button->get_active());
    m_hscale.set_draw_value(button->get_active());
}

void RangeControls::menu_pos_select_cb(Gtk::PositionType postype)
{
    m_vscale.set_value_pos(postype);
    m_hscale.set_value_pos(postype);
}

void RangeControls::menu_update_select_cb(Gtk::UpdateType type)
{
    m_vscale.set_update_policy(type);
    m_hscale.set_update_policy(type);
}

void RangeControls::digits_cb(Gtk::Adjustment *adj)
{
    double val = adj->get_value();
    m_vscale.set_digits((int)val);
    m_hscale.set_digits((int)val);
}

void RangeControls::psize_cb(Gtk::Adjustment *adj)
{
    Gtk::Adjustment* swadj = m_scrollbar.get_adjustment();
    double val = adj->get_value();
    swadj->set_page_size((int)val);
    swadj->set_page_increment((int)val);

    // note that we don't have to emit the "changed" signal;
    // GTK-- does this for us
}

int main(int argc, char *argv[])
{
  Gtk::Main myapp(&argc, &argv);
  RangeControls rangecontrols;

  myapp.run(rangecontrols);
  return 0;
}


