// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_COMBO_H
#define _GTKMM_COMBO_H

#include <glibmm.h>

/* $Id: combo.hg,v 1.24 2002/07/08 15:17:30 murrayc Exp $ */

/* combo.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/listhandle.h>
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/entry.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkCombo GtkCombo;
typedef struct _GtkComboClass GtkComboClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Combo_Class; } // namespace Gtk
namespace Gtk
{

class Item;
class ScrolledWindow;
class Window;

/** A text entry field with a dropdown list.
 * 
 * A combo is a compound widget which crosses a text entry area and a pull
 * down list.  It may allow text entry or it may just allow list
 * values depending on the settings.
 *
 * Access members allow altering of the widget components.
 *
 * @ingroup Widgets
 */

class Combo : public HBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Combo CppObjectType;
  typedef Combo_Class CppClassType;
  typedef GtkCombo BaseObjectType;
  typedef GtkComboClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Combo();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Combo_Class;
  static CppClassType combo_class_;

  // noncopyable
  Combo(const Combo&);
  Combo& operator=(const Combo&);

protected:
  explicit Combo(const Glib::ConstructParams& construct_params);
  explicit Combo(GtkCombo* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkCombo*       gobj()       { return reinterpret_cast<GtkCombo*>(gobject_); }
  const GtkCombo* gobj() const { return reinterpret_cast<GtkCombo*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:

  Combo();
  

  /** Allow direct text entry
   * Whether the text in the entry must be or not be in the list.
   *
   * {\param value} - Set to true if the value must be in list.
   *
   * {\param empty} - Set to true if the text area is allowed to be empty.
   */
  
  /** 
   * Specifies whether the value entered in the text entry field must match one of
   * the values in the list. If this is set then the user will not be able to
   * perform any other action until a valid value has been entered.
   * 
   * 
   * If an empty field is acceptable, the @a ok_if_empty parameter should be <tt>true</tt>.
   * 
   * @param val <tt>true</tt> if the value entered must match one of the values in the list.
   * @param ok_if_empty <tt>true</tt> if an empty value is considered valid.
   */
  void set_value_in_list(bool value = true, bool empty = false);

  /** Set arrows keys to change value
   * Up and down will scroll through the list items.
   * Useful when there is a small list of value that the
   * list must have.
   *
   * {\parm arrows_on} - true indicates the arrow keys scroll.
   */
  
  /** 
   * Specifies if the arrow (cursor) keys can be used to step through the items in
   * the list. This is on by default.
   * 
   * @param val <tt>true</tt> if the arrow keys can be used to step through the items in the list.
   */
  void set_use_arrows(bool arrows_on = true);

  /** Set arrows keys to change if value not in list
   * Up and down will scroll through the list items but only
   * change the current value if the text does not match a list item..
   * Useful when there is a small list of value that the
   * list must have.
   *
   * {\parm arrows_always} - true indicates the value will change.
   */
  
  /** 
   * Specifies if the arrow keys will still work even if the current contents of the
   * Gtk::Entry field do not match any of the list items. 
   * 
   * 
   * the Gtk::Entry field do not match any of the list items.
   * @param val <tt>true</tt> if the arrow keys will still work even if the current contents of.
   */
  void set_use_arrows_always(bool arrows_always = true);

  /** Sets list case sensitive
   * Determines if the list items and text comparisons for
   * {set_use_arrows_always()} should be case sensitive.
   */
  
  /** 
   * Specifies whether the text entered into the Gtk::Entry field and the text in
   * the list items is case sensitive.
   * 
   * 
   * This may be useful, for example, when you have called
   * set_value_in_list() to limit the values entered, but you are not
   * worried about differences in case.
   * 
   * @param val <tt>true</tt> if the text in the list items is case sensitive.
   */
  void set_case_sensitive(bool val = true);

  /** Set the current entry Glib::ustring
   * Call this function on an item if it isn't a label or you
   * want it to have a different value to be displayed in the entry
   */
  //_WRAP_METHOD(void set_item_string(Gtk::Item& item, const Glib::ustring& item_value), gtk_combo_set_item_string)
  //void remove_item_string(Gtk::Item& item);

  /// Insert a list of items.
  
  /** 
   * Convenience function to set all of the items in the popup list.
   * (See the example above.)
   * 
   * @param strings A list of strings.
   */
  void set_popdown_strings(const Glib::ListHandle<Glib::ustring>& strings);

  Glib::ListHandle<Glib::ustring> get_popdown_strings() const;

  
  /** 
   * Stops the Gtk::Combo widget from showing the popup list when the Gtk::Entry
   * emits the "activate" signal, i.e.\ when the Return key is pressed.
   * This may be useful if, for example, you want the Return key to close a dialog
   * instead.
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkCombo:enable-arrow-keys ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkCombo:enable-arrows-always ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkCombo:case-sensitive ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkCombo:allow-empty ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkCombo:value-in-list ##### --&gt;
   * 
   * 
   * 
   */
  void disable_activate();

  Entry* get_entry();
  const Entry* get_entry() const;
  //_MEMBER_GET_PTR(list,list,List*,GtkWidget*)

  Glib::PropertyProxy<bool> property_enable_arrow_keys();

  Glib::PropertyProxy<bool> property_enable_arrows_always();

  Glib::PropertyProxy<bool> property_case_sensitive();

  Glib::PropertyProxy<bool> property_allow_empty();

  Glib::PropertyProxy<bool> property_value_in_list();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Combo */
  Gtk::Combo* wrap(GtkCombo* object, bool take_copy = false);
}
#endif /* _GTKMM_COMBO_H */

