// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_CURVE_H
#define _GTKMM_CURVE_H

#include <glibmm.h>

/* $Id: curve.hg,v 1.18 2002/07/08 15:17:30 murrayc Exp $ */

/* curve.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/arrayhandle.h>
#include <gtkmm/box.h>
#include <gtkmm/drawingarea.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkCurve GtkCurve;
typedef struct _GtkCurveClass GtkCurveClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Curve_Class; } // namespace Gtk
#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkGammaCurve GtkGammaCurve;
typedef struct _GtkGammaCurveClass GtkGammaCurveClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class GammaCurve_Class; } // namespace Gtk
namespace Gtk
{

/** Allows direct editing of a curve.
 *
 * @ingroup Widgets
 */

class Curve : public DrawingArea
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Curve CppObjectType;
  typedef Curve_Class CppClassType;
  typedef GtkCurve BaseObjectType;
  typedef GtkCurveClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Curve();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Curve_Class;
  static CppClassType curve_class_;

  // noncopyable
  Curve(const Curve&);
  Curve& operator=(const Curve&);

protected:
  explicit Curve(const Glib::ConstructParams& construct_params);
  explicit Curve(GtkCurve* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkCurve*       gobj()       { return reinterpret_cast<GtkCurve*>(gobject_); }
  const GtkCurve* gobj() const { return reinterpret_cast<GtkCurve*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_curve_type_changed();


private:

  
public:

  Curve();
  

  /** &lt;para&gt;
   * Resets the curve to a straight line from the minimum x & y values to the
   * maximum x & y values (i.e.\ from the bottom-left to the top-right corners).
   * The curve type is not changed.
   * &lt;/para&gt;
   */
  void reset();
  
  /** &lt;para&gt;
   * Recomputes the entire curve using the given gamma value.
   * A gamma value of 1 results in a straight line. Values greater than 1 result
   * in a curve above the straight line. Values less than 1 result in a curve
   * below the straight line. The curve type is changed to %GTK_CURVE_TYPE_FREE.
   * FIXME: Needs a more precise definition of gamma.
   * &lt;/para&gt;
   * @param gamma The gamma value.
   */
  void set_gamma(float gamma);
  
  /** &lt;para&gt;
   * Sets the minimum and maximum x & y values of the curve.
   * The curve is also reset with a call to gtk_curve_reset().
   * &lt;/para&gt;
   * @param min_x The minimum x value.
   * @param max_x The maximum x value.
   * @param min_y The minimum y value.
   * @param max_y The maximum y value.
   */
  void set_range(float min_x, float max_x, float min_y, float max_y);
  
  /** &lt;para&gt;
   * Returns a vector of points representing the curve.
   * &lt;/para&gt;
   * @param veclen The number of points to calculate.
   * @param vector Returns the points.
   */
  void get_vector(int veclen, float* data) const;

  Glib::ArrayHandle<float> get_vector(int veclen) const;
  void set_vector(const Glib::ArrayHandle<float>& array);

  
  /** &lt;para&gt;
   * Sets the type of the curve. The curve will remain unchanged except when
   * changing from a free curve to a linear or spline curve, in which case the
   * curve will be changed as little as possible.
   * &lt;/para&gt;
   * 
   * 
   * 
   * &lt;!-- ##### SIGNAL GtkCurve::curve-type-changed ##### --&gt;
   * &lt;para&gt;
   * Emitted when the curve type has been changed.
   * The curve type can be changed explicitly with a call to
   * gtk_curve_set_curve_type(). It is also changed as a side-effect of
   * calling gtk_curve_reset() or gtk_curve_set_gamma().
   * &lt;/para&gt;
   * 
   * 
   * &lt;!-- ##### ARG GtkCurve:curve-type ##### --&gt;
   * &lt;para&gt;
   * 
   * &lt;/para&gt;
   * 
   * &lt;!-- ##### ARG GtkCurve:min-x ##### --&gt;
   * &lt;para&gt;
   * 
   * &lt;/para&gt;
   * 
   * &lt;!-- ##### ARG GtkCurve:max-x ##### --&gt;
   * &lt;para&gt;
   * 
   * &lt;/para&gt;
   * 
   * &lt;!-- ##### ARG GtkCurve:min-y ##### --&gt;
   * &lt;para&gt;
   * 
   * &lt;/para&gt;
   * 
   * &lt;!-- ##### ARG GtkCurve:max-y ##### --&gt;
   * &lt;para&gt;
   * 
   * &lt;/para&gt;
   * @param type The type of the curve.
   */
  void set_curve_type(CurveType type);

  
  /**
   * @par Prototype:
   * <tt>void %curve_type_changed()</tt>
   */
  Glib::SignalProxy0<void> signal_curve_type_changed();


  Glib::PropertyProxy<CurveType> property_curve_type();

  Glib::PropertyProxy<float> property_min_x();

  Glib::PropertyProxy<float> property_max_x();

  Glib::PropertyProxy<float> property_min_y();

  Glib::PropertyProxy<float> property_max_y();


};

/** A subclass of Gtk::Curve for editing gamma curves.
 *
 * @ingroup Widgets
 */

class GammaCurve : public VBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef GammaCurve CppObjectType;
  typedef GammaCurve_Class CppClassType;
  typedef GtkGammaCurve BaseObjectType;
  typedef GtkGammaCurveClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~GammaCurve();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class GammaCurve_Class;
  static CppClassType gammacurve_class_;

  // noncopyable
  GammaCurve(const GammaCurve&);
  GammaCurve& operator=(const GammaCurve&);

protected:
  explicit GammaCurve(const Glib::ConstructParams& construct_params);
  explicit GammaCurve(GtkGammaCurve* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkGammaCurve*       gobj()       { return reinterpret_cast<GtkGammaCurve*>(gobject_); }
  const GtkGammaCurve* gobj() const { return reinterpret_cast<GtkGammaCurve*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:
  GammaCurve();
  

};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Curve */
  Gtk::Curve* wrap(GtkCurve* object, bool take_copy = false);
}
namespace Glib
{
  /** @relates Gtk::GammaCurve */
  Gtk::GammaCurve* wrap(GtkGammaCurve* object, bool take_copy = false);
}
#endif /* _GTKMM_CURVE_H */

