// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_EDITABLE_H
#define _GTKMM_EDITABLE_H

#include <glibmm.h>

/* $Id: editable.hg,v 1.23 2002/07/08 15:17:30 murrayc Exp $ */

/* Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>
#include <gtk/gtkeditable.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkEditable GtkEditable;
typedef struct _GtkEditableClass GtkEditableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Editable_Class; } // namespace Gtk
namespace Gtk
{

/** Base class for text-editing widgets.
 *
 * The Gtk::Editable class is a base class for widgets for editing text,
 * such as Gtk::Entry. It cannot be instantiated by itself. The editable
 * class contains functions for generically manipulating an editable widget,
 * a large number of action signals used for key bindings, and several
 * signals that an application can connect to to modify the behavior of a
 * widget.
 *
 */

class Editable : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Editable CppObjectType;
  typedef Editable_Class CppClassType;
  typedef GtkEditable BaseObjectType;
  typedef GtkEditableClass BaseClassType;

private:
  friend class Editable_Class;
  static CppClassType editable_class_;

  // noncopyable
  Editable(const Editable&);
  Editable& operator=(const Editable&);

protected:
  Editable(); // you must derive from this class
  explicit Editable(GtkEditable* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Editable();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkEditable*       gobj()       { return reinterpret_cast<GtkEditable*>(gobject_); }
  const GtkEditable* gobj() const { return reinterpret_cast<GtkEditable*>(gobject_); }

private:


public:
  
  /** 
   * Causes the characters in the current selection to
   * be copied to the clipboard and then deleted from
   * the widget.
   * 
   */
  void cut_clipboard();
  
  /** 
   * Causes the characters in the current selection to
   * be copied to the clipboard.
   * 
   */
  void copy_clipboard();
  
  /** 
   * Causes the contents of the clipboard to be pasted into
   * the given widget at the current cursor position.
   * 
   */
  void paste_clipboard();
  
  /** 
   * Deletes the current contents of the widgets selection and
   * disclaims the selection.
   * 
   */
  void delete_selection();
  
  /** 
   * Determines if the user can edit the text in the editable
   * widget or not.
   * 
   * 
   *   in the widget.
   * @param is_editable <tt>true</tt> if the user is allowed to edit the text.
   */
  void set_editable(bool is_editable = true);
  
  /** Retrieves whether @a editable is editable. See
   * gtk_editable_set_editable().
   * 
   * 
   * 
   * 
   * 
   * 
   * 
   * &lt;!-- ##### SIGNAL GtkEditable::changed ##### --&gt;
   * 
   * Indicates that the user has changed the contents
   * of the widget.
   * 
   * 
   * 
   * &lt;!-- ##### SIGNAL GtkEditable::delete-text ##### --&gt;
   * 
   * This signal is emitted when text is deleted from
   * the widget by the user. The default handler for
   * this signal will normally be responsible for inserting
   * the text, so by connecting to this signal and then
   * stopping the signal with gtk_signal_emit_stop(), it
   * is possible to modify the inserted text, or prevent
   * it from being inserted entirely. The @a start_pos
   * and @a end_pos parameters are interpreted as for
   * gtk_editable_delete_text()
   * 
   * 
   * 
   * &lt;!-- ##### SIGNAL GtkEditable::insert-text ##### --&gt;
   * 
   * This signal is emitted when text is inserted into
   * the widget by the user. The default handler for
   * this signal will normally be responsible for inserting
   * the text, so by connecting to this signal and then
   * stopping the signal with gtk_signal_emit_stop(), it
   * is possible to modify the inserted text, or prevent
   * it from being inserted entirely.
   * 
   * 
   *            this is an in-out paramter. After the signal
   *            emission is finished, it should point after   
   *            the newly inserted text.
   * @param start_pos The starting position.
   * @param end_pos The end position.
   * @param new_text The new text to insert.
   * @param new_text_length The length of the new text.
   * @param position The position at which to insert the new text.
   * @return <tt>true</tt> if @a editable is editable.
   */
  bool get_editable() const;

  
  /** 
   * Inserts text at a given position.
   * 
   * 
   *            the position at which to insert the text. After the
   *            call it points at the position after the newly
   *            inserted text.
   * @param new_text The text to insert.
   * @param new_text_length The length of the text to insert, in bytes.
   * @param position An inout parameter. The caller initializes it to.
   */
  void insert_text(const Glib::ustring& text, int length, int& position);
  
  /** 
   * Deletes a sequence of characters. The characters that
   * are deleted are those characters at positions from
   *  @a start_pos up to, but not including @a end_pos. If 
   *  @a end_pos is negative, then the the characters deleted
   * will be those characters from @a start_pos to the end
   * of the text.
   * 
   * @param start_pos The starting position.
   * @param end_pos The end position.
   */
  void delete_text(int start_pos, int end_pos);

  
  /** 
   * Retrieves a sequence of characters. The characters that
   * are retrieved are those characters at positions from
   *  @a start_pos up to, but not including @a end_pos. If 
   *  @a end_pos is negative, then the the characters retrieved
   * will be those characters from @a start_pos to the end
   * of the text.
   * 
   * 
   *           The result must be freed with Glib::free() when
   *           the application is finished with it.
   * @param start_pos The starting position.
   * @param end_pos The end position.
   * @return The characters in the indicated region.
   */
  Glib::ustring get_chars(int start_pos, int end_pos) const;

  
  /** 
   * Selects a region of text. The characters that
   * are selected are those characters at positions from
   *  @a start_pos up to, but not including @a end_pos. If 
   *  @a end_pos is negative, then the the characters selected
   * will be those characters from @a start_pos to the end
   * of the text.
   * 
   * @param start The starting position.
   * @param end The end position.
   */
  void select_region(int start_pos, int end_pos);
  
  /** 
   * Gets the current selection bounds, if there is a selection.
   * 
   * @param start Location to store the starting position, or <tt>0</tt>.
   * @param end Location to store the end position, or <tt>0</tt>.
   * @return <tt>true</tt> if there is a selection.
   */
  bool get_selection_bounds(int& start_pos, int& end_pos) const;

  
  /** 
   * Sets the cursor position.
   * 
   * 
   *            before the character with the given (base 0) index
   *            in the widget. The value must be less than or
   *            equal to the number of characters in the widget.
   *            A value of -1 indicates that the position should
   *            be set after the last character in the entry.
   *            Note that this position is in characters, not in
   *            bytes.
   * @param position The position of the cursor. The cursor is displayed.
   */
  void set_position(int position);
  
  /** 
   * Retrieves the current cursor position.
   * 
   * 
   *            before the character with the given (base 0) index
   *            in the widget. The value will be less than or
   *            equal to the number of characters in the widget.
   *            Note that this position is in characters, not in
   *            bytes.
   * @return The position of the cursor. The cursor is displayed.
   */
  int get_position() const;

  
      /**
       * @param const Glib::ustring& text
       * @param int* position
       * @return void
       */
  Glib::SignalProxy2<void,const Glib::ustring&,int*> signal_insert_text();

    
  /**
   * @par Prototype:
   * <tt>void %delete_text(int start_pos, int end_pos)</tt>
   */
  Glib::SignalProxy2<void,int,int> signal_delete_text();

  
  /**
   * @par Prototype:
   * <tt>void %changed()</tt>
   */
  Glib::SignalProxy0<void> signal_changed();


protected:


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
  virtual void insert_text_vfunc(const Glib::ustring& text, int& position);
  virtual void delete_text_vfunc(int start_pos, int end_pos);
  virtual Glib::ustring get_chars_vfunc(int start_pos, int end_pos);
  virtual void select_region_vfunc(int start_pos, int end_pos);
  virtual bool get_selection_bounds_vfunc(int& start_pos, int& end_pos);
  virtual void set_position_vfunc(int position);
  virtual int get_position_vfunc();

  //Default Signal Handlers::
  virtual void on_insert_text(const Glib::ustring& text, int* position);
  virtual void on_delete_text(int start_pos, int end_pos);
  virtual void on_changed();


};

} // namespace Gtk


namespace Glib
{

/** @relates Gtk::Editable */
Glib::RefPtr<Gtk::Editable> wrap(GtkEditable* object, bool take_copy = false);

} // namespace Glib

#endif /* _GTKMM_EDITABLE_H */

