// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREEVIEWCOLUMN_H
#define _GTKMM_TREEVIEWCOLUMN_H

#include <glibmm.h>

/* $Id: treeviewcolumn.hg,v 1.36 2002/07/10 18:22:53 murrayc Exp $ */

/* Copyright(C) 2001 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/object.h>
#include <gtkmm/treeiter.h>
#include <gtkmm/widget.h>
#include <gdkmm/window.h>
//#include <gtkmm/cellrenderer.h>
#include <gtkmm/cellrenderertext.h>
#include <gtkmm/cellrendererpixbuf.h>
#include <gtkmm/cellrenderertoggle.h>
#include <gtkmm/treemodel.h>
#include <glibmm/listhandle.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTreeViewColumn GtkTreeViewColumn;
typedef struct _GtkTreeViewColumnClass GtkTreeViewColumnClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TreeViewColumn_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum TreeViewColumnSizing
{
  TREE_VIEW_COLUMN_GROW_ONLY,
  TREE_VIEW_COLUMN_AUTOSIZE,
  TREE_VIEW_COLUMN_FIXED
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TreeViewColumnSizing> : public Glib::Value_Enum<Gtk::TreeViewColumnSizing>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


namespace TreeViewColumn_CellRendererGeneration
{

template<class T_ModelColumnType> //e.g. bool or Glib::ustring.
CellRenderer* generate_cellrenderer()
{
  return new CellRendererText(); //the default - template specializations will use other renderers.
  //CellRendererText can render both strings and numerical values.
}

} //anoymous TreeViewColumn_CellRendererGeneration

/** Typdefed as Gtk::TreeView::Column.
 * This is a visible column in a Gtk::TreeView widget. It determines the geometry, type.
 *
 * @ingroup TreeView
*/

class TreeViewColumn : public Gtk::Object
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TreeViewColumn CppObjectType;
  typedef TreeViewColumn_Class CppClassType;
  typedef GtkTreeViewColumn BaseObjectType;
  typedef GtkTreeViewColumnClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TreeViewColumn();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class TreeViewColumn_Class;
  static CppClassType treeviewcolumn_class_;

  // noncopyable
  TreeViewColumn(const TreeViewColumn&);
  TreeViewColumn& operator=(const TreeViewColumn&);

protected:
  explicit TreeViewColumn(const Glib::ConstructParams& construct_params);
  explicit TreeViewColumn(GtkTreeViewColumn* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkTreeViewColumn*       gobj()       { return reinterpret_cast<GtkTreeViewColumn*>(gobject_); }
  const GtkTreeViewColumn* gobj() const { return reinterpret_cast<GtkTreeViewColumn*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_clicked();


private:

  
public:
  typedef TreeViewColumn Column;

  TreeViewColumn();

  explicit TreeViewColumn(const Glib::ustring& title);
  TreeViewColumn(const Glib::ustring& title, CellRenderer& cell);

  /** Create a default view column for the given model column type.
   */
  template<class T_ModelColumnType>
  TreeViewColumn(const Glib::ustring& title, const TreeModelColumn<T_ModelColumnType>& column);

  
  /** Packs the @a cell into the beginning column.  If @a expand is <tt>true</tt>, then the
   *  @a cell is allocated a share of all available space that the @a tree_column has.
   * 
   * 
   * 
   * @param cell The Gtk::CellRenderer.
   * @param expand <tt>true</tt> if @a cell is to be given extra space allocated to box.
   */
  void pack_start(CellRenderer& cell, bool expand = true);
  
  /** Packs the @a cell into the column.  If @a expand is <tt>true</tt>, then the @a cell is
   * allocated a share of all available space that the @a tree_column has.
   * 
   * 
   * 
   * @param cell The Gtk::CellRenderer.
   * @param expand <tt>true</tt> if @a cell is to be given extra space allocated to box.
   */
  void pack_end(CellRenderer& cell, bool expand = true);


  template<class T_ModelColumnType>
  void pack_start(const TreeModelColumn<T_ModelColumnType>& column, bool expand = true)
  {
    //Generate appropriate Renderer for the column:
    CellRenderer* pCellRenderer= manage( TreeViewColumn_CellRendererGeneration::generate_cellrenderer<T_ModelColumnType>() );

    //Use the renderer:
    pack_start(*pCellRenderer, expand);
    set_renderer(*pCellRenderer, column);
  }

  template<class T_ModelColumnType>
  void pack_end(const TreeModelColumn<T_ModelColumnType>& column, bool expand = true)
  {
    //Generate appropriate Renderer for the column:
    CellRenderer* pCellRenderer= manage( TreeViewColumn_CellRendererGeneration::generate_cellrenderer<T_ModelColumnType>() );

    //Use the renderer:
    pack_end(*pCellRenderer, expand);
    set_renderer(*pCellRenderer, column);
  }

  
  /** Unsets all the mappings on all renderers on the @a tree_column.
   * 
   * 
   * 
   */
  void clear();
  
  /** Returns a newly-allocated G::List of all the cell renderers in the column, 
   * in no particular order.  The list must be freed with Glib::list_free().
   * 
   * 
   * 
   * 
   * @return A list of Gtk::CellRenderers.
   */
  Glib::ListHandle<CellRenderer*> get_cell_renderers();
  
  /** Adds an attribute mapping to the list in @a tree_column.  The @a column is the
   * column of the model to get a value from, and the @a attribute is the
   * parameter on @a cell_renderer to be set from the value. So for example
   * if column 2 of the model contains strings, you could have the
   * "text" attribute of a Gtk::CellRendererText get its values from
   * column 2.
   * 
   * 
   * 
   * @param cell_renderer The Gtk::CellRenderer to set attributes on.
   * @param attribute An attribute on the renderer.
   * @param column The column position on the model to get the attribute from.
   */
  void add_attribute(CellRenderer& cell_renderer, const Glib::ustring& attribute, int column);

  void add_attribute(const Glib::PropertyProxy_Base& property, const TreeModelColumnBase& column);
  

  void set_renderer(Gtk::CellRenderer& renderer, const TreeModelColumnBase& column);

 // _WRAP_METHOD(void set_attributes(CellRenderer& cell_renderer, ...), )

  typedef SigC::Slot2<void, CellRenderer*, const Gtk::TreeModel::iterator&> SlotCellData;

  void set_cell_data_func(CellRenderer& cell_renderer, const SlotCellData& slot);
  void unset_cell_data_func(CellRenderer& cell_renderer);

  
  /** Clears all existing attributes previously set with
   * set_attributes().
   * 
   * 
   * 
   * @param cell_renderer A Gtk::CellRenderer to clear the attribute mapping on.
   */
  void clear_attributes(CellRenderer& cell_renderer);
  
  /** Sets the spacing field of @a tree_column, which is the number of pixels to
   * place between cell renderers packed into it.
   * 
   * 
   * 
   * @param spacing Distance between cell renderers in pixels.
   */
  void set_spacing(int spacing);
  
  /** Returns the spacing of @a tree_column.
   * 
   * 
   * 
   * 
   * @return The spacing of @a tree_column.
   */
  int get_spacing() const;
  
  /** Sets the visibility of @a tree_column.
   * 
   * 
   * 
   * @param visible <tt>true</tt> if the @a tree_column is visible.
   */
  void set_visible(bool visible = true);
  
  /** Returns <tt>true</tt> if @a tree_column is visible.
   * 
   * 
   * 
   * 
   * @return Whether the column is visible or not.  If it is visible, then
   * the tree will show the column.
   */
  bool get_visible() const;
  
  /** If @a resizable is <tt>true</tt>, then the user can explicitly resize the column by
   * grabbing the outer edge of the column button.  If resizable is TRUE and
   * sizing mode of the column is Gtk::TREE_VIEW_COLUMN_AUTOSIZE, then the sizing
   * mode is changed to Gtk::TREE_VIEW_COLUMN_GROW_ONLY.
   * 
   * 
   * 
   * @param resizable <tt>true</tt>, if the column can be resized.
   */
  void set_resizable(bool resizable = true);
  
  /** Returns T::RUE if the @a tree_column can be resized by the end user.
   * 
   * 
   * 
   * 
   * @return T::RUE, if the @a tree_column can be resized.
   */
  bool get_resizable() const;
  
  /** Sets the growth behavior of @a tree_column to @a type.
   * 
   * 
   * 
   * @param type The Gtk::TreeViewColumnSizing.
   */
  void set_sizing(TreeViewColumnSizing type);
  
  /** Returns the current type of @a tree_column.
   * 
   * 
   * 
   * 
   * @return The type of @a tree_column.
   */
  TreeViewColumnSizing get_sizing();
  
  /** Returns the current size of @a tree_column in pixels.
   * 
   * 
   * 
   * 
   * @return The current width of @a tree_column.
   */
  int get_width() const;
  
  /** Gets the fixed width of the column.  This value is only meaning may not be
   * the actual width of the column on the screen, just what is requested.
   * 
   * 
   * 
   * 
   * @return The fixed width of the column.
   */
  int get_fixed_width() const;
  
  /** Sets the size of the column in pixels.  This is meaningful only if the sizing
   * type is Gtk::TREE_VIEW_COLUMN_FIXED.  The size of the column is clamped to
   * the min/max width for the column.  Please note that the min/max width of the
   * column doesn't actually affect the "fixed_width" property of the widget, just
   * the actual size when displayed.
   * 
   * 
   * 
   * @param fixed_width The size to set @a tree_column to. Must be greater than 0.
   */
  void set_fixed_width(int fixed_width);
  
  /** Sets the minimum width of the @a tree_column.  If @a min_width is -1, then the
   * minimum width is unset.
   * 
   * 
   * 
   * @param min_width The minimum width of the column in pixels, or -1.
   */
  void set_min_width(int min_width);
  
  /** Returns the minimum width in pixels of the @a tree_column, or -1 if no minimum
   * width is set.
   * 
   * 
   * 
   * 
   * @return The minimum width of the @a tree_column.
   */
  int get_min_width() const;
  
  /** Sets the maximum width of the @a tree_column.  If @a max_width is -1, then the
   * maximum width is unset.  Note, the column can actually be wider than max
   * width if it's the last column in a view.  In this case, the column expands to
   * fill any extra space.
   * 
   * 
   * 
   * @param max_width The maximum width of the column in pixels, or -1.
   */
  void set_max_width(int max_width);
  
  /** Returns the maximum width in pixels of the @a tree_column, or -1 if no maximum
   * width is set.
   * 
   * 
   * 
   * 
   * @return The maximum width of the @a tree_column.
   */
  int get_max_width() const;
  
  /** Emits the "clicked" signal on the column.  This function will only work if
   *  @a tree_column is clickable.
   * 
   * 
   * 
   */
  void clicked();

  
  /** Sets the title of the @a tree_column.  If a custom widget has been set, then
   * this value is ignored.
   * 
   * 
   * 
   * @param title The title of the @a tree_column.
   */
  void set_title(const Glib::ustring& title);
  
  /** Returns the title of the widget.  This value should not be modified.
   * 
   * 
   * 
   * 
   * @return The title of the column.
   */
  Glib::ustring get_title() const;
  
  /** Sets the header to be active if @a active is <tt>true</tt>.  When the header is active,
   * then it can take keyboard focus, and can be clicked.
   * 
   * 
   * 
   * @param clickable <tt>true</tt> if the header is active.
   */
  void set_clickable(bool clickable = true);
  
  /** Returns <tt>true</tt> if the user can click on the header for the column.
   * 
   * 
   * 
   * 
   * @return <tt>true</tt> if user can click the column header.
   */
  bool get_clickable() const;
  
  /** Sets the widget in the header to be @a widget.  If widget is <tt>0</tt>, then the
   * header button is set with a Gtk::Label set to the title of @a tree_column.
   * 
   * 
   * 
   * @param widget A child Gtk::Widget, or <tt>0</tt>.
   */
  void set_widget(GtkWidget* widget);
  
  /** Returns the Gtk::Widget in the button on the column header.  If a custom
   * widget has not been set then <tt>0</tt> is returned.
   * 
   * 
   * 
   * 
   * @return The Gtk::Widget in the column header, or <tt>0</tt>.
   */
  Widget* get_widget();
  
  /** Sets the alignment of the title or custom widget inside the column header.
   * The alignment determines its location inside the button -- 0.0 for left, 0.5
   * for center, 1.0 for right.
   * 
   * 
   * 
   * @param xalign The alignment, which is between [0.0 and 1.0] inclusive.
   */
  void set_alignment(float xalign);
  
  /** Returns the current x alignment of @a tree_column.  This value can range
   * between 0.0 and 1.0.
   * 
   * 
   * 
   * 
   * @return The current alignent of @a tree_column.
   */
  float get_alignment() const;
  
  /** If @a reorderable is T::RUE, then the column can be reordered by the end user
   * dragging the header.
   * 
   * 
   * 
   * @param reorderable T::RUE, if the column can be reordered.
   */
  void set_reorderable(bool reorderable = true);
  
  /** Returns T::RUE if the @a tree_column can be reordered by the user.
   * 
   * 
   * 
   * 
   * @return T::RUE if the @a tree_column can be reordered by the user.
   */
  bool get_reorderable() const;

  
  /** Sets the logical @a sort_column_id that this column sorts on when this column 
   * is selected for sorting.  Doing so makes the column header clickable.
   * 
   * 
   * 
   * @param sort_column_id The @a sort_column_id of the model to sort on.
   */
  void set_sort_column_id(int sort_column_id);
  
  /** Gets the logical @a sort_column_id that the model sorts on when this
   * column is selected for sorting. See set_sort_column_id().
   * 
   * 
   * 
   * 
   * @return The current @a sort_column_id for this column, or -1 if
   * this column can't be used for sorting.
   */
  int get_sort_column_id() const;
  
  /** Call this function with a @a setting of <tt>true</tt> to display an arrow in
   * the header button indicating the column is sorted. Call
   * set_sort_order() to change the direction of
   * the arrow.
   * 
   * 
   * 
   * 
   * @param setting <tt>true</tt> to display an indicator that the column is sorted.
   */
  void set_sort_indicator(bool setting);
  
  /** Gets the value set by set_sort_indicator().
   * 
   * 
   * 
   * 
   * @return Whether the sort indicator arrow is displayed.
   */
  bool get_sort_indicator() const;
  
  /** Changes the appearance of the sort indicator. 
   * 
   * This <em>does not</em> actually sort the model.  Use
   * set_sort_column_id() if you want automatic sorting
   * support.  This function is primarily for custom sorting behavior, and should
   * be used in conjunction with gtk_tree_sortable_set_sort_column() to do
   * that. For custom models, the mechanism will vary. 
   * 
   * The sort indicator changes direction to indicate normal sort or reverse sort.
   * Note that you must have the sort indicator enabled to see anything when 
   * calling this function; see set_sort_indicator().
   * 
   * 
   * 
   * @param order Sort order that the sort indicator should indicate.
   */
  void set_sort_order(SortType order);
  
  /** Gets the value set by set_sort_order().
   * 
   * 
   * 
   * 
   * @return The sort order the sort indicator is indicating.
   */
  SortType get_sort_order() const;


  /** Sets the cell renderer based on the @a tree_model and @a tree_node.  That is, for
   * every attribute mapping in @a tree_column, it will get a value from the set
   * column on the @a tree_node, and use that value to set the attribute on the cell
   * renderer.  This is used primarily by the Gtk::TreeView.
   * 
   * 
   * 
   * @param tree_model The Gtk::TreeModel to to get the cell renderers attributes from.
   * @param iter The Gtk::TreeIter to to get the cell renderer's attributes from.
   * @param is_expander <tt>true</tt>, if the row has children.
   * @param is_expanded <tt>true</tt>, if the row has visible children.
   */
  void cell_set_cell_data(const Glib::RefPtr<TreeModel>& tree_model, const TreeModel::iterator& iter, bool is_expander, bool is_expanded);
  
  /** Obtains the width and height needed to render the column.  This is used
   * primarily by the Gtk::TreeView.
   * 
   * 
   * 
   * @param cell_area The area a the column will be allocated, or <tt>0</tt>.
   * @param x_offset Location to return x offset of cell relative to @a cell_area, or <tt>0</tt>.
   * @param y_offset Location to return y offset of cell relative to @a cell_area, or <tt>0</tt>.
   * @param width Location to return width needed to render a cell, or <tt>0</tt>.
   * @param height Location to return height needed to render a cell, or <tt>0</tt>.
   */
  void cell_get_size(Gdk::Rectangle& cell_area, int& x_offset, int& y_offset, int& width, int& height) const;
  
  /** Returns T::RUE if any of the cells packed into the @a tree_column are visible.
   * For this to be meaningful, you must first initialize the cells with
   * cell_set_cell_data()
   * 
   * 
   * 
   * 
   * 
   * 
   * 
   * &lt;!-- ##### SIGNAL GtkTreeViewColumn::clicked ##### --&gt;
   * 
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:visible ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:resizable ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:width ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:sizing ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:fixed-width ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:min-width ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:max-width ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:title ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:clickable ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:widget ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:alignment ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:reorderable ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:sort-indicator ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkTreeViewColumn:sort-order ##### --&gt;
   * 
   * 
   * 
   * @param treeviewcolumn The object which received the signal.
   * @return T::RUE, if any of the cells packed into the @a tree_column are currently visible.
   */
  bool cell_is_visible() const;

  
  /**
   * @par Prototype:
   * <tt>void %clicked()</tt>
   */
  Glib::SignalProxy0<void> signal_clicked();


  Glib::PropertyProxy<bool> property_visible();

  Glib::PropertyProxy_ReadOnly<int> property_width();

  Glib::PropertyProxy<TreeViewColumnSizing> property_sizing();

  Glib::PropertyProxy<int> property_fixed_width();

  Glib::PropertyProxy<int> property_min_width();

  Glib::PropertyProxy<int> property_max_width();

  Glib::PropertyProxy<Glib::ustring> property_title();

  Glib::PropertyProxy<bool> property_clickable();

  Glib::PropertyProxy<Widget*> property_widget();

  Glib::PropertyProxy<float> property_alignment();

  Glib::PropertyProxy<bool> property_reorderable();

  Glib::PropertyProxy<bool> property_sort_indicator();

  Glib::PropertyProxy<SortType> property_sort_order();


#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  // Only necessary because of the templated ctor, see below.
  static const Glib::Class& class_init_();
#endif


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS

template <class T_ModelColumnType>
TreeViewColumn::TreeViewColumn(const Glib::ustring& title,
                               const TreeModelColumn<T_ModelColumnType>& column)
:
  Glib::ObjectBase(0), // not (yet) a custom class
  Gtk::Object(Glib::ConstructParams(class_init_(), "title", title.c_str(), (char*) 0))
{
  pack_start(column);
}

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::TreeViewColumn */
  Gtk::TreeViewColumn* wrap(GtkTreeViewColumn* object, bool take_copy = false);
}
#endif /* _GTKMM_TREEVIEWCOLUMN_H */

