/* $Id: accelkey.h,v 1.5 2002/07/13 15:58:35 murrayc Exp $ */
#ifndef _GTKMM_ACCELKEY_H
#define _GTKMM_ACCELKEY_H

/* menu_elems.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdkkeysyms.h>
#include <gdkmm/types.h>


namespace Gtk
{

namespace Menu_Helpers
{

/** Defines accelerator key combinations.
 * For instance, pressing Control-Q to activate the File|Quit menu item.
 * Typedefed as Gtk::Menu::AccelKey
 * @ingroup Menus
 */
class AccelKey
{
public:
  AccelKey();

 /** AccelKey constructor.
  * @param accel_mods For instance, Gdk::CONTROL_MASK
  * @param accel_key For instance, 'q'
  */
  AccelKey(Gdk::ModifierType accel_mods, guint accel_key, const Glib::ustring& accel_path = "");

  //See GTK+ docs for gtk_accelerator_parse() for the accelerator string format.
  /** AccelKey constructor.
   * @param accelerator For instance, "<control>q" - Use <control>, <shift>. <alt> and <release>. Use F1, F2, etc, for function keys.
   */
  AccelKey(const Glib::ustring& accelerator, const Glib::ustring& accel_path = "");

  AccelKey(const AccelKey& src);

  AccelKey& operator=(const AccelKey& src);

  guint get_key() const;
  Gdk::ModifierType get_mod() const;
  Glib::ustring get_path() const;
  bool is_null() const;
  Glib::ustring get_abbrev() const; //Get's the accelerator representation for labels.

protected:
  guint key_;
  Gdk::ModifierType mod_;
  Glib::ustring path_;
};

} /* namespace Menu_Helpers */

} /* namespace Gtk */

#endif //_GTKMM_ACCELKEY_H
