// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_ICONFACTORY_H
#define _GTKMM_ICONFACTORY_H

#include <glibmm.h>

/* $Id: iconfactory.hg,v 1.9 2002/04/18 15:23:14 murrayc Exp $ */

/* iconfactory.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtkmm/enums.h>
#include <gtkmm/object.h>
#include <gtkmm/enums.h>
#include <gtkmm/iconset.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkIconFactory GtkIconFactory;
typedef struct _GtkIconFactoryClass GtkIconFactoryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class IconFactory_Class; } // namespace Gtk
namespace Gtk
{


class IconFactory : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef IconFactory CppObjectType;
  typedef IconFactory_Class CppClassType;
  typedef GtkIconFactory BaseObjectType;
  typedef GtkIconFactoryClass BaseClassType;

private:
  friend class IconFactory_Class;
  static CppClassType iconfactory_class_;

  // noncopyable
  IconFactory(const IconFactory&);
  IconFactory& operator=(const IconFactory&);

protected:
  explicit IconFactory(const Glib::ConstructParams& construct_params);
  explicit IconFactory(GtkIconFactory* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~IconFactory();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkIconFactory*       gobj()       { return reinterpret_cast<GtkIconFactory*>(gobject_); }
  const GtkIconFactory* gobj() const { return reinterpret_cast<GtkIconFactory*>(gobject_); }

  GtkIconFactory* gobj_copy();

private:

   
protected:

  IconFactory();

public:
  
  static Glib::RefPtr<IconFactory> create();


  /** Adds the given @a icon_set to the icon factory, under the name
   *  @a stock_id.  @a stock_id should be namespaced for your application,
   * e.g. "myapp-whatever-icon".  Normally applications create a
   * Gtk::IconFactory, then add it to the list of default factories with
   * add_default(). Then they pass the @a stock_id to
   * widgets such as Gtk::Image to display the icon. Themes can provide
   * an icon with the same name (such as "myapp-whatever-icon") to
   * override your application's default icons. If an icon already
   * existed in @a factory for @a stock_id, it is unreferenced and replaced
   * with the new @a icon_set.
   * 
   * 
   * 
   * 
   * @param stock_id Icon name.
   * @param icon_set Icon set.
   */
  void add(const Glib::ustring& stock_id, IconSet& icon_set);
  
  /** Adds an icon factory to the list of icon factories searched by
   * Gtk::Style::lookup_icon_set(). This means that, for example,
   * Gtk::Image::new_from_stock() will be able to find icons in @a factory.
   * There will normally be an icon factory added for each library or
   * application that comes with icons. The default icon factories
   * can be overridden by themes.
   * 
   * 
   * 
   * 
   */
  void add_default();
  
  /** Removes an icon factory from the list of default icon
   * factories. Not normally used; you might use it for a library that
   * can be unloaded or shut down.
   * 
   * 
   * 
   * 
   */
  void remove_default();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::IconFactory */
  Glib::RefPtr<Gtk::IconFactory> wrap(GtkIconFactory* object, bool take_copy = false);
}


#endif /* _GTKMM_ICONFACTORY_H */

