// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gtkmm/style.h>
#include <gtkmm/private/style_p.h>

// -*- c++ -*-
/* $Id: style.ccg,v 1.23 2002/06/01 00:23:19 daniel Exp $ */

/* Copyright 1998-1999 The gtkmm Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>
#include <gtk/gtkstyle.h>


namespace Gtk
{

/* 
Design notes:

Okay these are my notes on how a GtkStyle works.
They are not meant to be taken as documentation as I didn't
write the code.  

styles keeps a copy of itself for each color depth.  Thus
changing a style after it has been attached wont work!

At allocation time a Gtk Style has 
  - all GC set to 0 as they will be allocated later
  - has all color values set to default values.
  - a ref count of 1 and an attach count of 0 (floating?)
  - a properly referenced font.
  - colormap and depth are invalid.
  - The style list and rcstyle are 0. (??? styles wasn't set explicitly!)

It returns to this state if the style is detatched from
all widgets.

Attach acts to sink the object removing it from the floating state.

attaching a style for the first time initializes it. 
Initializing a style
  - sets the colormap and depth.
  - sets the mid colors. (thus allowing user to set these would be pointless)
  - gets black and white from the colormap.
  - allocates all the colors.
  - uses gtk_gc_get to share a gc if there is a matching one.

Conclusions, we need to rework the concept of Gdk to allow
for const objects.  

*/

/*
Style*
Style::copy() const
{
  return (Style*)(gtk_style_copy(const_cast<GtkStyle*>(gobj())));
}
*/

void Style::set_font(const Pango::FontDescription& font_desc)
{
  g_return_if_fail(font_desc.gobj() != 0);

  // It will be freed when it goes out of scope.
  const Pango::FontDescription fontBefore (gobj()->font_desc, false);

  gobj()->font_desc = font_desc.gobj_copy();
}

Pango::FontDescription Style::get_font() const
{
  // Direct struct access seems the only way.
  return Pango::FontDescription(gobj()->font_desc, true); // true = make a copy.
}

void Style::set_background(const Glib::RefPtr<const Gdk::Window>& window, StateType state_type)
{
  gtk_style_set_background(const_cast<GtkStyle*>(gobj()),
      const_cast<GdkWindow*>(window->gobj()), (GtkStateType)state_type);
}

void Style::apply_default_background(const Glib::RefPtr<const Gdk::Window>& window,
				    bool set_bg,
				    StateType state_type,
				    const Gdk::Rectangle& area,
				    int x, int y,
				    int width, int height)
{
  gtk_style_apply_default_background(
      gobj(), const_cast<GdkWindow*>(window->gobj()), set_bg,
      (GtkStateType)state_type, const_cast<GdkRectangle*>(area.gobj()),
      x, y, width, height);
}

Glib::RefPtr<Gdk::GC> Style::get_fg_gc  ( StateType state_type)
{
  return Glib::wrap(gobj()->fg_gc[state_type], true);
}

Glib::RefPtr<Gdk::GC> Style::get_bg_gc  ( StateType state_type)
{
  return Glib::wrap(gobj()->bg_gc[state_type], true);
}

Glib::RefPtr<Gdk::GC> Style::get_light_gc( StateType state_type)
{
  return Glib::wrap(gobj()->light_gc[state_type], true);
}

Glib::RefPtr<Gdk::GC> Style::get_dark_gc( StateType state_type)
{
  return Glib::wrap(gobj()->dark_gc[state_type], true);
}

Glib::RefPtr<Gdk::GC> Style::get_mid_gc ( StateType state_type)
{
  return Glib::wrap(gobj()->mid_gc[state_type], true);
}

Glib::RefPtr<Gdk::GC> Style::get_text_gc( StateType state_type)
{
  return Glib::wrap(gobj()->text_gc[state_type], true);
}

Glib::RefPtr<Gdk::GC> Style::get_base_gc( StateType state_type)
{
  return Glib::wrap(gobj()->base_gc[state_type], true);
}

Gdk::Color Style::get_background(StateType state_type) const
{
  GdkColor* pGdkColor = const_cast<GdkColor*>(&(gobj()->bg[state_type]));
  return Glib::wrap(pGdkColor, true); //true = take_copy.
}

Glib::RefPtr<Gdk::Pixmap> Style::get_background_pixmap(StateType state_type)
{
  return Glib::wrap((GdkPixmapObject*) (gobj()->bg_pixmap[state_type]), true); //true = take_copy.
}

void Style::paint_polygon(const Glib::RefPtr<Gdk::Window>&      window,
                          StateType                             state_type,
                          ShadowType                            shadow_type,
                          const Gdk::Rectangle&                 area,
                          Widget&                               widget,
                          const Glib::ustring&                  detail,
                          const Glib::ArrayHandle<Gdk::Point>&  points,
                          bool                                  fill) const
{
  gtk_paint_polygon(
      const_cast<GtkStyle*>(gobj()),
      Glib::unwrap(window),
      (GtkStateType) state_type,
      (GtkShadowType) shadow_type,
      const_cast<GdkRectangle*>(area.gobj()),
      widget.gobj(),
      detail.c_str(),
      reinterpret_cast<GdkPoint*>(const_cast<Gdk::Point*>(points.data())),
      points.size(),
      fill);
}

} // namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::Style> wrap(GtkStyle* object, bool take_copy)
{
  return Glib::RefPtr<Gtk::Style>( dynamic_cast<Gtk::Style*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Style_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Style_Class::class_init_function;

    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually necessary?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_style_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void Style_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

}


Glib::ObjectBase* Style_Class::wrap_new(GObject* object)
{
  return new Style((GtkStyle*)object);
}


/* The implementation: */

GtkStyle* Style::gobj_copy()
{
  reference();
  return gobj();
}

Style::Style(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{}

Style::Style(GtkStyle* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

Style::~Style()
{}

Style::CppClassType Style::style_class_; // initialize static member

GType Style::get_type()
{
  return style_class_.init().get_type();
}

GType Style::get_base_type()
{
  return gtk_style_get_type();
}

void Style::set_bg(StateType state, const Gdk::Color& color)
{
  gobj()->bg[state] = *color.gobj();
}

Gdk::Color Style::get_bg(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->bg[state]), true);
}

void Style::set_light(StateType state, const Gdk::Color& color)
{
  gobj()->light[state] = *color.gobj();
}

Gdk::Color Style::get_light(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->light[state]), true);
}

void Style::set_dark(StateType state, const Gdk::Color& color)
{
  gobj()->dark[state] = *color.gobj();
}

Gdk::Color Style::get_dark(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->dark[state]), true);
}

void Style::set_mid(StateType state, const Gdk::Color& color)
{
  gobj()->mid[state] = *color.gobj();
}

Gdk::Color Style::get_mid(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->mid[state]), true);
}

void Style::set_base(StateType state, const Gdk::Color& color)
{
  gobj()->base[state] = *color.gobj();
}

Gdk::Color Style::get_base(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->base[state]), true);
}

void Style::set_fg(StateType state, const Gdk::Color& color)
{
  gobj()->fg[state] = *color.gobj();
}

Gdk::Color Style::get_fg(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->fg[state]), true);
}

void Style::set_text(StateType state, const Gdk::Color& color)
{
  gobj()->text[state] = *color.gobj();
}

Gdk::Color Style::get_text(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->text[state]), true);
}

void Style::set_text_aa(StateType state, const Gdk::Color& color)
{
  gobj()->text_aa[state] = *color.gobj();
}

Gdk::Color Style::get_text_aa(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->text_aa[state]), true);
}

Glib::RefPtr<Gdk::GC> Style::get_black_gc()
{
  Glib::RefPtr<Gdk::GC> ref_ptr(Glib::wrap(gobj()->black_gc));

  if(!ref_ptr.is_null())
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gdk::GC> Style::get_black_gc() const
{
  Glib::RefPtr<const Gdk::GC> ref_ptr(Glib::wrap(gobj()->black_gc));

  if(!ref_ptr.is_null())
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<Gdk::GC> Style::get_white_gc()
{
  Glib::RefPtr<Gdk::GC> ref_ptr(Glib::wrap(gobj()->white_gc));

  if(!ref_ptr.is_null())
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gdk::GC> Style::get_white_gc() const
{
  Glib::RefPtr<const Gdk::GC> ref_ptr(Glib::wrap(gobj()->white_gc));

  if(!ref_ptr.is_null())
    ref_ptr->reference();

  return ref_ptr;
}

void Style::paint_arrow(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, ArrowType arrow_type, bool fill, int x, int y, int width, int height) const
{
  gtk_paint_arrow(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), ((GtkArrowType)(arrow_type)), static_cast<int>(fill), x, y, width, height);
}

void Style::paint_box(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_box(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}

void Style::paint_box_gap(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height, PositionType gap_side, int gap_x, int gap_width) const
{
  gtk_paint_box_gap(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), const_cast<gchar*>(detail.c_str()), x, y, width, height, ((GtkPositionType)(gap_side)), gap_x, gap_width);
}

void Style::paint_check(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_check(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}

void Style::paint_diamond(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_diamond(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}

void Style::paint_extension(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height, PositionType gap_side) const
{
  gtk_paint_extension(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), const_cast<gchar*>(detail.c_str()), x, y, width, height, ((GtkPositionType)(gap_side)));
}

void Style::paint_flat_box(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_flat_box(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}

void Style::paint_focus(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_focus(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}

void Style::paint_handle(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height, Orientation orientation) const
{
  gtk_paint_handle(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height, ((GtkOrientation)(orientation)));
}

void Style::paint_hline(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x1, int x2, int y) const
{
  gtk_paint_hline(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x1, x2, y);
}

void Style::paint_option(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_option(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}

void Style::paint_shadow(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_shadow(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}

void Style::paint_shadow_gap(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height, PositionType gap_side, int gap_x, int gap_width) const
{
  gtk_paint_shadow_gap(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), const_cast<gchar*>(detail.c_str()), x, y, width, height, ((GtkPositionType)(gap_side)), gap_x, gap_width);
}

void Style::paint_slider(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height, Orientation orientation) const
{
  gtk_paint_slider(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height, ((GtkOrientation)(orientation)));
}

void Style::paint_tab(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_tab(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}

void Style::paint_vline(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int y1, int y2, int x) const
{
  gtk_paint_vline(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), y1, y2, x);
}

void Style::paint_expander(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, ExpanderStyle expander_style) const
{
  gtk_paint_expander(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, ((GtkExpanderStyle)(expander_style)));
}

void Style::paint_layout(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, bool use_text, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, const Glib::RefPtr<Pango::Layout>& layout) const
{
  gtk_paint_layout(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), static_cast<int>(use_text), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, Glib::unwrap(layout));
}

void Style::paint_resize_grip(const Glib::RefPtr<Gdk::Window>& window, StateType state_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, Gdk::WindowEdge edge, int x, int y, int width, int height) const
{
  gtk_paint_resize_grip(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), ((GdkWindowEdge)(edge)), x, y, width, height);
}


} // namespace Gtk


