// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gtkmm/textbuffer.h>
#include <gtkmm/private/textbuffer_p.h>

// -*- c++ -*-
/* $Id: textbuffer.ccg,v 1.23 2002/07/10 18:44:05 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtktextbuffer.h>
#include <glib/gslist.h>
#include <gtkmm/textmark.h>
#include <gtkmm/textiter.h>


namespace Gtk
{

TextBuffer::TextBuffer()
:
  Glib::ObjectBase(0), //Mark this class as gtkmmproc-generated, rather than a custom class, to allow vfunc optimisations.
  Glib::Object(Glib::ConstructParams(textbuffer_class_.init(), (char*) 0))
{
  gobj()->tag_table = 0; //Code copied from gtk+ function: See bugzilla.gnome.org bug #70227
}

TextBuffer::TextBuffer(const Glib::RefPtr<TagTable>& tag_table)
:
  Glib::ObjectBase(0), //Mark this class as gtkmmproc-generated, rather than a custom class, to allow vfunc optimisations.
  Glib::Object(Glib::ConstructParams(textbuffer_class_.init(), (char*) 0))
{
  // FIXME: We need to poke around in the internals, because GtkTextBuffer
  // lacks a "tag_table" property.  This won't be fixed before GTK+ 2.2.

  //Code copied from gtk+ function: See bugzilla.gnome.org bug #70227

  GtkTextTagTable* table_gobj = 0;

  //if(tag_table) //Older compilers seem to have problems with this. But surely we use this technique in lots of places. murrayc
  if(!tag_table.is_null())

  {
    table_gobj = tag_table->gobj_copy();
    table_gobj->buffers = g_slist_prepend(table_gobj->buffers, gobj());
  }

  gobj()->tag_table = table_gobj;
}

Glib::RefPtr<TextBuffer::Tag> TextBuffer::create_tag(const Glib::ustring& tag_name)
{
  //gtk_text_buffer_create_tag takes a varargs list of property names and values.
  //gtkmm coders should use the Tag.set_* method instead.
  return Glib::wrap(gtk_text_buffer_create_tag(gobj(), tag_name.c_str(), (char*)0), true); //true = take_copy.
  //We have to take a copy because gtk_text_buffer_create_tag() doesn't ref for us, for no real reason.
}

TextBuffer::iterator TextBuffer::get_iter_at_line_offset(int line_number, int char_offset)
{
  iterator iter;
  gtk_text_buffer_get_iter_at_line_offset(gobj(), iter.gobj(), line_number, char_offset);
  return iter;
}

TextBuffer::iterator TextBuffer::get_iter_at_line_index(int line_number, int byte_index)
{
  iterator iter;
  gtk_text_buffer_get_iter_at_line_index(gobj(), iter.gobj(), line_number, byte_index);
  return iter;
}

TextBuffer::iterator TextBuffer::get_iter_at_offset(int char_offset)
{
  iterator iter;
  gtk_text_buffer_get_iter_at_offset(gobj(), iter.gobj(), char_offset);
  return iter;
}

TextBuffer::iterator TextBuffer::get_iter_at_line(int line_number)
{
  iterator iter;
  gtk_text_buffer_get_iter_at_line(gobj(), iter.gobj(), line_number);
  return iter;
}

TextBuffer::iterator TextBuffer::begin()
{
  iterator iter;
  gtk_text_buffer_get_start_iter(gobj(), iter.gobj());
  return iter;
}

TextBuffer::iterator TextBuffer::end()
{
  iterator iter;
  gtk_text_buffer_get_end_iter(gobj(), iter.gobj());
  return iter;
}

void TextBuffer::get_bounds(iterator& start, iterator& end)
{
  gtk_text_buffer_get_bounds(gobj(), start.gobj(), end.gobj());
}

TextBuffer::iterator TextBuffer::get_iter_at_mark(const Glib::RefPtr<Mark>& mark)
{
  iterator iter;
  gtk_text_buffer_get_iter_at_mark(gobj(), iter.gobj(), mark->gobj());
  return iter;
}

void TextBuffer::get_selection_bounds(iterator& start, iterator& end)
{
  gtk_text_buffer_get_selection_bounds(gobj(), start.gobj(), end.gobj());
}

void TextBuffer::set_text(const Glib::ustring& text)
{
  gtk_text_buffer_set_text(gobj(), text.data(), text.bytes());
}

void TextBuffer::set_text(const char* text_begin, const char* text_end)
{
  gtk_text_buffer_set_text(gobj(), text_begin, text_end - text_begin);
}

TextBuffer::iterator TextBuffer::insert(const iterator& iter, const Glib::ustring& text)
{
  iterator iterCopy(iter); //gtk_text_buffer_insert() modifies the iterator, but that's not the STL way so we give it something that we don't mind it modifying.
  gtk_text_buffer_insert(gobj(), iterCopy.gobj(), text.data(), text.bytes());

  //According to the gtk_text_buffer_insert() docs, the "default signal handler revalidates it to point to the end of the inserted text".
  return iterCopy;
}

TextBuffer::iterator TextBuffer::insert(const iterator& iter, const char* text_begin, const char* text_end)
{
  iterator iterCopy(iter); //gtk_text_buffer_insert() modifies the iterator, but that's not the STL way so we give it something that we don't mind it modifying.
  gtk_text_buffer_insert(gobj(), iterCopy.gobj(), text_begin, text_end - text_begin);

  //According to the gtk_text_buffer_insert() docs, the "default signal handler revalidates it to point to the end of the inserted text".
  return iterCopy;
}

TextBuffer::iterator TextBuffer::insert_pixbuf(const iterator& iter, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)
{
  iterator iterCopy(iter);
  gtk_text_buffer_insert_pixbuf(gobj(), iterCopy.gobj(), pixbuf->gobj());
  return iterCopy;
}

void TextBuffer::insert_at_cursor(const Glib::ustring& text)
{
  gtk_text_buffer_insert_at_cursor(gobj(), text.data(), text.bytes());
}

void TextBuffer::insert_at_cursor(const char* text_begin, const char* text_end)
{
  gtk_text_buffer_insert_at_cursor(gobj(), text_begin, text_end - text_begin);
}

TextBuffer::iterator TextBuffer::insert_interactive(const iterator& iter, const Glib::ustring& text, bool default_editable)
{
  iterator iterCopy(iter);
  bool bSuccess = gtk_text_buffer_insert_interactive(gobj(), iterCopy.gobj(), text.data(), text.bytes(), default_editable);
  return ( bSuccess ? iterCopy :  end());
}

TextBuffer::iterator TextBuffer::insert_interactive(const iterator& iter, const char* text_begin, const char* text_end, bool default_editable)
{
  iterator iterCopy(iter);
  bool bSuccess =  gtk_text_buffer_insert_interactive(gobj(), iterCopy.gobj(), text_begin, text_end - text_begin, default_editable);
  return ( bSuccess ? iterCopy :  end());
}

bool TextBuffer::insert_interactive_at_cursor(const Glib::ustring& text, bool default_editable)
{
  return gtk_text_buffer_insert_interactive_at_cursor(gobj(), text.data(), text.bytes(), default_editable);
}

bool TextBuffer::insert_interactive_at_cursor(const char* text_begin, const char* text_end, bool default_editable)
{
  return gtk_text_buffer_insert_interactive_at_cursor(gobj(), text_begin, text_end - text_begin, default_editable);
}

TextBuffer::iterator TextBuffer::insert_with_tag(const iterator& iter, const Glib::ustring& text, const Glib::RefPtr<Tag>& tag)
{
  const int offset = iter.get_offset(); //gtk_text_buffer_insert_with_tags() invalidates the iterator, but this lets us recreate it later.

  iterator iterCopy(iter);
  gtk_text_buffer_insert_with_tags(gobj(), iterCopy.gobj(), text.data(), text.bytes(), tag->gobj(), (GtkTextTag*)0);

  return get_iter_at_offset(offset + text.size());
}

TextBuffer::iterator TextBuffer::insert_with_tag(const iterator& iter, const char* text_begin, const char* text_end,
                                 const Glib::RefPtr<Tag>& tag)
{
  const int offset = iter.get_offset(); //gtk_text_buffer_insert_with_tags() invalidates the iterator, but this lets us recreate it later.

  iterator iterCopy(iter);
  gtk_text_buffer_insert_with_tags(gobj(), iterCopy.gobj(), text_begin, text_end - text_begin, tag->gobj(), (GtkTextTag*)0);

  return get_iter_at_offset(offset + (text_end - text_begin));
}

TextBuffer::iterator TextBuffer::insert_with_tag(const iterator& iter, const Glib::ustring& text, const Glib::ustring& tag_name)
{
  const int offset = iter.get_offset(); //gtk_text_buffer_insert_with_tags() invalidates the iterator, but this lets us recreate it later.

  iterator iterCopy(iter);
  gtk_text_buffer_insert_with_tags_by_name(gobj(), iterCopy.gobj(), text.data(), text.bytes(), tag_name.c_str(), (char*)0);

  return get_iter_at_offset(offset + text.size());
}

TextBuffer::iterator TextBuffer::insert_with_tag(const iterator& iter, const char* text_begin, const char* text_end,
                                 const Glib::ustring& tag_name)
{
  const int offset = iter.get_offset(); //gtk_text_buffer_insert_with_tags() invalidates the iterator, but this lets us recreate it later.

  iterator iterCopy(iter);
  gtk_text_buffer_insert_with_tags_by_name(
      gobj(), iterCopy.gobj(), text_begin, text_end - text_begin, tag_name.c_str(), (char*)0);

  return get_iter_at_offset(offset + (text_end - text_begin));
}

TextBuffer::iterator TextBuffer::insert_with_tags(const iterator& iter, const Glib::ustring& text, const Glib::ArrayHandle< Glib::RefPtr<Tag> >& tags)
{
  const char *const text_begin = text.data();
  return insert_with_tags(iter, text_begin, text_begin + text.bytes(), tags);
}

TextBuffer::iterator TextBuffer::insert_with_tags(const iterator& iter, const char* text_begin, const char* text_end, const Glib::ArrayHandle< Glib::RefPtr<Tag> >& tags)
{
  const int start_offset = iter.get_offset();
  iterator iterReturn = insert(iter, text_begin, text_end);

  GtkTextIter start;
  gtk_text_buffer_get_iter_at_offset(gobj(), &start, start_offset);

  GtkTextTag *const *const tags_begin = tags.data();
  GtkTextTag *const *const tags_end   = tags_begin + tags.size();

  for(GtkTextTag *const * ptag = tags_begin; ptag != tags_end; ++ptag)
  {
    gtk_text_buffer_apply_tag(gobj(), *ptag, &start, iter.gobj());
  }

  return iterReturn;
}

TextBuffer::iterator TextBuffer::insert_with_tags_by_name(const iterator& iter, const Glib::ustring& text,
                                          const Glib::ArrayHandle<Glib::ustring>& tag_names)
{
  const char *const text_begin = text.data();
  return insert_with_tags_by_name(iter, text_begin, text_begin + text.bytes(), tag_names);
}

TextBuffer::iterator TextBuffer::insert_with_tags_by_name(const iterator& iter, const char* text_begin, const char* text_end,
                                          const Glib::ArrayHandle<Glib::ustring>& tag_names)
{
  //gtk_buffer_insert_with_tags_by_name() is a convenience wrapper, so it's kind of OK to reimplement it:

  const int start_offset = iter.get_offset();
  iterator iterNext = insert(iter, text_begin, text_end);

  GtkTextIter start;
  gtk_text_buffer_get_iter_at_offset(gobj(), &start, start_offset);

  GtkTextTagTable *const tag_table = gtk_text_buffer_get_tag_table(gobj());

  const char *const *const names_begin = tag_names.data();
  const char *const *const names_end  = names_begin + tag_names.size();

  for(const char *const * pname = names_begin; pname != names_end; ++pname)
  {
    if(GtkTextTag *const tag = gtk_text_tag_table_lookup(tag_table, *pname))
    {
      gtk_text_buffer_apply_tag(gobj(), tag, &start, iterNext.gobj());
    }
    else
    {
      g_warning("Gtk::TextBuffer::insert_with_tags_by_name(): no tag with name '%s'!", *pname);
      return get_iter_at_offset(start_offset + (text_end - text_begin)); //insert_with_tags() seems to invalidate the iterator, so we rebuild it.
    }
  }

  return iterNext;
}

TextBuffer::iterator TextBuffer::insert_range(const iterator& iter, const iterator& start, const iterator& end)
{
  iterator iterCopy(iter);
  gtk_text_buffer_insert_range(gobj(), iterCopy.gobj(), start.gobj(), end.gobj());
  return iterCopy;
}


TextBuffer::iterator TextBuffer::insert_range_interactive(const iterator& iter, const iterator& start, const iterator& end, bool default_editable)
{
  iterator iterCopy(iter);
  bool bSuccess = gtk_text_buffer_insert_range_interactive(gobj(), iterCopy.gobj(), start.gobj(), end.gobj(), (gboolean)default_editable);
  return ( bSuccess ? iterCopy :  TextBuffer::end() ); //Use "TextBuffer::" to avoid compiler confusion with the "end" input parameter.
}


TextBuffer::iterator TextBuffer::get_iter_at_child_anchor(const Glib::RefPtr<TextChildAnchor>& anchor)
{
  iterator iter;
  gtk_text_buffer_get_iter_at_child_anchor(gobj(), iter.gobj(), anchor->gobj());
  return iter;
}

int TextBuffer::size() const
{
  return get_char_count();
}

} /* namespace Gtk */


namespace
{


void TextBuffer_signal_insert_text_callback(GtkTextBuffer*, GtkTextIter* p0,const gchar* p1,gint p2,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot3<void,const TextBuffer::iterator&,const Glib::ustring&,int> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0)
,Glib::convert_const_gchar_ptr_to_ustring(p1)
,p2
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TextBuffer_signal_insert_text_info =
{
  "insert_text",
  (GCallback) &TextBuffer_signal_insert_text_callback,
  (GCallback) &TextBuffer_signal_insert_text_callback
};


void TextBuffer_signal_insert_pixbuf_callback(GtkTextBuffer*, GtkTextIter* p0,GdkPixbuf* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const TextBuffer::iterator&,const Glib::RefPtr<Gdk::Pixbuf>&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0)
,Glib::wrap(p1, true)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TextBuffer_signal_insert_pixbuf_info =
{
  "insert_pixbuf",
  (GCallback) &TextBuffer_signal_insert_pixbuf_callback,
  (GCallback) &TextBuffer_signal_insert_pixbuf_callback
};


void TextBuffer_signal_insert_child_anchor_callback(GtkTextBuffer*, GtkTextIter* p0,GtkTextChildAnchor* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const TextBuffer::iterator&,const Glib::RefPtr<TextChildAnchor>&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0)
,Glib::wrap(p1, true)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TextBuffer_signal_insert_child_anchor_info =
{
  "insert_child_anchor",
  (GCallback) &TextBuffer_signal_insert_child_anchor_callback,
  (GCallback) &TextBuffer_signal_insert_child_anchor_callback
};


void TextBuffer_signal_delete_range_callback(GtkTextBuffer*, GtkTextIter* p0,GtkTextIter* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const TextBuffer::iterator&,const TextBuffer::iterator&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0)
,Glib::wrap(p1)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TextBuffer_signal_delete_range_info =
{
  "delete_range",
  (GCallback) &TextBuffer_signal_delete_range_callback,
  (GCallback) &TextBuffer_signal_delete_range_callback
};


const Glib::SignalProxyInfo TextBuffer_signal_changed_info =
{
  "changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo TextBuffer_signal_modified_changed_info =
{
  "modified_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


void TextBuffer_signal_mark_set_callback(GtkTextBuffer*, const GtkTextIter* p0,GtkTextMark* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const TextBuffer::iterator&,const Glib::RefPtr<TextBuffer::Mark>&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0)
,Glib::wrap(p1, true)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TextBuffer_signal_mark_set_info =
{
  "mark_set",
  (GCallback) &TextBuffer_signal_mark_set_callback,
  (GCallback) &TextBuffer_signal_mark_set_callback
};


void TextBuffer_signal_mark_deleted_callback(GtkTextBuffer*, GtkTextMark* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,const Glib::RefPtr<TextBuffer::Mark>&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0, true)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TextBuffer_signal_mark_deleted_info =
{
  "mark_deleted",
  (GCallback) &TextBuffer_signal_mark_deleted_callback,
  (GCallback) &TextBuffer_signal_mark_deleted_callback
};


void TextBuffer_signal_apply_tag_callback(GtkTextBuffer*, GtkTextTag* p0,const GtkTextIter* p1,const GtkTextIter* p2,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot3<void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0, true)
,Glib::wrap(p1)
,Glib::wrap(p2)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TextBuffer_signal_apply_tag_info =
{
  "apply_tag",
  (GCallback) &TextBuffer_signal_apply_tag_callback,
  (GCallback) &TextBuffer_signal_apply_tag_callback
};


void TextBuffer_signal_remove_tag_callback(GtkTextBuffer*, GtkTextTag* p0,const GtkTextIter* p1,const GtkTextIter* p2,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot3<void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0, true)
,Glib::wrap(p1)
,Glib::wrap(p2)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TextBuffer_signal_remove_tag_info =
{
  "remove_tag",
  (GCallback) &TextBuffer_signal_remove_tag_callback,
  (GCallback) &TextBuffer_signal_remove_tag_callback
};


const Glib::SignalProxyInfo TextBuffer_signal_begin_user_action_info =
{
  "begin_user_action",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo TextBuffer_signal_end_user_action_info =
{
  "end_user_action",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::TextBuffer> wrap(GtkTextBuffer* object, bool take_copy)
{
  return Glib::RefPtr<Gtk::TextBuffer>( dynamic_cast<Gtk::TextBuffer*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& TextBuffer_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &TextBuffer_Class::class_init_function;

    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually necessary?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_text_buffer_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void TextBuffer_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->insert_text = &insert_text_callback;
  klass->insert_pixbuf = &insert_pixbuf_callback;
  klass->insert_child_anchor = &insert_child_anchor_callback;
  klass->delete_range = &delete_range_callback;
  klass->changed = &changed_callback;
  klass->modified_changed = &modified_changed_callback;
  klass->mark_set = &mark_set_callback;
  klass->mark_deleted = &mark_deleted_callback;
  klass->apply_tag = &apply_tag_callback;
  klass->remove_tag = &remove_tag_callback;
  klass->begin_user_action = &begin_user_action_callback;
  klass->end_user_action = &end_user_action_callback;
}


void TextBuffer_Class::insert_text_callback(GtkTextBuffer* self, GtkTextIter* p0, const gchar* p1, gint p2)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  //Non-gtkmmproc-generated custom classes implicitly call the default Glib::ObjectBase constructor,
  //which sets is_derived_. But gtkmmproc-generated classes can use this optimisation, which avoids
  //the unnecessary parameter conversions if there is no possibility of the virtual function being overridden:
  if(obj && obj->is_derived_())
  {
    try //Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      //Call the virtual member method, which derived classes might override.
      obj->on_insert_text(Glib::wrap(p0)
, Glib::convert_const_gchar_ptr_to_ustring(p1)
, p2
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->insert_text)
      (*base->insert_text)(self, p0, p1, p2);
  }
}

void TextBuffer_Class::insert_pixbuf_callback(GtkTextBuffer* self, GtkTextIter* p0, GdkPixbuf* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  //Non-gtkmmproc-generated custom classes implicitly call the default Glib::ObjectBase constructor,
  //which sets is_derived_. But gtkmmproc-generated classes can use this optimisation, which avoids
  //the unnecessary parameter conversions if there is no possibility of the virtual function being overridden:
  if(obj && obj->is_derived_())
  {
    try //Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      //Call the virtual member method, which derived classes might override.
      obj->on_insert_pixbuf(Glib::wrap(p0)
, Glib::wrap(p1, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->insert_pixbuf)
      (*base->insert_pixbuf)(self, p0, p1);
  }
}

void TextBuffer_Class::insert_child_anchor_callback(GtkTextBuffer* self, GtkTextIter* p0, GtkTextChildAnchor* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  //Non-gtkmmproc-generated custom classes implicitly call the default Glib::ObjectBase constructor,
  //which sets is_derived_. But gtkmmproc-generated classes can use this optimisation, which avoids
  //the unnecessary parameter conversions if there is no possibility of the virtual function being overridden:
  if(obj && obj->is_derived_())
  {
    try //Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      //Call the virtual member method, which derived classes might override.
      obj->on_insert_child_anchor(Glib::wrap(p0)
, Glib::wrap(p1, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->insert_child_anchor)
      (*base->insert_child_anchor)(self, p0, p1);
  }
}

void TextBuffer_Class::delete_range_callback(GtkTextBuffer* self, GtkTextIter* p0, GtkTextIter* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  //Non-gtkmmproc-generated custom classes implicitly call the default Glib::ObjectBase constructor,
  //which sets is_derived_. But gtkmmproc-generated classes can use this optimisation, which avoids
  //the unnecessary parameter conversions if there is no possibility of the virtual function being overridden:
  if(obj && obj->is_derived_())
  {
    try //Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      //Call the virtual member method, which derived classes might override.
      obj->on_delete_range(Glib::wrap(p0)
, Glib::wrap(p1)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->delete_range)
      (*base->delete_range)(self, p0, p1);
  }
}

void TextBuffer_Class::changed_callback(GtkTextBuffer* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  //Non-gtkmmproc-generated custom classes implicitly call the default Glib::ObjectBase constructor,
  //which sets is_derived_. But gtkmmproc-generated classes can use this optimisation, which avoids
  //the unnecessary parameter conversions if there is no possibility of the virtual function being overridden:
  if(obj && obj->is_derived_())
  {
    try //Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      //Call the virtual member method, which derived classes might override.
      obj->on_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->changed)
      (*base->changed)(self);
  }
}

void TextBuffer_Class::modified_changed_callback(GtkTextBuffer* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  //Non-gtkmmproc-generated custom classes implicitly call the default Glib::ObjectBase constructor,
  //which sets is_derived_. But gtkmmproc-generated classes can use this optimisation, which avoids
  //the unnecessary parameter conversions if there is no possibility of the virtual function being overridden:
  if(obj && obj->is_derived_())
  {
    try //Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      //Call the virtual member method, which derived classes might override.
      obj->on_modified_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->modified_changed)
      (*base->modified_changed)(self);
  }
}

void TextBuffer_Class::mark_set_callback(GtkTextBuffer* self, const GtkTextIter* p0, GtkTextMark* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  //Non-gtkmmproc-generated custom classes implicitly call the default Glib::ObjectBase constructor,
  //which sets is_derived_. But gtkmmproc-generated classes can use this optimisation, which avoids
  //the unnecessary parameter conversions if there is no possibility of the virtual function being overridden:
  if(obj && obj->is_derived_())
  {
    try //Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      //Call the virtual member method, which derived classes might override.
      obj->on_mark_set(Glib::wrap(p0)
, Glib::wrap(p1, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->mark_set)
      (*base->mark_set)(self, p0, p1);
  }
}

void TextBuffer_Class::mark_deleted_callback(GtkTextBuffer* self, GtkTextMark* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  //Non-gtkmmproc-generated custom classes implicitly call the default Glib::ObjectBase constructor,
  //which sets is_derived_. But gtkmmproc-generated classes can use this optimisation, which avoids
  //the unnecessary parameter conversions if there is no possibility of the virtual function being overridden:
  if(obj && obj->is_derived_())
  {
    try //Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      //Call the virtual member method, which derived classes might override.
      obj->on_mark_deleted(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->mark_deleted)
      (*base->mark_deleted)(self, p0);
  }
}

void TextBuffer_Class::apply_tag_callback(GtkTextBuffer* self, GtkTextTag* p0, const GtkTextIter* p1, const GtkTextIter* p2)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  //Non-gtkmmproc-generated custom classes implicitly call the default Glib::ObjectBase constructor,
  //which sets is_derived_. But gtkmmproc-generated classes can use this optimisation, which avoids
  //the unnecessary parameter conversions if there is no possibility of the virtual function being overridden:
  if(obj && obj->is_derived_())
  {
    try //Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      //Call the virtual member method, which derived classes might override.
      obj->on_apply_tag(Glib::wrap(p0, true)
, Glib::wrap(p1)
, Glib::wrap(p2)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->apply_tag)
      (*base->apply_tag)(self, p0, p1, p2);
  }
}

void TextBuffer_Class::remove_tag_callback(GtkTextBuffer* self, GtkTextTag* p0, const GtkTextIter* p1, const GtkTextIter* p2)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  //Non-gtkmmproc-generated custom classes implicitly call the default Glib::ObjectBase constructor,
  //which sets is_derived_. But gtkmmproc-generated classes can use this optimisation, which avoids
  //the unnecessary parameter conversions if there is no possibility of the virtual function being overridden:
  if(obj && obj->is_derived_())
  {
    try //Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      //Call the virtual member method, which derived classes might override.
      obj->on_remove_tag(Glib::wrap(p0, true)
, Glib::wrap(p1)
, Glib::wrap(p2)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->remove_tag)
      (*base->remove_tag)(self, p0, p1, p2);
  }
}

void TextBuffer_Class::begin_user_action_callback(GtkTextBuffer* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  //Non-gtkmmproc-generated custom classes implicitly call the default Glib::ObjectBase constructor,
  //which sets is_derived_. But gtkmmproc-generated classes can use this optimisation, which avoids
  //the unnecessary parameter conversions if there is no possibility of the virtual function being overridden:
  if(obj && obj->is_derived_())
  {
    try //Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      //Call the virtual member method, which derived classes might override.
      obj->on_begin_user_action();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->begin_user_action)
      (*base->begin_user_action)(self);
  }
}

void TextBuffer_Class::end_user_action_callback(GtkTextBuffer* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  //Non-gtkmmproc-generated custom classes implicitly call the default Glib::ObjectBase constructor,
  //which sets is_derived_. But gtkmmproc-generated classes can use this optimisation, which avoids
  //the unnecessary parameter conversions if there is no possibility of the virtual function being overridden:
  if(obj && obj->is_derived_())
  {
    try //Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      //Call the virtual member method, which derived classes might override.
      obj->on_end_user_action();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->end_user_action)
      (*base->end_user_action)(self);
  }
}


Glib::ObjectBase* TextBuffer_Class::wrap_new(GObject* object)
{
  return new TextBuffer((GtkTextBuffer*)object);
}


/* The implementation: */

GtkTextBuffer* TextBuffer::gobj_copy()
{
  reference();
  return gobj();
}

TextBuffer::TextBuffer(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{}

TextBuffer::TextBuffer(GtkTextBuffer* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

TextBuffer::~TextBuffer()
{}

TextBuffer::CppClassType TextBuffer::textbuffer_class_; // initialize static member

GType TextBuffer::get_type()
{
  return textbuffer_class_.init().get_type();
}

GType TextBuffer::get_base_type()
{
  return gtk_text_buffer_get_type();
}

Glib::RefPtr<TextBuffer> TextBuffer::create()
{
  return Glib::RefPtr<TextBuffer>( new TextBuffer() );
}
Glib::RefPtr<TextBuffer> TextBuffer::create(const Glib::RefPtr<TagTable>& tag_table)
{
  return Glib::RefPtr<TextBuffer>( new TextBuffer(tag_table) );
}
int TextBuffer::get_line_count() const
{
  return gtk_text_buffer_get_line_count(const_cast<GtkTextBuffer*>(gobj()));
}

int TextBuffer::get_char_count() const
{
  return gtk_text_buffer_get_char_count(const_cast<GtkTextBuffer*>(gobj()));
}

Glib::RefPtr<TextBuffer::TagTable> TextBuffer::get_tag_table()
{
  Glib::RefPtr<TextBuffer::TagTable> retvalue = Glib::wrap(gtk_text_buffer_get_tag_table(gobj()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void TextBuffer::delete_text(iterator& start, iterator& end)
{
  gtk_text_buffer_delete(gobj(), (start).gobj(), (end).gobj());
}

bool TextBuffer::delete_interactive_text(iterator& start_iter, iterator& end_iter, bool default_editable)
{
  return gtk_text_buffer_delete_interactive(gobj(), (start_iter).gobj(), (end_iter).gobj(), static_cast<int>(default_editable));
}

Glib::ustring TextBuffer::get_text(const iterator& start, const iterator& end, bool include_hidden_chars)
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_text_buffer_get_text(gobj(), (start).gobj(), (end).gobj(), static_cast<int>(include_hidden_chars)));
}

Glib::ustring TextBuffer::get_slice(const iterator& start, const iterator& end, bool include_hidden_chars)
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_text_buffer_get_slice(gobj(), (start).gobj(), (end).gobj(), static_cast<int>(include_hidden_chars)));
}

void TextBuffer::insert_child_anchor(iterator& iter, const Glib::RefPtr<TextChildAnchor>& anchor)
{
  gtk_text_buffer_insert_child_anchor(gobj(), (iter).gobj(), Glib::unwrap(anchor));
}

Glib::RefPtr<TextChildAnchor> TextBuffer::create_child_anchor(iterator& iter)
{
  Glib::RefPtr<TextChildAnchor> retvalue = Glib::wrap(gtk_text_buffer_create_child_anchor(gobj(), (iter).gobj()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<TextBuffer::Mark> TextBuffer::create_mark(const Glib::ustring& mark_name, const iterator& where, bool left_gravity)
{
  Glib::RefPtr<TextBuffer::Mark> retvalue = Glib::wrap(gtk_text_buffer_create_mark(gobj(), mark_name.c_str(), (where).gobj(), static_cast<int>(left_gravity)));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void TextBuffer::move_mark(const Glib::RefPtr<Mark>& mark, const iterator& where)
{
  gtk_text_buffer_move_mark(gobj(), Glib::unwrap(mark), (where).gobj());
}

void TextBuffer::delete_mark(const Glib::RefPtr<Mark>& mark)
{
  gtk_text_buffer_delete_mark(gobj(), Glib::unwrap(mark));
}

Glib::RefPtr<TextBuffer::Mark> TextBuffer::get_mark(const Glib::ustring& name)
{
  Glib::RefPtr<TextBuffer::Mark> retvalue = Glib::wrap(gtk_text_buffer_get_mark(gobj(), name.c_str()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void TextBuffer::move_mark_by_name(const Glib::ustring& name, const iterator& where)
{
  gtk_text_buffer_move_mark_by_name(gobj(), name.c_str(), (where).gobj());
}

void TextBuffer::delete_mark_by_name(const Glib::ustring& name)
{
  gtk_text_buffer_delete_mark_by_name(gobj(), name.c_str());
}

Glib::RefPtr<TextBuffer::Mark> TextBuffer::get_insert()
{
  Glib::RefPtr<TextBuffer::Mark> retvalue = Glib::wrap(gtk_text_buffer_get_insert(gobj()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<TextBuffer::Mark> TextBuffer::get_selection_bound()
{
  Glib::RefPtr<TextBuffer::Mark> retvalue = Glib::wrap(gtk_text_buffer_get_selection_bound(gobj()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void TextBuffer::place_cursor(const iterator& where)
{
  gtk_text_buffer_place_cursor(gobj(), (where).gobj());
}

void TextBuffer::apply_tag(const Glib::RefPtr<Tag>& tag, const iterator& start, const iterator& end)
{
  gtk_text_buffer_apply_tag(gobj(), Glib::unwrap(tag), (start).gobj(), (end).gobj());
}

void TextBuffer::remove_tag(const Glib::RefPtr<Tag>& tag, const iterator& start, const iterator& end)
{
  gtk_text_buffer_remove_tag(gobj(), Glib::unwrap(tag), (start).gobj(), (end).gobj());
}

void TextBuffer::apply_tag_by_name(const Glib::ustring& name, const iterator& start, const iterator& end)
{
  gtk_text_buffer_apply_tag_by_name(gobj(), name.c_str(), (start).gobj(), (end).gobj());
}

void TextBuffer::remove_tag_by_name(const Glib::ustring& name, const iterator& start, const iterator& end)
{
  gtk_text_buffer_remove_tag_by_name(gobj(), name.c_str(), (start).gobj(), (end).gobj());
}

void TextBuffer::remove_all_tags(const iterator& start, const iterator& end)
{
  gtk_text_buffer_remove_all_tags(gobj(), (start).gobj(), (end).gobj());
}

bool TextBuffer::get_modified() const
{
  return gtk_text_buffer_get_modified(const_cast<GtkTextBuffer*>(gobj()));
}

void TextBuffer::set_modified(bool setting)
{
  gtk_text_buffer_set_modified(gobj(), static_cast<int>(setting));
}

void TextBuffer::add_selection_clipboard(Clipboard& clipboard)
{
  gtk_text_buffer_add_selection_clipboard(gobj(), (clipboard).gobj());
}

void TextBuffer::remove_selection_clipboard(Clipboard& clipboard)
{
  gtk_text_buffer_remove_selection_clipboard(gobj(), (clipboard).gobj());
}

void TextBuffer::cut_clipboard(Clipboard& clipboard, bool default_editable)
{
  gtk_text_buffer_cut_clipboard(gobj(), (clipboard).gobj(), static_cast<int>(default_editable));
}

void TextBuffer::copy_clipboard(Clipboard& clipboard)
{
  gtk_text_buffer_copy_clipboard(gobj(), (clipboard).gobj());
}

void TextBuffer::paste_clipboard(Clipboard& clipboard, iterator& override_location, bool default_editable)
{
  gtk_text_buffer_paste_clipboard(gobj(), (clipboard).gobj(), (override_location).gobj(), static_cast<int>(default_editable));
}

bool TextBuffer::delete_selection(bool interactive, bool default_editable)
{
  return gtk_text_buffer_delete_selection(gobj(), static_cast<int>(interactive), static_cast<int>(default_editable));
}

void TextBuffer::begin_user_action()
{
  gtk_text_buffer_begin_user_action(gobj());
}

void TextBuffer::end_user_action()
{
  gtk_text_buffer_end_user_action(gobj());
}


Glib::SignalProxy3<void,const TextBuffer::iterator&,const Glib::ustring&,int> TextBuffer::signal_insert_text()
{
  return Glib::SignalProxy3<void,const TextBuffer::iterator&,const Glib::ustring&,int>(this, &TextBuffer_signal_insert_text_info);
}

Glib::SignalProxy2<void,const TextBuffer::iterator&,const Glib::RefPtr<Gdk::Pixbuf>&> TextBuffer::signal_insert_pixbuf()
{
  return Glib::SignalProxy2<void,const TextBuffer::iterator&,const Glib::RefPtr<Gdk::Pixbuf>&>(this, &TextBuffer_signal_insert_pixbuf_info);
}

Glib::SignalProxy2<void,const TextBuffer::iterator&,const Glib::RefPtr<TextChildAnchor>&> TextBuffer::signal_insert_child_anchor()
{
  return Glib::SignalProxy2<void,const TextBuffer::iterator&,const Glib::RefPtr<TextChildAnchor>&>(this, &TextBuffer_signal_insert_child_anchor_info);
}

Glib::SignalProxy2<void,const TextBuffer::iterator&,const TextBuffer::iterator&> TextBuffer::signal_delete_range()
{
  return Glib::SignalProxy2<void,const TextBuffer::iterator&,const TextBuffer::iterator&>(this, &TextBuffer_signal_delete_range_info);
}

Glib::SignalProxy0<void> TextBuffer::signal_changed()
{
  return Glib::SignalProxy0<void>(this, &TextBuffer_signal_changed_info);
}

Glib::SignalProxy0<void> TextBuffer::signal_modified_changed()
{
  return Glib::SignalProxy0<void>(this, &TextBuffer_signal_modified_changed_info);
}

Glib::SignalProxy2<void,const TextBuffer::iterator&,const Glib::RefPtr<TextBuffer::Mark>&> TextBuffer::signal_mark_set()
{
  return Glib::SignalProxy2<void,const TextBuffer::iterator&,const Glib::RefPtr<TextBuffer::Mark>&>(this, &TextBuffer_signal_mark_set_info);
}

Glib::SignalProxy1<void,const Glib::RefPtr<TextBuffer::Mark>&> TextBuffer::signal_mark_deleted()
{
  return Glib::SignalProxy1<void,const Glib::RefPtr<TextBuffer::Mark>&>(this, &TextBuffer_signal_mark_deleted_info);
}

Glib::SignalProxy3<void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator&> TextBuffer::signal_apply_tag()
{
  return Glib::SignalProxy3<void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator&>(this, &TextBuffer_signal_apply_tag_info);
}

Glib::SignalProxy3<void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator&> TextBuffer::signal_remove_tag()
{
  return Glib::SignalProxy3<void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator&>(this, &TextBuffer_signal_remove_tag_info);
}

Glib::SignalProxy0<void> TextBuffer::signal_begin_user_action()
{
  return Glib::SignalProxy0<void>(this, &TextBuffer_signal_begin_user_action_info);
}

Glib::SignalProxy0<void> TextBuffer::signal_end_user_action()
{
  return Glib::SignalProxy0<void>(this, &TextBuffer_signal_end_user_action_info);
}


void Gtk::TextBuffer::on_insert_text(const TextBuffer::iterator& pos, const Glib::ustring& text, int bytes)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->insert_text)
    (*base->insert_text)(gobj(),const_cast<GtkTextIter*>((pos).gobj()),text.c_str(),bytes);
}

void Gtk::TextBuffer::on_insert_pixbuf(const TextBuffer::iterator& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->insert_pixbuf)
    (*base->insert_pixbuf)(gobj(),const_cast<GtkTextIter*>((pos).gobj()),Glib::unwrap(pixbuf));
}

void Gtk::TextBuffer::on_insert_child_anchor(const TextBuffer::iterator& pos, const Glib::RefPtr<TextChildAnchor>& anchor)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->insert_child_anchor)
    (*base->insert_child_anchor)(gobj(),const_cast<GtkTextIter*>((pos).gobj()),Glib::unwrap(anchor));
}

void Gtk::TextBuffer::on_delete_range(const TextBuffer::iterator& start, const TextBuffer::iterator& end)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->delete_range)
    (*base->delete_range)(gobj(),const_cast<GtkTextIter*>((start).gobj()),const_cast<GtkTextIter*>((end).gobj()));
}

void Gtk::TextBuffer::on_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->changed)
    (*base->changed)(gobj());
}

void Gtk::TextBuffer::on_modified_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->modified_changed)
    (*base->modified_changed)(gobj());
}

void Gtk::TextBuffer::on_mark_set(const TextBuffer::iterator& location, const Glib::RefPtr<TextBuffer::Mark>& mark)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->mark_set)
    (*base->mark_set)(gobj(),(location).gobj(),Glib::unwrap(mark));
}

void Gtk::TextBuffer::on_mark_deleted(const Glib::RefPtr<TextBuffer::Mark>& mark)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->mark_deleted)
    (*base->mark_deleted)(gobj(),Glib::unwrap(mark));
}

void Gtk::TextBuffer::on_apply_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& start_char, const TextBuffer::iterator& end_char)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->apply_tag)
    (*base->apply_tag)(gobj(),Glib::unwrap(tag),(start_char).gobj(),(end_char).gobj());
}

void Gtk::TextBuffer::on_remove_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& start_char, const TextBuffer::iterator& end_char)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->remove_tag)
    (*base->remove_tag)(gobj(),Glib::unwrap(tag),(start_char).gobj(),(end_char).gobj());
}

void Gtk::TextBuffer::on_begin_user_action()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->begin_user_action)
    (*base->begin_user_action)(gobj());
}

void Gtk::TextBuffer::on_end_user_action()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->end_user_action)
    (*base->end_user_action)(gobj());
}


} // namespace Gtk


