// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gtkmm/toolbar.h>
#include <gtkmm/private/toolbar_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: toolbar.ccg,v 1.28 2002/11/25 10:11:53 murrayc Exp $ */

/* 
 *
 * Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glib.h>
#include <gtkmm/button.h>
#include <gtkmm/togglebutton.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/tooltips.h>
//#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtk/gtklabel.h>

namespace Gtk
{

namespace Toolbar_Helpers
{

/*********************************************************************
***** Item classes (This should be an easy and cool interface)
*********************************************************************/

Element::Element(const Element& other)
:
  type_                 (other.type_),
  widget_               (other.widget_),
  text_                 (other.text_),
  has_text_             (other.has_text_),
  stock_id_             (other.stock_id_),
  tooltip_text_         (other.tooltip_text_),
  tooltip_private_text_ (other.tooltip_private_text_),
  content_              (other.content_),
  callback_             (other.callback_),
  group_                (0)
{}

Element::Element(ToolbarChildType  type,
                                  Widget*              widget,
                                  const Glib::ustring& text,
                                  bool                 has_text,
                                  const Gtk::StockID&  stock_id,
                                  const Glib::ustring& tooltip_text,
                                  const Glib::ustring& tooltip_private_text,
                                  Widget*              content,
                                  const Callback0&     callback)
:
  type_                 (type),
  widget_               (widget),
  text_                 (text),
  has_text_             (has_text),
  stock_id_             (stock_id),
  tooltip_text_         (tooltip_text),
  tooltip_private_text_ (tooltip_private_text),
  content_              (content),
  callback_             (callback),
  group_                (0)
{}

Element::Element(Widget&         widget,
                                  const Glib::ustring& tooltip_text,
                                  const Glib::ustring& tooltip_private_text)
:
  type_                 (TOOLBAR_CHILD_WIDGET),
  widget_               (&widget),
  text_                 (),
  has_text_             (false),
  stock_id_             (Glib::ustring()),
  tooltip_text_         (tooltip_text),
  tooltip_private_text_ (tooltip_private_text),
  content_              (0),
  callback_             (),
  group_                (0)
{}

Space::Space()
:
  Element(TOOLBAR_CHILD_SPACE,
          0,
          Glib::ustring(),
          false,
          Gtk::StockID(Glib::ustring()),
          Glib::ustring(),
          Glib::ustring(),
          0,
          Callback0())
{}

StockElem::StockElem(const Gtk::StockID&   stock_id,
                     const Callback0&      callback,
                     const Glib::ustring&  tooltip_text,
                     const Glib::ustring&  tooltip_private_text)
:
  Element(TOOLBAR_CHILD_SPACE,
          0,
          Glib::ustring(),
          false,
          stock_id,
          tooltip_text,
          tooltip_private_text,
          0,
          callback)
{}

ButtonElem::ButtonElem(const Glib::ustring& text,
                                        Widget&         content,
                                        const Callback0&     callback,
                                        const Glib::ustring& tooltip_text,
                                        const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_BUTTON,
          0,
          text,
          true,
          Gtk::StockID(Glib::ustring()),
          tooltip_text,
          tooltip_private_text,
          &content,
          callback)
{}

ButtonElem::ButtonElem(const Glib::ustring& text,
                                        const Callback0&     callback,
                                        const Glib::ustring& tooltip_text,
                                        const Glib::ustring& tooltip_private_text)

:
  Element(TOOLBAR_CHILD_BUTTON,
          0,
          text,
          true,
          Gtk::StockID(Glib::ustring()),
          tooltip_text,
          tooltip_private_text,
          0,
          callback)
{}

ButtonElem::ButtonElem(Widget&         content,
                                        const Callback0&     callback,
                                        const Glib::ustring& tooltip_text,
                                        const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_BUTTON,
          0,
          Glib::ustring(),
          false,
          Gtk::StockID(Glib::ustring()),
          tooltip_text,
          tooltip_private_text,
          &content,
          callback)
{}

ToggleElem::ToggleElem(const Glib::ustring& text,
                                        Widget&         content,
                                        const Callback0&     callback,
                                        const Glib::ustring& tooltip_text,
                                        const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_TOGGLEBUTTON,
          0,
          text,
          true,
          Gtk::StockID(Glib::ustring()),
          tooltip_text,
          tooltip_private_text,
          &content,
          callback)
{}

ToggleElem::ToggleElem(const Glib::ustring& text,
                                        const Callback0&     callback,
                                        const Glib::ustring& tooltip_text,
                                        const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_TOGGLEBUTTON,
          0,
          text,
          true,
          Gtk::StockID(Glib::ustring()),
          tooltip_text,
          tooltip_private_text,
          0,
          callback)
{}

ToggleElem::ToggleElem(Widget&         content,
                                        const Callback0&     callback,
                                        const Glib::ustring& tooltip_text,
                                        const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_TOGGLEBUTTON,
          0,
          Glib::ustring(),
          false,
          Gtk::StockID(Glib::ustring()),
          tooltip_text,
          tooltip_private_text,
          &content,
          callback)
{}

RadioElem::RadioElem(RadioButton::Group&  group,
                                      const Glib::ustring& text,
                                      Widget&         content,
                                      const Callback0&     callback,
                                      const Glib::ustring& tooltip_text,
                                      const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_RADIOBUTTON,
          0,
          text,
          true,
          Gtk::StockID(Glib::ustring()),
          tooltip_text,
          tooltip_private_text,
          &content,
          callback)
{
  group_ = &group;
}

RadioElem::RadioElem(RadioButton::Group&  group,
                                      const Glib::ustring& text,
                                      const Callback0&     callback,
                                      const Glib::ustring& tooltip_text,
                                      const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_RADIOBUTTON,
          0,
          text,
          true,
          Gtk::StockID(Glib::ustring()),
          tooltip_text,
          tooltip_private_text,
          0,
          callback)
{
  group_ = &group;
}

RadioElem::RadioElem(RadioButton::Group&  group,
                                      Widget&         content,
                                      const Callback0&     callback,
                                      const Glib::ustring& tooltip_text,
                                      const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_RADIOBUTTON,
          0,
          Glib::ustring(),
          false,
          Gtk::StockID(Glib::ustring()),
          tooltip_text,
          tooltip_private_text,
          &content,
          callback)
{
  group_ = &group;
}


/*********************************************************************
***** List properties
*********************************************************************/
ToolList::iterator ToolList::insert(ToolList::iterator position, const Element& e)
{
  int pos = gparent()->num_children;

  // locate the items desired position
  if(position.node_)
    pos = g_list_position(glist(), position.node_);

  const char* text    = 0;
  const char* tooltip = 0;
  const char* tooltip_private = 0;
  Widget* w = NULL;

  if(e.has_text_)
    text = e.text_.c_str();

  if(!e.tooltip_text_.empty())
    tooltip = e.tooltip_text_.c_str();

  if(!e.tooltip_private_text_.empty())
    tooltip_private = e.tooltip_private_text_.c_str();

  // give item to gtk+
  if (e.stock_id_.get_string().empty ()) {
    w = Glib::wrap(
      gtk_toolbar_insert_element(gparent(),
                                 (GtkToolbarChildType)e.type_,
                                 ((e.widget_) ? e.widget_->gobj() : 0),
                                 text, tooltip, tooltip_private,
                                 ((e.content_) ? e.content_->gobj() : 0),
                                 0, 0,
                                 pos));
  } else {
    w = Glib::wrap(
      gtk_toolbar_insert_stock(gparent(),
                               e.stock_id_.get_string().c_str(),
                               tooltip, tooltip_private,
                               0, 0,
                               pos));
  }

  if(e.group_ && w)
  {
    RadioButton* rb = dynamic_cast<RadioButton*>(w);
    rb->set_group(*e.group_);
    *(e.group_) = rb->get_group(); // TODO: What is this for?
  }

  // connect slot
  if(e.callback_ && w)
  {
    if(Button* btn = dynamic_cast<Button*>(w))
      btn->signal_clicked().connect(e.callback_);
  }

  // return the right iterator
  if(pos == 0)
    return begin();

  if(!position.node_)
    return --end();

  return --position;
}


ToolList::iterator ToolList::erase(ToolList::iterator position)
{
  if(!position.node_)
    return end();

  iterator next = position;
  ++next;

  if(position->get_type() == TOOLBAR_CHILD_SPACE)
  {
    gtk_toolbar_remove_space(gparent(), g_list_position(glist(), position.node_));
  }
  else
  {
    gtk_container_remove(
        reinterpret_cast<GtkContainer*>(gparent()),
        position->get_widget()->gobj());
  }

  return next;
}

void ToolList::remove(const_reference t)
{
  erase(find(t));
}

void ToolList::remove(Widget& widget)
{
  gtk_container_remove(
      reinterpret_cast<GtkContainer*>(gparent()), widget.gobj());
}

ToolbarChildType Tool::get_type() const
{
  return (ToolbarChildType) type;
}

Widget* Tool::get_widget() const
{
  return Glib::wrap(widget);
}

Widget* Tool::get_content() const
{
  return Glib::wrap(icon);
}

Label* Tool::get_label() const
{
  return Glib::wrap(reinterpret_cast<GtkLabel*>(label));
}

} // namespace Toolbar_Helpers


Toolbar::ToolList& Toolbar::tools()
{
  tools_proxy_ = ToolList(gobj());
  return tools_proxy_;
}

const Toolbar::ToolList& Toolbar::tools() const
{
  tools_proxy_ =  ToolList(const_cast<GtkToolbar*>(gobj()));
  return tools_proxy_;
}


//Non-STL-style interface:

namespace //anonymous
{
  
// This Signal Proxy allows the C++ coder to specify
// a SigC::Slot instead of a static function.
class SignalProxy_ToolbarCallback
{
public:
  typedef Gtk::Toolbar::Callback0 SlotType;

  SignalProxy_ToolbarCallback(const SlotType& slot) : slot_(slot) {}
  ~SignalProxy_ToolbarCallback();

  static void gtk_callback(void* data);

  static void gtk_callback_destroy(void* data);

private:
  SlotType slot_;
};

SignalProxy_ToolbarCallback::~SignalProxy_ToolbarCallback()
{}

void SignalProxy_ToolbarCallback::gtk_callback(void* data)
{
  SignalProxy_ToolbarCallback *const self = static_cast<SignalProxy_ToolbarCallback*>(data);

  try
  {
    (self->slot_)();
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

void SignalProxy_ToolbarCallback::gtk_callback_destroy(void* data)
{
  delete static_cast<SignalProxy_ToolbarCallback*>(data);
}

} // anonymous namespace


Gtk::Widget* Toolbar::append_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
  Gtk::Widget& icon, Callback0 slot)
{
  SignalProxy_ToolbarCallback* pProxy = new SignalProxy_ToolbarCallback(slot);
  GtkWidget* cwidget = gtk_toolbar_append_item(gobj(), text.c_str(), tooltip_text.c_str(), tooltip_private_text.c_str(), icon.gobj(), GTK_SIGNAL_FUNC(SignalProxy_ToolbarCallback::gtk_callback), pProxy);
  g_signal_connect(G_OBJECT(cwidget), "destroy", G_CALLBACK(SignalProxy_ToolbarCallback::gtk_callback_destroy), pProxy); //Delete the callback proxy when the widget is destroyed.
  return Glib::wrap(cwidget);
}

Gtk::Widget* Toolbar::append_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
  Callback0 slot)
{
  SignalProxy_ToolbarCallback* pProxy = new SignalProxy_ToolbarCallback(slot);
  GtkWidget* cwidget = gtk_toolbar_append_item(gobj(), text.c_str(), tooltip_text.c_str(), tooltip_private_text.c_str(), 0, GTK_SIGNAL_FUNC(SignalProxy_ToolbarCallback::gtk_callback), pProxy);
  g_signal_connect(G_OBJECT(cwidget), "destroy", G_CALLBACK(SignalProxy_ToolbarCallback::gtk_callback_destroy), pProxy); //Delete the callback proxy when the widget is destroyed.
  return Glib::wrap(cwidget);
}

Gtk::Widget* Toolbar::prepend_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
  Gtk::Widget& icon, Callback0 slot)
{
  SignalProxy_ToolbarCallback* pProxy = new SignalProxy_ToolbarCallback(slot);
  GtkWidget* cwidget = gtk_toolbar_prepend_item(gobj(), text.c_str(), tooltip_text.c_str(), tooltip_private_text.c_str(), icon.gobj(), GTK_SIGNAL_FUNC(SignalProxy_ToolbarCallback::gtk_callback), pProxy);
  g_signal_connect(G_OBJECT(cwidget), "destroy", G_CALLBACK(SignalProxy_ToolbarCallback::gtk_callback_destroy), pProxy); //Delete the callback proxy when the widget is destroyed.
  return Glib::wrap(cwidget);
}

Gtk::Widget* Toolbar::prepend_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
  Callback0 slot)
{
  SignalProxy_ToolbarCallback* pProxy = new SignalProxy_ToolbarCallback(slot);
  GtkWidget* cwidget = gtk_toolbar_prepend_item(gobj(), text.c_str(), tooltip_text.c_str(), tooltip_private_text.c_str(), 0, GTK_SIGNAL_FUNC(SignalProxy_ToolbarCallback::gtk_callback), pProxy);
  g_signal_connect(G_OBJECT(cwidget), "destroy", G_CALLBACK(SignalProxy_ToolbarCallback::gtk_callback_destroy), pProxy); //Delete the callback proxy when the widget is destroyed.
  return Glib::wrap(cwidget);
}

Gtk::Widget* Toolbar::insert_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
  Gtk::Widget& icon, Callback0 slot,
  int position)
{
  SignalProxy_ToolbarCallback* pProxy = new SignalProxy_ToolbarCallback(slot);
  GtkWidget* cwidget = gtk_toolbar_insert_item(gobj(), text.c_str(), tooltip_text.c_str(), tooltip_private_text.c_str(), icon.gobj(), GTK_SIGNAL_FUNC(SignalProxy_ToolbarCallback::gtk_callback), pProxy, position);
  g_signal_connect(G_OBJECT(cwidget), "destroy", G_CALLBACK(SignalProxy_ToolbarCallback::gtk_callback_destroy), pProxy); //Delete the callback proxy when the widget is destroyed.
  return Glib::wrap(cwidget);
}

Gtk::Widget* Toolbar::insert_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
  Callback0 slot,
  int position)
{
  SignalProxy_ToolbarCallback* pProxy = new SignalProxy_ToolbarCallback(slot);
  GtkWidget* cwidget = gtk_toolbar_insert_item(gobj(), text.c_str(), tooltip_text.c_str(), tooltip_private_text.c_str(), 0, GTK_SIGNAL_FUNC(SignalProxy_ToolbarCallback::gtk_callback), pProxy, position);
  g_signal_connect(G_OBJECT(cwidget), "destroy", G_CALLBACK(SignalProxy_ToolbarCallback::gtk_callback_destroy), pProxy); //Delete the callback proxy when the widget is destroyed.
  return Glib::wrap(cwidget);
}

Gtk::Widget* Toolbar::insert_stock(const Gtk::StockID& stock_id, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
  Callback0 slot,
  int position)
{
  SignalProxy_ToolbarCallback* pProxy = new SignalProxy_ToolbarCallback(slot);
  GtkWidget* cwidget = gtk_toolbar_insert_stock(gobj(), stock_id.get_c_str(), tooltip_text.c_str(), tooltip_private_text.c_str(), GTK_SIGNAL_FUNC(SignalProxy_ToolbarCallback::gtk_callback), pProxy, position);
  g_signal_connect(G_OBJECT(cwidget), "destroy", G_CALLBACK(SignalProxy_ToolbarCallback::gtk_callback_destroy), pProxy); //Delete the callback proxy when the widget is destroyed.
  return Glib::wrap(cwidget);
}


} // namespace Gtk


namespace
{

void Toolbar_signal_orientation_changed_callback(GtkToolbar* self, GtkOrientation p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,Orientation> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*(SlotType::Proxy)(slot->proxy_))
            (((Orientation)(p0))
, slot);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

const Glib::SignalProxyInfo Toolbar_signal_orientation_changed_info =
{
  "orientation_changed",
  (GCallback) &Toolbar_signal_orientation_changed_callback,
  (GCallback) &Toolbar_signal_orientation_changed_callback
};


void Toolbar_signal_toolbar_style_changed_callback(GtkToolbar* self, GtkToolbarStyle p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,ToolbarStyle> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*(SlotType::Proxy)(slot->proxy_))
            (((ToolbarStyle)(p0))
, slot);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

const Glib::SignalProxyInfo Toolbar_signal_toolbar_style_changed_info =
{
  "style_changed",
  (GCallback) &Toolbar_signal_toolbar_style_changed_callback,
  (GCallback) &Toolbar_signal_toolbar_style_changed_callback
};

} // anonymous namespace

// static
GType Glib::Value<Gtk::ToolbarChildType>::value_type()
{
  return gtk_toolbar_child_type_get_type();
}


namespace Glib
{

Gtk::Toolbar* wrap(GtkToolbar* object, bool take_copy)
{
  return dynamic_cast<Gtk::Toolbar *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Toolbar_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Toolbar_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_toolbar_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void Toolbar_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->orientation_changed = &orientation_changed_callback;
  klass->style_changed = &style_changed_callback;
}


void Toolbar_Class::orientation_changed_callback(GtkToolbar* self, GtkOrientation p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_orientation_changed(((Orientation)(p0))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->orientation_changed)
      (*base->orientation_changed)(self, p0);
  }
}

void Toolbar_Class::style_changed_callback(GtkToolbar* self, GtkToolbarStyle p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_toolbar_style_changed(((ToolbarStyle)(p0))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->style_changed)
      (*base->style_changed)(self, p0);
  }
}


Glib::ObjectBase* Toolbar_Class::wrap_new(GObject* o)
{
  return manage(new Toolbar((GtkToolbar*)(o)));

}


/* The implementation: */

Toolbar::Toolbar(const Glib::ConstructParams& construct_params)
:
  Gtk::Container(construct_params)
{
  }

Toolbar::Toolbar(GtkToolbar* castitem)
:
  Gtk::Container((GtkContainer*)(castitem))
{
  }

Toolbar::~Toolbar()
{
  destroy_();
}

Toolbar::CppClassType Toolbar::toolbar_class_; // initialize static member

GType Toolbar::get_type()
{
  return toolbar_class_.init().get_type();
}

GType Toolbar::get_base_type()
{
  return gtk_toolbar_get_type();
}


namespace Toolbar_Helpers
{

ToolList::iterator ToolList::find(const_reference w)
{
  iterator i = begin();
  for(i = begin(); i != end() && (i->get_widget()->gobj() != w.get_widget()->gobj()); i++);
  return i;
}

ToolList::iterator ToolList::find(Widget& w)
{
  iterator i;
  for(i = begin(); i != end() && ((GtkWidget*)i->get_widget()->gobj() != w.gobj()); i++);
  return i;
}

} /* namespace Toolbar_Helpers */


namespace Toolbar_Helpers
{

ToolList::ToolList()
{}

ToolList::ToolList(GtkToolbar* gparent)
: type_base((GObject*)gparent)
{}

ToolList::ToolList(const ToolList& src)
:
  type_base(src)
{}

ToolList& ToolList::operator=(const ToolList& src)
{
  type_base::operator=(src);
  return *this;
}

GList*& ToolList::glist() const
{
  return ((GtkToolbar*)gparent_)->children;
}

void ToolList::erase(iterator start, iterator stop)
{
  type_base::erase(start, stop);
}

GtkToolbar* ToolList::gparent()
{
  return (GtkToolbar*)type_base::gparent();
}

const GtkToolbar* ToolList::gparent() const
{
  return (GtkToolbar*)type_base::gparent();
}

ToolList::reference ToolList::operator[](size_type l) const
{
  return type_base::operator[](l);
}

} /* namespace Toolbar_Helpers */

Toolbar::Toolbar()
:
  Glib::ObjectBase(0), //Mark this class as gtkmmproc-generated, rather than a custom class, to allow vfunc optimisations.
  Gtk::Container(Glib::ConstructParams(toolbar_class_.init()))
{
  }

void Toolbar::set_orientation(Orientation orientation)
{
  gtk_toolbar_set_orientation(gobj(), ((GtkOrientation)(orientation)));
}

Orientation Toolbar::get_orientation() const
{
  return ((Orientation)(gtk_toolbar_get_orientation(const_cast<GtkToolbar*>(gobj()))));
}

void Toolbar::set_toolbar_style(ToolbarStyle style)
{
  gtk_toolbar_set_style(gobj(), ((GtkToolbarStyle)(style)));
}

ToolbarStyle Toolbar::get_toolbar_style() const
{
  return ((ToolbarStyle)(gtk_toolbar_get_style(const_cast<GtkToolbar*>(gobj()))));
}

void Toolbar::set_tooltips(bool enable)
{
  gtk_toolbar_set_tooltips(gobj(), static_cast<int>(enable));
}

bool Toolbar::get_tooltips() const
{
  return gtk_toolbar_get_tooltips(const_cast<GtkToolbar*>(gobj()));
}

void Toolbar::set_icon_size(IconSize icon_size)
{
  gtk_toolbar_set_icon_size(gobj(), static_cast<GtkIconSize>(int(icon_size)));
}

IconSize Toolbar::get_icon_size() const
{
  return IconSize(static_cast<int>(gtk_toolbar_get_icon_size(const_cast<GtkToolbar*>(gobj()))));
}

void Toolbar::unset_toolbar_style()
{
  gtk_toolbar_unset_style(gobj());
}

void Toolbar::unset_icon_size()
{
  gtk_toolbar_unset_icon_size(gobj());
}

void Toolbar::append_space()
{
  gtk_toolbar_append_space(gobj());
}

void Toolbar::prepend_space()
{
  gtk_toolbar_prepend_space(gobj());
}

void Toolbar::insert_space(int position)
{
  gtk_toolbar_insert_space(gobj(), position);
}

void Toolbar::remove_space(int position)
{
  gtk_toolbar_remove_space(gobj(), position);
}

void Toolbar::append_widget(Gtk::Widget& widget, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text)
{
  gtk_toolbar_append_widget(gobj(), (widget).gobj(), tooltip_text.c_str(), tooltip_private_text.c_str());
}

void Toolbar::prepend_widget(Gtk::Widget& widget, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text)
{
  gtk_toolbar_prepend_widget(gobj(), (widget).gobj(), tooltip_text.c_str(), tooltip_private_text.c_str());
}

void Toolbar::insert_widget(Gtk::Widget& widget, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text, int position)
{
  gtk_toolbar_insert_widget(gobj(), (widget).gobj(), tooltip_text.c_str(), tooltip_private_text.c_str(), position);
}


Glib::SignalProxy1<void,Orientation> Toolbar::signal_orientation_changed()
{
  return Glib::SignalProxy1<void,Orientation>(this, &Toolbar_signal_orientation_changed_info);
}

Glib::SignalProxy1<void,ToolbarStyle> Toolbar::signal_toolbar_style_changed()
{
  return Glib::SignalProxy1<void,ToolbarStyle>(this, &Toolbar_signal_toolbar_style_changed_info);
}


/**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes. 
 */
Glib::PropertyProxy<Orientation> Toolbar::property_orientation()
{
  return /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes. 
 */
Glib::PropertyProxy<Orientation>(this, "orientation");
}

/**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes. 
 */
Glib::PropertyProxy<ToolbarStyle> Toolbar::property_toolbar_style()
{
  return /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes. 
 */
Glib::PropertyProxy<ToolbarStyle>(this, "toolbar_style");
}


void Gtk::Toolbar::on_orientation_changed(Orientation orientation)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->orientation_changed)
    (*base->orientation_changed)(gobj(),((GtkOrientation)(orientation)));
}

void Gtk::Toolbar::on_toolbar_style_changed(ToolbarStyle style)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->style_changed)
    (*base->style_changed)(gobj(),((GtkToolbarStyle)(style)));
}


} // namespace Gtk


