// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _PANGOMM_LAYOUT_H
#define _PANGOMM_LAYOUT_H

#include <glibmm.h>

/* $Id: layout.hg,v 1.21 2002/09/10 10:05:33 murrayc Exp $ */

/* layout.h
 *
 * Copyright(C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/object.h>
#include <glibmm/slisthandle.h>
#include <pangomm/font.h>
#include <pangomm/fontdescription.h>
#include <pangomm/context.h>
#include <pangomm/attrlist.h>
#include <pangomm/tabarray.h>
#include <pangomm/layoutline.h>
#include <pangomm/layoutiter.h>
#include <pango/pango-layout.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _PangoLayout PangoLayout;
typedef struct _PangoLayoutClass PangoLayoutClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{ class Layout_Class; } // namespace Pango
namespace Pango
{


/** @addtogroup pangommEnums Enums and Flags */

/**
 * @ingroup pangommEnums
 */
enum Alignment
{
  ALIGN_LEFT,
  ALIGN_CENTER,
  ALIGN_RIGHT
};

} // namespace Pango


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Pango::Alignment> : public Glib::Value_Enum<Pango::Alignment>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{

/**
 * @ingroup pangommEnums
 */
enum WrapMode
{
  WRAP_WORD,
  WRAP_CHAR,
  WRAP_WORD_CHAR
};

} // namespace Pango


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Pango::WrapMode> : public Glib::Value_Enum<Pango::WrapMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{


/** A Pango::Layout represents and entire paragraph of text.
 * It is initialized with a Pango::Context, UTF-8 string and set of attributes for that string.
 * Once that is done, the set of formatted lines can be extracted from the object,
 * the layout can be rendered, and conversion between logical character positions
 * within the layout's text, and the physical position of the resulting glyphs can be made.
 */

class Layout : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Layout CppObjectType;
  typedef Layout_Class CppClassType;
  typedef PangoLayout BaseObjectType;
  typedef PangoLayoutClass BaseClassType;

private:
  friend class Layout_Class;
  static CppClassType layout_class_;

  // noncopyable
  Layout(const Layout&);
  Layout& operator=(const Layout&);

protected:
  explicit Layout(const Glib::ConstructParams& construct_params);
  explicit Layout(PangoLayout* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Layout();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  PangoLayout*       gobj()       { return reinterpret_cast<PangoLayout*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const PangoLayout* gobj() const { return reinterpret_cast<PangoLayout*>(gobject_); }

  PangoLayout* gobj_copy();

private:

  
protected:
  explicit Layout(const Glib::RefPtr<Context>& context);

public:
  
  static Glib::RefPtr<Layout> create(const Glib::RefPtr<Context>& context);


  /** Does a deep copy-by-value of the @a src  layout. The attribute list,
   * tab array, and text from the original layout are all copied by
   * value.
   * @return A new Pango::Layout identical to @a src .
   */
  Glib::RefPtr<Layout> copy();
  
  /** Retrieves the Pango::Context used for this layout.
   * @return The Pango::Context for the layout. This does not
   * have an additional refcount added, so if you want to keep
   * a copy of this around, you must reference it yourself.
   */
  Glib::RefPtr<Context> get_context() const;
  
  /** Sets the text attributes for a layout object
   * @param attrs A Pango::AttrList.
   */
  void set_attributes(AttrList& attrs);
  
  /** Gets the attribute list for the layout, if any
   * @return A Pango::AttrList.
   */
  AttrList get_attributes() const;

  /** Set the text of the layout.
   * @param text The text for the layout.
   */
  void set_text(const Glib::ustring& text);

  
  /** Gets the text in the layout. The returned text should not
   * be freed or modified.
   * @return The text in the @a layout .
   */
  Glib::ustring get_text() const;

  /** Sets the layout text and attribute list from marked-up text (see markup format).
   * Replaces the current text and attribute list.
   * @param markup Some marked-up text.
   */
  void set_markup(const Glib::ustring& markup);

  /** Sets the layout text and attribute list from marked-up text (see markup format).
   * Replaces the current text and attribute list.
   *
   * If @a accel_marker is nonzero, the given character will mark the character following
   * it as an accelerator. For example, the accel marker might be an ampersand or
   * underscore. All characters marked as an accelerator will receive a
   * Pango::UNDERLINE_LOW attribute, and the first character so marked will be returned
   * in @a accel_char. Two @a accel_marker characters following each other produce a
   * single literal @a accel_marker character.
   * @param markup Some marked-up text.
   * @param accel_marker Marker for accelerators in the text.
   * @param accel_char Return location for any located accelerators.
   */
  void set_markup(const Glib::ustring& markup, gunichar accel_marker, gunichar& accel_char);

  
  /** Set the default font description for the layout. If no font 
   * description is set on the layout, the font description from
   * the layout's context is used.
   * @param desc The new pango font description, or <tt>0</tt> to unset the
   * current font description.
   */
  void set_font_description(const FontDescription& desc);
  
  /** Sets the width to which the lines of the Pango::Layout should be wrapped.
   * @param width The desired width, or -1 to indicate that no wrapping should be
   * performed.
   */
  void set_width(int width);
  
  /** Gets the width to which the lines of the Pango::Layout should be wrapped.
   * @return The width.
   */
  int get_width() const;
  
  /** Sets the wrap style; the wrap style only has an effect if a width
   * is set on the layout with pango_layout_set_width(). To turn off wrapping,
   * set the width to -1.
   * @param wrap Wrap mode.
   */
  void set_wrap(WrapMode wrap);
  
  /** Get the wrap mode for the layout.
   * @return Active wrap mode.
   */
  WrapMode get_wrap() const;
  
  /** Sets the amount by which the first line should be shorter than the
   * rest of the lines. This may be negative, in which case
   * the subsequent lines will be shorter than the first line. (However,
   * in either case, the entire width of the layout will be given by
   * the value
   * @param indent The amount by which to indent.
   */
  void set_indent(int indent);
  
  /** Gets the amount by which the first line should be shorter than the
   * rest of the lines.
   * @return The indent.
   */
  int get_indent() const;
  
  /** Sets the amount of spacing between the lines of the layout.
   * @param spacing The amount of spacing.
   */
  void set_spacing(int spacing);
  
  /** Gets the amount of spacing between the lines of the layout.
   * @return The spacing (in thousandths of a device unit).
   */
  int get_spacing() const;
  
  /** Sets whether or not each complete line should be stretched to
   * fill the entire width of the layout. This stretching is typically
   * done by adding whitespace, but for some scripts (such as Arabic),
   * the justification is done by extending the characters.
   * @param justify Whether the lines in the layout should be justified.
   */
  void set_justify(bool justify = true);
  
  /** Gets whether or not each complete line should be stretched to
   * fill the entire width of the layout.
   * @return The justify.
   */
  bool get_justify() const;
  
  /** Sets the alignment for the layout (how partial lines are
   * positioned within the horizontal space available.)
   * @param alignment The new alignment.
   */
  void set_alignment(Alignment alignment);
  
  /** Sets the alignment for the layout (how partial lines are
   * positioned within the horizontal space available.)
   * @return The alignment value.
   */
  Alignment get_alignment() const;

  
  /** Sets the tabs to use for @a layout , overriding the default tabs
   * (by default, tabs are every 8 spaces). If @a tabs  is <tt>0</tt>, the default
   * tabs are reinstated. @a tabs  is copied into the layout; you must
   * free your copy of @a tabs  yourself.
   * @param tabs A Pango::TabArray.
   */
  void set_tabs(TabArray& tabs);
  
  /** Get the current Pango::TabArray used by this layout. If no
   * Pango::TabArray has been set, then the default tabs are in use
   * and an invalid instance is returned. Default tabs are every 8 spaces.
   * @return A copy of the tabs for this layout.
   */
  TabArray get_tabs() const;

  
  /** If @a setting  is <tt>true</tt>, do not treat newlines and similar characters
   * as paragraph separators; instead, keep all text in a single paragraph,
   * and display a glyph for paragraph separator characters. Used when
   * you want to allow editing of newlines on a single text line.
   * @param setting New setting.
   */
  void set_single_paragraph_mode(bool setting = true);
  
  /** Obtains the value set by pango_layout_set_single_paragraph_mode().
   * @return <tt>true</tt> if the layout does not break paragraphs at 
   * paragraph separator characters.
   */
  bool get_single_paragraph_mode() const;

  
  /** Forces recomputation of any state in the Pango::Layout that
   * might depend on the layout's context. This function should
   * be called if you make changes to the context subsequent
   * to creating the layout.
   */
  void context_changed();

  /** Retrieve an array of logical attributes for each character in the layout.
   * @return An array of logical attributes.
   */
  Glib::ArrayHandle<LogAttr> get_log_attrs() const;

  /** Convert from an index within the layout to the onscreen position corresponding to the grapheme at that index, which is represented as rectangle.
   * Note that @a x in the returned rectangle is always the leading edge of the grapheme
   * and @a x + @a width the trailing edge of the grapheme.
   * If the directionality of the grapheme is right-to-left, then @a width will be negative.
   * @param index Byte index within layout.
   * @return The position of the grapheme.
   */
  Rectangle index_to_pos(int index) const;

  
  /** Given an index within a layout, determine the positions that of the
   * strong and weak cursors if the insertion point is at that
   * index. The position of each cursor is stored as a zero-width
   * rectangle. The strong cursor location is the location where
   * characters of the directionality equal to the base direction of the
   * layout are inserted.  The weak cursor location is the location
   * where characters of the directionality opposite to the base
   * direction of the layout are inserted.
   * @param index_ The byte index of the cursor.
   * @param strong_pos Location to store the strong cursor position (may be <tt>0</tt>).
   * @param weak_pos Location to store the weak cursor position (may be <tt>0</tt>).
   */
  void get_cursor_pos(int index, Rectangle& strong_pos, Rectangle& weak_pos) const;

  /** Given an index within the layout, determine the positions that of the strong cursors if the insertion point is at that index.
   * @param index The byte index of the cursor.
   * @return The strong cursor position.
   */
  Rectangle get_cursor_strong_pos(int index) const;

  /** Given an index within the layout, determine the positions that of the weak cursors if the insertion point is at that index.
   * @param index The byte index of the cursor.
   * @return The weak cursor position.
   */
  Rectangle get_cursor_weak_pos(int index) const;

  
  /** Computes a new cursor position from an old position and
   * a count of positions to move visually. If @a count  is positive,
   * then the new strong cursor position will be one position
   * to the right of the old cursor position. If @a count  is position
   * then the new strong cursor position will be one position
   * to the left of the old cursor position. 
   * 
   * In the presence of bidirection text, the correspondence
   * between logical and visual order will depend on the direction
   * of the current run, and there may be jumps when the cursor
   * is moved off of the end of a run.
   * 
   * Motion here is in cursor positions, not in characters, so a
   * single call to pango_layout_move_cursor_visually() may move the
   * cursor over multiple characters when multiple characters combine
   * to form a single grapheme.
   * @param strong Whether the moving cursor is the strong cursor or the
   * weak cursor. The strong cursor is the cursor corresponding
   * to text insertion in the base direction for the layout.
   * @param old_index The byte index of the grapheme for the old index.
   * @param old_trailing If 0, the cursor was at the trailing edge of the 
   * grapheme indicated by @a old_index , if &gt; 0, the cursor
   * was at the leading edge.
   * @param direction Direction to move cursor. A negative
   * value indicates motion to the left.
   * @param new_index Location to store the new cursor byte index. A value of -1 
   * indicates that the cursor has been moved off the beginning
   * of the layout. A value of G_MAXINT indicates that
   * the cursor has been moved off the end of the layout.
   * @param new_trailing Number of characters to move forward from the location returned
   * for @a new_index  to get the position where the cursor should
   * be displayed. This allows distinguishing the position at
   * the beginning of one line from the position at the end
   * of the preceding line. @a new_index  is always on the line
   * where the cursor should be displayed.
   */
  void move_cursor_visually(bool strong,
     int old_index, int old_trailing, int direction,
     int& new_index, int& new_trailing) const;

  
  /** Convert from X and Y position within a layout to the byte 
   * index to the character at that logical position. If the
   * position is not inside the layout, the closest position is chosen
   * (the x/y position will be clamped inside the layout).
   * If a closest position is chosen, then the function returns <tt>false</tt>;
   * on an exact hit, it returns <tt>true</tt>.
   * @param x The X offset (in thousandths of a device unit)
   * from the left edge of the layout.
   * @param y The Y offset (in thousandths of a device unit)
   * from the top edge of the layout.
   * @param index_ Location to store calculated byte index.
   * @param trailing Location to store a integer indicating where
   * in the grapheme the user clicked. It will either
   * be zero, or the number of characters in the
   * grapheme. 0 represents the trailing edge of the grapheme.
   * @return <tt>true</tt> if the coordinates were inside text.
   */
  bool xy_to_index(int x, int y, int& index, int& trailing) const;

  
  /** Compute the logical and ink extents of @a layout . Logical extents
   * are usually what you want for positioning things. The extents
   * are given in layout coordinates; layout coordinates begin at the
   * top left corner of the layout.
   * @param ink_rect Rectangle used to store the extents of the layout as drawn
   * or <tt>0</tt> to indicate that the result is not needed.
   * @param logical_rect Rectangle used to store the logical extents of the layout 
   *                  or <tt>0</tt> to indicate that the result is not needed.
   */
  void get_extents(Rectangle& ink_rect, Rectangle& logical_rect) const;

  /** Compute the ink extents of layout.
   * @return The extents of the layout as drawn.
   */
  Rectangle get_ink_extents() const;

  /** Compute the logical extents of layout.
   * @return The logical extents of the layout.
   */
  Rectangle get_logical_extents() const;

  
  /** Compute the logical and ink extents of @a layout  in device units.
   * See pango_layout_get_extents(); this function just calls
   * pango_layout_get_extents() and then converts the extents to
   * pixels using the Pango::SCALE factor.
   * @param ink_rect Rectangle used to store the extents of the layout as drawn
   * or <tt>0</tt> to indicate that the result is not needed.
   * @param logical_rect Rectangle used to store the logical extents of the 
   * layout or <tt>0</tt> to indicate that the result is not needed.
   */
  void get_pixel_extents(Rectangle& ink_rect, Rectangle& logical_rect) const;

  /** Compute the ink extents of the layout in device units.
   * @return The extents of the layout as drawn.
   */
  Rectangle get_pixel_ink_extents() const;

  /** Compute the logical extents of the layout in device units.
   * @return The logical extents of the layout.
   */
  Rectangle get_pixel_logical_extents() const;

  
  /** Determine the logical width and height of a Pango::Layout
   * in Pango units. (device units divided by PANGO_SCALE). This
   * is simply a convenience function around pango_layout_get_extents.
   * @param width Location to store the logical width, or <tt>0</tt>.
   * @param height Location to store the logical height, or <tt>0</tt>.
   */
  void get_size(int& width, int& height) const;
  
  /** Determine the logical width and height of a Pango::Layout
   * in device units. (pango_layout_get_size() returns the width
   * and height in thousandths of a device unit.) This
   * is simply a convenience function around pango_layout_get_extents.
   * @param width Location to store the logical width, or <tt>0</tt>.
   * @param height Location to store the logical height, or <tt>0</tt>.
   */
  void get_pixel_size(int& width, int& height) const;

  
  /** Retrieve the count of lines for the @a layout .
   * @return The line count.
   */
  int get_line_count() const;
  
  /** Retrieves a particular line from a Pango::Layout.
   * @param line The index of a line, which must be between 0 and
   * pango_layout_get_line_count(layout) - 1, inclusive.
   * @return The requested Pango::LayoutLine, or <tt>0</tt> if the
   * index is out of range. This layout line can
   * be ref'ed and retained, but will become invalid
   * if changes are made to the Pango::Layout.
   */
  Glib::RefPtr<LayoutLine> get_line(int line) const;
  
  /** Return the lines of the @a layout  as a list.
   * @return A G::SList containing the lines in the layout. This
   * points to internal data of the Pango::Layout and must be used with
   * care. It will become invalid on any change to the layout's
   * text or properties.
   */
  SListHandle_LayoutLine get_lines() const;

  /** Gets an iterator to iterate over the visual extents of the layout.
   * @param iter Location to store the iterator.
   */
  void get_iter(LayoutIter& iter);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Pango */


namespace Glib
{
  /** @relates Pango::Layout */
  Glib::RefPtr<Pango::Layout> wrap(PangoLayout* object, bool take_copy = false);
}


#endif /* _PANGOMM_LAYOUT_H */

