// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_SCREEN_H
#define _GDKMM_SCREEN_H

#include <glibmm.h>

/* $Id: screen.hg,v 1.3 2003/09/28 16:02:02 murrayc Exp $ */

/* screen.h
 *
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

//#include <gdkmm/visual.h>
//#include <gdkmm/window.h>
#include <gdkmm/rectangle.h>
#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkScreen GdkScreen;
typedef struct _GdkScreenClass GdkScreenClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Screen_Class; } // namespace Gdk
namespace Gdk
{

class Display;
class Colormap;
class Visual;
class Window;


class Screen : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Screen CppObjectType;
  typedef Screen_Class CppClassType;
  typedef GdkScreen BaseObjectType;
  typedef GdkScreenClass BaseClassType;

private:  friend class Screen_Class;
  static CppClassType screen_class_;

private:
  // noncopyable
  Screen(const Screen&);
  Screen& operator=(const Screen&);

protected:
  explicit Screen(const Glib::ConstructParams& construct_params);
  explicit Screen(GdkScreen* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Screen();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkScreen*       gobj()       { return reinterpret_cast<GdkScreen*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkScreen* gobj() const { return reinterpret_cast<GdkScreen*>(gobject_); }

  GdkScreen* gobj_copy();

private:

protected:

public:
  
  Glib::RefPtr<Colormap> get_default_colormap();
  
  Glib::RefPtr<const Colormap> get_default_colormap() const;

  
  void set_default_colormap(const Glib::RefPtr<const Colormap>& colormap);
  
  Glib::RefPtr<Colormap> get_system_colormap();
  
  Glib::RefPtr<const Colormap> get_system_colormap() const;

  
  Glib::RefPtr<Visual> get_system_visual();
  
  Glib::RefPtr<const Visual> get_system_visual() const;

  
  Glib::RefPtr<Colormap> get_rgb_colormap();
  
  Glib::RefPtr<const Colormap> get_rgb_colormap() const;

  
  Glib::RefPtr<Visual> get_rgb_visual();
  
  Glib::RefPtr<const Visual> get_rgb_visual() const;

  
  Glib::RefPtr<Window> get_root_window();
  
  Glib::RefPtr<const Window> get_root_window() const;

  
  Glib::RefPtr<Display> get_display();
  
  Glib::RefPtr<const Display> get_display() const;

  
  int get_number() const;
  
  int get_width() const;
  
  int get_height() const;
  
  int get_width_mm() const;
  
  int get_height_mm() const;

  
  Glib::ListHandle< Glib::RefPtr<Visual> > list_visuals();
  
  Glib::ListHandle< Glib::RefPtr<Window> > get_toplevel_windows();
  
  Glib::ustring make_display_name();

  
  int get_n_monitors() const;
  
  void get_monitor_geometry(int monitor_num, Rectangle& dest) const;
  
  int get_monitor_at_point(int x, int y) const;
  
  int get_monitor_at_window(const Glib::RefPtr<Window>& window) const;

  
  void broadcast_client_message(GdkEvent* event);

  
  static Glib::RefPtr<Screen> get_default();

  template <class ValueType>
  bool get_setting(const Glib::ustring& name, ValueType& value) const;
  

  /**
   * @par Prototype:
   * <tt>void %size_changed()</tt>
   */
  Glib::SignalProxy0< void > signal_size_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_size_changed();


};

template <class ValueType>
bool Screen::get_setting(const Glib::ustring& name, ValueType& value) const
{
  Glib::Value<ValueType> glibmmvalue;
  glibmmvalue.init(Glib::Value<ValueType>::value_type());

  gboolean result = gdk_screen_get_setting(const_cast<GdkScreen*>(gobj()), name.c_str(), glibmmvalue.gobj());

  value = glibmmvalue.get();
  return result;
}

} /* namespace Gdk */


namespace Glib
{
  /** @relates Gdk::Screen */
  Glib::RefPtr<Gdk::Screen> wrap(GdkScreen* object, bool take_copy = false);
}


#endif /* _GDKMM_SCREEN_H */

