// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_ENTRY_H
#define _GTKMM_ENTRY_H

#include <glibmm.h>

/* $Id: entry.hg,v 1.4 2003/10/12 09:38:11 murrayc Exp $ */

/* entry.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>
#include <gtkmm/editable.h>
#include <gtkmm/menu.h>
#include <gtkmm/celleditable.h>
#include <gtkmm/entrycompletion.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkEntry GtkEntry;
typedef struct _GtkEntryClass GtkEntryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Entry_Class; } // namespace Gtk
namespace Gtk
{

/** A single line text entry field.
 *
 * The Gtk::Entry widget is a single line text entry widget. A fairly large
 * set of key bindings are supported by default. If the entered text is
 * longer than the allocation of the widget, the widget will scroll so that
 * the cursor position is visible. 
 *
 * @ingroup Widgets
 */

class Entry
: public Widget,
  public Editable,
  public CellEditable
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Entry CppObjectType;
  typedef Entry_Class CppClassType;
  typedef GtkEntry BaseObjectType;
  typedef GtkEntryClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Entry();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Entry_Class;
  static CppClassType entry_class_;

  // noncopyable
  Entry(const Entry&);
  Entry& operator=(const Entry&);

protected:
  explicit Entry(const Glib::ConstructParams& construct_params);
  explicit Entry(GtkEntry* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkEntry*       gobj()       { return reinterpret_cast<GtkEntry*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkEntry* gobj() const { return reinterpret_cast<GtkEntry*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_populate_popup(Menu* menu);
  virtual void on_insert_at_cursor(const Glib::ustring& str);
  virtual void on_activate();


private:

  
public:

  Entry();
  

  void set_visibility(bool visible = true);
  
  /** Retrieves whether the text in @a entry  is visible. See
   * set_visibility().
   * @return <tt>true</tt> if the text is currently visible.
   */
  bool get_visibility() const;
  
  /** Sets the character to use in place of the actual text when
   * set_visibility() has been called to set text visibility
   * to <tt>false</tt>. i.e. this is the character used in "password mode" to
   * show the user how many characters have been typed. The default
   * invisible char is an asterisk ('*').  If you set the invisible char
   * to 0, then the user will get no feedback at all; there will be
   * no text on the screen as they type.
   * @param ch A Unicode character.
   */
  void set_invisible_char(gunichar ch);
  
  /** Retrieves the character displayed in place of the real characters
   * for entries with visisbility set to false. See set_invisible_char().
   * @return The current invisible char, or 0, if the entry does not
   * show invisible text at all.
   */
  gunichar get_invisible_char() const;	
  
  /** Sets whether the entry has a beveled frame around it.
   * @param setting New value.
   */
  void set_has_frame(bool setting = true);
  
  /** Gets the value set by set_has_frame().
   * @return Whether the entry has a beveled frame.
   */
  bool get_has_frame() const;
  
  /** Sets the maximum allowed length of the contents of the widget. If
   * the current contents are longer than the given length, then they
   * will be truncated to fit.
   * @param max The maximum length of the entry, or 0 for no maximum.
   * (other than the maximum length of entries.) The value passed in will
   * be clamped to the range 0-65536.
   */
  void set_max_length(int max);
  
  /** Retrieves the maximum allowed length of the text in
   *  @a entry . See set_max_length().
   * @return The maximum allowed number of characters
   * in Gtk::Entry, or 0 if there is no maximum.
   */
  int get_max_length() const;
  
  /** If @a setting  is <tt>true</tt>, pressing Enter in the @a entry  will activate the default
   * widget for the window containing the entry. This usually means that
   * the dialog box containing the entry will be closed, since the default
   * widget is usually one of the dialog buttons.
   * 
   * (For experts: if @a setting  is <tt>true</tt>, the entry calls
   * Gtk::Window::activate_default() on the window containing the entry, in
   * the default handler for the "activate" signal.)
   * @param setting <tt>true</tt> to activate window's default widget on Enter keypress.
   */
  void set_activates_default(bool setting = true);
  
  /** Retrieves the value set by set_activates_default().
   * @return <tt>true</tt> if the entry will activate the default widget.
   */
  gboolean get_activates_default() const;
  
  /** Changes the size request of the entry to be about the right size
   * for @a n_chars  characters. Note that it changes the size
   * <em>request</em>, the size can still be affected by
   * how you pack the widget into containers. If @a n_chars  is -1, the
   * size reverts to the default entry size.
   * @param n_chars Width in chars.
   */
  void set_width_chars(int n_chars);
  
  /** Gets the value set by set_width_chars().
   * @return Number of chars to request space for, or negative if unset.
   */
  int get_width_chars() const;
  
  void set_text(const Glib::ustring &text);
  
  /** Retrieves the contents of the entry widget.
   * See also gtk_editable_get_chars().
   * @return A pointer to the contents of the widget as a
   * string.  This string points to internally allocated
   * storage in the widget and must not be freed, modified or
   * stored.
   */
  Glib::ustring get_text() const;
  
  /** Gets the Pango::Layout used to display the entry.
   * The layout is useful to e.g. convert text positions to
   * pixel positions, in combination with get_layout_offsets().
   * The returned layout is owned by the entry so need not be
   * freed by the caller.
   * 
   * Keep in mind that the layout text may contain a preedit string, so
   * gtk_entry_layout_index_to_text_index() and
   * gtk_entry_text_index_to_layout_index() are needed to convert byte
   * indices in the layout to byte indices in the entry contents.
   * @return The Pango::Layout for this entry.
   */
  Glib::RefPtr<Pango::Layout> get_layout();
  
  /** Obtains the position of the Pango::Layout used to render text
   * in the entry, in widget coordinates. Useful if you want to line
   * up the text in an entry with some other text, e.g. when using the
   * entry to implement editable cells in a sheet widget.
   * 
   * Also useful to convert mouse events into coordinates inside the
   * Pango::Layout, e.g. to take some action if some part of the entry text
   * is clicked.
   * 
   * Note that as the user scrolls around in the entry the offsets will
   * change; you'll need to connect to the "notify::scroll_offset"
   * signal to track this. Remember when using the Pango::Layout
   * functions you need to convert to and from pixels using
   * PANGO_PIXELS() or Pango::SCALE.
   * 
   * Keep in mind that the layout text may contain a preedit string, so
   * gtk_entry_layout_index_to_text_index() and
   * gtk_entry_text_index_to_layout_index() are needed to convert byte
   * indices in the layout to byte indices in the entry contents.
   * @param x Location to store X offset of layout, or <tt>0</tt>.
   * @param y Location to store Y offset of layout, or <tt>0</tt>.
   */
  void get_layout_offsets(int& x, int& y);

  
  /** Sets @a completion  to be the auxiliary completion object to use with @a entry .
   * All further configuration of the completion mechanism is done on
   *  @a completion  using the Gtk::EntryCompletion API.
   * 
   * Since: 2.4
   * @param completion The Gtk::EntryCompletion.
   */
  void set_completion(const Glib::RefPtr<EntryCompletion>& completion);
  
  /** Returns the auxiliary completion object currently in use by @a entry .
   * @return The auxiliary completion object currently in use by @a entry .
   * 
   * Since: 2.4.
   */
  Glib::RefPtr<EntryCompletion> get_completion();
  
  /** Returns the auxiliary completion object currently in use by @a entry .
   * @return The auxiliary completion object currently in use by @a entry .
   * 
   * Since: 2.4.
   */
  Glib::RefPtr<const EntryCompletion> get_completion() const;

  guint16 get_text_length() const;

  
  /**
   * @par Prototype:
   * <tt>void %populate_popup(Menu* menu)</tt>
   */
  Glib::SignalProxy1< void,Menu* > signal_populate_popup();

  
  /**
   * @par Prototype:
   * <tt>void %insert_at_cursor(const Glib::ustring& str)</tt>
   */
  Glib::SignalProxy1< void,const Glib::ustring& > signal_insert_at_cursor();


  //Key-binding signals:
  
  /**
   * @par Prototype:
   * <tt>void %activate()</tt>
   */
  Glib::SignalProxy0< void > signal_activate();
 //TODO: ignore this too? It's used in an example.
  
  
    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_cursor_position() const;


    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_selection_bound() const;


    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_editable() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_editable() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_max_length() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_max_length() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visibility() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visibility() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_has_frame() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_has_frame() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<gunichar> property_invisible_char() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<gunichar> property_invisible_char() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_activates_default() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_activates_default() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_width_chars() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_width_chars() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_scroll_offset() const;


    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_text() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_text() const;


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Entry
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::Entry* wrap(GtkEntry* object, bool take_copy = false);
}
#endif /* _GTKMM_ENTRY_H */

